/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import org.apache.ignite.internal.commandline.snapshot.SnapshotCancelCommand;
import org.apache.ignite.internal.commandline.snapshot.SnapshotCheckCommand;
import org.apache.ignite.internal.commandline.snapshot.SnapshotCreateCommand;
import org.apache.ignite.internal.commandline.snapshot.SnapshotRestoreCommand;
import org.apache.ignite.internal.commandline.snapshot.SnapshotStatusCommand;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommand;
import org.apache.ignite.internal.util.typedef.F;

public enum SnapshotSubcommands {
    CREATE(new SnapshotCreateCommand()),
    CANCEL(new SnapshotCancelCommand()),
    CHECK(new SnapshotCheckCommand()),
    RESTORE(new SnapshotRestoreCommand()),
    STATUS(new SnapshotStatusCommand());

    private final SnapshotSubcommand cmd;

    private SnapshotSubcommands(SnapshotSubcommand cmd) {
        this.cmd = cmd;
    }

    public static SnapshotSubcommands of(String name) {
        SnapshotSubcommands[] cmds;
        for (SnapshotSubcommands cmd : cmds = SnapshotSubcommands.values()) {
            if (!cmd.subCommand().name().equalsIgnoreCase(name)) continue;
            return cmd;
        }
        throw new IllegalArgumentException("Invalid argument: " + name + ". One of " + F.asList((Object[])cmds) + " is expected.");
    }

    public SnapshotSubcommand subCommand() {
        return this.cmd;
    }

    public String toString() {
        return this.cmd.name();
    }
}

