/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommand;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommands;
import org.apache.ignite.internal.commandline.systemview.SystemViewCommand;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotStatusTask;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTask;

public class SnapshotStatusCommand
extends SnapshotSubcommand {
    protected SnapshotStatusCommand() {
        super("status", VisorSnapshotStatusTask.class);
    }

    @Override
    protected void printResult(Object res, Logger log) {
        if (res == null) {
            log.info("There is no create or restore snapshot operation in progress.");
            return;
        }
        VisorSnapshotStatusTask.SnapshotStatus status = (VisorSnapshotStatusTask.SnapshotStatus)res;
        boolean isCreating = status.operation() == VisorSnapshotStatusTask.SnapshotOperation.CREATE;
        GridStringBuilder s = new GridStringBuilder();
        if (isCreating) {
            s.a("Create snapshot operation is in progress.").nl();
        } else {
            s.a("Restore snapshot operation is in progress.").nl();
        }
        s.a("Snapshot name: ").a(status.name()).nl();
        s.a("Operation ID: ").a(status.requestId()).nl();
        s.a("Started at: ").a(DateFormat.getDateTimeInstance().format(new Date(status.startTime()))).nl();
        s.a("Duration: ").a(X.timeSpan2DHMSM((long)(System.currentTimeMillis() - status.startTime()))).nl().nl();
        s.a("Estimated operation progress:").nl();
        log.info(s.toString());
        List titles = isCreating ? F.asList((Object[])new String[]{"Node ID", "Processed, bytes", "Total, bytes", "Percent"}) : F.asList((Object[])new String[]{"Node ID", "Processed, partitions", "Total, partitions", "Percent"});
        List<List<?>> rows = status.progress().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> {
            UUID nodeId = (UUID)e.getKey();
            long processed = (Long)((T2)e.getValue()).get1();
            long total = (Long)((T2)e.getValue()).get2();
            if (total <= 0L) {
                return F.asList((Object[])new Serializable[]{nodeId, "unknown", "unknown", "unknown"});
            }
            String percent = (int)(processed * 100L / total) + "%";
            if (isCreating) {
                return F.asList((Object[])new Serializable[]{nodeId, U.humanReadableByteCount((long)processed), U.humanReadableByteCount((long)total), percent});
            }
            return F.asList((Object[])new Serializable[]{nodeId, Long.valueOf(processed), Long.valueOf(total), percent});
        }).collect(Collectors.toList());
        SystemViewCommand.printTable(titles, F.asList((Object[])new VisorSystemViewTask.SimpleType[]{VisorSystemViewTask.SimpleType.STRING, VisorSystemViewTask.SimpleType.NUMBER, VisorSystemViewTask.SimpleType.NUMBER, VisorSystemViewTask.SimpleType.NUMBER}), rows, log);
        log.info(U.nl());
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Unexpected argument: " + argIter.peekNextArg() + '.');
        }
    }

    @Override
    public void printUsage(Logger log) {
        this.usage(log, "Get the status of the current snapshot operation:", CommandList.SNAPSHOT, SnapshotSubcommands.STATUS.toString());
    }
}

