/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.snapshot.SnapshotRestoreCommandOption;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommand;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommands;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotRestoreTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotRestoreTaskAction;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotRestoreTaskArg;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;

public class SnapshotRestoreCommand
extends SnapshotSubcommand {
    protected SnapshotRestoreCommand() {
        super("restore", VisorSnapshotRestoreTask.class);
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        if (this.cmdArg instanceof VisorSnapshotRestoreTaskArg && ((VisorSnapshotRestoreTaskArg)this.cmdArg).jobAction() == VisorSnapshotRestoreTaskAction.STATUS) {
            log.warning("Command deprecated. Use '" + (Object)((Object)CommandList.SNAPSHOT) + ' ' + (Object)((Object)SnapshotSubcommands.STATUS) + "' instead.");
        }
        Object res = super.execute(clientCfg, log);
        log.info(String.valueOf(res));
        return res;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String snpName = argIter.nextArg("Expected snapshot name.");
        VisorSnapshotRestoreTaskAction restoreAction = this.parseAction(argIter);
        String snpPath = null;
        Set<String> grpNames = null;
        boolean sync = false;
        while (argIter.hasNextSubArg()) {
            String arg = argIter.nextArg(null);
            if (restoreAction != VisorSnapshotRestoreTaskAction.START) {
                throw new IllegalArgumentException("Invalid argument: " + arg + ". Action \"--" + restoreAction.name().toLowerCase() + "\" does not support specified option.");
            }
            SnapshotRestoreCommandOption option = CommandArgUtils.of(arg, SnapshotRestoreCommandOption.class);
            if (option == null) {
                throw new IllegalArgumentException("Invalid argument: " + arg + ". Possible options: " + F.concat((Iterable)F.asList((Object[])SnapshotRestoreCommandOption.values()), (String)", ") + '.');
            }
            if (option == SnapshotRestoreCommandOption.GROUPS) {
                if (grpNames != null) {
                    throw new IllegalArgumentException(SnapshotRestoreCommandOption.GROUPS.argName() + " arg specified twice.");
                }
                String argDesc = "a comma-separated list of cache group names.";
                grpNames = argIter.nextStringSet(argDesc);
                if (!grpNames.isEmpty()) continue;
                throw new IllegalArgumentException("Expected " + argDesc);
            }
            if (option == SnapshotRestoreCommandOption.SOURCE) {
                if (snpPath != null) {
                    throw new IllegalArgumentException(SnapshotRestoreCommandOption.SOURCE.argName() + " arg specified twice.");
                }
                String errMsg = "Expected path to the snapshot directory.";
                if (CommandArgIterator.isCommandOrOption(argIter.peekNextArg())) {
                    throw new IllegalArgumentException(errMsg);
                }
                snpPath = argIter.nextArg(errMsg);
                continue;
            }
            if (option != SnapshotRestoreCommandOption.SYNC) continue;
            if (sync) {
                throw new IllegalArgumentException(SnapshotRestoreCommandOption.SYNC.argName() + " arg specified twice.");
            }
            sync = true;
        }
        this.cmdArg = new VisorSnapshotRestoreTaskArg(snpName, snpPath, sync, restoreAction, grpNames);
    }

    @Override
    public void printUsage(Logger log) {
        Map<String, String> params = this.generalUsageOptions();
        LinkedHashMap<String, String> startParams = new LinkedHashMap<String, String>(params);
        startParams.put(SnapshotRestoreCommandOption.GROUPS.argName() + " " + SnapshotRestoreCommandOption.GROUPS.arg(), SnapshotRestoreCommandOption.GROUPS.description());
        startParams.put(SnapshotRestoreCommandOption.SOURCE.argName() + " " + SnapshotRestoreCommandOption.SOURCE.arg(), SnapshotRestoreCommandOption.SOURCE.description());
        startParams.put(SnapshotRestoreCommandOption.SYNC.argName(), SnapshotRestoreCommandOption.SYNC.description());
        this.usage(log, "Restore snapshot:", CommandList.SNAPSHOT, startParams, SnapshotSubcommands.RESTORE.toString(), "snapshot_name", "--start", CommandLogger.optional(SnapshotRestoreCommandOption.GROUPS.argName(), SnapshotRestoreCommandOption.GROUPS.arg()), CommandLogger.optional(SnapshotRestoreCommandOption.SOURCE.argName(), SnapshotRestoreCommandOption.SOURCE.arg()), CommandLogger.optional(SnapshotRestoreCommandOption.SYNC.argName()));
        this.usage(log, "Snapshot restore operation status (Command deprecated. Use '" + (Object)((Object)CommandList.SNAPSHOT) + ' ' + (Object)((Object)SnapshotSubcommands.STATUS) + "' instead.):", CommandList.SNAPSHOT, params, SnapshotSubcommands.RESTORE.toString(), "snapshot_name", "--status");
        this.usage(log, "Cancel snapshot restore operation:", CommandList.SNAPSHOT, params, SnapshotSubcommands.RESTORE.toString(), "snapshot_name", "--cancel");
    }

    @Override
    public String confirmationPrompt() {
        VisorSnapshotRestoreTaskArg arg = (VisorSnapshotRestoreTaskArg)this.cmdArg;
        return arg.jobAction() != VisorSnapshotRestoreTaskAction.START || arg.groupNames() != null ? null : "Warning: command will restore ALL USER-CREATED CACHE GROUPS from the snapshot " + arg.snapshotName() + '.';
    }

    private VisorSnapshotRestoreTaskAction parseAction(CommandArgIterator argIter) {
        Collection cmdNames = F.viewReadOnly((Collection)F.asList((Object[])VisorSnapshotRestoreTaskAction.values()), (IgniteClosure & Serializable)v -> "--" + v.toString().toLowerCase(), (IgnitePredicate[])new IgnitePredicate[0]);
        String actionErrMsg = "One of " + cmdNames + " is expected.";
        String action = argIter.nextArg(actionErrMsg);
        for (VisorSnapshotRestoreTaskAction val : VisorSnapshotRestoreTaskAction.values()) {
            if (!action.toLowerCase().equals("--" + val.name().toLowerCase())) continue;
            return val;
        }
        throw new IllegalArgumentException("Invalid argument: " + action + ". " + actionErrMsg);
    }
}

