/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.encryption;

import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.encryption.EncryptionSubcommands;
import org.apache.ignite.internal.visor.encryption.VisorGetMasterKeyNameTask;

public class GetMasterKeyNameCommand
extends AbstractCommand<Void> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            String masterKeyName = (String)TaskExecutor.executeTaskByNameOnNode(client, VisorGetMasterKeyNameTask.class.getName(), null, null, clientCfg);
            log.info(masterKeyName);
            String string = masterKeyName;
            return string;
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public Void arg() {
        return null;
    }

    @Override
    public void printUsage(Logger log) {
        this.usage(log, "Print the current master key name:", CommandList.ENCRYPTION, EncryptionSubcommands.GET_MASTER_KEY_NAME.toString());
    }

    @Override
    public String name() {
        return EncryptionSubcommands.GET_MASTER_KEY_NAME.text().toUpperCase();
    }
}

