/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.encryption;

import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.encryption.EncryptionSubcommands;

public class EncryptionCommands
extends AbstractCommand<EncryptionSubcommands> {
    private EncryptionSubcommands cmd;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        return this.cmd.subcommand().execute(clientCfg, logger);
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        EncryptionSubcommands cmd = EncryptionSubcommands.of(argIter.nextArg("Expected encryption action."));
        if (cmd == null) {
            throw new IllegalArgumentException("Expected correct encryption action.");
        }
        cmd.subcommand().parseArguments(argIter);
        if (argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Unexpected argument of --encryption subcommand: " + argIter.peekNextArg());
        }
        this.cmd = cmd;
    }

    @Override
    public EncryptionSubcommands arg() {
        return this.cmd;
    }

    @Override
    public void printUsage(Logger logger) {
        for (EncryptionSubcommands cmd : EncryptionSubcommands.values()) {
            cmd.subcommand().printUsage(logger);
        }
    }

    @Override
    public String name() {
        return CommandList.ENCRYPTION.toCommandName();
    }
}

