/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Set;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTask;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTaskArg;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTaskResult;

public class ResetLostPartitions
extends AbstractCommand<Set<String>> {
    private Set<String> caches;

    @Override
    public void printUsage(Logger logger) {
        String CACHES = "cacheName1,...,cacheNameN";
        String description = "Reset the state of lost partitions for the specified caches.";
        this.usageCache(logger, CacheSubcommands.RESET_LOST_PARTITIONS, description, null, CACHES);
    }

    @Override
    public Set<String> arg() {
        return this.caches;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        CacheResetLostPartitionsTaskArg taskArg = new CacheResetLostPartitionsTaskArg(this.caches);
        try (GridClient client = Command.startClient(clientCfg);){
            CacheResetLostPartitionsTaskResult res = (CacheResetLostPartitionsTaskResult)TaskExecutor.executeTaskByNameOnNode(client, CacheResetLostPartitionsTask.class.getName(), taskArg, null, clientCfg);
            res.print(System.out);
            CacheResetLostPartitionsTaskResult cacheResetLostPartitionsTaskResult = res;
            return cacheResetLostPartitionsTaskResult;
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.caches = argIter.nextStringSet("Cache names");
    }

    @Override
    public String name() {
        return CacheSubcommands.RESET_LOST_PARTITIONS.text().toUpperCase();
    }
}

