/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.systemview.SystemViewCommand;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.cache.metrics.CacheMetricsOperation;
import org.apache.ignite.internal.visor.cache.metrics.VisorCacheMetricsTask;
import org.apache.ignite.internal.visor.cache.metrics.VisorCacheMetricsTaskArg;
import org.apache.ignite.internal.visor.cache.metrics.VisorCacheMetricsTaskResult;
import org.apache.ignite.internal.visor.systemview.VisorSystemViewTask;

public class CacheMetrics
extends AbstractCommand<VisorCacheMetricsTaskArg> {
    public static final String CACHES_ARGUMENT = "--caches";
    public static final String ALL_CACHES_ARGUMENT = "--all-caches";
    public static final String INCORRECT_METRICS_OPERATION_MESSAGE = "Expected correct metrics command operation.";
    public static final String INCORRECT_CACHE_ARGUMENT_MESSAGE = String.format("Expected one of these arguments: '%s' or '%s'. Multiple arguments are not allowed.", "--caches", "--all-caches");
    public static final String EXPECTED_CACHES_LIST_MESSAGE = "comma-separated list of cache names.";
    private VisorCacheMetricsTaskArg arg;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            VisorCacheMetricsTaskResult res = (VisorCacheMetricsTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorCacheMetricsTask.class.getName(), this.arg, null, clientCfg);
            ArrayList values = new ArrayList();
            for (Map.Entry e : res.result().entrySet()) {
                values.add(Arrays.asList((String)e.getKey(), (Boolean)e.getValue() != false ? "enabled" : "disabled"));
            }
            SystemViewCommand.printTable(Arrays.asList("Cache Name", "Metrics Status"), Arrays.asList(VisorSystemViewTask.SimpleType.STRING, VisorSystemViewTask.SimpleType.STRING), values, log);
            Iterator iterator = null;
            return iterator;
        }
    }

    @Override
    public void printUsage(Logger log) {
        String desc = "Manages user cache metrics collection: enables, disables it or shows status.";
        String cachesArgDesc = "--caches cache1" + CommandLogger.optional(",...,cacheN");
        Map paramsDesc = F.asMap((Object)cachesArgDesc, (Object)"specifies a comma-separated list of cache names to which operation should be applied.", (Object)ALL_CACHES_ARGUMENT, (Object)"applies operation to all user caches.");
        this.usageCache(log, CacheSubcommands.METRICS, desc, paramsDesc, CommandLogger.or(CacheMetricsOperation.ENABLE, CacheMetricsOperation.DISABLE, CacheMetricsOperation.STATUS), CommandLogger.or(cachesArgDesc, ALL_CACHES_ARGUMENT));
    }

    @Override
    public VisorCacheMetricsTaskArg arg() {
        return this.arg;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        Set cacheNames;
        CacheMetricsOperation op = CacheMetricsOperation.of((String)argIter.nextArg(INCORRECT_METRICS_OPERATION_MESSAGE));
        if (op == null) {
            throw new IllegalArgumentException(INCORRECT_METRICS_OPERATION_MESSAGE);
        }
        String arg = argIter.nextArg(INCORRECT_CACHE_ARGUMENT_MESSAGE);
        if (CACHES_ARGUMENT.equals(arg)) {
            cacheNames = new TreeSet<String>(argIter.nextStringSet(EXPECTED_CACHES_LIST_MESSAGE));
        } else if (ALL_CACHES_ARGUMENT.equals(arg)) {
            cacheNames = Collections.emptySet();
        } else {
            throw new IllegalArgumentException(INCORRECT_CACHE_ARGUMENT_MESSAGE);
        }
        this.arg = new VisorCacheMetricsTaskArg(op, cacheNames);
    }

    @Override
    public String name() {
        return CacheSubcommands.METRICS.text().toUpperCase();
    }
}

