/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import org.jetbrains.annotations.NotNull;

public enum OutputFormat {
    SINGLE_LINE("single-line"),
    MULTI_LINE("multi-line");

    private final String text;

    private OutputFormat(String text) {
        this.text = text;
    }

    public String text() {
        return this.text;
    }

    public static OutputFormat fromConsoleName(@NotNull String text) {
        for (OutputFormat format : OutputFormat.values()) {
            if (!format.text.equals(text)) continue;
            return format;
        }
        throw new IllegalArgumentException("Unknown output format " + text);
    }

    public String toString() {
        return this.text;
    }
}

