/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.multicast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgnitePortProtocol;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiThread;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.jetbrains.annotations.Nullable;

public class TcpDiscoveryMulticastIpFinder
extends TcpDiscoveryVmIpFinder {
    public static final String DFLT_MCAST_GROUP = "228.1.2.4";
    public static final int DFLT_MCAST_PORT = 47400;
    public static final int DFLT_RES_WAIT_TIME = 500;
    public static final int DFLT_ADDR_REQ_ATTEMPTS = 2;
    private static final byte[] MSG_ADDR_REQ_DATA = U.IGNITE_HEADER;
    private static final Marshaller marsh = new JdkMarshaller();
    @LoggerResource
    private IgniteLogger log;
    private String mcastGrp = "228.1.2.4";
    private int mcastPort = 47400;
    private int resWaitTime = 500;
    private int addrReqAttempts = 2;
    private String locAddr;
    private int ttl = -1;
    @GridToStringExclude
    private Collection<AddressSender> addrSnds;
    @GridToStringExclude
    private InetAddress mcastAddr;
    @GridToStringExclude
    private Set<InetAddress> reqItfs;
    private boolean firstReq;
    private boolean mcastErr;
    @GridToStringExclude
    private Set<InetSocketAddress> locNodeAddrs;

    public TcpDiscoveryMulticastIpFinder() {
        this.setShared(true);
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryMulticastIpFinder setMulticastGroup(String mcastGrp) {
        this.mcastGrp = mcastGrp;
        return this;
    }

    public String getMulticastGroup() {
        return this.mcastGrp;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryMulticastIpFinder setMulticastPort(int mcastPort) {
        this.mcastPort = mcastPort;
        return this;
    }

    public int getMulticastPort() {
        return this.mcastPort;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryMulticastIpFinder setResponseWaitTime(int resWaitTime) {
        this.resWaitTime = resWaitTime;
        return this;
    }

    public int getResponseWaitTime() {
        return this.resWaitTime;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryMulticastIpFinder setAddressRequestAttempts(int addrReqAttempts) {
        this.addrReqAttempts = addrReqAttempts;
        return this;
    }

    public int getAddressRequestAttempts() {
        return this.addrReqAttempts;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryMulticastIpFinder setLocalAddress(String locAddr) {
        this.locAddr = locAddr;
        return this;
    }

    public String getLocalAddress() {
        return this.locAddr;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryMulticastIpFinder setTimeToLive(int ttl) {
        this.ttl = ttl;
        return this;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    @Override
    public void initializeLocalAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        block14: {
            if (F.isEmpty(super.getRegisteredAddresses())) {
                U.warn(this.log, "TcpDiscoveryMulticastIpFinder has no pre-configured addresses (it is recommended in production to specify at least one address in TcpDiscoveryMulticastIpFinder.getAddresses() configuration property)");
            }
            Collection<InetAddress> locAddrs = this.resolveLocalAddresses();
            this.addrSnds = new ArrayList<AddressSender>(locAddrs.size());
            this.reqItfs = new HashSet<InetAddress>(U.capacity(locAddrs.size()));
            for (InetAddress addr : locAddrs) {
                try {
                    this.addrSnds.add(new AddressSender(this.mcastAddr, addr, addrs));
                    this.reqItfs.add(addr);
                }
                catch (IOException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to create multicast socket [mcastAddr=" + this.mcastAddr + ", mcastGrp=" + this.mcastGrp + ", mcastPort=" + this.mcastPort + ", locAddr=" + addr + ", err=" + e + ']');
                }
            }
            this.locNodeAddrs = new HashSet<InetSocketAddress>(addrs);
            if (this.addrSnds.isEmpty()) {
                block13: {
                    try {
                        this.addrSnds.add(new AddressSender(this.mcastAddr, null, addrs));
                    }
                    catch (IOException e) {
                        if (!this.log.isDebugEnabled()) break block13;
                        this.log.debug("Failed to create multicast socket [mcastAddr=" + this.mcastAddr + ", mcastGrp=" + this.mcastGrp + ", mcastPort=" + this.mcastPort + ", err=" + e + ']');
                    }
                }
                if (this.addrSnds.isEmpty()) {
                    try {
                        this.addrSnds.add(new AddressSender(this.mcastAddr, this.mcastAddr, addrs));
                        this.reqItfs.add(this.mcastAddr);
                    }
                    catch (IOException e) {
                        if (!this.log.isDebugEnabled()) break block14;
                        this.log.debug("Failed to create multicast socket [mcastAddr=" + this.mcastAddr + ", mcastGrp=" + this.mcastGrp + ", mcastPort=" + this.mcastPort + ", locAddr=" + this.mcastAddr + ", err=" + e + ']');
                    }
                }
            }
        }
        if (!this.addrSnds.isEmpty()) {
            for (AddressSender addrSnd : this.addrSnds) {
                addrSnd.start();
            }
        } else {
            this.mcastErr = true;
        }
    }

    @Override
    public void onSpiContextInitialized(IgniteSpiContext spiCtx) throws IgniteSpiException {
        super.onSpiContextInitialized(spiCtx);
        spiCtx.registerPort(this.mcastPort, IgnitePortProtocol.UDP);
    }

    @Override
    public synchronized Collection<InetSocketAddress> getRegisteredAddresses() {
        if (this.mcastAddr == null) {
            this.reqItfs = new HashSet<InetAddress>(this.resolveLocalAddresses());
        }
        if (this.mcastAddr != null && this.reqItfs != null) {
            Collection ret;
            if (this.reqItfs.size() > 1) {
                ret = this.requestAddresses(this.reqItfs);
            } else {
                T2<Collection<InetSocketAddress>, Boolean> res = this.requestAddresses(this.mcastAddr, F.first(this.reqItfs));
                ret = (Collection)res.get1();
                this.mcastErr |= ((Boolean)res.get2()).booleanValue();
            }
            if (ret.isEmpty()) {
                if (this.mcastErr && this.firstReq) {
                    if (super.getRegisteredAddresses().isEmpty()) {
                        InetSocketAddress addr = new InetSocketAddress("localhost", 47500);
                        U.quietAndWarn(this.log, "TcpDiscoveryMulticastIpFinder failed to initialize multicast, will use default address: " + addr);
                        this.registerAddresses(Collections.singleton(addr));
                    } else {
                        U.quietAndWarn(this.log, "TcpDiscoveryMulticastIpFinder failed to initialize multicast, will use pre-configured addresses.");
                    }
                }
            } else {
                this.registerAddresses(ret);
            }
            this.firstReq = false;
        }
        return super.getRegisteredAddresses();
    }

    private Collection<InetAddress> resolveLocalAddresses() {
        Collection<String> locAddrs;
        String overrideMcastGrp = System.getProperty("IGNITE_OVERRIDE_MCAST_GRP");
        if (overrideMcastGrp != null) {
            this.mcastGrp = overrideMcastGrp;
        }
        if (F.isEmpty(this.mcastGrp)) {
            throw new IgniteSpiException("Multicast IP address is not specified.");
        }
        if (this.mcastPort < 0 || this.mcastPort > 65535) {
            throw new IgniteSpiException("Invalid multicast port: " + this.mcastPort);
        }
        if (this.resWaitTime <= 0) {
            throw new IgniteSpiException("Invalid wait time, value greater than zero is expected: " + this.resWaitTime);
        }
        if (this.addrReqAttempts <= 0) {
            throw new IgniteSpiException("Invalid number of address request attempts, value greater than zero is expected: " + this.addrReqAttempts);
        }
        if (this.ttl != -1 && (this.ttl < 0 || this.ttl > 255)) {
            throw new IgniteSpiException("Time-to-live value is out of 0 <= TTL <= 255 range: " + this.ttl);
        }
        try {
            this.mcastAddr = InetAddress.getByName(this.mcastGrp);
        }
        catch (UnknownHostException e) {
            throw new IgniteSpiException("Unknown multicast group: " + this.mcastGrp, e);
        }
        if (!this.mcastAddr.isMulticastAddress()) {
            throw new IgniteSpiException("Invalid multicast group address: " + this.mcastAddr);
        }
        try {
            locAddrs = U.resolveLocalAddresses(U.resolveLocalHost(this.locAddr)).get1();
        }
        catch (IOException e) {
            throw new IgniteSpiException("Failed to resolve local addresses [locAddr=" + this.locAddr + ']', e);
        }
        assert (locAddrs != null);
        ArrayList<InetAddress> inetAddrs = new ArrayList<InetAddress>(locAddrs.size());
        for (String locAddr : locAddrs) {
            InetAddress addr;
            try {
                addr = InetAddress.getByName(locAddr);
            }
            catch (UnknownHostException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Failed to resolve local address [locAddr=" + locAddr + ", err=" + e + ']');
                continue;
            }
            if (addr.isLoopbackAddress()) continue;
            inetAddrs.add(addr);
        }
        return inetAddrs;
    }

    private Collection<InetSocketAddress> requestAddresses(Set<InetAddress> reqItfs) {
        if (reqItfs.size() > 1) {
            HashSet<InetSocketAddress> ret = new HashSet<InetSocketAddress>();
            ArrayList<AddressReceiver> rcvrs = new ArrayList<AddressReceiver>();
            for (InetAddress itf : reqItfs) {
                AddressReceiver rcvr = new AddressReceiver(this.mcastAddr, itf);
                rcvr.start();
                rcvrs.add(rcvr);
            }
            for (AddressReceiver rcvr : rcvrs) {
                try {
                    rcvr.join();
                    ret.addAll(rcvr.addresses());
                }
                catch (InterruptedException ignore) {
                    U.warn(this.log, "Got interrupted while receiving address request.");
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            return ret;
        }
        T2<Collection<InetSocketAddress>, Boolean> res = this.requestAddresses(this.mcastAddr, F.first(reqItfs));
        return (Collection)res.get1();
    }

    /*
     * Exception decompiling
     */
    private T2<Collection<InetSocketAddress>, Boolean> requestAddresses(InetAddress mcastAddr, @Nullable InetAddress sockItf) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
        if (this.addrSnds != null) {
            for (AddressSender addrSnd : this.addrSnds) {
                U.interrupt(addrSnd);
            }
            for (AddressSender addrSnd : this.addrSnds) {
                U.join(addrSnd, this.log);
            }
        }
    }

    private boolean handleNetworkError(IOException e) {
        if ("Network is unreachable".equals(e.getMessage()) && U.isMacOs()) {
            U.warn(this.log, "Multicast does not work on Mac OS JVM loopback address (configure external IP address for 'localHost' configuration property)");
            return false;
        }
        return true;
    }

    @Override
    public TcpDiscoveryMulticastIpFinder setShared(boolean shared) {
        super.setShared(shared);
        return this;
    }

    @Override
    public String toString() {
        return S.toString(TcpDiscoveryMulticastIpFinder.class, this, "super", (Object)super.toString());
    }

    private class AddressSender
    extends IgniteSpiThread {
        private MulticastSocket sock;
        private final InetAddress mcastGrp;
        private final Collection<InetSocketAddress> addrs;
        private final InetAddress sockItf;

        private AddressSender(@Nullable InetAddress mcastGrp, InetAddress sockItf, Collection<InetSocketAddress> addrs) throws IOException {
            super(null, "tcp-disco-multicast-addr-sender", TcpDiscoveryMulticastIpFinder.this.log);
            this.mcastGrp = mcastGrp;
            this.addrs = addrs;
            this.sockItf = sockItf;
            this.sock = this.createSocket();
        }

        private MulticastSocket createSocket() throws IOException {
            MulticastSocket sock = new MulticastSocket(TcpDiscoveryMulticastIpFinder.this.mcastPort);
            sock.setLoopbackMode(false);
            if (this.sockItf != null) {
                sock.setInterface(this.sockItf);
            }
            if (sock.getLoopbackMode()) {
                U.warn(TcpDiscoveryMulticastIpFinder.this.log, "Loopback mode is disabled which prevents nodes on the same machine from discovering each other.");
            }
            sock.joinGroup(this.mcastGrp);
            if (TcpDiscoveryMulticastIpFinder.this.ttl != -1) {
                sock.setTimeToLive(TcpDiscoveryMulticastIpFinder.this.ttl);
            }
            return sock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException {
            AddressResponse res;
            try {
                res = new AddressResponse(this.addrs);
            }
            catch (IgniteCheckedException e) {
                U.error(TcpDiscoveryMulticastIpFinder.this.log, "Failed to prepare multicast message.", e);
                return;
            }
            byte[] reqData = new byte[MSG_ADDR_REQ_DATA.length];
            DatagramPacket pckt = new DatagramPacket(reqData, reqData.length);
            while (!this.isInterrupted()) {
                AddressSender addressSender;
                try {
                    MulticastSocket sock;
                    addressSender = this;
                    synchronized (addressSender) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        sock = this.sock;
                        if (sock == null) {
                            sock = this.createSocket();
                        }
                    }
                    sock.receive(pckt);
                    if (!U.bytesEqual(U.IGNITE_HEADER, 0, reqData, 0, U.IGNITE_HEADER.length)) {
                        U.error(TcpDiscoveryMulticastIpFinder.this.log, "Failed to verify message header.");
                        continue;
                    }
                    try {
                        sock.send(new DatagramPacket(res.data(), res.data().length, pckt.getAddress(), pckt.getPort()));
                    }
                    catch (IOException e) {
                        if (e.getMessage().contains("Operation not permitted")) {
                            if (!TcpDiscoveryMulticastIpFinder.this.log.isDebugEnabled()) continue;
                            TcpDiscoveryMulticastIpFinder.this.log.debug("Got 'operation not permitted' error, ignoring: " + e);
                            continue;
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    if (this.isInterrupted()) continue;
                    LT.error(TcpDiscoveryMulticastIpFinder.this.log, e, "Failed to send/receive address message (will try to reconnect).");
                    addressSender = this;
                    synchronized (addressSender) {
                        U.close(this.sock);
                        this.sock = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupt() {
            super.interrupt();
            AddressSender addressSender = this;
            synchronized (addressSender) {
                U.close(this.sock);
                this.sock = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cleanup() {
            AddressSender addressSender = this;
            synchronized (addressSender) {
                U.close(this.sock);
                this.sock = null;
            }
        }
    }

    private class AddressReceiver
    extends IgniteSpiThread {
        private final InetAddress mcastAddr;
        private final InetAddress sockAddr;
        private Collection<InetSocketAddress> addrs;

        private AddressReceiver(InetAddress mcastAddr, InetAddress sockAddr) {
            super(null, "tcp-disco-multicast-addr-rcvr", TcpDiscoveryMulticastIpFinder.this.log);
            this.mcastAddr = mcastAddr;
            this.sockAddr = sockAddr;
        }

        @Override
        protected void body() throws InterruptedException {
            this.addrs = (Collection)TcpDiscoveryMulticastIpFinder.this.requestAddresses(this.mcastAddr, this.sockAddr).get1();
        }

        Collection<InetSocketAddress> addresses() {
            return this.addrs;
        }
    }

    private static class AddressResponse {
        public static final int MAX_DATA_LENGTH = 65536;
        private byte[] data;
        private Collection<InetSocketAddress> addrs;

        private AddressResponse(Collection<InetSocketAddress> addrs) throws IgniteCheckedException {
            this.addrs = addrs;
            byte[] addrsData = U.marshal(marsh, addrs);
            this.data = new byte[U.IGNITE_HEADER.length + addrsData.length];
            if (this.data.length > 65536) {
                throw new IgniteCheckedException("Too long data packet [size=" + this.data.length + ", max=" + 65536 + "]");
            }
            System.arraycopy(U.IGNITE_HEADER, 0, this.data, 0, U.IGNITE_HEADER.length);
            System.arraycopy(addrsData, 0, this.data, 4, addrsData.length);
        }

        private AddressResponse(byte[] data) throws IgniteCheckedException {
            assert (U.bytesEqual(U.IGNITE_HEADER, 0, data, 0, U.IGNITE_HEADER.length));
            this.data = data;
            this.addrs = (Collection)U.unmarshal(marsh, Arrays.copyOfRange(data, U.IGNITE_HEADER.length, data.length), null);
        }

        byte[] data() {
            return this.data;
        }

        public Collection<InetSocketAddress> addresses() {
            return this.addrs;
        }
    }
}

