/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorMvccConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int mvccVacuumThreadCnt;
    private long mvccVacuumFreq;

    public VisorMvccConfiguration() {
    }

    public VisorMvccConfiguration(IgniteConfiguration cfg) {
        assert (cfg != null);
        this.mvccVacuumThreadCnt = cfg.getMvccVacuumThreadCount();
        this.mvccVacuumFreq = cfg.getMvccVacuumFrequency();
    }

    public int getMvccVacuumThreadCount() {
        return this.mvccVacuumThreadCnt;
    }

    public long getMvccVacuumFrequency() {
        return this.mvccVacuumFreq;
    }

    @Override
    public byte getProtocolVersion() {
        return 1;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.mvccVacuumThreadCnt);
        out.writeLong(this.mvccVacuumFreq);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.mvccVacuumThreadCnt = in.readInt();
        this.mvccVacuumFreq = in.readLong();
    }

    public String toString() {
        return S.toString(VisorMvccConfiguration.class, this);
    }
}

