/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.cache.VisorCacheMetrics;

public class VisorCacheAggregatedMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private CacheMode mode;
    private boolean sys;
    private Map<UUID, VisorCacheMetrics> metrics = new HashMap<UUID, VisorCacheMetrics>();
    private transient Long totalHeapSize;
    private transient Long minHeapSize;
    private transient Double avgHeapSize;
    private transient Long maxHeapSize;
    private transient Long totalOffHeapSize;
    private transient Long minOffHeapSize;
    private transient Double avgOffHeapSize;
    private transient Long maxOffHeapSize;
    private transient Long minHits;
    private transient Double avgHits;
    private transient Long maxHits;
    private transient Long minMisses;
    private transient Double avgMisses;
    private transient Long maxMisses;
    private transient Long minReads;
    private transient Double avgReads;
    private transient Long maxReads;
    private transient Long minWrites;
    private transient Double avgWrites;
    private transient Long maxWrites;
    private transient Long minQryTime;
    private transient Double avgQryTime;
    private transient Long maxQryTime;
    private transient Long totalQryTime;
    private transient Integer execsQry;
    private transient Integer failsQry;

    public VisorCacheAggregatedMetrics() {
    }

    public VisorCacheAggregatedMetrics(VisorCacheMetrics cm) {
        this.name = cm.getName();
        this.mode = cm.getMode();
        this.sys = cm.isSystem();
    }

    public String getName() {
        return this.name;
    }

    public CacheMode getMode() {
        return this.mode;
    }

    public boolean isSystem() {
        return this.sys;
    }

    public Collection<UUID> getNodes() {
        return this.metrics.keySet();
    }

    public long getTotalHeapSize() {
        if (this.totalHeapSize == null) {
            this.totalHeapSize = 0L;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.totalHeapSize = this.totalHeapSize + metric.getHeapEntriesCount();
            }
        }
        return this.totalHeapSize;
    }

    public long getMinimumHeapSize() {
        if (this.minHeapSize == null) {
            this.minHeapSize = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minHeapSize = Math.min(this.minHeapSize, metric.getHeapEntriesCount());
            }
        }
        return this.minHeapSize;
    }

    public double getAverageHeapSize() {
        if (this.avgHeapSize == null) {
            this.avgHeapSize = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgHeapSize = this.avgHeapSize + (double)metric.getHeapEntriesCount();
            }
            this.avgHeapSize = this.avgHeapSize / (double)this.metrics.size();
        }
        return this.avgHeapSize;
    }

    public long getMaximumHeapSize() {
        if (this.maxHeapSize == null) {
            this.maxHeapSize = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxHeapSize = Math.max(this.maxHeapSize, metric.getHeapEntriesCount());
            }
        }
        return this.maxHeapSize;
    }

    private long getOffHeapPrimaryEntriesCount(VisorCacheMetrics metric) {
        return metric.getOffHeapPrimaryEntriesCount();
    }

    public long getTotalOffHeapSize() {
        if (this.totalOffHeapSize == null) {
            this.totalOffHeapSize = 0L;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.totalOffHeapSize = this.totalOffHeapSize + metric.getOffHeapPrimaryEntriesCount();
            }
        }
        return this.totalOffHeapSize;
    }

    public long getMinimumOffHeapPrimarySize() {
        if (this.minOffHeapSize == null) {
            this.minOffHeapSize = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minOffHeapSize = Math.min(this.minOffHeapSize, this.getOffHeapPrimaryEntriesCount(metric));
            }
        }
        return this.minOffHeapSize;
    }

    public double getAverageOffHeapPrimarySize() {
        if (this.avgOffHeapSize == null) {
            this.avgOffHeapSize = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgOffHeapSize = this.avgOffHeapSize + (double)this.getOffHeapPrimaryEntriesCount(metric);
            }
            this.avgOffHeapSize = this.avgOffHeapSize / (double)this.metrics.size();
        }
        return this.avgOffHeapSize;
    }

    public long getMaximumOffHeapPrimarySize() {
        if (this.maxOffHeapSize == null) {
            this.maxOffHeapSize = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxOffHeapSize = Math.max(this.maxOffHeapSize, this.getOffHeapPrimaryEntriesCount(metric));
            }
        }
        return this.maxOffHeapSize;
    }

    public long getMinimumHits() {
        if (this.minHits == null) {
            this.minHits = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minHits = Math.min(this.minHits, metric.getHits());
            }
        }
        return this.minHits;
    }

    public double getAverageHits() {
        if (this.avgHits == null) {
            this.avgHits = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgHits = this.avgHits + (double)metric.getHits();
            }
            this.avgHits = this.avgHits / (double)this.metrics.size();
        }
        return this.avgHits;
    }

    public long getMaximumHits() {
        if (this.maxHits == null) {
            this.maxHits = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxHits = Math.max(this.maxHits, metric.getHits());
            }
        }
        return this.maxHits;
    }

    public long getMinimumMisses() {
        if (this.minMisses == null) {
            this.minMisses = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minMisses = Math.min(this.minMisses, metric.getMisses());
            }
        }
        return this.minMisses;
    }

    public double getAverageMisses() {
        if (this.avgMisses == null) {
            this.avgMisses = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgMisses = this.avgMisses + (double)metric.getMisses();
            }
            this.avgMisses = this.avgMisses / (double)this.metrics.size();
        }
        return this.avgMisses;
    }

    public long getMaximumMisses() {
        if (this.maxMisses == null) {
            this.maxMisses = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxMisses = Math.max(this.maxMisses, metric.getMisses());
            }
        }
        return this.maxMisses;
    }

    public long getMinimumReads() {
        if (this.minReads == null) {
            this.minReads = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minReads = Math.min(this.minReads, metric.getReads());
            }
        }
        return this.minReads;
    }

    public double getAverageReads() {
        if (this.avgReads == null) {
            this.avgReads = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgReads = this.avgReads + (double)metric.getReads();
            }
            this.avgReads = this.avgReads / (double)this.metrics.size();
        }
        return this.avgReads;
    }

    public long getMaximumReads() {
        if (this.maxReads == null) {
            this.maxReads = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxReads = Math.max(this.maxReads, metric.getReads());
            }
        }
        return this.maxReads;
    }

    public long getMinimumWrites() {
        if (this.minWrites == null) {
            this.minWrites = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minWrites = Math.min(this.minWrites, metric.getWrites());
            }
        }
        return this.minWrites;
    }

    public double getAverageWrites() {
        if (this.avgWrites == null) {
            this.avgWrites = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgWrites = this.avgWrites + (double)metric.getWrites();
            }
            this.avgWrites = this.avgWrites / (double)this.metrics.size();
        }
        return this.avgWrites;
    }

    public long getMaximumWrites() {
        if (this.maxWrites == null) {
            this.maxWrites = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxWrites = Math.max(this.maxWrites, metric.getWrites());
            }
        }
        return this.maxWrites;
    }

    public long getMinimumQueryTime() {
        if (this.minQryTime == null) {
            this.minQryTime = Long.MAX_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.minQryTime = Math.min(this.minQryTime, metric.getQueryMetrics().getMinimumTime());
            }
        }
        return this.minQryTime;
    }

    public double getAverageQueryTime() {
        if (this.avgQryTime == null) {
            this.avgQryTime = 0.0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.avgQryTime = this.avgQryTime + metric.getQueryMetrics().getAverageTime();
            }
            this.avgQryTime = this.avgQryTime / (double)this.metrics.size();
        }
        return this.avgQryTime;
    }

    public long getMaximumQueryTime() {
        if (this.maxQryTime == null) {
            this.maxQryTime = Long.MIN_VALUE;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.maxQryTime = Math.max(this.maxQryTime, metric.getQueryMetrics().getMaximumTime());
            }
        }
        return this.maxQryTime;
    }

    public long getTotalQueryTime() {
        if (this.totalQryTime == null) {
            this.totalQryTime = (long)(this.getAverageQueryTime() * (double)this.getQueryExecutions());
        }
        return this.totalQryTime;
    }

    public int getQueryExecutions() {
        if (this.execsQry == null) {
            this.execsQry = 0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.execsQry = this.execsQry + metric.getQueryMetrics().getExecutions();
            }
        }
        return this.execsQry;
    }

    public int getQueryFailures() {
        if (this.failsQry == null) {
            this.failsQry = 0;
            for (VisorCacheMetrics metric : this.metrics.values()) {
                this.failsQry = this.failsQry + metric.getQueryMetrics().getFailures();
            }
        }
        return this.failsQry;
    }

    public Map<UUID, VisorCacheMetrics> getMetrics() {
        return this.metrics;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        out.writeByte(CacheMode.toCode(this.mode));
        out.writeBoolean(this.sys);
        U.writeMap(out, this.metrics);
        out.writeObject(this.minHeapSize);
        out.writeObject(this.avgHeapSize);
        out.writeObject(this.maxHeapSize);
        out.writeObject(this.minOffHeapSize);
        out.writeObject(this.avgOffHeapSize);
        out.writeObject(this.maxOffHeapSize);
        out.writeObject(this.minHits);
        out.writeObject(this.avgHits);
        out.writeObject(this.maxHits);
        out.writeObject(this.minMisses);
        out.writeObject(this.avgMisses);
        out.writeObject(this.maxMisses);
        out.writeObject(this.minReads);
        out.writeObject(this.avgReads);
        out.writeObject(this.maxReads);
        out.writeObject(this.minWrites);
        out.writeObject(this.avgWrites);
        out.writeObject(this.maxWrites);
        out.writeObject(this.minQryTime);
        out.writeObject(this.avgQryTime);
        out.writeObject(this.maxQryTime);
        out.writeObject(this.totalQryTime);
        out.writeObject(this.execsQry);
        out.writeObject(this.failsQry);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.mode = CacheMode.fromCode(in.readByte());
        this.sys = in.readBoolean();
        this.metrics = U.readMap(in);
        this.minHeapSize = (Long)in.readObject();
        this.avgHeapSize = (Double)in.readObject();
        this.maxHeapSize = (Long)in.readObject();
        this.minOffHeapSize = (Long)in.readObject();
        this.avgOffHeapSize = (Double)in.readObject();
        this.maxOffHeapSize = (Long)in.readObject();
        this.minHits = (Long)in.readObject();
        this.avgHits = (Double)in.readObject();
        this.maxHits = (Long)in.readObject();
        this.minMisses = (Long)in.readObject();
        this.avgMisses = (Double)in.readObject();
        this.maxMisses = (Long)in.readObject();
        this.minReads = (Long)in.readObject();
        this.avgReads = (Double)in.readObject();
        this.maxReads = (Long)in.readObject();
        this.minWrites = (Long)in.readObject();
        this.avgWrites = (Double)in.readObject();
        this.maxWrites = (Long)in.readObject();
        this.minQryTime = (Long)in.readObject();
        this.avgQryTime = (Double)in.readObject();
        this.maxQryTime = (Long)in.readObject();
        this.totalQryTime = (Long)in.readObject();
        this.execsQry = (Integer)in.readObject();
        this.failsQry = (Integer)in.readObject();
    }

    public String toString() {
        return S.toString(VisorCacheAggregatedMetrics.class, this);
    }
}

