/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryArray;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.platform.PlatformNativeException;
import org.apache.ignite.internal.processors.platform.services.PlatformService;
import org.apache.ignite.internal.processors.service.GridServiceMethodNotFoundException;
import org.apache.ignite.internal.processors.service.GridServiceMethodReflectKey;
import org.apache.ignite.internal.processors.service.GridServiceNotFoundException;
import org.apache.ignite.internal.processors.service.ServiceCallContextHolder;
import org.apache.ignite.internal.processors.service.ServiceCallContextImpl;
import org.apache.ignite.internal.processors.service.ServiceContextImpl;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.platform.PlatformServiceMethod;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceCallInterceptor;
import org.jetbrains.annotations.Nullable;

public class GridServiceProxy<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Method PLATFORM_SERVICE_INVOKE_METHOD;
    @GridToStringExclude
    private final IgniteLogger log;
    private final T proxy;
    private final ClusterGroup prj;
    @GridToStringExclude
    private final GridKernalContext ctx;
    private final AtomicReference<ClusterNode> rmtNode = new AtomicReference();
    private boolean hasLocNode;
    private final String name;
    private final boolean sticky;
    private final long waitTimeout;
    private final boolean keepBinary;

    public GridServiceProxy(ClusterGroup prj, String name, Class<? super T> svc, boolean sticky, long timeout, GridKernalContext ctx, @Nullable Supplier<Map<String, Object>> callAttrsProvider, boolean keepBinary) {
        assert (timeout >= 0L) : timeout;
        this.prj = prj;
        this.ctx = ctx;
        this.name = name;
        this.sticky = sticky;
        this.keepBinary = keepBinary;
        this.waitTimeout = timeout;
        this.hasLocNode = this.hasLocalNode(prj);
        this.log = ctx.log(this.getClass());
        this.proxy = Proxy.newProxyInstance(svc.getClassLoader(), new Class[]{svc}, (InvocationHandler)new ProxyInvocationHandler(callAttrsProvider));
    }

    private boolean hasLocalNode(ClusterGroup prj) {
        for (ClusterNode n : prj.nodes()) {
            if (!n.isLocal()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invokeMethod(Method mtd, Object[] args, @Nullable Map<String, Object> callAttrs) throws Throwable {
        block21: {
            if (U.isHashCodeMethod(mtd)) {
                return System.identityHashCode(this.proxy);
            }
            if (U.isEqualsMethod(mtd)) {
                if (this.proxy == args[0]) {
                    v0 = true;
                    return v0;
                }
                v0 = false;
                return v0;
            }
            if (U.isToStringMethod(mtd)) {
                return GridServiceProxy.class.getSimpleName() + " [name=" + this.name + ", sticky=" + this.sticky + ']';
            }
            this.ctx.gateway().readLock();
            try {
                startTime = U.currentTimeMillis();
lbl14:
                // 2 sources

                while (true) {
                    node = null;
                    try {
                        node = this.nodeForService(this.name, this.sticky);
                        if (node == null) {
                            throw new IgniteException("Failed to find deployed service: " + this.name);
                        }
                        if (node.isLocal()) {
                            svcCtx = this.ctx.service().serviceContext(this.name);
                            if (svcCtx == null || (svc = svcCtx.service()) == null) break block21;
                            hist = svcCtx.isStatisticsEnabled() != false ? GridServiceProxy.invocationHistogramm((ServiceContextImpl)svcCtx, mtd.getName(), args) : null;
                            var10_15 = hist == null ? this.callServiceLocally((ServiceContextImpl)svcCtx, mtd, args, callAttrs) : GridServiceProxy.measureCall(hist, (Callable<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$invokeMethod$0(org.apache.ignite.internal.processors.service.ServiceContextImpl java.lang.reflect.Method java.lang.Object[] java.util.Map ), ()Ljava/lang/Object;)((GridServiceProxy)this, (ServiceContextImpl)svcCtx, (Method)mtd, (Object[])args, callAttrs));
                        }
                        break;
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                    catch (Error | RuntimeException e) {
                        throw e;
                    }
                    catch (IgniteCheckedException e) {
                        ignorableCause = X.cause(e, ClusterTopologyCheckedException.class);
                        if (ignorableCause == null) {
                            ignorableCause = X.cause(e, GridServiceNotFoundException.class);
                        }
                        if (ignorableCause == null) {
                            svcProxyE = X.cause(e, ServiceProxyException.class);
                            if (svcProxyE == null) throw U.convertException(e);
                            throw svcProxyE.getCause();
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Service was not found or topology changed (will retry): " + ignorableCause.getMessage());
                        }
                        break block21;
                    }
                    catch (Exception e) {
                        throw new IgniteException(e);
                    }
                    this.ctx.gateway().readUnlock();
                    return var10_15;
                }
            }
            catch (Throwable var11_16) {
                this.ctx.gateway().readUnlock();
                throw var11_16;
            }
            {
                this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_IO_POLICY, (byte)11);
                svcCtx = this.unmarshalResult(this.ctx.closure().callAsyncNoFailover(GridClosureCallMode.BROADCAST, new ServiceProxyCallable(GridServiceProxy.methodName(mtd), this.name, mtd.getParameterTypes(), args, callAttrs), Collections.singleton(node), false, this.waitTimeout, true).get());
            }
            this.ctx.gateway().readUnlock();
            return svcCtx;
        }
        this.rmtNode.compareAndSet(node, null);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteException(e);
        }
        ** while (this.waitTimeout <= 0L || U.currentTimeMillis() - startTime < this.waitTimeout)
lbl63:
        // 1 sources

        throw new IgniteException("Service acquire timeout was reached, stopping. [timeout=" + this.waitTimeout + "]");
    }

    private Object callServiceLocally(ServiceContextImpl svcCtx, Method mtd, Object[] args, @Nullable Map<String, Object> callAttrs) throws Exception {
        Service svc = svcCtx.service();
        if (svc instanceof PlatformService && !PLATFORM_SERVICE_INVOKE_METHOD.equals(mtd)) {
            return ((PlatformService)svc).invokeMethod(GridServiceProxy.methodName(mtd), false, true, args, callAttrs);
        }
        return GridServiceProxy.callServiceMethod(svcCtx, mtd, args, callAttrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object callServiceMethod(ServiceContextImpl svcCtx, Method mtd, Object[] args, @Nullable Map<String, Object> callAttrs) throws Exception {
        ServiceCallContextImpl prevCtx = null;
        if (callAttrs != null) {
            prevCtx = ServiceCallContextHolder.current();
            ServiceCallContextHolder.current(new ServiceCallContextImpl(callAttrs));
        }
        try {
            ServiceCallInterceptor interceptor = svcCtx.interceptor();
            Object object = interceptor == null ? mtd.invoke((Object)svcCtx.service(), args) : interceptor.invoke(mtd.getName(), args, svcCtx, () -> mtd.invoke((Object)svcCtx.service(), args));
            return object;
        }
        finally {
            if (callAttrs != null) {
                ServiceCallContextHolder.current(prevCtx);
            }
        }
    }

    private Object unmarshalResult(byte[] res) throws IgniteCheckedException {
        Marshaller marsh = this.ctx.config().getMarshaller();
        if (this.keepBinary && BinaryArray.useBinaryArrays() && marsh instanceof BinaryMarshaller) {
            return ((BinaryMarshaller)marsh).binaryMarshaller().unmarshal(res, null);
        }
        return U.unmarshal(marsh, res, null);
    }

    private ClusterNode nodeForService(String name, boolean sticky) throws IgniteCheckedException {
        while (sticky) {
            ClusterNode curNode = this.rmtNode.get();
            if (curNode != null) {
                return curNode;
            }
            curNode = this.randomNodeForService(name);
            if (curNode == null) {
                return null;
            }
            if (!this.rmtNode.compareAndSet(null, curNode)) continue;
            return curNode;
        }
        return this.randomNodeForService(name);
    }

    private ClusterNode randomNodeForService(String name) throws IgniteCheckedException {
        if (this.hasLocNode && this.ctx.service().service(name) != null) {
            return this.ctx.discovery().localNode();
        }
        Map<UUID, Integer> snapshot = this.ctx.service().serviceTopology(name, this.waitTimeout);
        if (snapshot == null || snapshot.isEmpty()) {
            return null;
        }
        if (snapshot.size() == 1) {
            UUID nodeId = snapshot.keySet().iterator().next();
            return this.prj.node(nodeId);
        }
        Collection<ClusterNode> nodes = this.prj.nodes();
        if (nodes.size() == 1) {
            ClusterNode n = nodes.iterator().next();
            return snapshot.containsKey(n.id()) ? n : null;
        }
        if (this.prj.predicate() == F.alwaysTrue()) {
            int idx = ThreadLocalRandom.current().nextInt(snapshot.size());
            int i = 0;
            for (Map.Entry<UUID, Integer> e : snapshot.entrySet()) {
                if (i++ < idx || e.getValue() <= 0) continue;
                return this.ctx.discovery().node(e.getKey());
            }
            i = 0;
            for (Map.Entry<UUID, Integer> e : snapshot.entrySet()) {
                if (e.getValue() > 0) {
                    return this.ctx.discovery().node(e.getKey());
                }
                if (i++ != idx) continue;
                return null;
            }
        } else {
            ArrayList<ClusterNode> nodeList = new ArrayList<ClusterNode>(nodes.size());
            for (ClusterNode n : nodes) {
                Integer cnt = snapshot.get(n.id());
                if (cnt == null || cnt <= 0) continue;
                nodeList.add(n);
            }
            if (nodeList.isEmpty()) {
                return null;
            }
            int idx = ThreadLocalRandom.current().nextInt(nodeList.size());
            return (ClusterNode)nodeList.get(idx);
        }
        return null;
    }

    T proxy() {
        return this.proxy;
    }

    private static String methodName(Method mtd) {
        PlatformServiceMethod ann = mtd.getDeclaredAnnotation(PlatformServiceMethod.class);
        return ann == null ? mtd.getName() : ann.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T measureCall(HistogramMetricImpl histogram, Callable<T> target) throws Exception {
        long startTime = System.nanoTime();
        try {
            T t = target.call();
            return t;
        }
        finally {
            histogram.value(System.nanoTime() - startTime);
        }
    }

    private static HistogramMetricImpl invocationHistogramm(ServiceContextImpl ctx, String mtdName, Object[] args) {
        if (ctx.service() instanceof PlatformService) {
            assert (args.length > 0 && args[0] instanceof String);
            assert (ctx.metrics() != null);
            return (HistogramMetricImpl)ctx.metrics().findMetric((String)args[0]);
        }
        return (HistogramMetricImpl)ctx.metrics().findMetric(mtdName);
    }

    private /* synthetic */ Object lambda$invokeMethod$0(ServiceContextImpl svcCtx, Method mtd, Object[] args, Map callAttrs) throws Exception {
        return this.callServiceLocally(svcCtx, mtd, args, callAttrs);
    }

    static {
        try {
            PLATFORM_SERVICE_INVOKE_METHOD = PlatformService.class.getMethod("invokeMethod", String.class, Boolean.TYPE, Boolean.TYPE, Object[].class, Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError("'invokeMethod' is not defined in " + PlatformService.class.getName());
        }
    }

    private static class ServiceProxyException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        ServiceProxyException(Throwable cause) {
            super(cause);
        }
    }

    private static class ServiceProxyCallable
    implements IgniteCallable<byte[]>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private String mtdName;
        private String svcName;
        private Class<?>[] argTypes;
        private Object[] args;
        private Map<String, Object> callAttrs;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        public ServiceProxyCallable() {
        }

        private ServiceProxyCallable(String mtdName, String svcName, Class<?>[] argTypes, Object[] args, @Nullable Map<String, Object> callAttrs) {
            this.mtdName = mtdName;
            this.svcName = svcName;
            this.argTypes = argTypes;
            this.args = args;
            this.callAttrs = callAttrs;
        }

        @Override
        public byte[] call() throws Exception {
            ServiceContextImpl ctx = this.ignite.context().service().serviceContext(this.svcName);
            if (ctx == null || ctx.service() == null) {
                throw new GridServiceNotFoundException(this.svcName);
            }
            GridServiceMethodReflectKey key = new GridServiceMethodReflectKey(this.mtdName, this.argTypes);
            Method mtd = ctx.method(key);
            HistogramMetricImpl hist = ctx.isStatisticsEnabled() ? GridServiceProxy.invocationHistogramm(ctx, this.mtdName, this.args) : null;
            Object res = hist == null ? this.callService(ctx, mtd) : GridServiceProxy.measureCall(hist, () -> this.callService(ctx, mtd));
            return U.marshal(this.ignite.configuration().getMarshaller(), res);
        }

        private Object callService(ServiceContextImpl svcCtx, Method mtd) throws Exception {
            if (svcCtx.service() instanceof PlatformService && mtd == null) {
                return this.callPlatformService((PlatformService)svcCtx.service());
            }
            return this.callOrdinaryService(svcCtx, mtd);
        }

        private Object callPlatformService(PlatformService srv) {
            try {
                return srv.invokeMethod(this.mtdName, false, true, this.args, this.callAttrs);
            }
            catch (PlatformNativeException ne) {
                throw new ServiceProxyException(U.convertException(ne));
            }
            catch (Exception e) {
                throw new ServiceProxyException(e);
            }
        }

        private Object callOrdinaryService(ServiceContextImpl svcCtx, Method mtd) throws Exception {
            if (mtd == null) {
                throw new GridServiceMethodNotFoundException(this.svcName, this.mtdName, this.argTypes);
            }
            try {
                return GridServiceProxy.callServiceMethod(svcCtx, mtd, this.args, this.callAttrs);
            }
            catch (InvocationTargetException e) {
                throw new ServiceProxyException(e.getCause());
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeString(out, this.svcName);
            U.writeString(out, this.mtdName);
            U.writeArray(out, this.argTypes);
            U.writeArray(out, this.args);
            U.writeMap(out, this.callAttrs);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.svcName = U.readString(in);
            this.mtdName = U.readString(in);
            this.argTypes = U.readClassArray(in);
            this.args = U.readArray(in);
            this.callAttrs = U.readMap(in);
        }

        public String toString() {
            return S.toString(ServiceProxyCallable.class, this);
        }
    }

    private class ProxyInvocationHandler
    implements InvocationHandler {
        private final Supplier<Map<String, Object>> callAttrsProvider;

        public ProxyInvocationHandler(Supplier<Map<String, Object>> callAttrsProvider) {
            this.callAttrsProvider = callAttrsProvider;
        }

        @Override
        public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
            return GridServiceProxy.this.invokeMethod(mtd, args, this.callAttrsProvider != null ? this.callAttrsProvider.get() : null);
        }
    }
}

