/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.cache.GridCacheRestMetrics;
import org.apache.ignite.internal.processors.rest.protocols.tcp.GridMemcachedMessage;
import org.apache.ignite.internal.processors.rest.request.DataStructuresRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.lang.IgniteClosure2X;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioServerListenerAdapter;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridTcpMemcachedNioListener
extends GridNioServerListenerAdapter<GridMemcachedMessage> {
    private static final String CACHE_NAME = "default";
    private final IgniteLogger log;
    private final GridRestProtocolHandler hnd;

    public GridTcpMemcachedNioListener(IgniteLogger log, GridRestProtocolHandler hnd) {
        this.log = log;
        this.hnd = hnd;
    }

    @Override
    public void onConnected(GridNioSession ses) {
        assert (false);
    }

    @Override
    public void onDisconnected(GridNioSession ses, @Nullable Exception e) {
        assert (false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(final GridNioSession ses, final GridMemcachedMessage req) {
        IgniteInternalFuture<GridRestResponse> f;
        assert (req != null);
        final GridTuple3<GridRestCommand, Boolean, Boolean> cmd = this.command(req.operationCode());
        if (cmd == null) {
            U.warn(this.log, "Cannot find corresponding REST command for op code (session will be closed) [ses=" + ses + ", opCode=" + Integer.toHexString(req.operationCode()) + ']');
            ses.close();
            return;
        }
        assert (req.requestFlag() == -128);
        assert (cmd.get2() != null && cmd.get3() != null);
        if (cmd.get1() == GridRestCommand.QUIT) {
            try {
                if (cmd.get2().booleanValue()) {
                    GridMemcachedMessage res = new GridMemcachedMessage(req);
                    this.sendResponse(ses, res).get();
                }
            }
            catch (Exception e) {
                U.warn(this.log, "Failed to send quit response packet (session will be closed anyway) [ses=" + ses + ", msg=" + e.getMessage() + "]");
            }
            finally {
                ses.close();
            }
            return;
        }
        IgniteInternalFuture lastFut = (IgniteInternalFuture)ses.removeMeta(GridNioSessionMetaKey.LAST_FUT.ordinal());
        if (lastFut != null && lastFut.isDone()) {
            lastFut = null;
        }
        if ((f = lastFut == null ? this.handleRequest0(ses, req, cmd) : new GridEmbeddedFuture<GridRestResponse, GridRestResponse>(lastFut, new C2<GridRestResponse, Exception, IgniteInternalFuture<GridRestResponse>>(){

            @Override
            public IgniteInternalFuture<GridRestResponse> apply(GridRestResponse res, Exception e) {
                return GridTcpMemcachedNioListener.this.handleRequest0(ses, req, cmd);
            }
        })) != null) {
            ses.addMeta(GridNioSessionMetaKey.LAST_FUT.ordinal(), f);
        }
    }

    @Nullable
    private IgniteInternalFuture<GridRestResponse> handleRequest0(final GridNioSession ses, final GridMemcachedMessage req, final GridTuple3<GridRestCommand, Boolean, Boolean> cmd) {
        if (cmd.get1() == GridRestCommand.NOOP) {
            GridMemcachedMessage res0 = new GridMemcachedMessage(req);
            res0.status(0);
            this.sendResponse(ses, res0);
            return null;
        }
        return new GridEmbeddedFuture<GridRestResponse, GridRestResponse>(new IgniteClosure2X<GridRestResponse, Exception, GridRestResponse>(){

            @Override
            public GridRestResponse applyx(GridRestResponse restRes, Exception ex) throws IgniteCheckedException {
                if (ex != null) {
                    throw U.cast(ex);
                }
                if (cmd.get1() == GridRestCommand.CACHE_METRICS) {
                    assert (restRes.getResponse() instanceof GridCacheRestMetrics);
                    Map<String, Long> metrics = ((GridCacheRestMetrics)restRes.getResponse()).map();
                    for (Map.Entry<String, Long> e : metrics.entrySet()) {
                        GridMemcachedMessage res = new GridMemcachedMessage(req);
                        res.key(e.getKey());
                        res.value(String.valueOf(e.getValue()));
                        GridTcpMemcachedNioListener.this.sendResponse(ses, res);
                    }
                    GridTcpMemcachedNioListener.this.sendResponse(ses, new GridMemcachedMessage(req));
                } else {
                    GridMemcachedMessage res = new GridMemcachedMessage(req);
                    if (restRes.getSuccessStatus() == 0) {
                        switch ((GridRestCommand)((Object)cmd.get1())) {
                            case CACHE_GET: {
                                res.status(restRes.getResponse() == null ? 1 : 0);
                                break;
                            }
                            case CACHE_PUT: 
                            case CACHE_ADD: 
                            case CACHE_REMOVE: 
                            case CACHE_REPLACE: 
                            case CACHE_CAS: 
                            case CACHE_APPEND: 
                            case CACHE_PREPEND: {
                                boolean res0 = restRes.getResponse().equals(Boolean.TRUE);
                                res.status(res0 ? 0 : 4);
                                break;
                            }
                            default: {
                                res.status(0);
                                break;
                            }
                        }
                    } else {
                        res.status(4);
                    }
                    if (cmd.get3() == Boolean.TRUE) {
                        res.key(req.key());
                    }
                    if (restRes.getSuccessStatus() == 0 && res.addData() && restRes.getResponse() != null) {
                        res.value(restRes.getResponse());
                    }
                    GridTcpMemcachedNioListener.this.sendResponse(ses, res);
                }
                return restRes;
            }
        }, this.hnd.handleAsync(this.createRestRequest(req, cmd.get1())));
    }

    private GridNioFuture<?> sendResponse(GridNioSession ses, GridMemcachedMessage res) {
        return ses.send(res);
    }

    private GridRestRequest createRestRequest(GridMemcachedMessage req, GridRestCommand cmd) {
        assert (req != null);
        if (cmd == GridRestCommand.ATOMIC_INCREMENT || cmd == GridRestCommand.ATOMIC_DECREMENT) {
            DataStructuresRequest restReq = new DataStructuresRequest();
            restReq.command(cmd);
            restReq.key(req.key());
            restReq.delta(req.delta());
            restReq.initial(req.initial());
            return restReq;
        }
        GridRestCacheRequest restReq = new GridRestCacheRequest();
        restReq.command(cmd);
        restReq.clientId(req.clientId());
        restReq.ttl(req.expiration());
        restReq.cacheName(req.cacheName() == null ? CACHE_NAME : req.cacheName());
        restReq.key(req.key());
        if (cmd == GridRestCommand.CACHE_REMOVE_ALL) {
            Object[] keys = (Object[])req.value();
            if (keys != null) {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                for (Object key : keys) {
                    map.put(key, null);
                }
                restReq.values(map);
            }
        } else if (req.value() != null) {
            restReq.value(req.value());
        }
        return restReq;
    }

    @Nullable
    private GridTuple3<GridRestCommand, Boolean, Boolean> command(int opCode) {
        GridRestCommand cmd;
        boolean quiet = false;
        boolean retKey = false;
        switch (opCode) {
            case 0: {
                cmd = GridRestCommand.CACHE_GET;
                break;
            }
            case 1: {
                cmd = GridRestCommand.CACHE_PUT;
                break;
            }
            case 2: {
                cmd = GridRestCommand.CACHE_ADD;
                break;
            }
            case 3: {
                cmd = GridRestCommand.CACHE_REPLACE;
                break;
            }
            case 4: {
                cmd = GridRestCommand.CACHE_REMOVE;
                break;
            }
            case 5: {
                cmd = GridRestCommand.ATOMIC_INCREMENT;
                break;
            }
            case 6: {
                cmd = GridRestCommand.ATOMIC_DECREMENT;
                break;
            }
            case 7: {
                cmd = GridRestCommand.QUIT;
                break;
            }
            case 8: {
                cmd = GridRestCommand.CACHE_REMOVE_ALL;
                break;
            }
            case 9: {
                cmd = GridRestCommand.CACHE_GET;
                break;
            }
            case 10: {
                cmd = GridRestCommand.NOOP;
                break;
            }
            case 11: {
                cmd = GridRestCommand.VERSION;
                break;
            }
            case 12: {
                cmd = GridRestCommand.CACHE_GET;
                retKey = true;
                break;
            }
            case 13: {
                cmd = GridRestCommand.CACHE_GET;
                retKey = true;
                break;
            }
            case 14: {
                cmd = GridRestCommand.CACHE_APPEND;
                break;
            }
            case 15: {
                cmd = GridRestCommand.CACHE_PREPEND;
                break;
            }
            case 16: {
                cmd = GridRestCommand.CACHE_METRICS;
                break;
            }
            case 17: {
                cmd = GridRestCommand.CACHE_PUT;
                quiet = true;
                break;
            }
            case 18: {
                cmd = GridRestCommand.CACHE_ADD;
                quiet = true;
                break;
            }
            case 19: {
                cmd = GridRestCommand.CACHE_REPLACE;
                quiet = true;
                break;
            }
            case 20: {
                cmd = GridRestCommand.CACHE_REMOVE;
                quiet = true;
                break;
            }
            case 21: {
                cmd = GridRestCommand.ATOMIC_INCREMENT;
                quiet = true;
                break;
            }
            case 22: {
                cmd = GridRestCommand.ATOMIC_DECREMENT;
                quiet = true;
                break;
            }
            case 23: {
                cmd = GridRestCommand.QUIT;
                quiet = true;
                break;
            }
            case 24: {
                cmd = GridRestCommand.CACHE_REMOVE_ALL;
                quiet = true;
                break;
            }
            case 25: {
                cmd = GridRestCommand.CACHE_APPEND;
                quiet = true;
                break;
            }
            case 26: {
                cmd = GridRestCommand.CACHE_PREPEND;
                quiet = true;
                break;
            }
            default: {
                return null;
            }
        }
        return new GridTuple3<GridRestCommand, Boolean, Boolean>(cmd, quiet, retKey);
    }
}

