/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.QueryEngineConfiguration;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.cache.query.index.IndexQueryProcessor;
import org.apache.ignite.internal.cache.query.index.IndexQueryResult;
import org.apache.ignite.internal.cache.query.index.sorted.maintenance.MaintenanceRebuildIndexUtils;
import org.apache.ignite.internal.cache.query.index.sorted.maintenance.RebuildIndexWorkflowCallback;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.IndexQueryDesc;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformProcessor;
import org.apache.ignite.internal.processors.query.CacheQueryObjectValueContext;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.IndexingQueryEngine;
import org.apache.ignite.internal.processors.query.QueryContext;
import org.apache.ignite.internal.processors.query.QueryEngine;
import org.apache.ignite.internal.processors.query.QueryEngineConfigurationEx;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryIndexKey;
import org.apache.ignite.internal.processors.query.QueryKeyValueIterable;
import org.apache.ignite.internal.processors.query.QuerySchema;
import org.apache.ignite.internal.processors.query.QueryTypeCandidate;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryTypeIdKey;
import org.apache.ignite.internal.processors.query.QueryTypeNameKey;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.RunningQueryManager;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.processors.query.UpdateSourceIterator;
import org.apache.ignite.internal.processors.query.aware.IndexBuildStatusStorage;
import org.apache.ignite.internal.processors.query.aware.IndexRebuildFutureStorage;
import org.apache.ignite.internal.processors.query.property.QueryBinaryProperty;
import org.apache.ignite.internal.processors.query.schema.IndexRebuildCancelToken;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorImpl;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationClientFuture;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationManager;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationWorker;
import org.apache.ignite.internal.processors.query.schema.management.SchemaManager;
import org.apache.ignite.internal.processors.query.schema.message.SchemaAbstractDiscoveryMessage;
import org.apache.ignite.internal.processors.query.schema.message.SchemaFinishDiscoveryMessage;
import org.apache.ignite.internal.processors.query.schema.message.SchemaOperationStatusMessage;
import org.apache.ignite.internal.processors.query.schema.message.SchemaProposeDiscoveryMessage;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAbstractOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAddQueryEntityOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAlterTableAddColumnOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAlterTableDropColumnOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaIndexCreateOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaIndexDropOperation;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsManager;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsManagerImpl;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashSet;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridPlainOutClosure;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.lang.IgniteOutClosureX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

public class GridQueryProcessor
extends GridProcessorAdapter {
    private static final String INLINE_SIZES_DISCO_BAG_KEY = "inline_sizes";
    public static final String INLINE_SIZES_DIFFER_WARN_MSG_FORMAT = "Inline sizes on local node and node %s are different. Please drop and create again these indexes to avoid performance problems with SQL queries. Problem indexes: %s";
    private static final int QRY_DETAIL_METRICS_EVICTION_FREQ = 3000;
    public static final Pattern QRY_HINT_PATTERN = Pattern.compile("/\\*\\+((?:.|[\\n\\r])*?)\\*/");
    public static final Pattern QRY_ENGINE_PATTERN = Pattern.compile("QUERY_ENGINE[\\s]*\\([\\s]*'([a-z0-9]+)'[\\s]*\\)", 2);
    private static final ThreadLocal<AffinityTopologyVersion> requestTopVer = new ThreadLocal();
    public static Class<? extends GridQueryIndexing> idxCls;
    private final JdkMarshaller marsh = new JdkMarshaller();
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private GridTimeoutProcessor.CancelableTask qryDetailMetricsEvictTask;
    private final Map<QueryTypeIdKey, QueryTypeDescriptorImpl> types = new ConcurrentHashMap<QueryTypeIdKey, QueryTypeDescriptorImpl>();
    private final ConcurrentMap<QueryTypeNameKey, QueryTypeDescriptorImpl> typesByName = new ConcurrentHashMap<QueryTypeNameKey, QueryTypeDescriptorImpl>();
    @Nullable
    private final GridQueryIndexing idx;
    private final IndexProcessor idxProc;
    private final IndexQueryProcessor idxQryPrc;
    private final CacheQueryObjectValueContext valCtx;
    private final ConcurrentMap<QueryIndexKey, QueryIndexDescriptorImpl> idxs = new ConcurrentHashMap<QueryIndexKey, QueryIndexDescriptorImpl>();
    private final ConcurrentMap<UUID, SchemaOperationClientFuture> schemaCliFuts = new ConcurrentHashMap<UUID, SchemaOperationClientFuture>();
    private final GridMessageListener ioLsnr;
    private final ConcurrentHashMap<String, SchemaOperation> schemaOps = new ConcurrentHashMap();
    private final LinkedHashMap<UUID, SchemaProposeDiscoveryMessage> activeProposals = new LinkedHashMap();
    private final Object stateMux = new Object();
    private ClusterNode crd;
    private final Collection<String> cacheNames = ConcurrentHashMap.newKeySet();
    private final GridBoundedConcurrentLinkedHashSet<IgniteUuid> dscoMsgIdHist = new GridBoundedConcurrentLinkedHashSet(QueryUtils.discoveryHistorySize());
    private final GridBoundedConcurrentLinkedHashSet<UUID> completedOpIds = new GridBoundedConcurrentLinkedHashSet(QueryUtils.discoveryHistorySize());
    private final LinkedList<SchemaOperationStatusMessage> pendingMsgs = new LinkedList();
    private final ThreadLocal<GridCacheContext> curCache = new ThreadLocal();
    private boolean disconnected;
    private boolean exchangeReady;
    private boolean skipFieldLookup;
    private final Set<Long> missedCacheTypes = ConcurrentHashMap.newKeySet();
    private final IndexRebuildFutureStorage idxRebuildFutStorage = new IndexRebuildFutureStorage();
    private final IndexBuildStatusStorage idxBuildStatusStorage;
    private IgniteStatisticsManager statsMgr;
    private QueryEngine dfltQryEngine;
    private QueryEngine[] qryEngines;
    private QueryEngineConfigurationEx[] qryEnginesCfg;
    private RunningQueryManager runningQryMgr;
    private final SchemaManager schemaMgr;

    public GridQueryProcessor(GridKernalContext ctx) throws IgniteCheckedException {
        super(ctx);
        if (idxCls != null) {
            this.idx = U.newInstance(idxCls);
            idxCls = null;
        } else {
            this.idx = IgniteComponentType.INDEXING.inClassPath() ? (GridQueryIndexing)U.newInstance(IgniteComponentType.INDEXING.className()) : null;
        }
        this.schemaMgr = new SchemaManager(ctx);
        this.idxProc = ctx.indexProcessor();
        this.idxQryPrc = new IndexQueryProcessor(this.idxProc);
        this.valCtx = new CacheQueryObjectValueContext(ctx);
        this.ioLsnr = (nodeId, msg, plc) -> {
            if (msg instanceof SchemaOperationStatusMessage) {
                SchemaOperationStatusMessage msg0 = (SchemaOperationStatusMessage)msg;
                msg0.senderNodeId(nodeId);
                this.processStatusMessage(msg0);
            } else {
                U.warn(this.log, "Unsupported IO message: " + msg);
            }
        };
        this.initQueryEngines();
        this.idxBuildStatusStorage = new IndexBuildStatusStorage(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        this.runningQryMgr = new RunningQueryManager(this.ctx);
        this.runningQryMgr.start(this.busyLock);
        if (this.idx != null) {
            this.ctx.resource().injectGeneric(this.idx);
            this.idx.start(this.ctx, this.busyLock);
        }
        this.statsMgr = new IgniteStatisticsManagerImpl(this.ctx);
        this.schemaMgr.start(this.ctx.config().getSqlConfiguration().getSqlSchemas());
        this.ctx.io().addMessageListener(GridTopic.TOPIC_SCHEMA, this.ioLsnr);
        this.qryDetailMetricsEvictTask = this.ctx.timeout().schedule(() -> {
            for (GridCacheContext ctxs : this.ctx.cache().context().cacheContexts()) {
                ctxs.queries().evictDetailMetrics();
            }
        }, 3000L, 3000L);
        this.ctx.maintenanceRegistry().registerWorkflowCallbackIfTaskExists("indexRebuildMaintenanceTask", task -> new RebuildIndexWorkflowCallback(MaintenanceRebuildIndexUtils.parseMaintenanceTaskParameters(task.parameters()), this.ctx));
        this.idxBuildStatusStorage.start();
        this.registerMetadataForRegisteredCaches(false);
    }

    @Override
    public void onKernalStop(boolean cancel) {
        super.onKernalStop(cancel);
        if (cancel && this.idx != null) {
            try {
                while (!this.busyLock.tryBlock(500L)) {
                    this.idx.onKernalStop();
                }
                return;
            }
            catch (InterruptedException ignored) {
                U.warn(this.log, "Interrupted while waiting for active queries cancellation.");
                Thread.currentThread().interrupt();
            }
        }
        this.busyLock.block();
        this.idxBuildStatusStorage.stop();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        super.stop(cancel);
        this.ctx.io().removeMessageListener(GridTopic.TOPIC_SCHEMA, this.ioLsnr);
        if (this.idx != null) {
            this.idx.stop();
        }
        this.runningQryMgr.stop();
        this.schemaMgr.stop();
        this.statsMgr.stop();
        U.closeQuiet(this.qryDetailMetricsEvictTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheKernalStart() throws IgniteCheckedException {
        Object object = this.stateMux;
        synchronized (object) {
            this.exchangeReady = true;
            for (SchemaOperation schemaOp : this.schemaOps.values()) {
                this.onSchemaPropose(schemaOp.proposeMessage());
            }
        }
        this.idxBuildStatusStorage.onCacheKernalStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheReconnect() throws IgniteCheckedException {
        Object object = this.stateMux;
        synchronized (object) {
            assert (this.disconnected);
            this.disconnected = false;
            this.onCacheKernalStart();
        }
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.QUERY_PROC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        LinkedHashMap<UUID, SchemaProposeDiscoveryMessage> proposals;
        Object object = this.stateMux;
        synchronized (object) {
            proposals = new LinkedHashMap<UUID, SchemaProposeDiscoveryMessage>(this.activeProposals);
        }
        dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.QUERY_PROC.ordinal(), proposals);
        if (!dataBag.isJoiningNodeClient()) {
            HashMap<String, Serializable> nodeSpecificMap = new HashMap<String, Serializable>();
            Serializable oldVal = nodeSpecificMap.put(INLINE_SIZES_DISCO_BAG_KEY, this.collectSecondaryIndexesInlineSize());
            assert (oldVal == null) : oldVal;
            dataBag.addNodeSpecificData(GridComponent.DiscoveryDataExchangeType.QUERY_PROC.ordinal(), nodeSpecificMap);
        }
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        Map nodeSpecificDataMap;
        if (data.hasJoiningNodeData() && data.joiningNodeData() instanceof Map && (nodeSpecificDataMap = (Map)((Object)data.joiningNodeData())).containsKey(INLINE_SIZES_DISCO_BAG_KEY)) {
            Serializable serializable = (Serializable)nodeSpecificDataMap.get(INLINE_SIZES_DISCO_BAG_KEY);
            assert (serializable instanceof Map) : serializable;
            Map joiningNodeIndexesInlineSize = (Map)((Object)serializable);
            this.checkInlineSizes(this.secondaryIndexesInlineSize(), joiningNodeIndexesInlineSize, data.joiningNodeId());
        }
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        HashMap<String, Serializable> dataMap = new HashMap<String, Serializable>();
        dataMap.put(INLINE_SIZES_DISCO_BAG_KEY, this.collectSecondaryIndexesInlineSize());
        dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.QUERY_PROC.ordinal(), dataMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        Map<String, Integer> indexesInlineSize;
        LinkedHashMap activeProposals = (LinkedHashMap)data.commonData();
        if (!F.isEmpty(activeProposals)) {
            Object object = this.stateMux;
            synchronized (object) {
                for (SchemaProposeDiscoveryMessage activeProposal : activeProposals.values()) {
                    this.onSchemaProposeDiscovery0(activeProposal);
                }
            }
        }
        if (!F.isEmpty(data.nodeSpecificData()) && !F.isEmpty(indexesInlineSize = this.secondaryIndexesInlineSize())) {
            for (UUID nodeId : data.nodeSpecificData().keySet()) {
                Serializable serializable = data.nodeSpecificData().get(nodeId);
                assert (serializable instanceof Map) : serializable;
                Map nodeSpecificData = (Map)((Object)serializable);
                if (!nodeSpecificData.containsKey(INLINE_SIZES_DISCO_BAG_KEY)) continue;
                this.checkInlineSizes(indexesInlineSize, (Map)nodeSpecificData.get(INLINE_SIZES_DISCO_BAG_KEY), nodeId);
            }
        }
    }

    public void beforeExchange(GridDhtPartitionsExchangeFuture fut) {
        Set<Integer> cacheIds = this.rebuildIndexCacheIds(fut);
        Set<Integer> rejected = this.idxRebuildFutStorage.prepareRebuildIndexes(cacheIds, fut.initialVersion());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Preparing features of rebuilding indexes for caches on exchange [requested=" + cacheIds + ", rejected=" + rejected + ']');
        }
    }

    private void initQueryEngines() throws IgniteCheckedException {
        boolean hasIdxCfg = false;
        int dfltQryEngineIdx = -1;
        QueryEngineConfiguration[] qryEnginesCfg = this.ctx.config().getSqlConfiguration().getQueryEnginesConfiguration();
        if (F.isEmpty(qryEnginesCfg)) {
            if (!this.indexingEnabled()) {
                for (GridComponent cmp : this.ctx.components()) {
                    if (!(cmp instanceof QueryEngine)) continue;
                    this.qryEngines = new QueryEngine[]{(QueryEngine)cmp};
                    this.dfltQryEngine = (QueryEngine)cmp;
                }
            }
            return;
        }
        this.qryEnginesCfg = new QueryEngineConfigurationEx[qryEnginesCfg.length];
        this.qryEngines = new QueryEngine[qryEnginesCfg.length];
        for (int i = 0; i < qryEnginesCfg.length; ++i) {
            QueryEngineConfigurationEx qryEngineCfgEx;
            QueryEngineConfiguration qryEngineCfg = qryEnginesCfg[i];
            if (!(qryEngineCfg instanceof QueryEngineConfigurationEx)) {
                throw new IgniteCheckedException("Unsupported query engine configuration: " + qryEngineCfg.getClass());
            }
            this.qryEnginesCfg[i] = qryEngineCfgEx = (QueryEngineConfigurationEx)qryEngineCfg;
            Class<? extends QueryEngine> qryEngineCls = qryEngineCfgEx.engineClass();
            for (int j = 0; j < i; ++j) {
                if (this.qryEnginesCfg[j].engineClass() != qryEngineCls) continue;
                throw new IgniteCheckedException("Only one instance of each query engine can be set");
            }
            QueryEngine qryEngine = null;
            if (qryEngineCls == IndexingQueryEngine.class) {
                hasIdxCfg = true;
            } else {
                for (GridComponent cmp : this.ctx.components()) {
                    if (!(cmp instanceof QueryEngine) || cmp.getClass() != qryEngineCls) continue;
                    qryEngine = (QueryEngine)cmp;
                    break;
                }
                if (qryEngine == null) {
                    throw new IgniteCheckedException("Can't find query engine for class " + qryEngineCls);
                }
                this.qryEngines[i] = qryEngine;
            }
            if (!qryEngineCfgEx.isDefault()) continue;
            if (dfltQryEngineIdx >= 0) {
                throw new IgniteCheckedException("Only one query engine can be set as default");
            }
            dfltQryEngineIdx = i;
        }
        if (dfltQryEngineIdx < 0) {
            if (!hasIdxCfg) {
                this.dfltQryEngine = this.qryEngines[0];
            }
        } else {
            this.dfltQryEngine = this.qryEngines[dfltQryEngineIdx];
        }
    }

    public Map<String, Integer> secondaryIndexesInlineSize() {
        return this.moduleEnabled() ? this.ctx.indexProcessor().secondaryIndexesInlineSize() : Collections.emptyMap();
    }

    private void checkInlineSizes(Map<String, Integer> local, Map<String, Integer> remote, UUID remoteNodeId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Check inline sizes on remote node with node id: " + remoteNodeId + ". Local: " + local + ", remote: " + remote);
        }
        if (F.isEmpty(local) || F.isEmpty(remote)) {
            return;
        }
        SB sb = new SB();
        for (String indexFullname : local.keySet()) {
            int remoteInlineSize;
            int localInlineSize;
            if (!remote.containsKey(indexFullname) || (localInlineSize = local.get(indexFullname).intValue()) == (remoteInlineSize = remote.get(indexFullname).intValue())) continue;
            sb.a(indexFullname).a("(").a(localInlineSize).a(",").a(remoteInlineSize).a(")").a(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            this.log.warning(String.format(INLINE_SIZES_DIFFER_WARN_MSG_FORMAT, remoteNodeId, sb));
        }
    }

    private Serializable collectSecondaryIndexesInlineSize() {
        Map<String, Integer> map = this.secondaryIndexesInlineSize();
        return map instanceof Serializable ? (Serializable)((Object)map) : new HashMap<String, Integer>(map);
    }

    private boolean onSchemaProposeDiscovery(SchemaProposeDiscoveryMessage msg) {
        SchemaAbstractOperation op = msg.operation();
        UUID opId = op.id();
        String cacheName = op.cacheName();
        if (!msg.initialized()) {
            DynamicCacheDescriptor cacheDesc = this.ctx.cache().cacheDescriptor(cacheName);
            if (cacheDesc == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received schema propose discovery message, but cache doesn't exist (will report error) [opId=" + opId + ", msg=" + msg + ']');
                }
                msg.onError(new SchemaOperationException(1, cacheName));
            } else {
                CacheConfiguration ccfg = cacheDesc.cacheConfiguration();
                if (this.failOnStaticCacheSchemaChanges(cacheDesc)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Received schema propose discovery message, but cache is statically configured and IGNITE_KEEP_STATIC_CACHE_CONFIGURATION flag is set (will report error) [opId=" + opId + ", msg=" + msg + ']');
                    }
                    msg.onError(new SchemaOperationException("Schema changes are not supported for statically configured cache when IGNITE_KEEP_STATIC_CACHE_CONFIGURATION flag is set."));
                } else {
                    if (msg.deploymentId() == null) {
                        msg.deploymentId(cacheDesc.deploymentId());
                    }
                    assert (F.eq(cacheDesc.deploymentId(), msg.deploymentId()));
                    if (msg.operation() instanceof SchemaAlterTableAddColumnOperation) {
                        SchemaAlterTableAddColumnOperation alterOp = (SchemaAlterTableAddColumnOperation)msg.operation();
                        try {
                            for (QueryField field : alterOp.columns()) {
                                if (field.isNullable()) continue;
                                QueryUtils.checkNotNullAllowed(ccfg);
                            }
                        }
                        catch (IgniteSQLException ex) {
                            msg.onError(new SchemaOperationException("Received schema propose discovery message, but cache doesn't applicable for this modification", ex));
                        }
                    }
                }
            }
        }
        if (msg.hasError()) {
            SchemaOperationClientFuture cliFut = (SchemaOperationClientFuture)this.schemaCliFuts.remove(opId);
            if (cliFut != null) {
                cliFut.onDone(msg.error());
            }
            return false;
        }
        return this.onSchemaProposeDiscovery0(msg);
    }

    private boolean failOnStaticCacheSchemaChanges(DynamicCacheDescriptor cacheDesc) {
        return cacheDesc.staticallyConfigured() && this.ctx.cache().keepStaticCacheConfiguration() && cacheDesc.groupDescriptor().persistenceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onSchemaProposeDiscovery0(SchemaProposeDiscoveryMessage msg) {
        UUID opId = msg.operation().id();
        Object object = this.stateMux;
        synchronized (object) {
            if (this.disconnected) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Processing discovery schema propose message, but node is disconnected (will ignore) [opId=" + opId + ", msg=" + msg + ']');
                }
                return false;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Processing discovery schema propose message [opId=" + opId + ", msg=" + msg + ']');
            }
            SchemaProposeDiscoveryMessage oldDesc = this.activeProposals.put(msg.operation().id(), msg);
            assert (oldDesc == null);
            SchemaOperation schemaOp = new SchemaOperation(msg);
            String schemaName = msg.schemaName();
            SchemaOperation prevSchemaOp = this.schemaOps.get(schemaName);
            if (prevSchemaOp != null) {
                prevSchemaOp = prevSchemaOp.unwind();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Schema change is enqueued and will be executed after previous operation is completed [opId=" + opId + ", prevOpId=" + prevSchemaOp.id() + ']');
                }
                prevSchemaOp.next(schemaOp);
                return false;
            }
            this.schemaOps.put(schemaName, schemaOp);
            return this.exchangeReady;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSchemaPropose(SchemaProposeDiscoveryMessage msg) {
        UUID opId = msg.operation().id();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing schema propose message (exchange) [opId=" + opId + ']');
        }
        Object object = this.stateMux;
        synchronized (object) {
            if (this.disconnected) {
                return;
            }
            SchemaOperation curOp = this.schemaOps.get(msg.schemaName());
            assert (curOp != null);
            assert (F.eq(opId, curOp.id()));
            assert (!curOp.started());
            this.startSchemaChange(curOp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSchemaFinishDiscovery(SchemaFinishDiscoveryMessage msg) {
        UUID opId = msg.operation().id();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received schema finish message (discovery) [opId=" + opId + ", msg=" + msg + ']');
        }
        Object object = this.stateMux;
        synchronized (object) {
            DynamicCacheDescriptor cacheDesc;
            if (this.disconnected) {
                return;
            }
            boolean completedOpAdded = this.completedOpIds.add(opId);
            assert (completedOpAdded);
            SchemaProposeDiscoveryMessage proposeMsg = (SchemaProposeDiscoveryMessage)this.activeProposals.remove(opId);
            assert (proposeMsg != null);
            if (!msg.hasError() && (cacheDesc = this.ctx.cache().cacheDescriptor(msg.operation().cacheName())) != null && F.eq(cacheDesc.deploymentId(), proposeMsg.deploymentId())) {
                cacheDesc.schemaChangeFinish(msg);
                try {
                    this.ctx.cache().saveCacheConfiguration(cacheDesc);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Error while saving cache configuration on disk, cfg = " + (Object)((Object)cacheDesc.cacheConfiguration()), e);
                }
            }
            msg.proposeMessage(proposeMsg);
            if (this.exchangeReady) {
                SchemaOperation op = this.schemaOps.get(proposeMsg.schemaName());
                if (F.eq(op.id(), opId)) {
                    op.finishMessage(msg);
                    if (op.started()) {
                        op.doFinish();
                    }
                } else {
                    while (op != null && !F.eq(op.id(), opId)) {
                        op = op.next();
                    }
                    assert (op != null);
                    assert (!op.started());
                    op.finishMessage(msg);
                }
            } else {
                String schemaName = proposeMsg.schemaName();
                SchemaOperation op = this.schemaOps.remove(schemaName);
                assert (op != null);
                assert (F.eq(op.id(), opId));
                SchemaOperation nextOp = op.next();
                if (nextOp != null) {
                    this.schemaOps.put(schemaName, nextOp);
                }
            }
            this.cleanStaleStatusMessages(opId);
        }
    }

    private void startSchemaChange(SchemaOperation schemaOp) {
        SchemaOperationException err;
        assert (Thread.holdsLock(this.stateMux));
        assert (!schemaOp.started());
        SchemaProposeDiscoveryMessage msg = schemaOp.proposeMessage();
        String cacheName = msg.operation().cacheName();
        DynamicCacheDescriptor cacheDesc = this.ctx.cache().cacheDescriptor(cacheName);
        boolean cacheExists = cacheDesc != null && F.eq(msg.deploymentId(), cacheDesc.deploymentId());
        boolean cacheRegistered = cacheExists && this.cacheNames.contains(cacheName);
        SchemaAbstractOperation op = msg.operation();
        QueryTypeDescriptorImpl type = null;
        boolean nop = false;
        if (cacheExists) {
            Cloneable res;
            if (cacheRegistered) {
                res = this.prepareChangeOnStartedCache(op);
                assert (((GridTuple3)res).get2() != null);
                type = (QueryTypeDescriptorImpl)((GridTuple3)res).get1();
                nop = (Boolean)((GridTuple3)res).get2();
                err = (SchemaOperationException)((GridTuple3)res).get3();
            } else {
                res = this.prepareChangeOnNotStartedCache(op, cacheDesc);
                assert (((IgniteBiTuple)res).get1() != null);
                type = null;
                nop = (Boolean)((IgniteBiTuple)res).get1();
                err = (SchemaOperationException)((IgniteBiTuple)res).get2();
            }
        } else {
            err = new SchemaOperationException(1, cacheName);
        }
        SchemaOperationWorker worker = new SchemaOperationWorker(this.ctx, this, msg.deploymentId(), op, nop, err, cacheRegistered, type);
        SchemaOperationManager mgr = new SchemaOperationManager(this.ctx, this, worker, this.ctx.clientNode() ? null : this.coordinator());
        schemaOp.manager(mgr);
        mgr.start();
        if (!this.ctx.clientNode() && this.coordinator().isLocal()) {
            this.unwindPendingMessages(schemaOp.id(), mgr);
        }
        if (schemaOp.hasFinishMessage()) {
            schemaOp.doFinish();
        }
    }

    public boolean indexingEnabled() {
        return this.idx != null;
    }

    public boolean moduleEnabled() {
        return this.indexingEnabled() || this.dfltQryEngine != null;
    }

    public GridQueryIndexing getIndexing() throws IgniteException {
        this.checkxIndexingEnabled();
        return this.idx;
    }

    public RunningQueryManager runningQueryManager() throws IgniteException {
        return this.runningQryMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheStart0(GridCacheContextInfo<?, ?> cacheInfo, QuerySchema schema, boolean isSql) throws IgniteCheckedException {
        if (!this.cacheSupportSql(cacheInfo.config())) {
            Object object = this.stateMux;
            synchronized (object) {
                boolean proceed = false;
                for (SchemaAbstractDiscoveryMessage schemaAbstractDiscoveryMessage : this.activeProposals.values()) {
                    SchemaAddQueryEntityOperation op;
                    if (!(schemaAbstractDiscoveryMessage.operation() instanceof SchemaAddQueryEntityOperation) || !(op = (SchemaAddQueryEntityOperation)schemaAbstractDiscoveryMessage.operation()).cacheName().equals(cacheInfo.name())) continue;
                    proceed = true;
                    break;
                }
                if (!proceed) {
                    return;
                }
            }
        }
        this.ctx.cache().context().database().checkpointReadLock();
        try {
            String cacheName = cacheInfo.name();
            String schemaName = QueryUtils.normalizeSchemaName(cacheName, cacheInfo.config().getSqlSchema());
            if (cacheInfo.isClientCache() && cacheInfo.isCacheContextInited() && this.schemaMgr.initCacheContext(cacheInfo.cacheContext())) {
                if (this.idx != null) {
                    this.idx.registerCache(cacheName, schemaName, cacheInfo);
                }
                return;
            }
            Object object = this.stateMux;
            synchronized (object) {
                boolean bl = cacheInfo.config().isSqlEscapeAll();
                T3<Collection<QueryTypeCandidate>, Map<String, QueryTypeDescriptorImpl>, Map<String, QueryTypeDescriptorImpl>> candRes = this.createQueryCandidates(cacheName, schemaName, cacheInfo, schema.entities(), bl);
                Collection cands = (Collection)candRes.get1();
                Map tblTypMap = (Map)candRes.get2();
                Map idxTypMap = (Map)candRes.get3();
                for (SchemaOperation op : this.schemaOps.values()) {
                    if (!F.eq(op.proposeMessage().deploymentId(), cacheInfo.dynamicDeploymentId())) continue;
                    if (!op.started()) break;
                    SchemaOperationWorker worker = op.manager().worker();
                    assert (!worker.cacheRegistered());
                    if (worker.nop()) break;
                    IgniteInternalFuture fut = worker.future();
                    assert (fut.isDone());
                    if (fut.error() != null) break;
                    SchemaAbstractOperation op0 = op.proposeMessage().operation();
                    if (op0 instanceof SchemaIndexCreateOperation) {
                        SchemaIndexCreateOperation opCreate = (SchemaIndexCreateOperation)op0;
                        QueryTypeDescriptorImpl typeDesc = (QueryTypeDescriptorImpl)tblTypMap.get(opCreate.tableName());
                        assert (typeDesc != null);
                        QueryUtils.processDynamicIndexChange(opCreate.indexName(), opCreate.index(), typeDesc);
                        break;
                    }
                    if (op0 instanceof SchemaIndexDropOperation) {
                        SchemaIndexDropOperation opDrop = (SchemaIndexDropOperation)op0;
                        QueryTypeDescriptorImpl typeDesc = (QueryTypeDescriptorImpl)idxTypMap.get(opDrop.indexName());
                        assert (typeDesc != null);
                        QueryUtils.processDynamicIndexChange(opDrop.indexName(), null, typeDesc);
                        break;
                    }
                    if (op0 instanceof SchemaAlterTableAddColumnOperation) {
                        SchemaAlterTableAddColumnOperation opAddCol = (SchemaAlterTableAddColumnOperation)op0;
                        QueryTypeDescriptorImpl typeDesc = (QueryTypeDescriptorImpl)tblTypMap.get(opAddCol.tableName());
                        assert (typeDesc != null);
                        this.processDynamicAddColumn(typeDesc, opAddCol.columns());
                        break;
                    }
                    if (op0 instanceof SchemaAlterTableDropColumnOperation) {
                        SchemaAlterTableDropColumnOperation opDropCol = (SchemaAlterTableDropColumnOperation)op0;
                        QueryTypeDescriptorImpl typeDesc = (QueryTypeDescriptorImpl)tblTypMap.get(opDropCol.tableName());
                        assert (typeDesc != null);
                        this.processDynamicDropColumn(typeDesc, opDropCol.columns());
                        break;
                    }
                    if (op0 instanceof SchemaAddQueryEntityOperation) {
                        SchemaAddQueryEntityOperation opEnableIdx = (SchemaAddQueryEntityOperation)op0;
                        cacheInfo.onSchemaAddQueryEntity(opEnableIdx);
                        cands = (Collection)this.createQueryCandidates(opEnableIdx.cacheName(), opEnableIdx.schemaName(), cacheInfo, opEnableIdx.entities(), opEnableIdx.isSqlEscape()).get1();
                        schemaName = opEnableIdx.schemaName();
                        break;
                    }
                    assert (false) : "Unsupported operation: " + op0;
                    break;
                }
                this.registerCache0(cacheName, schemaName, cacheInfo, cands, isSql);
            }
        }
        finally {
            this.ctx.cache().context().database().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        ArrayList futs;
        Iterator iterator = this.stateMux;
        synchronized (iterator) {
            this.disconnected = true;
            this.exchangeReady = false;
            futs = new ArrayList(this.schemaCliFuts.values());
            this.schemaCliFuts.clear();
            this.activeProposals.clear();
            this.schemaOps.clear();
        }
        for (SchemaOperationClientFuture fut : futs) {
            fut.onDone(new SchemaOperationException("Client node is disconnected (operation result is unknown)."));
        }
        if (this.idx != null) {
            this.idx.onDisconnected(reconnectFut);
        }
        this.runningQryMgr.onDisconnected();
    }

    public void initQueryStructuresForNotStartedCache(DynamicCacheDescriptor cacheDesc) throws IgniteCheckedException {
        QuerySchema schema = cacheDesc.schema() != null ? cacheDesc.schema() : new QuerySchema();
        GridCacheContextInfo cacheInfo = new GridCacheContextInfo(cacheDesc);
        this.onCacheStart(cacheInfo, schema, cacheDesc.sql());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheStart(GridCacheContextInfo cacheInfo, QuerySchema schema, boolean isSql) throws IgniteCheckedException {
        if (!this.moduleEnabled()) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.onCacheStart0(cacheInfo, schema, isSql);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void onCacheStop(String cacheName) {
        if (!this.moduleEnabled()) {
            return;
        }
        GridCacheContextInfo<?, ?> cacheInfo = this.schemaMgr.cacheInfo(cacheName);
        if (cacheInfo != null) {
            this.onCacheStop(cacheInfo, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheStop(GridCacheContextInfo cacheInfo, boolean removeIdx, boolean clearIdx) {
        if (!this.moduleEnabled()) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.onCacheStop0(cacheInfo, removeIdx, clearIdx);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void onClientCacheStop(GridCacheContextInfo cacheInfo) {
        if (!this.moduleEnabled()) {
            return;
        }
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            if (this.schemaMgr.clearCacheContext(cacheInfo.cacheContext()) && this.idx != null) {
                this.idx.unregisterCache(cacheInfo);
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public boolean skipFieldLookup() {
        return this.skipFieldLookup;
    }

    public void skipFieldLookup(boolean skipFieldLookup) {
        this.skipFieldLookup = skipFieldLookup;
    }

    public void registerMetadataForRegisteredCaches(boolean platformOnly) {
        for (DynamicCacheDescriptor cacheDescriptor : this.ctx.cache().cacheDescriptors().values()) {
            this.registerBinaryMetadata(cacheDescriptor.cacheConfiguration(), cacheDescriptor.schema(), platformOnly);
        }
    }

    public void onCacheChangeRequested(DynamicCacheChangeBatch batch) {
        for (DynamicCacheChangeRequest req : batch.requests()) {
            if (!req.start()) continue;
            try {
                this.registerBinaryMetadata(req.startCacheConfiguration(), req.schema(), false);
            }
            catch (BinaryObjectException e) {
                this.ctx.cache().completeCacheStartFuture(req, false, e);
            }
        }
    }

    private void registerBinaryMetadata(CacheConfiguration ccfg, QuerySchema schema, boolean platformOnly) throws BinaryObjectException {
        boolean binaryEnabled;
        Collection<QueryEntity> qryEntities;
        if (schema != null && !F.isEmpty(qryEntities = schema.entities()) && (binaryEnabled = this.ctx.cacheObjects().isBinaryEnabled(ccfg))) {
            for (QueryEntity qryEntity : qryEntities) {
                this.registerTypeLocally(qryEntity.findKeyType(), platformOnly);
                this.registerTypeLocally(qryEntity.findValueType(), platformOnly);
            }
        }
    }

    private T3<Collection<QueryTypeCandidate>, Map<String, QueryTypeDescriptorImpl>, Map<String, QueryTypeDescriptorImpl>> createQueryCandidates(String cacheName, String schemaName, GridCacheContextInfo<?, ?> cacheInfo, Collection<QueryEntity> entities, boolean escape) throws IgniteCheckedException {
        ArrayList<QueryTypeCandidate> cands = new ArrayList<QueryTypeCandidate>();
        ArrayList mustDeserializeClss = new ArrayList();
        if (!F.isEmpty(entities)) {
            for (QueryEntity qryEntity : entities) {
                QueryTypeCandidate cand = QueryUtils.typeForQueryEntity(this.ctx, cacheName, schemaName, cacheInfo, qryEntity, mustDeserializeClss, escape);
                cands.add(cand);
            }
        }
        HashMap<String, QueryTypeDescriptorImpl> tblTypMap = new HashMap<String, QueryTypeDescriptorImpl>();
        HashMap<String, QueryTypeDescriptorImpl> idxTypMap = new HashMap<String, QueryTypeDescriptorImpl>();
        for (QueryTypeCandidate cand : cands) {
            QueryTypeDescriptorImpl desc = cand.descriptor();
            QueryTypeDescriptorImpl oldDesc = tblTypMap.put(desc.tableName(), desc);
            if (oldDesc != null) {
                throw new IgniteException("Duplicate table name [cache=" + cacheName + ",tblName=" + desc.tableName() + ", type1=" + desc.name() + ", type2=" + oldDesc.name() + ']');
            }
            for (String idxName : desc.indexes().keySet()) {
                oldDesc = idxTypMap.put(idxName, desc);
                if (oldDesc == null) continue;
                throw new IgniteException("Duplicate index name [cache=" + cacheName + ",idxName=" + idxName + ", type1=" + desc.name() + ", type2=" + oldDesc.name() + ']');
            }
        }
        if (!mustDeserializeClss.isEmpty()) {
            U.warnDevOnly(this.log, "Some classes in query configuration cannot be written in binary format because they either implement Externalizable interface or have writeObject/readObject methods. Instances of these classes will be deserialized in order to build indexes. Please ensure that all nodes have these classes in classpath. To enable binary serialization either implement " + Binarylizable.class.getSimpleName() + " interface or set explicit serializer using BinaryTypeConfiguration.setSerializer() method: " + mustDeserializeClss);
        }
        return new T3<Collection<QueryTypeCandidate>, Map<String, QueryTypeDescriptorImpl>, Map<String, QueryTypeDescriptorImpl>>(cands, tblTypMap, idxTypMap);
    }

    private void registerTypeLocally(String clsName, boolean platformOnly) throws BinaryObjectException {
        if (clsName == null) {
            return;
        }
        IgniteCacheObjectProcessor cacheObjProc = this.ctx.cacheObjects();
        if (cacheObjProc instanceof CacheObjectBinaryProcessorImpl) {
            CacheObjectBinaryProcessorImpl binProc = (CacheObjectBinaryProcessorImpl)cacheObjProc;
            Class<?> cls = U.box(U.classForName(clsName, null, true));
            if (cls != null) {
                if (!platformOnly) {
                    binProc.binaryContext().registerClass(cls, true, false, true);
                }
            } else {
                this.registerPlatformTypeLocally(clsName, binProc);
            }
        }
    }

    private void registerPlatformTypeLocally(String clsName, CacheObjectBinaryProcessorImpl binProc) {
        PlatformProcessor platformProc = this.ctx.platform();
        if (platformProc == null || !platformProc.hasContext()) {
            return;
        }
        PlatformContext platformCtx = platformProc.context();
        BinaryMetadata meta = platformCtx.getBinaryType(clsName);
        if (meta != null) {
            binProc.binaryContext().registerClassLocally(meta.wrap(binProc.binaryContext()), false, platformCtx.getMarshallerPlatformId());
        }
    }

    public void onDiscovery(SchemaAbstractDiscoveryMessage msg) {
        IgniteUuid id = msg.id();
        if (!this.dscoMsgIdHist.add(id)) {
            U.warn(this.log, "Received duplicate schema custom discovery message (will ignore) [opId=" + msg.operation().id() + ", msg=" + msg + ']');
            return;
        }
        if (msg instanceof SchemaProposeDiscoveryMessage) {
            SchemaProposeDiscoveryMessage msg0 = (SchemaProposeDiscoveryMessage)msg;
            boolean exchange = this.onSchemaProposeDiscovery(msg0);
            msg0.exchange(exchange);
        } else if (msg instanceof SchemaFinishDiscoveryMessage) {
            SchemaFinishDiscoveryMessage msg0 = (SchemaFinishDiscoveryMessage)msg;
            this.onSchemaFinishDiscovery(msg0);
        } else {
            U.warn(this.log, "Received unsupported schema custom discovery message (will ignore) [opId=" + msg.operation().id() + ", msg=" + msg + ']');
        }
    }

    private T3<QueryTypeDescriptorImpl, Boolean, SchemaOperationException> prepareChangeOnStartedCache(SchemaAbstractOperation op) {
        QueryTypeDescriptorImpl type = null;
        boolean nop = false;
        SchemaOperationException err = null;
        String cacheName = op.cacheName();
        if (op instanceof SchemaIndexCreateOperation) {
            SchemaIndexCreateOperation op0 = (SchemaIndexCreateOperation)op;
            QueryIndex idx = op0.index();
            String tblName = op0.tableName();
            type = this.type(cacheName, tblName);
            if (type == null) {
                err = new SchemaOperationException(2, tblName);
            } else {
                for (String idxField : idx.getFieldNames()) {
                    if (((HashMap)type.fields()).containsKey(idxField)) continue;
                    err = new SchemaOperationException(4, idxField);
                    break;
                }
            }
            if (err == null) {
                String idxName = op0.index().getName();
                QueryIndexKey idxKey = new QueryIndexKey(op.schemaName(), idxName);
                if (this.idxs.get(idxKey) != null) {
                    if (op0.ifNotExists()) {
                        nop = true;
                    } else {
                        err = new SchemaOperationException(7, idxName);
                    }
                }
            }
        } else if (op instanceof SchemaIndexDropOperation) {
            SchemaIndexDropOperation op0 = (SchemaIndexDropOperation)op;
            String idxName = op0.indexName();
            QueryIndexDescriptorImpl oldIdx = (QueryIndexDescriptorImpl)this.idxs.get(new QueryIndexKey(op.schemaName(), idxName));
            if (oldIdx == null) {
                if (op0.ifExists()) {
                    nop = true;
                } else {
                    err = new SchemaOperationException(6, idxName);
                }
            } else {
                type = oldIdx.typeDescriptor();
            }
        } else if (op instanceof SchemaAlterTableAddColumnOperation) {
            SchemaAlterTableAddColumnOperation op0 = (SchemaAlterTableAddColumnOperation)op;
            type = this.type(cacheName, op0.tableName());
            if (type == null) {
                if (op0.ifTableExists()) {
                    nop = true;
                } else {
                    err = new SchemaOperationException(2, op0.tableName());
                }
            } else {
                for (QueryField col : op0.columns()) {
                    if (type.hasField(col.name())) {
                        if (op0.ifNotExists()) {
                            assert (op0.columns().size() == 1);
                            nop = true;
                            continue;
                        }
                        err = new SchemaOperationException(5, col.name());
                        continue;
                    }
                    if (this.checkFieldOnBinaryType(type.typeId(), col)) continue;
                    err = new SchemaOperationException(5, "with a different type.");
                }
            }
        } else if (op instanceof SchemaAlterTableDropColumnOperation) {
            SchemaAlterTableDropColumnOperation op0 = (SchemaAlterTableDropColumnOperation)op;
            type = this.type(cacheName, op0.tableName());
            if (type == null) {
                if (op0.ifTableExists()) {
                    nop = true;
                } else {
                    err = new SchemaOperationException(2, op0.tableName());
                }
            } else {
                for (String name : op0.columns()) {
                    if (err != null) break;
                    if (!type.hasField(name)) {
                        if (op0.ifExists()) {
                            assert (op0.columns().size() == 1);
                            nop = true;
                        } else {
                            err = new SchemaOperationException(4, name);
                        }
                        break;
                    }
                    err = QueryUtils.validateDropColumn(type, name);
                }
            }
        } else if (op instanceof SchemaAddQueryEntityOperation) {
            if (this.cacheNames.contains(op.cacheName())) {
                err = new SchemaOperationException(8, op.cacheName());
            }
        } else {
            err = new SchemaOperationException("Unsupported operation: " + op);
        }
        return new T3<QueryTypeDescriptorImpl, Boolean, SchemaOperationException>(type, nop, err);
    }

    private boolean checkFieldOnBinaryType(int typeId, QueryField qryField) {
        assert (Objects.nonNull(qryField));
        try {
            BinaryType binaryType = this.ctx.cacheObjects().metadata(typeId);
            String binaryFieldType = Objects.nonNull(binaryType) ? binaryType.fieldTypeName(qryField.name()) : null;
            return Objects.isNull(binaryFieldType) || binaryFieldType.equals(BinaryUtils.fieldTypeName(BinaryUtils.typeByClass(Class.forName(qryField.typeName()))));
        }
        catch (ClassNotFoundException e) {
            throw new IgniteException("Class not found for property [name=" + qryField.name() + ", type=" + qryField.typeName() + ']');
        }
    }

    private T2<Boolean, SchemaOperationException> prepareChangeOnNotStartedCache(SchemaAbstractOperation op, DynamicCacheDescriptor desc) {
        QueryEntity e;
        T2 oldIdxEntity;
        String idxName;
        SchemaAbstractOperation op0;
        boolean nop = false;
        SchemaOperationException err = null;
        if (op instanceof SchemaAddQueryEntityOperation) {
            if (this.cacheSupportSql(desc.cacheConfiguration())) {
                err = new SchemaOperationException(8, desc.cacheName());
            }
            return new T2<Boolean, Object>(nop, err);
        }
        QuerySchema schema = desc.schema();
        HashMap<String, QueryEntity> tblMap = new HashMap<String, QueryEntity>();
        HashMap<String, T2<QueryEntity, QueryIndex>> idxMap = new HashMap<String, T2<QueryEntity, QueryIndex>>();
        for (QueryEntity entity : schema.entities()) {
            String tblName = entity.getTableName();
            QueryEntity oldEntity = tblMap.put(tblName, entity);
            if (oldEntity != null) {
                err = new SchemaOperationException("Invalid schema state (duplicate table found): " + tblName);
                break;
            }
            for (QueryIndex entityIdx : entity.getIndexes()) {
                String idxName2 = entityIdx.getName();
                T2<QueryEntity, QueryIndex> oldIdxEntity2 = idxMap.put(idxName2, new T2<QueryEntity, QueryIndex>(entity, entityIdx));
                if (oldIdxEntity2 == null) continue;
                err = new SchemaOperationException("Invalid schema state (duplicate index found): " + idxName2);
                break;
            }
            if (err == null) continue;
            break;
        }
        if (op instanceof SchemaIndexCreateOperation) {
            op0 = (SchemaIndexCreateOperation)op;
            idxName = ((SchemaIndexCreateOperation)op0).indexName();
            oldIdxEntity = (T2)idxMap.get(idxName);
            if (oldIdxEntity == null) {
                String tblName = ((SchemaIndexCreateOperation)op0).tableName();
                QueryEntity oldEntity = (QueryEntity)tblMap.get(tblName);
                if (oldEntity == null) {
                    err = new SchemaOperationException(2, tblName);
                } else {
                    for (String fieldName : ((SchemaIndexCreateOperation)op0).index().getFields().keySet()) {
                        HashSet<String> oldEntityFields = new HashSet<String>(oldEntity.getFields().keySet());
                        for (Map.Entry<String, String> alias : oldEntity.getAliases().entrySet()) {
                            oldEntityFields.remove(alias.getKey());
                            oldEntityFields.add(alias.getValue());
                        }
                        if (oldEntityFields.contains(fieldName)) continue;
                        err = new SchemaOperationException(4, fieldName);
                        break;
                    }
                }
            } else if (((SchemaIndexCreateOperation)op0).ifNotExists()) {
                nop = true;
            } else {
                err = new SchemaOperationException(7, idxName);
            }
        } else if (op instanceof SchemaIndexDropOperation) {
            op0 = (SchemaIndexDropOperation)op;
            idxName = ((SchemaIndexDropOperation)op0).indexName();
            oldIdxEntity = (T2)idxMap.get(idxName);
            if (oldIdxEntity == null) {
                if (((SchemaIndexDropOperation)op0).ifExists()) {
                    nop = true;
                } else {
                    err = new SchemaOperationException(6, idxName);
                }
            }
        } else if (op instanceof SchemaAlterTableAddColumnOperation) {
            op0 = (SchemaAlterTableAddColumnOperation)op;
            e = (QueryEntity)tblMap.get(((SchemaAlterTableAddColumnOperation)op0).tableName());
            if (e == null) {
                if (((SchemaAlterTableAddColumnOperation)op0).ifTableExists()) {
                    nop = true;
                } else {
                    err = new SchemaOperationException(2, ((SchemaAlterTableAddColumnOperation)op0).tableName());
                }
            } else {
                for (QueryField fld : ((SchemaAlterTableAddColumnOperation)op0).columns()) {
                    if (!e.getFields().containsKey(fld.name())) continue;
                    if (((SchemaAlterTableAddColumnOperation)op0).ifNotExists()) {
                        assert (((SchemaAlterTableAddColumnOperation)op0).columns().size() == 1);
                        nop = true;
                        continue;
                    }
                    err = new SchemaOperationException(5, fld.name());
                }
            }
        } else if (op instanceof SchemaAlterTableDropColumnOperation) {
            op0 = (SchemaAlterTableDropColumnOperation)op;
            e = (QueryEntity)tblMap.get(((SchemaAlterTableDropColumnOperation)op0).tableName());
            if (e == null) {
                if (((SchemaAlterTableDropColumnOperation)op0).ifTableExists()) {
                    nop = true;
                } else {
                    err = new SchemaOperationException(2, ((SchemaAlterTableDropColumnOperation)op0).tableName());
                }
            } else {
                for (String colName : ((SchemaAlterTableDropColumnOperation)op0).columns()) {
                    if (err != null) break;
                    String fldName = QueryUtils.fieldNameByAlias(e, colName);
                    if (!e.getFields().containsKey(fldName)) {
                        if (((SchemaAlterTableDropColumnOperation)op0).ifExists()) {
                            assert (((SchemaAlterTableDropColumnOperation)op0).columns().size() == 1);
                            nop = true;
                        } else {
                            err = new SchemaOperationException(4, fldName);
                        }
                        break;
                    }
                    err = QueryUtils.validateDropColumn(e, fldName, colName);
                }
            }
        } else {
            err = new SchemaOperationException("Unsupported operation: " + op);
        }
        return new T2<Boolean, SchemaOperationException>(nop, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCoordinatorFinished(SchemaAbstractOperation op, @Nullable SchemaOperationException err) {
        Object object = this.stateMux;
        synchronized (object) {
            SchemaFinishDiscoveryMessage msg = new SchemaFinishDiscoveryMessage(op, err);
            try {
                this.ctx.discovery().sendCustomEvent(msg);
            }
            catch (Exception e) {
                U.warn(this.log, "Failed to send schema finish discovery message [opId=" + op.id() + ']', e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterNode coordinator() {
        assert (!this.ctx.clientNode());
        Object object = this.stateMux;
        synchronized (object) {
            if (this.crd == null) {
                ClusterNode crd0 = null;
                for (ClusterNode node : this.ctx.discovery().aliveServerNodes()) {
                    if (crd0 != null && crd0.order() <= node.order()) continue;
                    crd0 = node;
                }
                assert (crd0 != null);
                this.crd = crd0;
            }
            return this.crd;
        }
    }

    private void cleanStaleStatusMessages(UUID opId) {
        Iterator it = this.pendingMsgs.iterator();
        while (it.hasNext()) {
            SchemaOperationStatusMessage statusMsg = (SchemaOperationStatusMessage)it.next();
            if (!F.eq(opId, statusMsg.operationId())) continue;
            it.remove();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Dropped operation status message because it is already completed [opId=" + opId + ", rmtNode=" + statusMsg.senderNodeId() + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLocalOperationFinished(SchemaAbstractOperation op, @Nullable QueryTypeDescriptorImpl type) {
        Object object = this.stateMux;
        synchronized (object) {
            if (this.disconnected) {
                return;
            }
            if (type == null || type.obsolete()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Local operation finished, but type descriptor is either missing or obsolete (will ignore) [opId=" + op.id() + ']');
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Local operation finished successfully [opId=" + op.id() + ']');
            }
            String schemaName = op.schemaName();
            try {
                if (op instanceof SchemaIndexCreateOperation) {
                    SchemaIndexCreateOperation op0 = (SchemaIndexCreateOperation)op;
                    QueryUtils.processDynamicIndexChange(op0.indexName(), op0.index(), type);
                    QueryIndexDescriptorImpl idxDesc = type.index(op0.indexName());
                    QueryIndexKey idxKey = new QueryIndexKey(schemaName, op0.indexName());
                    this.idxs.put(idxKey, idxDesc);
                } else if (op instanceof SchemaIndexDropOperation) {
                    SchemaIndexDropOperation op0 = (SchemaIndexDropOperation)op;
                    QueryUtils.processDynamicIndexChange(op0.indexName(), null, type);
                    QueryIndexKey idxKey = new QueryIndexKey(schemaName, op0.indexName());
                    this.idxs.remove(idxKey);
                } else assert (op instanceof SchemaAddQueryEntityOperation || op instanceof SchemaAlterTableAddColumnOperation || op instanceof SchemaAlterTableDropColumnOperation);
            }
            catch (IgniteCheckedException e) {
                U.warn(this.log, "Failed to finish index operation [opId=" + op.id() + " op=" + op + ']', e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNodeLeave(ClusterNode node) {
        Object object = this.stateMux;
        synchronized (object) {
            if (this.ctx.clientNode()) {
                return;
            }
            ClusterNode crd0 = this.coordinator();
            if (F.eq(node.id(), crd0.id())) {
                this.crd = null;
                crd0 = this.coordinator();
            }
            for (SchemaOperation op : this.schemaOps.values()) {
                if (!op.started()) continue;
                op.manager().onNodeLeave(node.id(), crd0);
                if (!crd0.isLocal()) continue;
                this.unwindPendingMessages(op.id(), op.manager());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processSchemaOperationLocal(SchemaAbstractOperation op, QueryTypeDescriptorImpl type, IgniteUuid depId, IndexRebuildCancelToken cancelTok) throws SchemaOperationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started local index operation [opId=" + op.id() + ']');
        }
        final String cacheName = op.cacheName();
        GridCacheContextInfo<Object, Object> cacheInfo = null;
        if (op instanceof SchemaAddQueryEntityOperation) {
            GridCacheContext cctx = this.ctx.cache().context().cacheContext(CU.cacheId(cacheName));
            if (cctx == null) return;
            cacheInfo = new GridCacheContextInfo(cctx, false);
        } else {
            cacheInfo = this.schemaMgr.cacheInfo(cacheName);
        }
        if (cacheInfo == null || !F.eq(depId, cacheInfo.dynamicDeploymentId())) {
            throw new SchemaOperationException(1, cacheName);
        }
        try {
            SchemaAbstractOperation op0;
            if (op instanceof SchemaIndexCreateOperation) {
                SchemaIndexCacheVisitor visitor;
                op0 = (SchemaIndexCreateOperation)op;
                QueryIndexDescriptorImpl idxDesc = QueryUtils.createIndexDescriptor(type, ((SchemaIndexCreateOperation)op0).index());
                if (cacheInfo.isCacheContextInited()) {
                    int buildIdxPoolSize = this.ctx.config().getBuildIndexThreadPoolSize();
                    int parallel = ((SchemaIndexCreateOperation)op0).parallel();
                    if (parallel > buildIdxPoolSize) {
                        String idxName = ((SchemaIndexCreateOperation)op0).indexName();
                        this.log.warning("Provided parallelism " + parallel + " for creation of index " + idxName + " is greater than the number of index building threads. Will use " + buildIdxPoolSize + " threads to build index. Increase by IgniteConfiguration.setBuildIndexThreadPoolSize and restart the node if you want to use more threads. [tableName=" + ((SchemaIndexCreateOperation)op0).tableName() + ", indexName=" + idxName + ", requestedParallelism=" + parallel + ", buildIndexPoolSize=" + buildIdxPoolSize + "]");
                    }
                    GridFutureAdapter createIdxFut = new GridFutureAdapter();
                    final GridCacheContext<Object, Object> cacheCtx = cacheInfo.cacheContext();
                    visitor = new SchemaIndexCacheVisitorImpl(cacheCtx, cancelTok, createIdxFut){

                        @Override
                        public void visit(SchemaIndexCacheVisitorClosure clo) {
                            GridQueryProcessor.this.idxBuildStatusStorage.onStartBuildNewIndex(cacheCtx);
                            try {
                                super.visit(clo);
                                this.buildIdxFut.get();
                            }
                            catch (Exception e) {
                                throw new IgniteException(e);
                            }
                            finally {
                                GridQueryProcessor.this.idxBuildStatusStorage.onFinishBuildNewIndex(cacheName);
                            }
                        }
                    };
                } else {
                    visitor = clo -> {};
                }
                this.schemaMgr.createIndex(op0.schemaName(), ((SchemaIndexCreateOperation)op0).tableName(), idxDesc, ((SchemaIndexCreateOperation)op0).ifNotExists(), visitor);
                return;
            } else if (op instanceof SchemaIndexDropOperation) {
                op0 = (SchemaIndexDropOperation)op;
                this.schemaMgr.dropIndex(op0.schemaName(), ((SchemaIndexDropOperation)op0).indexName(), ((SchemaIndexDropOperation)op0).ifExists());
                return;
            } else if (op instanceof SchemaAlterTableAddColumnOperation) {
                op0 = (SchemaAlterTableAddColumnOperation)op;
                this.processDynamicAddColumn(type, ((SchemaAlterTableAddColumnOperation)op0).columns());
                this.schemaMgr.addColumn(op0.schemaName(), ((SchemaAlterTableAddColumnOperation)op0).tableName(), ((SchemaAlterTableAddColumnOperation)op0).columns(), ((SchemaAlterTableAddColumnOperation)op0).ifTableExists(), ((SchemaAlterTableAddColumnOperation)op0).ifNotExists());
                return;
            } else if (op instanceof SchemaAlterTableDropColumnOperation) {
                op0 = (SchemaAlterTableDropColumnOperation)op;
                this.processDynamicDropColumn(type, ((SchemaAlterTableDropColumnOperation)op0).columns());
                this.schemaMgr.dropColumn(op0.schemaName(), ((SchemaAlterTableDropColumnOperation)op0).tableName(), ((SchemaAlterTableDropColumnOperation)op0).columns(), ((SchemaAlterTableDropColumnOperation)op0).ifTableExists(), ((SchemaAlterTableDropColumnOperation)op0).ifExists());
                return;
            } else {
                if (!(op instanceof SchemaAddQueryEntityOperation)) throw new SchemaOperationException("Unsupported operation: " + op);
                op0 = (SchemaAddQueryEntityOperation)op;
                if (!this.cacheNames.contains(op0.cacheName())) {
                    cacheInfo.onSchemaAddQueryEntity((SchemaAddQueryEntityOperation)op0);
                    T3<Collection<QueryTypeCandidate>, Map<String, QueryTypeDescriptorImpl>, Map<String, QueryTypeDescriptorImpl>> candRes = this.createQueryCandidates(op0.cacheName(), op0.schemaName(), cacheInfo, ((SchemaAddQueryEntityOperation)op0).entities(), ((SchemaAddQueryEntityOperation)op0).isSqlEscape());
                    this.registerCache0(op0.cacheName(), op.schemaName(), cacheInfo, (Collection)candRes.get1(), false);
                }
                if (this.idxRebuildFutStorage.prepareRebuildIndexes(Collections.singleton(cacheInfo.cacheId()), null).isEmpty()) {
                    this.rebuildIndexesFromHash0(cacheInfo.cacheContext(), false, cancelTok);
                    return;
                } else {
                    if (!this.log.isInfoEnabled()) return;
                    this.log.info("Rebuilding indexes for the cache is already in progress: " + cacheInfo.name());
                    return;
                }
            }
        }
        catch (Throwable e) {
            if (!(e instanceof SchemaOperationException)) throw new SchemaOperationException("Schema change operation failed: " + e.getMessage(), e);
            throw (SchemaOperationException)e;
        }
    }

    public void dynamicTableCreate(String schemaName, QueryEntity entity, String templateName, String cacheName, String cacheGroup, @Nullable String dataRegion, String affinityKey, @Nullable CacheAtomicityMode atomicityMode, @Nullable CacheWriteSynchronizationMode writeSyncMode, @Nullable Integer backups, boolean ifNotExists, @Nullable Boolean encrypted, @Nullable Integer qryParallelism) throws IgniteCheckedException {
        boolean res;
        assert (!F.isEmpty(templateName));
        assert (backups == null || backups >= 0);
        assert (qryParallelism == null || qryParallelism > 0);
        CacheConfiguration ccfg = this.ctx.cache().getConfigFromTemplate(templateName);
        if (ccfg == null) {
            if ("PARTITIONED".equalsIgnoreCase(templateName)) {
                ccfg = new CacheConfiguration().setCacheMode(CacheMode.PARTITIONED);
            } else if ("REPLICATED".equalsIgnoreCase(templateName)) {
                ccfg = new CacheConfiguration().setCacheMode(CacheMode.REPLICATED);
            } else {
                throw new SchemaOperationException(1, templateName);
            }
            ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        }
        if (!F.isEmpty(ccfg.getQueryEntities())) {
            throw new SchemaOperationException("Template cache already contains query entities which it should not: " + templateName);
        }
        if (!F.isEmpty(entity.getNotNullFields())) {
            QueryUtils.checkNotNullAllowed(ccfg);
        }
        if (F.isEmpty(cacheName)) {
            cacheName = QueryUtils.createTableCacheName(schemaName, entity.getTableName());
        }
        ccfg.setName(cacheName);
        if (!F.isEmpty(cacheGroup)) {
            ccfg.setGroupName(cacheGroup);
        }
        if (!F.isEmpty(dataRegion)) {
            ccfg.setDataRegionName(dataRegion);
        }
        if (atomicityMode != null) {
            ccfg.setAtomicityMode(atomicityMode);
        }
        if (writeSyncMode != null) {
            ccfg.setWriteSynchronizationMode(writeSyncMode);
        }
        if (backups != null) {
            ccfg.setBackups(backups);
        }
        if (qryParallelism != null) {
            ccfg.setQueryParallelism(qryParallelism);
        }
        if (encrypted != null) {
            ccfg.setEncryptionEnabled(encrypted);
        }
        ccfg.setSqlSchema("\"" + schemaName + "\"");
        ccfg.setSqlEscapeAll(true);
        ccfg.setQueryEntities(Collections.singleton(entity));
        if (!QueryUtils.isCustomAffinityMapper(ccfg.getAffinityMapper())) {
            ccfg.setAffinityMapper(null);
        }
        if (affinityKey != null) {
            ccfg.setKeyConfiguration(new CacheKeyConfiguration(entity.getKeyType(), affinityKey));
        }
        try {
            res = this.ctx.grid().getOrCreateCache0(ccfg, true).get2();
        }
        catch (CacheException e) {
            if (e.getCause() instanceof SchemaOperationException) {
                throw (SchemaOperationException)e.getCause();
            }
            throw e;
        }
        if (!res && !ifNotExists) {
            throw new SchemaOperationException(3, entity.getTableName());
        }
    }

    public void dynamicTableDrop(String cacheName, String tblName, boolean ifExists) throws SchemaOperationException {
        GridCacheContext currCache = this.curCache.get();
        if (currCache != null && F.eq(currCache.name(), cacheName)) {
            throw new IgniteSQLException("DROP TABLE cannot be called from the same cache that holds the table being dropped [cacheName-" + cacheName + ", tblName=" + tblName + ']', 1002);
        }
        boolean res = this.ctx.grid().destroyCache0(cacheName, true);
        if (!res && !ifExists) {
            throw new SchemaOperationException(2, tblName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCache0(String cacheName, String schemaName, GridCacheContextInfo<?, ?> cacheInfo, Collection<QueryTypeCandidate> cands, boolean isSql) throws IgniteCheckedException {
        Object object = this.stateMux;
        synchronized (object) {
            if (this.moduleEnabled()) {
                this.ctx.indexProcessor().idxRowCacheRegistry().onCacheRegistered(cacheInfo);
                this.schemaMgr.onCacheCreated(cacheName, schemaName, cacheInfo.config().getSqlFunctionClasses());
                if (this.idx != null) {
                    this.idx.registerCache(cacheName, schemaName, cacheInfo);
                }
            }
            try {
                for (QueryTypeCandidate cand : cands) {
                    QueryTypeIdKey typeId = cand.typeId();
                    QueryTypeIdKey altTypeId = cand.alternativeTypeId();
                    QueryTypeDescriptorImpl desc = cand.descriptor();
                    if (this.typesByName.putIfAbsent(new QueryTypeNameKey(cacheName, desc.name()), desc) != null) {
                        throw new IgniteCheckedException("Type with name '" + desc.name() + "' already indexed in cache '" + cacheName + "'.");
                    }
                    this.types.put(typeId, desc);
                    if (altTypeId != null) {
                        this.types.put(altTypeId, desc);
                    }
                    for (QueryIndexDescriptorImpl idx : desc.indexes0()) {
                        QueryIndexKey idxKey = new QueryIndexKey(schemaName, idx.name());
                        QueryIndexDescriptorImpl oldIdx = this.idxs.putIfAbsent(idxKey, idx);
                        if (oldIdx == null) continue;
                        throw new IgniteException("Duplicate index name [cache=" + cacheName + ", schemaName=" + schemaName + ", idxName=" + idx.name() + ", existingTable=" + oldIdx.typeDescriptor().tableName() + ", table=" + desc.tableName() + ']');
                    }
                    if (!this.moduleEnabled()) continue;
                    this.schemaMgr.onCacheTypeCreated(cacheInfo, desc, isSql);
                }
                this.cacheNames.add(CU.mask(cacheName));
            }
            catch (RuntimeException | IgniteCheckedException e) {
                this.onCacheStop0(cacheInfo, true, true);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheStop0(GridCacheContextInfo cacheInfo, boolean destroy, boolean clearIdx) {
        if (!this.moduleEnabled() || !this.cacheNames.contains(cacheInfo.name())) {
            return;
        }
        String cacheName = cacheInfo.name();
        Object object = this.stateMux;
        synchronized (object) {
            Iterator<Map.Entry<QueryTypeIdKey, QueryTypeDescriptorImpl>> it = this.types.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<QueryTypeIdKey, QueryTypeDescriptorImpl> entry = it.next();
                if (!F.eq(cacheName, entry.getKey().cacheName())) continue;
                it.remove();
                this.typesByName.remove(new QueryTypeNameKey(cacheName, entry.getValue().name()));
                entry.getValue().markObsolete();
            }
            Iterator idxIt = this.idxs.entrySet().iterator();
            while (idxIt.hasNext()) {
                Map.Entry idxEntry = idxIt.next();
                if (!F.eq(cacheName, ((QueryIndexDescriptorImpl)idxEntry.getValue()).typeDescriptor().cacheName())) continue;
                idxIt.remove();
            }
            for (SchemaOperation op : this.schemaOps.values()) {
                if (!op.started()) continue;
                op.manager().worker().cancel();
            }
            try {
                this.ctx.indexProcessor().unregisterCache(cacheInfo);
                this.schemaMgr.onCacheDestroyed(cacheName, destroy, clearIdx);
                if (this.idx != null) {
                    this.idx.unregisterCache(cacheInfo);
                }
            }
            catch (Exception e) {
                U.error(this.log, "Failed to clear schema manager on cache unregister (will ignore): " + cacheName, e);
            }
            this.cacheNames.remove(cacheName);
            Iterator<Long> missedCacheTypeIter = this.missedCacheTypes.iterator();
            while (missedCacheTypeIter.hasNext()) {
                long key = missedCacheTypeIter.next();
                if (!GridQueryProcessor.missedCacheTypeKeyMatches(key, cacheName)) continue;
                missedCacheTypeIter.remove();
            }
        }
    }

    private boolean cacheSupportSql(CacheConfiguration cfg) {
        return !F.isEmpty(cfg.getQueryEntities()) || !F.isEmpty(cfg.getSqlSchema()) || !F.isEmpty(cfg.getSqlFunctionClasses());
    }

    public boolean belongsToTable(GridCacheContext cctx, String expCacheName, String expTblName, KeyCacheObject key, CacheObject val) throws IgniteCheckedException {
        QueryTypeDescriptorImpl desc = this.type(expCacheName, val);
        if (desc == null) {
            return false;
        }
        if (!F.eq(expTblName, desc.tableName())) {
            return false;
        }
        if (!cctx.cacheObjects().isBinaryObject(val)) {
            Class<?> valCls = val.value(cctx.cacheObjectContext(), false).getClass();
            if (!desc.valueClass().isAssignableFrom(valCls)) {
                return false;
            }
        }
        if (!cctx.cacheObjects().isBinaryObject(key)) {
            Class<?> keyCls = key.value(cctx.cacheObjectContext(), false).getClass();
            if (!desc.keyClass().isAssignableFrom(keyCls)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public String tableName(String cacheName, String valType) {
        int typeId = this.ctx.cacheObjects().typeId(valType);
        QueryTypeIdKey id = new QueryTypeIdKey(cacheName, typeId);
        QueryTypeDescriptorImpl desc = this.types.get(id);
        return desc == null ? null : desc.tableName();
    }

    public void markAsRebuildNeeded(GridCacheContext cctx, boolean val) {
        if (this.rebuildIsMeaningless(cctx)) {
            return;
        }
        this.idxProc.markRebuildIndexesForCache(cctx, val);
        this.schemaMgr.markIndexRebuild(cctx.name(), val);
    }

    private boolean rebuildIsMeaningless(GridCacheContext cctx) {
        if (!this.moduleEnabled()) {
            return true;
        }
        if (!cctx.affinityNode()) {
            return true;
        }
        return !cctx.isQueryEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> rebuildIndexesFromHash(GridCacheContext cctx, boolean force) {
        assert (Objects.nonNull(cctx));
        if (this.rebuildIsMeaningless(cctx)) {
            return this.chainIndexRebuildFuture(null, cctx);
        }
        boolean empty = true;
        for (IgniteCacheOffheapManager.CacheDataStore store : cctx.offheap().cacheDataStores()) {
            if (store.isEmpty()) continue;
            empty = false;
            break;
        }
        if (empty) {
            return this.chainIndexRebuildFuture(null, cctx);
        }
        if (!this.busyLock.enterBusy()) {
            return new GridFinishedFuture(new NodeStoppingException("Failed to rebuild indexes from hash (grid is stopping)."));
        }
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.rebuildIndexesFromHash0(cctx, force, new IndexRebuildCancelToken());
            return igniteInternalFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private IgniteInternalFuture<?> rebuildIndexesFromHash0(GridCacheContext<?, ?> cctx, boolean force, IndexRebuildCancelToken cancelTok) {
        IgniteInternalFuture<?> idxFut = this.idxProc.rebuildIndexesForCache(cctx, force, cancelTok);
        return this.chainIndexRebuildFuture(idxFut, cctx);
    }

    @Nullable
    private IgniteInternalFuture<?> chainIndexRebuildFuture(@Nullable IgniteInternalFuture<?> idxFut, GridCacheContext<?, ?> cctx) {
        GridFutureAdapter<Void> res = this.idxRebuildFutStorage.indexRebuildFuture(cctx.cacheId());
        assert (res != null);
        if (idxFut != null) {
            String cacheInfo = "[name=" + cctx.name() + ", grpName=" + cctx.group().name() + "]";
            if (this.log.isInfoEnabled()) {
                this.log.info("Started indexes rebuilding for cache " + cacheInfo);
            }
            idxFut.listen(fut -> {
                Throwable err = fut.error();
                if (Objects.isNull(err) && this.log.isInfoEnabled()) {
                    this.log.info("Finished indexes rebuilding for cache " + cacheInfo);
                } else if (!(err instanceof NodeStoppingException)) {
                    this.log.error("Failed to rebuild indexes for cache " + cacheInfo, err);
                }
                this.idxRebuildFutStorage.onFinishRebuildIndexes(cctx.cacheId(), err);
            });
            return res;
        }
        this.idxRebuildFutStorage.onFinishRebuildIndexes(cctx.cacheId(), null);
        return null;
    }

    @Nullable
    public IgniteInternalFuture<?> indexRebuildFuture(int cacheId) {
        return this.idxRebuildFutStorage.indexRebuildFuture(cacheId);
    }

    @Nullable
    private CacheObjectContext cacheObjectContext(String cacheName) {
        GridCacheAdapter cache = this.ctx.cache().internalCache(cacheName);
        return cache == null ? null : cache.context().cacheObjectContext();
    }

    public void store(GridCacheContext cctx, CacheDataRow newRow, @Nullable CacheDataRow prevRow, boolean prevRowAvailable) throws IgniteCheckedException {
        QueryTypeDescriptorImpl prevValDesc;
        assert (cctx != null);
        assert (newRow != null);
        assert (prevRowAvailable || prevRow == null);
        KeyCacheObject key = newRow.key();
        CacheObject val = newRow.value();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Store [cache=" + cctx.name() + ", key=" + key + ", val=" + val + "]");
        }
        String cacheName = cctx.name();
        CacheObjectContext coctx = cctx.cacheObjectContext();
        QueryTypeDescriptorImpl desc = this.typeByValue(cacheName, coctx, key, val, true);
        if (prevRowAvailable && prevRow != null && (prevValDesc = this.typeByValue(cacheName, coctx, key, prevRow.value(), false)) != desc) {
            if (prevValDesc != null) {
                this.idxProc.remove(cacheName, prevRow);
                if (this.idx != null) {
                    this.idx.remove(cctx, prevValDesc, prevRow);
                }
            }
            prevRow = null;
        }
        if (desc == null) {
            int typeId = this.ctx.cacheObjects().typeId(val);
            long missedCacheTypeKey = GridQueryProcessor.missedCacheTypeKey(cacheName, typeId);
            if (!this.missedCacheTypes.contains(missedCacheTypeKey) && this.missedCacheTypes.add(missedCacheTypeKey)) {
                LT.warn(this.log, "Key-value pair is not inserted into any SQL table [cacheName=" + cacheName + ", " + this.describeTypeMismatch(cacheName, val) + "]");
                LT.warn(this.log, "  ^-- Value type(s) are specified via CacheConfiguration.indexedTypes or CacheConfiguration.queryEntities");
                LT.warn(this.log, "  ^-- Make sure that same type(s) used when adding Object or BinaryObject to cache");
                LT.warn(this.log, "  ^-- Otherwise, entries will be stored in cache, but not appear as SQL Table rows");
            }
            return;
        }
        this.idxProc.store(cctx, newRow, prevRow, prevRowAvailable);
        if (this.idx != null) {
            this.idx.store(cctx, desc, newRow, prevRow, prevRowAvailable);
        }
    }

    private String describeTypeMismatch(String cacheName, Object val) {
        try {
            QueryTypeDescriptorImpl indexedType = null;
            for (QueryTypeIdKey typeKey : this.types.keySet()) {
                if (!typeKey.cacheName().equals(cacheName)) continue;
                if (indexedType != null) {
                    indexedType = null;
                    break;
                }
                indexedType = this.types.get(typeKey);
            }
            boolean bin = this.ctx.cacheObjects().isBinaryObject(val);
            if (indexedType != null && bin && !indexedType.valueTypeName().equals(((BinaryObject)val).type().typeName())) {
                return "expValType=" + indexedType.valueTypeName() + ", actualValType=" + ((BinaryObject)val).type().typeName();
            }
            if (bin) {
                return "valType=" + ((BinaryObject)val).type().typeName();
            }
            return "val=" + val.toString();
        }
        catch (Exception e) {
            return val.getClass().getName();
        }
    }

    @Nullable
    public QueryTypeDescriptorImpl typeByValue(String cacheName, CacheObjectContext coctx, KeyCacheObject key, CacheObject val, boolean checkType) throws IgniteCheckedException {
        QueryTypeIdKey id;
        Class<?> valCls = null;
        boolean binaryVal = this.ctx.cacheObjects().isBinaryObject(val);
        if (binaryVal) {
            int typeId = this.ctx.cacheObjects().typeId(val);
            id = new QueryTypeIdKey(cacheName, typeId);
        } else {
            valCls = val.value(coctx, false).getClass();
            id = new QueryTypeIdKey(cacheName, valCls);
        }
        QueryTypeDescriptorImpl desc = this.types.get(id);
        if (desc == null) {
            return null;
        }
        if (checkType) {
            if (!binaryVal && !desc.valueClass().isAssignableFrom(valCls)) {
                throw new IgniteCheckedException("Failed to update index due to class name conflict(multiple classes with same simple name are stored in the same cache) [expCls=" + desc.valueClass().getName() + ", actualCls=" + valCls.getName() + ']');
            }
            if (!this.ctx.cacheObjects().isBinaryObject(key)) {
                Class<?> keyCls = key.value(coctx, false).getClass();
                if (!desc.keyClass().isAssignableFrom(keyCls)) {
                    throw new IgniteCheckedException("Failed to update index, incorrect key class [expCls=" + desc.keyClass().getName() + ", actualCls=" + keyCls.getName() + "]");
                }
            }
        }
        return desc;
    }

    private QueryTypeDescriptorImpl type(String cacheName, CacheObject val) throws IgniteCheckedException {
        QueryTypeIdKey id;
        boolean binaryVal = this.ctx.cacheObjects().isBinaryObject(val);
        if (binaryVal) {
            id = new QueryTypeIdKey(cacheName, this.ctx.cacheObjects().typeId(val));
        } else {
            CacheObjectContext coctx = this.cacheObjectContext(cacheName);
            if (coctx == null) {
                throw new IgniteCheckedException("Object context for cache not found: " + cacheName);
            }
            id = new QueryTypeIdKey(cacheName, val.value(coctx, false).getClass());
        }
        return this.types.get(id);
    }

    private void checkIndexingEnabled() throws IgniteCheckedException {
        if (this.idx == null) {
            throw new IgniteCheckedException("Indexing is disabled.");
        }
    }

    private void checkxIndexingEnabled() throws IgniteException {
        if (this.idx == null) {
            throw new IgniteException("Failed to execute query because indexing is disabled (consider adding module " + IgniteComponentType.INDEXING.module() + " to classpath or moving it from 'optional' to 'libs' folder).");
        }
    }

    public UpdateSourceIterator<?> executeUpdateOnDataNodeTransactional(GridCacheContext<?, ?> cctx, int[] cacheIds, int[] parts, String schema, String qry, Object[] params, int flags, int pageSize, int timeout, AffinityTopologyVersion topVer, MvccSnapshot mvccSnapshot, GridQueryCancel cancel) throws IgniteCheckedException {
        this.checkxIndexingEnabled();
        return this.idx.executeUpdateOnDataNodeTransactional(cctx, cacheIds, parts, schema, qry, params, flags, pageSize, timeout, topVer, mvccSnapshot, cancel);
    }

    public List<FieldsQueryCursor<List<?>>> querySqlFields(SqlFieldsQuery qry, boolean keepBinary, boolean failOnMultipleStmts) {
        return this.querySqlFields(null, qry, null, keepBinary, failOnMultipleStmts);
    }

    public FieldsQueryCursor<List<?>> querySqlFields(SqlFieldsQuery qry, boolean keepBinary) {
        return this.querySqlFields(null, qry, null, keepBinary, true).get(0);
    }

    public List<FieldsQueryCursor<List<?>>> querySqlFields(@Nullable GridCacheContext<?, ?> cctx, SqlFieldsQuery qry, SqlClientContext cliCtx, boolean keepBinary, boolean failOnMultipleStmts) {
        return this.querySqlFields(cctx, qry, cliCtx, keepBinary, failOnMultipleStmts, GridCacheQueryType.SQL_FIELDS, null);
    }

    public List<FieldsQueryCursor<List<?>>> querySqlFields(@Nullable GridCacheContext<?, ?> cctx, SqlFieldsQuery qry, SqlClientContext cliCtx, boolean keepBinary, boolean failOnMultipleStmts, @Nullable GridQueryCancel cancel) {
        return this.querySqlFields(cctx, qry, cliCtx, keepBinary, failOnMultipleStmts, GridCacheQueryType.SQL_FIELDS, cancel);
    }

    public List<FieldsQueryCursor<List<?>>> querySqlFields(final @Nullable GridCacheContext<?, ?> cctx, final SqlFieldsQuery qry, final SqlClientContext cliCtx, final boolean keepBinary, final boolean failOnMultipleStmts, final GridCacheQueryType qryType, final @Nullable GridQueryCancel cancel) {
        if (!this.moduleEnabled()) {
            throw new IgniteException("Failed to execute query because indexing is disabled and no query engine is configured (consider adding module " + IgniteComponentType.INDEXING.module() + " to classpath or moving it from 'optional' to 'libs' folder or configuring any query engine with IgniteConfiguration.SqlConfiguration.QueryEnginesConfiguration property).");
        }
        if (qry.isDistributedJoins() && qry.getPartitions() != null) {
            throw new CacheException("Using both partitions and distributed JOINs is not supported for the same query");
        }
        if (qry.isLocal() && this.ctx.clientNode()) {
            throw new CacheException("Execution of local SqlFieldsQuery on client node disallowed.");
        }
        return this.executeQuerySafe(cctx, () -> {
            final String schemaName = qry.getSchema() == null ? this.schemaName(cctx) : qry.getSchema();
            IgniteOutClosureX clo = new IgniteOutClosureX<List<FieldsQueryCursor<List<?>>>>(){

                @Override
                public List<FieldsQueryCursor<List<?>>> applyx() {
                    GridQueryCancel cancel0 = cancel != null ? cancel : new GridQueryCancel();
                    QueryEngine qryEngine = GridQueryProcessor.this.engineForQuery(cliCtx, qry);
                    List<FieldsQueryCursor<List<?>>> res = qryEngine != null ? (qry instanceof SqlFieldsQueryEx && ((SqlFieldsQueryEx)qry).isBatched() ? qryEngine.queryBatched(QueryContext.of(qry, cliCtx, cancel), schemaName, qry.getSql(), ((SqlFieldsQueryEx)qry).batchedArguments()) : qryEngine.query(QueryContext.of(qry, cliCtx, cancel), schemaName, qry.getSql(), qry.getArgs() != null ? qry.getArgs() : X.EMPTY_OBJECT_ARRAY)) : GridQueryProcessor.this.idx.querySqlFields(schemaName, qry, cliCtx, keepBinary, failOnMultipleStmts, cancel0);
                    if (cctx != null) {
                        GridQueryProcessor.this.sendQueryExecutedEvent(qry.getSql(), qry.getArgs(), cctx, qryType);
                    }
                    return res;
                }
            };
            return (List)this.executeQuery(qryType, qry.getSql(), cctx, clo, true);
        });
    }

    public String schemaName(GridCacheContext<?, ?> cctx) {
        String cacheSchemaName;
        if (cctx != null && !F.isEmpty(cacheSchemaName = this.schemaMgr.schemaName(cctx.name()))) {
            return cacheSchemaName;
        }
        return "PUBLIC";
    }

    private QueryEngine engineForQuery(SqlClientContext cliCtx, SqlFieldsQuery qry) {
        String hint;
        Matcher engineMatcher;
        String engineName = null;
        Matcher hintMatcher = QRY_HINT_PATTERN.matcher(qry.getSql());
        if (hintMatcher.find() && (engineMatcher = QRY_ENGINE_PATTERN.matcher(hint = hintMatcher.group(1))).find()) {
            engineName = engineMatcher.group(1);
        }
        if (engineName == null && cliCtx != null) {
            engineName = cliCtx.queryEngine();
        }
        if (engineName == null) {
            return this.dfltQryEngine;
        }
        if (this.qryEnginesCfg == null) {
            throw new IgniteException("Query engines not configured, but specified engine: " + engineName);
        }
        for (int i = 0; i < this.qryEnginesCfg.length; ++i) {
            if (!engineName.equalsIgnoreCase(this.qryEnginesCfg[i].engineName())) continue;
            return this.qryEngines[i];
        }
        throw new IgniteException("Query engine not found: " + engineName);
    }

    private <T> T executeQuerySafe(@Nullable GridCacheContext<?, ?> cctx, GridPlainOutClosure<T> supplier) {
        GridCacheContext oldCctx = this.curCache.get();
        this.curCache.set(cctx);
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            T t = supplier.apply();
            return t;
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            this.curCache.set(oldCctx);
            this.busyLock.leaveBusy();
        }
    }

    public long streamUpdateQuery(@Nullable String cacheName, final String schemaName, final IgniteDataStreamer<?, ?> streamer, final String qry, final Object[] args, final String qryInitiatorId) {
        assert (streamer != null);
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            GridCacheContext cctx = this.ctx.cache().cache(cacheName).context();
            long l = this.executeQuery(GridCacheQueryType.SQL_FIELDS, qry, cctx, new IgniteOutClosureX<Long>(){

                @Override
                public Long applyx() throws IgniteCheckedException {
                    return GridQueryProcessor.this.idx.streamUpdateQuery(schemaName, qry, args, streamer, qryInitiatorId);
                }
            }, true);
            return l;
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public List<Long> streamBatchedUpdateQuery(final String schemaName, final SqlClientContext cliCtx, final String qry, final List<Object[]> args, final String qryInitiatorId) {
        this.checkxIndexingEnabled();
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            List<Long> list = this.executeQuery(GridCacheQueryType.SQL_FIELDS, qry, null, new IgniteOutClosureX<List<Long>>(){

                @Override
                public List<Long> applyx() throws IgniteCheckedException {
                    return GridQueryProcessor.this.idx.streamBatchedUpdateQuery(schemaName, qry, args, cliCtx, qryInitiatorId);
                }
            }, true);
            return list;
        }
        catch (IgniteCheckedException e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public <K, V> QueryCursor<Cache.Entry<K, V>> querySql(GridCacheContext<?, ?> cctx, SqlQuery qry, boolean keepBinary) {
        String type = qry.getType();
        String typeName = this.typeName(cctx.name(), type);
        qry.setType(typeName);
        SqlFieldsQuery fieldsQry = this.idx.generateFieldsQuery(cctx.name(), qry);
        FieldsQueryCursor<List<?>> res = this.querySqlFields(cctx, fieldsQry, null, keepBinary, true, GridCacheQueryType.SQL, null).get(0);
        final QueryKeyValueIterable converted = new QueryKeyValueIterable(res);
        return new QueryCursorImpl<Cache.Entry<K, V>>(converted){

            @Override
            public void close() {
                converted.cursor().close();
            }
        };
    }

    public Collection<GridRunningQueryInfo> runningQueries(long duration) {
        return this.runningQryMgr.longRunningQueries(duration);
    }

    public void cancelQuery(long queryId, @Nullable UUID nodeId, boolean async) {
        this.runningQryMgr.cancelQuery(queryId, nodeId, async);
    }

    public void cancelLocalQueries(Collection<Long> queries) {
        if (!F.isEmpty(queries)) {
            for (Long qryId : queries) {
                this.runningQryMgr.cancelLocalQuery(qryId);
            }
        }
    }

    public IgniteInternalFuture<?> dynamicIndexCreate(String cacheName, String schemaName, String tblName, QueryIndex idx, boolean ifNotExists, int parallel) {
        SchemaIndexCreateOperation op = new SchemaIndexCreateOperation(UUID.randomUUID(), cacheName, schemaName, tblName, idx, ifNotExists, parallel);
        return this.startIndexOperationDistributed(op);
    }

    public IgniteInternalFuture<?> dynamicIndexDrop(String cacheName, String schemaName, String idxName, boolean ifExists) {
        SchemaIndexDropOperation op = new SchemaIndexDropOperation(UUID.randomUUID(), cacheName, schemaName, idxName, ifExists);
        return this.startIndexOperationDistributed(op);
    }

    public IgniteInternalFuture<?> dynamicColumnAdd(String cacheName, String schemaName, String tblName, List<QueryField> cols, boolean ifTblExists, boolean ifNotExists) {
        SchemaAlterTableAddColumnOperation op = new SchemaAlterTableAddColumnOperation(UUID.randomUUID(), cacheName, schemaName, tblName, cols, ifTblExists, ifNotExists);
        return this.startIndexOperationDistributed(op);
    }

    public IgniteInternalFuture<?> dynamicColumnRemove(String cacheName, String schemaName, String tblName, List<String> cols, boolean ifTblExists, boolean ifExists) {
        SchemaAlterTableDropColumnOperation op = new SchemaAlterTableDropColumnOperation(UUID.randomUUID(), cacheName, schemaName, tblName, cols, ifTblExists, ifExists);
        return this.startIndexOperationDistributed(op);
    }

    public IgniteInternalFuture<?> dynamicAddQueryEntity(String cacheName, String schemaName, QueryEntity entity, Integer qryParallelism, boolean sqlEscape) {
        assert (qryParallelism == null || qryParallelism > 0);
        CacheConfiguration cfg = this.ctx.cache().cacheConfiguration(cacheName);
        if (qryParallelism != null && qryParallelism > 1 && cfg.getCacheMode() != CacheMode.PARTITIONED) {
            throw new IgniteSQLException("Segmented indices are supported for PARTITIONED mode only.");
        }
        QueryEntity entity0 = QueryUtils.normalizeQueryEntity(this.ctx, entity, sqlEscape);
        SchemaAddQueryEntityOperation op = new SchemaAddQueryEntityOperation(UUID.randomUUID(), cacheName, schemaName, Collections.singletonList(entity0), qryParallelism != null ? qryParallelism : 1, sqlEscape);
        return this.startIndexOperationDistributed(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<?> startIndexOperationDistributed(SchemaAbstractOperation op) {
        SchemaOperationClientFuture fut = new SchemaOperationClientFuture(op.id());
        SchemaOperationClientFuture oldFut = this.schemaCliFuts.put(op.id(), fut);
        assert (oldFut == null);
        try {
            boolean disconnected0;
            this.ctx.discovery().sendCustomEvent(new SchemaProposeDiscoveryMessage(op));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sent schema propose discovery message [opId=" + op.id() + ", op=" + op + ']');
            }
            Object object = this.stateMux;
            synchronized (object) {
                disconnected0 = this.disconnected;
            }
            if (disconnected0) {
                fut.onDone(new SchemaOperationException("Client node is disconnected (operation result is unknown)."));
                this.schemaCliFuts.remove(op.id());
            }
        }
        catch (Exception e) {
            if (e instanceof SchemaOperationException) {
                fut.onDone(e);
            } else {
                fut.onDone(new SchemaOperationException("Failed to start schema change operation due to unexpected exception [opId=" + op.id() + ", op=" + op + ']', e));
            }
            this.schemaCliFuts.remove(op.id());
        }
        return fut;
    }

    private void sendQueryExecutedEvent(String sqlQry, Object[] params, GridCacheContext<?, ?> cctx, GridCacheQueryType qryType) {
        if (cctx.events().isRecordable(96)) {
            this.ctx.event().record(new CacheQueryExecutedEvent(this.ctx.discovery().localNode(), qryType.name() + " query executed.", 96, qryType.name(), cctx.name(), null, sqlQry, null, null, params, this.ctx.localNodeId(), null));
        }
    }

    private void processDynamicAddColumn(QueryTypeDescriptorImpl d, List<QueryField> cols) throws IgniteCheckedException {
        ArrayList<QueryBinaryProperty> props = new ArrayList<QueryBinaryProperty>(cols.size());
        for (QueryField queryField : cols) {
            try {
                props.add(new QueryBinaryProperty(this.ctx, queryField.name(), null, Class.forName(queryField.typeName()), false, null, !queryField.isNullable(), null, queryField.precision(), queryField.scale()));
            }
            catch (ClassNotFoundException e) {
                throw new SchemaOperationException("Class not found for new property: " + queryField.typeName());
            }
        }
        for (GridQueryProperty gridQueryProperty : props) {
            d.addProperty(gridQueryProperty, true);
        }
    }

    private void processDynamicDropColumn(QueryTypeDescriptorImpl d, List<String> cols) throws IgniteCheckedException {
        for (String field : cols) {
            d.removeProperty(field);
        }
    }

    public void remove(GridCacheContext cctx, CacheDataRow row) throws IgniteCheckedException {
        QueryTypeDescriptorImpl desc;
        assert (row != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove [cacheName=" + cctx.name() + ", key=" + row.key() + ", val=" + row.value() + "]");
        }
        if ((desc = this.typeByValue(cctx.name(), cctx.cacheObjectContext(), row.key(), row.value(), false)) == null) {
            return;
        }
        this.idxProc.remove(cctx.name(), row);
        if (this.indexingEnabled()) {
            this.idx.remove(cctx, desc, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> queryText(final String cacheName, final String clause, final String resType, final IndexingQueryFilter filters, final int limit) throws IgniteCheckedException {
        this.checkIndexingEnabled();
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            GridCacheContext cctx = this.ctx.cache().internalCache(cacheName).context();
            GridCloseableIterator gridCloseableIterator = (GridCloseableIterator)this.executeQuery(GridCacheQueryType.TEXT, clause, cctx, new IgniteOutClosureX<GridCloseableIterator<IgniteBiTuple<K, V>>>(){

                @Override
                public GridCloseableIterator<IgniteBiTuple<K, V>> applyx() throws IgniteCheckedException {
                    String typeName = GridQueryProcessor.this.typeName(cacheName, resType);
                    String schemaName = GridQueryProcessor.this.schemaMgr.schemaName(cacheName);
                    return GridQueryProcessor.this.idx.queryLocalText(schemaName, cacheName, clause, typeName, filters, limit);
                }
            }, true);
            return gridCloseableIterator;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> IndexQueryResult<K, V> queryIndex(String cacheName, String valCls, final IndexQueryDesc idxQryDesc, final @Nullable IgniteBiPredicate<K, V> entryFilter, final IndexingQueryFilter cacheFilter, final boolean keepBinary) throws IgniteCheckedException {
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            final GridCacheContext cctx = this.ctx.cache().internalCache(cacheName).context();
            IndexQueryResult indexQueryResult = (IndexQueryResult)this.executeQuery(GridCacheQueryType.INDEX, valCls, cctx, new IgniteOutClosureX<IndexQueryResult<K, V>>(){

                @Override
                public IndexQueryResult<K, V> applyx() throws IgniteCheckedException {
                    try {
                        return GridQueryProcessor.this.idxQryPrc.queryLocal(cctx, idxQryDesc, entryFilter, cacheFilter, keepBinary);
                    }
                    catch (IgniteCheckedException e) {
                        String msg = "Failed to execute IndexQuery: " + e.getMessage() + ". Query desc: " + idxQryDesc;
                        throw new IgniteCheckedException(msg, e);
                    }
                }
            }, true);
            return indexQueryResult;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public Collection<GridQueryTypeDescriptor> types(@Nullable String cacheName) {
        Set<GridQueryTypeDescriptor> cacheTypes = Collections.newSetFromMap(new IdentityHashMap());
        for (Map.Entry<QueryTypeIdKey, QueryTypeDescriptorImpl> e : this.types.entrySet()) {
            if (!F.eq(e.getKey().cacheName(), cacheName)) continue;
            cacheTypes.add(e.getValue());
        }
        return cacheTypes;
    }

    @Nullable
    private QueryTypeDescriptorImpl type(@Nullable String cacheName, String tblName) {
        for (QueryTypeDescriptorImpl type : this.types.values()) {
            if (!F.eq(cacheName, type.cacheName()) || !F.eq(tblName, type.tableName())) continue;
            return type;
        }
        return null;
    }

    private String typeName(@Nullable String cacheName, String typeName) throws IgniteException {
        QueryTypeDescriptorImpl type = (QueryTypeDescriptorImpl)this.typesByName.get(new QueryTypeNameKey(cacheName, typeName));
        if (type == null) {
            throw new IgniteException("Failed to find SQL table for type: " + typeName);
        }
        return type.name();
    }

    @Nullable
    public GridQueryTypeDescriptor typeDescriptor(@Nullable String cacheName, String typeName) {
        return (GridQueryTypeDescriptor)this.typesByName.get(new QueryTypeNameKey(cacheName, typeName));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R executeQuery(GridCacheQueryType qryType, String qry, @Nullable GridCacheContext<?, ?> cctx, IgniteOutClosureX<R> clo, boolean complete) throws IgniteCheckedException {
        boolean bl;
        CacheQueryFuture fut;
        long startTime = U.currentTimeMillis();
        Throwable err = null;
        CacheQueryFuture res = null;
        try {
            res = (CacheQueryFuture)clo.apply();
            if (res instanceof CacheQueryFuture) {
                fut = res;
                err = fut.error();
            }
            fut = res;
            bl = err != null;
        }
        catch (GridClosureException e) {
            try {
                err = e.unwrap();
                throw (IgniteCheckedException)err;
                catch (CacheException | IgniteException e2) {
                    err = e2;
                    throw e2;
                }
                catch (Exception e3) {
                    err = e3;
                    throw new IgniteCheckedException(e3);
                }
            }
            catch (Throwable throwable) {
                boolean failed2 = err != null;
                long duration = U.currentTimeMillis() - startTime;
                if (complete || failed2) {
                    if (cctx != null) {
                        cctx.queries().collectMetrics(qryType, qry, startTime, duration, failed2);
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Query execution [startTime=" + startTime + ", duration=" + duration + ", fail=" + failed2 + ", res=" + res + ']');
                    }
                }
                throw throwable;
            }
        }
        boolean failed = bl;
        long duration = U.currentTimeMillis() - startTime;
        if (complete || failed) {
            if (cctx != null) {
                cctx.queries().collectMetrics(qryType, qry, startTime, duration, failed);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Query execution [startTime=" + startTime + ", duration=" + duration + ", fail=" + failed + ", res=" + res + ']');
            }
        }
        return (R)fut;
    }

    public void sendStatusMessage(UUID destNodeId, UUID opId, SchemaOperationException err) {
        block3: {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending schema operation status message [opId=" + opId + ", crdNode=" + destNodeId + ", err=" + err + ']');
            }
            try {
                byte[] errBytes = this.marshalSchemaError(opId, err);
                SchemaOperationStatusMessage msg = new SchemaOperationStatusMessage(opId, errBytes);
                this.ctx.io().sendToGridTopic(destNodeId, GridTopic.TOPIC_SCHEMA, (Message)msg, (byte)12);
            }
            catch (IgniteCheckedException e) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("Failed to send schema status response [opId=" + opId + ", destNodeId=" + destNodeId + ", err=" + e + ']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStatusMessage(SchemaOperationStatusMessage msg) {
        Object object = this.stateMux;
        synchronized (object) {
            SchemaOperation op;
            if (this.completedOpIds.contains(msg.operationId())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received status message for completed operation (will ignore) [opId=" + msg.operationId() + ", sndNodeId=" + msg.senderNodeId() + ']');
                }
                return;
            }
            UUID opId = msg.operationId();
            SchemaProposeDiscoveryMessage proposeMsg = this.activeProposals.get(opId);
            if (proposeMsg != null && (op = this.schemaOps.get(proposeMsg.schemaName())) != null && F.eq(op.id(), opId) && op.started() && this.coordinator().isLocal()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received status message [opId=" + msg.operationId() + ", sndNodeId=" + msg.senderNodeId() + ']');
                }
                op.manager().onNodeFinished(msg.senderNodeId(), this.unmarshalSchemaError(msg.errorBytes()));
                return;
            }
            this.pendingMsgs.add(msg);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received status message (added to pending set) [opId=" + msg.operationId() + ", sndNodeId=" + msg.senderNodeId() + ']');
            }
        }
    }

    private void unwindPendingMessages(UUID opId, SchemaOperationManager mgr) {
        assert (Thread.holdsLock(this.stateMux));
        Iterator it = this.pendingMsgs.iterator();
        while (it.hasNext()) {
            SchemaOperationStatusMessage msg = (SchemaOperationStatusMessage)it.next();
            if (!F.eq(msg.operationId(), opId)) continue;
            mgr.onNodeFinished(msg.senderNodeId(), this.unmarshalSchemaError(msg.errorBytes()));
            it.remove();
        }
    }

    @Nullable
    private byte[] marshalSchemaError(UUID opId, @Nullable SchemaOperationException err) {
        if (err == null) {
            return null;
        }
        try {
            return U.marshal(this.marsh, (Object)err);
        }
        catch (Exception e) {
            U.warn(this.log, "Failed to marshal schema operation error [opId=" + opId + ", err=" + err + ']', e);
            try {
                return U.marshal(this.marsh, (Object)new SchemaOperationException("Operation failed, but error cannot be serialized (see local node log for more details) [opId=" + opId + ", nodeId=" + this.ctx.localNodeId() + ']'));
            }
            catch (Exception e0) {
                assert (false);
                return null;
            }
        }
    }

    @Nullable
    private SchemaOperationException unmarshalSchemaError(@Nullable byte[] errBytes) {
        if (errBytes == null) {
            return null;
        }
        try {
            return (SchemaOperationException)U.unmarshal((Marshaller)this.marsh, errBytes, U.resolveClassLoader(this.ctx.config()));
        }
        catch (Exception e) {
            return new SchemaOperationException("Operation failed, but error cannot be deserialized.");
        }
    }

    public CacheQueryObjectValueContext objectContext() {
        return this.valCtx;
    }

    public void validateKeyAndValue(CacheObjectContext coctx, KeyCacheObject key, CacheObject val) throws IgniteCheckedException {
        QueryTypeDescriptorImpl desc = this.typeByValue(coctx.cacheName(), coctx, key, val, true);
        if (desc == null) {
            return;
        }
        desc.validateKeyAndValue(key, val);
    }

    public static void setRequestAffinityTopologyVersion(AffinityTopologyVersion ver) {
        requestTopVer.set(ver);
    }

    public static AffinityTopologyVersion getRequestAffinityTopologyVersion() {
        return requestTopVer.get();
    }

    private static long missedCacheTypeKey(String cacheName, int typeId) {
        return (long)CU.cacheId(cacheName) << 32 | (long)typeId;
    }

    private static boolean missedCacheTypeKeyMatches(long key, String cacheName) {
        int cacheId = CU.cacheId(cacheName);
        long cacheIdShifted = (long)cacheId << 32;
        return (key & cacheIdShifted) == cacheIdShifted;
    }

    public void removeIndexRebuildFuturesOnExchange(GridDhtPartitionsExchangeFuture fut, @Nullable Set<Integer> cacheIds) {
        this.idxRebuildFutStorage.cancelRebuildIndexesOnExchange(cacheIds != null ? cacheIds : this.rebuildIndexCacheIds(fut), fut.initialVersion());
    }

    public boolean rebuildIndexOnExchange(int cacheId, GridDhtPartitionsExchangeFuture fut) {
        return this.idxRebuildFutStorage.rebuildIndexesOnExchange(cacheId, fut.initialVersion());
    }

    public Set<Integer> prepareRebuildIndexes(Set<Integer> cacheIds) {
        return this.idxRebuildFutStorage.prepareRebuildIndexes(cacheIds, null);
    }

    private Set<Integer> rebuildIndexCacheIds(GridDhtPartitionsExchangeFuture fut) {
        ExchangeActions acts = fut.exchangeActions();
        Set<Integer> cacheIds = Collections.emptySet();
        if (acts != null) {
            if (!F.isEmpty(acts.cacheStartRequests())) {
                cacheIds = acts.cacheStartRequests().stream().map(d -> CU.cacheId(d.request().cacheName())).collect(Collectors.toSet());
            } else if (acts.localJoinContext() != null && !F.isEmpty(acts.localJoinContext().caches())) {
                cacheIds = acts.localJoinContext().caches().stream().map(t2 -> ((DynamicCacheDescriptor)t2.get1()).cacheId()).collect(Collectors.toSet());
            }
        }
        return cacheIds;
    }

    public void onStartRebuildIndexes(GridCacheContext cacheCtx) {
        this.idxBuildStatusStorage.onStartRebuildIndexes(cacheCtx);
    }

    public void onFinishRebuildIndexes(GridCacheContext cacheCtx) {
        this.idxBuildStatusStorage.onFinishRebuildIndexes(cacheCtx.name());
    }

    public boolean rebuildIndexesCompleted(GridCacheContext cacheCtx) {
        return this.idxBuildStatusStorage.rebuildCompleted(cacheCtx.name());
    }

    public void completeRebuildIndexes(String cacheName) {
        this.idxBuildStatusStorage.onFinishRebuildIndexes(cacheName);
    }

    public IndexBuildStatusStorage getIdxBuildStatusStorage() {
        return this.idxBuildStatusStorage;
    }

    public SchemaManager schemaManager() {
        return this.schemaMgr;
    }

    public IgniteStatisticsManager statsManager() {
        return this.statsMgr;
    }

    private class SchemaOperation {
        private final SchemaProposeDiscoveryMessage proposeMsg;
        private SchemaOperation next;
        private SchemaOperationManager mgr;
        private SchemaFinishDiscoveryMessage finishMsg;
        private final AtomicBoolean finishGuard = new AtomicBoolean();

        public SchemaOperation(SchemaProposeDiscoveryMessage proposeMsg) {
            this.proposeMsg = proposeMsg;
        }

        public UUID id() {
            return this.proposeMsg.operation().id();
        }

        public SchemaProposeDiscoveryMessage proposeMessage() {
            return this.proposeMsg;
        }

        @Nullable
        public SchemaOperation next() {
            return this.next;
        }

        public void next(SchemaOperation next) {
            this.next = next;
        }

        public void finishMessage(SchemaFinishDiscoveryMessage finishMsg) {
            this.finishMsg = finishMsg;
        }

        public boolean hasFinishMessage() {
            return this.finishMsg != null;
        }

        public void doFinish() {
            assert (this.started());
            if (!this.finishGuard.compareAndSet(false, true)) {
                return;
            }
            final UUID opId = this.id();
            final String schemaName = this.proposeMsg.schemaName();
            this.mgr.worker().future().listen(new IgniteInClosure<IgniteInternalFuture>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(IgniteInternalFuture fut) {
                    Object object = GridQueryProcessor.this.stateMux;
                    synchronized (object) {
                        SchemaOperation nextOp;
                        SchemaOperation op = (SchemaOperation)GridQueryProcessor.this.schemaOps.remove(schemaName);
                        assert (op != null);
                        assert (F.eq(op.id(), opId));
                        SchemaOperationClientFuture cliFut = (SchemaOperationClientFuture)GridQueryProcessor.this.schemaCliFuts.remove(opId);
                        if (cliFut != null) {
                            if (SchemaOperation.this.finishMsg.hasError()) {
                                cliFut.onDone(SchemaOperation.this.finishMsg.error());
                            } else {
                                cliFut.onDone();
                            }
                        }
                        if ((nextOp = op.next()) != null) {
                            GridQueryProcessor.this.schemaOps.put(schemaName, nextOp);
                            if (GridQueryProcessor.this.log.isDebugEnabled()) {
                                GridQueryProcessor.this.log.debug("Next schema change operation started [opId=" + nextOp.id() + ']');
                            }
                            assert (!nextOp.started());
                            new IgniteThread(GridQueryProcessor.this.ctx.igniteInstanceName(), "schema-circuit-breaker-" + op.id(), new Runnable(){

                                @Override
                                public void run() {
                                    GridQueryProcessor.this.onSchemaPropose(nextOp.proposeMessage());
                                }
                            }).start();
                        }
                    }
                }
            });
        }

        public SchemaOperation unwind() {
            if (this.next == null) {
                return this;
            }
            return this.next.unwind();
        }

        public boolean started() {
            return this.mgr != null;
        }

        public SchemaOperationManager manager() {
            return this.mgr;
        }

        public void manager(SchemaOperationManager mgr) {
            assert (this.mgr == null);
            this.mgr = mgr;
        }
    }
}

