/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BooleanSupplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.PageStoreWriter;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointMetricsTracker;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridConcurrentMultiPairQueue;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.CountDownFuture;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.jsr166.ConcurrentLinkedHashMap;

public class CheckpointPagesWriter
implements Runnable {
    private final IgniteLogger log;
    private final CheckpointMetricsTracker tracker;
    private final GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> writePageIds;
    private final ConcurrentLinkedHashMap<PageStore, LongAdder> updStores;
    private final CountDownFuture doneFut;
    private final Runnable beforePageWrite;
    private final IgniteCacheSnapshotManager snapshotMgr;
    private final DataStorageMetricsImpl persStoreMetrics;
    private final ThreadLocal<ByteBuffer> threadBuf;
    private final PageMemoryImpl.ThrottlingPolicy throttlingPolicy;
    private final IgniteThrowableFunction<Integer, PageMemoryEx> pageMemoryGroupResolver;
    private final CheckpointProgressImpl curCpProgress;
    private final CheckpointPageWriter pageWriter;
    private final BooleanSupplier shutdownNow;

    CheckpointPagesWriter(CheckpointMetricsTracker tracker, GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> writePageIds, ConcurrentLinkedHashMap<PageStore, LongAdder> updStores, CountDownFuture doneFut, Runnable beforePageWrite, IgniteCacheSnapshotManager snapshotManager, IgniteLogger log, DataStorageMetricsImpl dsMetrics, ThreadLocal<ByteBuffer> buf, PageMemoryImpl.ThrottlingPolicy throttlingPolicy, IgniteThrowableFunction<Integer, PageMemoryEx> pageMemoryGroupResolver, CheckpointProgressImpl progress, CheckpointPageWriter pageWriter, BooleanSupplier shutdownNow) {
        this.tracker = tracker;
        this.writePageIds = writePageIds;
        this.updStores = updStores;
        this.doneFut = doneFut;
        this.beforePageWrite = beforePageWrite;
        this.snapshotMgr = snapshotManager;
        this.log = log;
        this.persStoreMetrics = dsMetrics;
        this.threadBuf = buf;
        this.throttlingPolicy = throttlingPolicy;
        this.pageMemoryGroupResolver = pageMemoryGroupResolver;
        this.curCpProgress = progress;
        this.pageWriter = pageWriter;
        this.shutdownNow = shutdownNow;
    }

    @Override
    public void run() {
        this.snapshotMgr.beforeCheckpointPageWritten();
        GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> writePageIds = this.writePageIds;
        try {
            GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> pagesToRetry = this.writePages(writePageIds);
            if (pagesToRetry.isEmpty()) {
                this.doneFut.onDone();
            } else {
                if (this.log.isInfoEnabled()) {
                    this.log.info(pagesToRetry.initialSize() + " checkpoint pages were not written yet due to unsuccessful page write lock acquisition and will be retried");
                }
                while (!pagesToRetry.isEmpty()) {
                    pagesToRetry = this.writePages(pagesToRetry);
                }
                this.doneFut.onDone();
            }
        }
        catch (Throwable e) {
            this.doneFut.onDone(e);
        }
    }

    private GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> writePages(GridConcurrentMultiPairQueue<PageMemoryEx, FullPageId> writePageIds) throws IgniteCheckedException {
        HashMap pagesToRetry = new HashMap();
        CheckpointMetricsTracker tracker = this.persStoreMetrics.metricsEnabled() ? this.tracker : null;
        HashMap<PageMemoryEx, PageStoreWriter> pageStoreWriters = new HashMap<PageMemoryEx, PageStoreWriter>();
        ByteBuffer tmpWriteBuf = this.threadBuf.get();
        boolean throttlingEnabled = this.throttlingPolicy != PageMemoryImpl.ThrottlingPolicy.DISABLED;
        GridConcurrentMultiPairQueue.Result res = new GridConcurrentMultiPairQueue.Result();
        while (writePageIds.next(res) && !this.shutdownNow.getAsBoolean()) {
            FullPageId cpPageId;
            this.beforePageWrite.run();
            FullPageId fullId = (FullPageId)res.getValue();
            PageMemoryEx pageMem = (PageMemoryEx)res.getKey();
            this.snapshotMgr.beforePageWrite(fullId);
            tmpWriteBuf.rewind();
            PageStoreWriter pageStoreWriter = pageStoreWriters.computeIfAbsent(pageMem, pageMemEx -> this.createPageStoreWriter((PageMemoryEx)pageMemEx, pagesToRetry));
            pageMem.checkpointWritePage(fullId, tmpWriteBuf, pageStoreWriter, tracker);
            if (!throttlingEnabled) continue;
            while (pageMem.isCpBufferOverflowThresholdExceeded() && !(cpPageId = pageMem.pullPageFromCpBuffer()).equals(FullPageId.NULL_PAGE)) {
                this.snapshotMgr.beforePageWrite(cpPageId);
                tmpWriteBuf.rewind();
                pageMem.checkpointWritePage(cpPageId, tmpWriteBuf, pageStoreWriter, tracker);
            }
        }
        return pagesToRetry.isEmpty() ? GridConcurrentMultiPairQueue.EMPTY : new GridConcurrentMultiPairQueue(pagesToRetry);
    }

    private PageStoreWriter createPageStoreWriter(final PageMemoryEx pageMemEx, final Map<PageMemoryEx, List<FullPageId>> pagesToRetry) {
        return new PageStoreWriter(){

            @Override
            public void writePage(FullPageId fullPageId, ByteBuffer buf, int tag) throws IgniteCheckedException {
                int pageType;
                if (tag == -1) {
                    pagesToRetry.computeIfAbsent(pageMemEx, k -> new ArrayList()).add(fullPageId);
                    return;
                }
                int groupId = fullPageId.groupId();
                long pageId = fullPageId.pageId();
                assert (PageIO.getType(buf) != 0) : "Invalid state. Type is 0! pageId = " + IgniteUtils.hexLong(pageId);
                assert (PageIO.getVersion(buf) != 0) : "Invalid state. Version is 0! pageId = " + IgniteUtils.hexLong(pageId);
                if (CheckpointPagesWriter.this.persStoreMetrics.metricsEnabled() && PageIO.isDataPageType(pageType = PageIO.getType(buf))) {
                    CheckpointPagesWriter.this.tracker.onDataPageWritten();
                }
                CheckpointPagesWriter.this.curCpProgress.updateWrittenPages(1);
                PageStore store = CheckpointPagesWriter.this.pageWriter.write(pageMemEx, fullPageId, buf, tag);
                CheckpointPagesWriter.this.updStores.computeIfAbsent(store, k -> new LongAdder()).increment();
            }
        };
    }

    public static interface CheckpointPageWriter {
        public PageStore write(PageMemoryEx var1, FullPageId var2, ByteBuffer var3, int var4) throws IgniteCheckedException;
    }
}

