/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.mvcc.txlog;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxKey;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxLogIO;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;

public class TxLogLeafIO
extends BPlusLeafIO<TxKey>
implements TxLogIO {
    public static final IOVersions<TxLogLeafIO> VERSIONS = new IOVersions((PageIO[])new TxLogLeafIO[]{new TxLogLeafIO(1)});

    protected TxLogLeafIO(int ver) {
        super(30, ver, 17);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, TxKey row) {
        this.assertPageType(pageAddr);
        TxRow row0 = (TxRow)row;
        this.setMajor(pageAddr, off, row0.major());
        this.setMinor(pageAddr, off, row0.minor());
        this.setState(pageAddr, off, row0.state());
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BPlusIO<TxKey> srcIo, long srcPageAddr, int srcIdx) {
        this.assertPageType(dstPageAddr);
        TxLogIO srcIo0 = (TxLogIO)((Object)srcIo);
        int srcOff = srcIo.offset(srcIdx);
        int dstOff = this.offset(dstIdx);
        this.setMajor(dstPageAddr, dstOff, srcIo0.getMajor(srcPageAddr, srcOff));
        this.setMinor(dstPageAddr, dstOff, srcIo0.getMinor(srcPageAddr, srcOff));
        this.setState(dstPageAddr, dstOff, srcIo0.getState(srcPageAddr, srcOff));
    }

    @Override
    public TxKey getLookupRow(BPlusTree<TxKey, ?> tree, long pageAddr, int idx) {
        int off = this.offset(idx);
        return new TxRow(this.getMajor(pageAddr, off), this.getMinor(pageAddr, off), this.getState(pageAddr, off));
    }

    @Override
    public int compare(long pageAddr, int off, TxKey row) {
        int cmp = Long.compare(this.getMajor(pageAddr, off), row.major());
        return cmp != 0 ? cmp : Long.compare(this.getMinor(pageAddr, off), row.minor());
    }

    @Override
    public long getMajor(long pageAddr, int off) {
        return PageUtils.getLong(pageAddr, off);
    }

    @Override
    public void setMajor(long pageAddr, int off, long major) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, off, major);
    }

    @Override
    public long getMinor(long pageAddr, int off) {
        return PageUtils.getLong(pageAddr, off + 8);
    }

    @Override
    public void setMinor(long pageAddr, int off, long minor) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, off + 8, minor);
    }

    @Override
    public byte getState(long pageAddr, int off) {
        return PageUtils.getByte(pageAddr, off + 16);
    }

    @Override
    public void setState(long pageAddr, int off, byte state) {
        this.assertPageType(pageAddr);
        PageUtils.putByte(pageAddr, off + 16, state);
    }
}

