/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near.consistency;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.ReadRepairStrategy;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.GridNearReadRepairAbstractFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteIrreparableConsistencyViolationException;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.transactions.TransactionState;

public class GridNearReadRepairFuture
extends GridNearReadRepairAbstractFuture {
    public GridNearReadRepairFuture(AffinityTopologyVersion topVer, GridCacheContext ctx, Collection<KeyCacheObject> keys, ReadRepairStrategy strategy, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, IgniteInternalTx tx) {
        this(topVer, ctx, keys, strategy, readThrough, taskName, deserializeBinary, recovery, expiryPlc, tx, (GridNearReadRepairFuture)null);
    }

    private GridNearReadRepairFuture(AffinityTopologyVersion topVer, GridCacheContext ctx, Collection<KeyCacheObject> keys, ReadRepairStrategy strategy, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, IgniteInternalTx tx, GridNearReadRepairFuture remappedFut) {
        super(topVer, ctx, keys, strategy, readThrough, taskName, deserializeBinary, recovery, expiryPlc, tx, remappedFut);
        assert (ctx.transactional()) : "Atomic cache should not be recovered using this future";
    }

    @Override
    protected GridNearReadRepairAbstractFuture remapFuture(AffinityTopologyVersion topVer) {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    protected void reduce() {
        assert (this.strategy != null);
        try {
            this.check();
            this.onDone(Collections.emptyMap());
        }
        catch (GridNearReadRepairAbstractFuture.IgniteConsistencyCheckFailedException e) {
            Set<KeyCacheObject> inconsistentKeys = e.keys();
            try {
                Map<KeyCacheObject, EntryGetResult> correctedMap = this.correct(inconsistentKeys);
                assert (!correctedMap.isEmpty());
                this.tx.finishFuture().listen(future -> {
                    TransactionState state = this.tx.state();
                    if (state == TransactionState.COMMITTED) {
                        this.recordConsistencyViolation(correctedMap.keySet(), correctedMap);
                    }
                });
                this.onDone(correctedMap);
            }
            catch (GridNearReadRepairAbstractFuture.IgniteConsistencyRepairFailedException rfe) {
                this.recordConsistencyViolation(inconsistentKeys, null);
                Map<KeyCacheObject, EntryGetResult> correctedMap = rfe.correctedMap();
                this.onDone(new IgniteIrreparableConsistencyViolationException(correctedMap != null ? this.ctx.unwrapBinariesIfNeeded(correctedMap.keySet(), !this.deserializeBinary) : null, this.ctx.unwrapBinariesIfNeeded(rfe.irreparableKeys(), !this.deserializeBinary)));
            }
            catch (IgniteCheckedException ce) {
                this.onDone(ce);
            }
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
    }
}

