/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataHolder;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;

class BinaryMetadataFileStore {
    private File metadataDir;
    private final ConcurrentMap<Integer, BinaryMetadataHolder> metadataLocCache;
    private final GridKernalContext ctx;
    private final boolean enabled;
    private FileIOFactory fileIOFactory;
    private final IgniteLogger log;
    private BinaryMetadataAsyncWriter writer;

    BinaryMetadataFileStore(ConcurrentMap<Integer, BinaryMetadataHolder> metadataLocCache, GridKernalContext ctx, IgniteLogger log, File binaryMetadataFileStoreDir) throws IgniteCheckedException {
        this.metadataLocCache = metadataLocCache;
        this.ctx = ctx;
        this.enabled = CU.isPersistenceEnabled(ctx.config()) || CU.isCdcEnabled(ctx.config());
        this.log = log;
        if (!this.enabled) {
            return;
        }
        this.fileIOFactory = ctx.config().getDataStorageConfiguration().getFileIOFactory();
        String nodeFolderName = ctx.pdsFolderResolver().resolveFolders().folderName();
        this.metadataDir = binaryMetadataFileStoreDir != null ? binaryMetadataFileStoreDir : new File(U.resolveWorkDirectory(ctx.config().getWorkDirectory(), "db/binary_meta", false), nodeFolderName);
        this.fixLegacyFolder(nodeFolderName);
    }

    void start() throws IgniteCheckedException {
        if (!this.enabled) {
            return;
        }
        U.ensureDirectory(this.metadataDir, "directory for serialized binary metadata", this.log);
        this.writer = new BinaryMetadataAsyncWriter();
        new IgniteThread(this.writer).start();
    }

    void stop() {
        U.cancel(this.writer);
    }

    void writeMetadata(BinaryMetadata binMeta) {
        if (!this.enabled) {
            return;
        }
        try {
            File file = new File(this.metadataDir, BinaryUtils.binaryMetaFileName(binMeta.typeId()));
            byte[] marshalled = U.marshal(this.ctx, (Object)binMeta);
            try (FileIO out = this.fileIOFactory.create(file);){
                int left = marshalled.length;
                while ((left -= out.writeFully(marshalled, 0, Math.min(marshalled.length, left))) > 0) {
                }
                out.force();
            }
        }
        catch (Exception e) {
            String msg = "Failed to save metadata for typeId: " + binMeta.typeId() + "; exception was thrown: " + e.getMessage();
            U.error(this.log, msg);
            U.cancel(this.writer);
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw new IgniteException(msg, e);
        }
    }

    private void removeMeta(int typeId) {
        if (!this.enabled) {
            return;
        }
        File file = new File(this.metadataDir, BinaryUtils.binaryMetaFileName(typeId));
        if (!file.delete()) {
            String msg = "Failed to remove metadata for typeId: " + typeId;
            U.error(this.log, msg);
            this.writer.cancel();
            IgniteException e = new IgniteException(msg);
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    void restoreMetadata() {
        if (!this.enabled) {
            return;
        }
        for (File file : this.metadataDir.listFiles()) {
            this.restoreMetadata(file);
        }
    }

    void restoreMetadata(int typeId) {
        this.restoreMetadata(new File(this.metadataDir, BinaryUtils.binaryMetaFileName(typeId)));
    }

    private void restoreMetadata(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            BinaryMetadata meta = (BinaryMetadata)U.unmarshal(this.ctx.config().getMarshaller(), in, U.resolveClassLoader(this.ctx.config()));
            this.metadataLocCache.put(meta.typeId(), new BinaryMetadataHolder(meta, 0, 0));
        }
        catch (Exception e) {
            U.warn(this.log, "Failed to restore metadata from file: " + file.getName() + "; exception was thrown: " + e.getMessage());
        }
    }

    void mergeAndWriteMetadata(BinaryMetadata binMeta) {
        BinaryMetadata existingMeta = this.readMetadata(binMeta.typeId());
        if (existingMeta != null) {
            BinaryMetadata mergedMeta = BinaryUtils.mergeMetadata(existingMeta, binMeta);
            this.writeMetadata(mergedMeta);
        } else {
            this.writeMetadata(binMeta);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BinaryMetadata readMetadata(int typeId) {
        File file = new File(this.metadataDir, BinaryUtils.binaryMetaFileName(typeId));
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream in = new FileInputStream(file);){
            BinaryMetadata binaryMetadata = (BinaryMetadata)U.unmarshal(this.ctx.config().getMarshaller(), in, U.resolveClassLoader(this.ctx.config()));
            return binaryMetadata;
        }
        catch (Exception e) {
            U.warn(this.log, "Failed to restore metadata from file: " + file.getName() + "; exception was thrown: " + e.getMessage());
            return null;
        }
    }

    void prepareMetadataWriting(BinaryMetadata meta, int typeVer) {
        if (!this.enabled) {
            return;
        }
        this.writer.prepareWriteFuture(meta, typeVer);
    }

    void writeMetadataAsync(int typeId, int typeVer) {
        if (!this.enabled) {
            return;
        }
        this.writer.startTaskAsync(typeId, typeVer);
    }

    public void removeMetadataAsync(int typeId) {
        if (!this.enabled) {
            return;
        }
        this.writer.startTaskAsync(typeId, -2);
    }

    void waitForWriteCompletion(int typeId, int typeVer) throws IgniteCheckedException {
        if (!this.enabled) {
            return;
        }
        this.writer.waitForWriteCompletion(typeId, typeVer);
    }

    void finishWrite(int typeId, int typeVer) {
        if (!this.enabled) {
            return;
        }
        this.writer.finishWriteFuture(typeId, typeVer, null);
    }

    private void fixLegacyFolder(String consistendId) throws IgniteCheckedException {
        if (this.ctx.config().getWorkDirectory() == null) {
            return;
        }
        File legacyDir = new File(new File(this.ctx.config().getWorkDirectory(), "binary_meta"), consistendId);
        File legacyTmpDir = new File(legacyDir.toString() + ".tmp");
        if (legacyTmpDir.exists() && !IgniteUtils.delete(legacyTmpDir)) {
            throw new IgniteCheckedException("Failed to delete legacy binary metadata dir: " + legacyTmpDir.getAbsolutePath());
        }
        if (legacyDir.exists()) {
            try {
                IgniteUtils.copy(legacyDir, this.metadataDir, true);
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to copy legacy binary metadata dir to new location", e);
            }
            try {
                Files.move(legacyDir.toPath(), legacyTmpDir.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to rename legacy binary metadata dir", e);
            }
            if (!IgniteUtils.delete(legacyTmpDir)) {
                throw new IgniteCheckedException("Failed to delete legacy binary metadata dir");
            }
        }
    }

    void prepareMetadataRemove(int typeId) {
        if (!this.enabled) {
            return;
        }
        this.writer.cancelTasksForType(typeId);
        this.writer.prepareRemoveFuture(typeId);
    }

    private static final class OperationSyncKey {
        private final int typeId;
        private final int typeVer;

        private OperationSyncKey(int typeId, int typeVer) {
            this.typeId = typeId;
            this.typeVer = typeVer;
        }

        public int hashCode() {
            return 31 * this.typeId + this.typeVer;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OperationSyncKey)) {
                return false;
            }
            OperationSyncKey that = (OperationSyncKey)obj;
            return that.typeId == this.typeId && that.typeVer == this.typeVer;
        }

        public String toString() {
            return S.toString(OperationSyncKey.class, this);
        }
    }

    private static final class RemoveOperationTask
    extends OperationTask {
        private final int typeId;

        private RemoveOperationTask(int typeId) {
            this.typeId = typeId;
        }

        @Override
        void execute(BinaryMetadataFileStore store) {
            store.removeMeta(this.typeId);
        }

        @Override
        int typeId() {
            return this.typeId;
        }

        @Override
        int typeVersion() {
            return -2;
        }
    }

    private static final class WriteOperationTask
    extends OperationTask {
        private final BinaryMetadata meta;
        private final int typeVer;

        private WriteOperationTask(BinaryMetadata meta, int ver) {
            this.meta = meta;
            this.typeVer = ver;
        }

        @Override
        void execute(BinaryMetadataFileStore store) {
            store.writeMetadata(this.meta);
        }

        @Override
        int typeId() {
            return this.meta.typeId();
        }

        @Override
        int typeVersion() {
            return this.typeVer;
        }
    }

    private static abstract class OperationTask {
        private final GridFutureAdapter<Void> future = new GridFutureAdapter();

        private OperationTask() {
        }

        abstract void execute(BinaryMetadataFileStore var1);

        abstract int typeId();

        abstract int typeVersion();

        GridFutureAdapter<Void> future() {
            return this.future;
        }
    }

    private class BinaryMetadataAsyncWriter
    extends GridWorker {
        private final BlockingQueue<OperationTask> queue;
        private final ConcurrentMap<OperationSyncKey, OperationTask> preparedTasks;

        BinaryMetadataAsyncWriter() {
            super(BinaryMetadataFileStore.this.ctx.igniteInstanceName(), "binary-metadata-writer", BinaryMetadataFileStore.this.log, BinaryMetadataFileStore.this.ctx.workersRegistry());
            this.queue = new LinkedBlockingQueue<OperationTask>();
            this.preparedTasks = new ConcurrentHashMap<OperationSyncKey, OperationTask>();
        }

        synchronized void startTaskAsync(int typeId, int typeVer) {
            if (this.isCancelled()) {
                return;
            }
            OperationTask task = (OperationTask)this.preparedTasks.get(new OperationSyncKey(typeId, typeVer));
            if (task != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Submitting task for async write for [typeId=" + typeId + ", typeVersion=" + typeVer + ']');
                }
                this.queue.add(task);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Task for async write for [typeId=" + typeId + ", typeVersion=" + typeVer + "] not found");
            }
        }

        @Override
        public synchronized void cancel() {
            super.cancel();
            this.queue.clear();
            IgniteCheckedException err = new IgniteCheckedException("Operation has been cancelled (node is stopping).");
            for (Map.Entry e : this.preparedTasks.entrySet()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cancelling future for write operation for [typeId=" + ((OperationSyncKey)e.getKey()).typeId + ", typeVer=" + ((OperationSyncKey)e.getKey()).typeVer + ']');
                }
                ((OperationTask)e.getValue()).future.onDone(err);
            }
            this.preparedTasks.clear();
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            while (!this.isCancelled()) {
                try {
                    this.body0();
                }
                catch (InterruptedException e) {
                    if (this.isCancelled.get()) continue;
                    BinaryMetadataFileStore.this.ctx.failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, e));
                    throw e;
                }
            }
        }

        private void body0() throws InterruptedException {
            OperationTask task;
            this.blockingSectionBegin();
            try {
                task = this.queue.take();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Starting write operation for [typeId=" + task.typeId() + ", typeVer=" + task.typeVersion() + ']');
                }
                task.execute(BinaryMetadataFileStore.this);
            }
            finally {
                this.blockingSectionEnd();
            }
            this.finishWriteFuture(task.typeId(), task.typeVersion(), task);
        }

        synchronized void cancelTasksForType(int typeId) {
            IgniteCheckedException err = new IgniteCheckedException("Operation has been cancelled by type remove.");
            this.preparedTasks.entrySet().removeIf(entry -> {
                if (((OperationSyncKey)entry.getKey()).typeId == typeId) {
                    ((OperationTask)entry.getValue()).future().onDone(err);
                    return true;
                }
                return false;
            });
        }

        void finishWriteFuture(int typeId, int typeVer, OperationTask task) {
            boolean removed;
            if (task != null) {
                removed = this.preparedTasks.remove(new OperationSyncKey(typeId, typeVer), task);
            } else {
                task = (OperationTask)this.preparedTasks.remove(new OperationSyncKey(typeId, typeVer));
                boolean bl = removed = task != null;
            }
            if (removed) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Future for write operation for [typeId=" + typeId + ", typeVer=" + typeVer + ']' + " completed.");
                }
                task.future.onDone();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Future for write operation for [typeId=" + typeId + ", typeVer=" + typeVer + ']' + " not found.");
            }
        }

        synchronized void prepareWriteFuture(BinaryMetadata meta, int typeVer) {
            if (this.isCancelled()) {
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Prepare task for async write for[typeName=" + meta.typeName() + ", typeId=" + meta.typeId() + ", typeVersion=" + typeVer + ']');
            }
            this.preparedTasks.putIfAbsent(new OperationSyncKey(meta.typeId(), typeVer), new WriteOperationTask(meta, typeVer));
        }

        synchronized void prepareRemoveFuture(int typeId) {
            if (this.isCancelled()) {
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Prepare task for async remove for[typeId=" + typeId + ']');
            }
            this.preparedTasks.putIfAbsent(new OperationSyncKey(typeId, -2), new RemoveOperationTask(typeId));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForWriteCompletion(int typeId, int typeVer) throws IgniteCheckedException {
            if (typeVer == -1) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("No need to wait for " + typeId + ", negative typeVer was passed.");
                }
                return;
            }
            OperationTask task = (OperationTask)this.preparedTasks.get(new OperationSyncKey(typeId, typeVer));
            if (task != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Waiting for write completion of [typeId=" + typeId + ", typeVer=" + typeVer + "]");
                }
                try {
                    task.future.get();
                }
                finally {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Released for write completion of [typeId=" + typeId + ", typeVer=" + typeVer + ']');
                    }
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Task for async write for [typeId=" + typeId + ", typeVersion=" + typeVer + "] not found");
            }
        }
    }
}

