/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview.walker;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.systemview.view.PagesListView;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

public class PagesListViewWalker
implements SystemViewRowAttributeWalker<PagesListView> {
    public static final String BUCKET_NUMBER_FILTER = "bucketNumber";
    private static final List<String> FILTRABLE_ATTRS = Collections.unmodifiableList(F.asList("bucketNumber"));

    @Override
    public List<String> filtrableAttributes() {
        return FILTRABLE_ATTRS;
    }

    @Override
    public void visitAll(SystemViewRowAttributeWalker.AttributeVisitor v) {
        v.accept(0, "name", String.class);
        v.accept(1, BUCKET_NUMBER_FILTER, Integer.TYPE);
        v.accept(2, "bucketSize", Long.TYPE);
        v.accept(3, "stripesCount", Integer.TYPE);
        v.accept(4, "cachedPagesCount", Integer.TYPE);
    }

    @Override
    public void visitAll(PagesListView row, SystemViewRowAttributeWalker.AttributeWithValueVisitor v) {
        v.accept(0, "name", String.class, row.name());
        v.acceptInt(1, BUCKET_NUMBER_FILTER, row.bucketNumber());
        v.acceptLong(2, "bucketSize", row.bucketSize());
        v.acceptInt(3, "stripesCount", row.stripesCount());
        v.acceptInt(4, "cachedPagesCount", row.cachedPagesCount());
    }

    @Override
    public int count() {
        return 5;
    }
}

