/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cdc;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cdc.CdcCacheEvent;
import org.apache.ignite.cdc.CdcConsumer;
import org.apache.ignite.cdc.CdcEvent;
import org.apache.ignite.cdc.TypeMapping;
import org.apache.ignite.internal.cdc.CdcEventImpl;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.UnwrappedDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;

public class WalRecordsConsumer<K, V> {
    public static final String EVTS_CNT = "EventsCount";
    public static final String LAST_EVT_TIME = "LastEventTime";
    private final IgniteLogger log;
    private final CdcConsumer consumer;
    private AtomicLongMetric evtsCnt;
    private AtomicLongMetric lastEvtTs;
    private static final EnumSet<GridCacheOperation> OPERATIONS_TYPES = EnumSet.of(GridCacheOperation.CREATE, GridCacheOperation.UPDATE, GridCacheOperation.DELETE, GridCacheOperation.TRANSFORM);
    private static final IgnitePredicate<? super DataEntry> OPERATIONS_FILTER = e -> {
        if (!(e instanceof UnwrappedDataEntry)) {
            throw new IllegalStateException("Unexpected data entry [type=" + e.getClass().getName() + ']');
        }
        if ((e.flags() & 2) != 0 || (e.flags() & 4) != 0) {
            return false;
        }
        return OPERATIONS_TYPES.contains((Object)e.op());
    };
    private static final IgniteClosure<DataEntry, CdcEvent> CDC_EVENT_TRANSFORMER = e -> {
        UnwrappedDataEntry ue = (UnwrappedDataEntry)((Object)e);
        return new CdcEventImpl(ue.unwrappedKey(), ue.unwrappedValue(), (e.flags() & 1) != 0, e.partitionId(), e.writeVersion(), e.cacheId());
    };

    public WalRecordsConsumer(CdcConsumer consumer, IgniteLogger log) {
        this.consumer = consumer;
        this.log = log;
    }

    public boolean onRecords(final Iterator<DataEntry> entries) {
        Iterator<CdcEvent> evts = F.iterator(new Iterator<DataEntry>(){

            @Override
            public boolean hasNext() {
                return entries.hasNext();
            }

            @Override
            public DataEntry next() {
                DataEntry next = (DataEntry)entries.next();
                WalRecordsConsumer.this.evtsCnt.increment();
                WalRecordsConsumer.this.lastEvtTs.value(System.currentTimeMillis());
                return next;
            }
        }, CDC_EVENT_TRANSFORMER, true, OPERATIONS_FILTER);
        return this.consumer.onEvents(evts);
    }

    public void onTypes(Iterator<BinaryType> types) {
        this.consumer.onTypes(types);
    }

    public void onMappings(Iterator<TypeMapping> mappings) {
        this.consumer.onMappings(mappings);
    }

    public void onCacheEvents(Iterator<CdcCacheEvent> cacheEvts) {
        this.consumer.onCacheChange(cacheEvts);
    }

    public void onCacheDestroyEvents(Iterator<Integer> caches) {
        this.consumer.onCacheDestroy(caches);
    }

    public void start(MetricRegistry cdcReg, MetricRegistry cdcConsumerReg) throws IgniteCheckedException {
        this.consumer.start(cdcConsumerReg);
        this.evtsCnt = cdcReg.longMetric(EVTS_CNT, "Count of events processed by the consumer");
        this.lastEvtTs = cdcReg.longMetric(LAST_EVT_TIME, "Time of the last event process");
        if (this.log.isDebugEnabled()) {
            this.log.debug("WalRecordsConsumer started [consumer=" + this.consumer.getClass() + ']');
        }
    }

    public void stop() {
        this.consumer.stop();
        if (this.log.isInfoEnabled()) {
            this.log.info("WalRecordsConsumer stopped [consumer=" + this.consumer.getClass() + ']');
        }
    }

    public CdcConsumer consumer() {
        return this.consumer;
    }

    public String toString() {
        return S.toString(WalRecordsConsumer.class, this);
    }

    public static class DataEntryIterator
    implements Iterator<DataEntry>,
    AutoCloseable {
        private final WALIterator walIter;
        private IgniteBiTuple<WALPointer, WALRecord> curRec;
        private DataEntry next;
        private int entryIdx;

        DataEntryIterator(WALIterator walIter) {
            this.walIter = walIter;
            this.advance();
        }

        T2<WALPointer, Integer> state() {
            return this.hasNext() ? new T2<WALPointer, Integer>(this.curRec.get1(), this.entryIdx) : new T2<WALPointer, Integer>(this.curRec.get1().next(), 0);
        }

        void init(int idx) {
            for (int i = 0; i < idx; ++i) {
                if (!this.hasNext()) {
                    throw new IgniteException("Failed to restore entry index [idx=" + idx + ", rec=" + this.curRec + ']');
                }
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public DataEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            DataEntry e = this.next;
            this.next = null;
            this.advance();
            return e;
        }

        private void advance() {
            if (this.curRec != null) {
                ++this.entryIdx;
                DataRecord rec = (DataRecord)this.curRec.get2();
                if (this.entryIdx < rec.entryCount()) {
                    this.next = rec.get(this.entryIdx);
                    return;
                }
                this.entryIdx = 0;
            }
            if (!this.walIter.hasNext()) {
                return;
            }
            this.curRec = (IgniteBiTuple)this.walIter.next();
            this.next = ((DataRecord)this.curRec.get2()).get(this.entryIdx);
        }

        @Override
        public void close() throws IgniteCheckedException {
            this.walIter.close();
        }
    }
}

