/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.cache.store.cassandra.datasource;

/**
 * Simple implementation of {@link Credentials} which just uses its constructor to hold user/password values.
 */
public class PlainCredentials implements Credentials {
    /** */
    private static final long serialVersionUID = 0L;

    /** User name. */
    private String user;

    /** User password. */
    private String pwd;

    /**
     * Creates credentials object.
     *
     * @param user User name.
     * @param pwd User password.
     */
    public PlainCredentials(String user, String pwd) {
        this.user = user;
        this.pwd = pwd;
    }

    /** {@inheritDoc} */
    @Override public String getUser() {
        return user;
    }

    /** {@inheritDoc} */
    @Override public String getPassword() {
        return pwd;
    }
}
