/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.consistency;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.ReadRepairStrategy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheConsistencyViolationEvent;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteIrreparableConsistencyViolationException;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.consistency.AbstractConsistencyTask;
import org.apache.ignite.internal.visor.consistency.VisorConsistencyRepairTaskArg;
import org.apache.ignite.internal.visor.consistency.VisorConsistencyStatusTask;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.LoggerResource;

public class VisorConsistencyRepairTask
extends AbstractConsistencyTask<VisorConsistencyRepairTaskArg, String> {
    private static final long serialVersionUID = 0L;
    public static final String NOTHING_FOUND = "Consistency violations were NOT found";
    public static final String CONSISTENCY_VIOLATIONS_FOUND = "Consistency violations were FOUND";
    public static final String CONSISTENCY_VIOLATIONS_RECORDED = "Cache consistency violations recorded.";

    @Override
    protected VisorJob<VisorConsistencyRepairTaskArg, String> job(VisorConsistencyRepairTaskArg arg) {
        return new VisorConsistencyRepairJob(arg, this.debug);
    }

    private static class VisorConsistencyRepairJob
    extends VisorJob<VisorConsistencyRepairTaskArg, String> {
        private static final long serialVersionUID = 0L;
        @LoggerResource
        protected IgniteLogger log;
        private final Set<CacheConsistencyViolationEvent> evts = new GridConcurrentHashSet<CacheConsistencyViolationEvent>();

        protected VisorConsistencyRepairJob(VisorConsistencyRepairTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String run(VisorConsistencyRepairTaskArg arg) throws IgniteException {
            String cacheName = arg.cacheName();
            ReadRepairStrategy strategy = arg.strategy();
            int p = arg.part();
            int batchSize = 1024;
            int statusDelay = 60000;
            IgniteInternalCache internalCache = this.ignite.context().cache().cache(cacheName);
            if (internalCache == null) {
                if (this.ignite.context().cache().cacheDescriptor(cacheName) != null) {
                    return null;
                }
                throw new IgniteException("Cache not found [name=" + cacheName + "]");
            }
            GridCacheContext cctx = internalCache.context();
            if (!cctx.gridEvents().isRecordable(135)) {
                throw new UnsupportedOperationException("Consistency violation events recording is disabled on cluster.");
            }
            CacheGroupContext grpCtx = cctx.group();
            GridDhtLocalPartition part = grpCtx.topology().localPartition(p);
            if (part == null) {
                return null;
            }
            this.log.info("Consistency check started [grp=" + grpCtx.cacheOrGroupName() + ", part=" + p + ", strategy=" + (Object)((Object)strategy) + "]");
            StringBuilder sb = new StringBuilder();
            sb.append("[node=").append(this.ignite.localNode());
            sb.append(", cacheGroup=").append(grpCtx.cacheOrGroupName());
            sb.append(", part=").append(p).append("]");
            String statusKey = sb.toString();
            if (VisorConsistencyStatusTask.MAP.putIfAbsent(statusKey, "0/" + part.fullSize()) != null) {
                throw new IllegalStateException("Consistency check already started [grp=" + grpCtx.cacheOrGroupName() + ", part=" + p + "]");
            }
            long cnt = 0L;
            long statusTs = 0L;
            part.reserve();
            try {
                CacheConsistencyViolationEventListener lsnr = new CacheConsistencyViolationEventListener(cacheName);
                this.ignite.events().localListen(lsnr, 135);
                try {
                    HashSet<KeyCacheObject> keys = new HashSet<KeyCacheObject>();
                    GridCursor<? extends CacheDataRow> cursor = grpCtx.offheap().dataStore(part).cursor(cctx.cacheId());
                    IgniteCache cache = this.ignite.cache(cacheName).withKeepBinary().withReadRepair(strategy);
                    do {
                        block20: {
                            keys.clear();
                            for (int i = 0; i < batchSize && cursor.next(); ++i) {
                                CacheDataRow row = cursor.get();
                                keys.add(row.key());
                            }
                            if (keys.isEmpty()) {
                                this.log.info("Consistency check finished [grp=" + grpCtx.cacheOrGroupName() + ", part=" + p + ", checked=" + cnt + "]");
                                break;
                            }
                            try {
                                cache.getAll(keys);
                            }
                            catch (CacheException e) {
                                if (e.getCause() instanceof IgniteIrreparableConsistencyViolationException || this.isCancelled()) break block20;
                                throw new IgniteException("Read repair attempt failed.", e);
                            }
                        }
                        cnt += (long)keys.size();
                        if (System.currentTimeMillis() < statusTs) continue;
                        statusTs = System.currentTimeMillis() + (long)statusDelay;
                        this.log.info("Consistency check progress [grp=" + grpCtx.cacheOrGroupName() + ", part=" + p + ", checked=" + cnt + "/" + part.fullSize() + "]");
                        VisorConsistencyStatusTask.MAP.put(statusKey, cnt + "/" + part.fullSize());
                    } while (!this.isCancelled());
                }
                finally {
                    this.ignite.events().stopLocalListen(lsnr, new int[0]);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Partition repair attempt failed.", e);
            }
            finally {
                part.release();
                VisorConsistencyStatusTask.MAP.remove(statusKey);
            }
            if (!this.evts.isEmpty()) {
                return this.processEvents(p, cnt);
            }
            return "Consistency violations were NOT found [processed=" + cnt + "]\n";
        }

        private String processEvents(int part, long cnt) {
            int found = 0;
            int fixed = 0;
            StringBuilder sb = new StringBuilder();
            for (CacheConsistencyViolationEvent evt : this.evts) {
                for (Map.Entry<Object, CacheConsistencyViolationEvent.EntriesInfo> entry : evt.getEntries().entrySet()) {
                    Object key = entry.getKey();
                    if (entry.getValue().partition() != part) continue;
                    ++found;
                    sb.append("Key: ").append(key).append(" (cache: ").append(evt.getCacheName()).append(", partition: ").append(entry.getValue().partition()).append(", strategy: ").append((Object)evt.getStrategy()).append(")").append("\n");
                    if (evt.getFixedEntries().containsKey(key)) {
                        sb.append(" Fixed: ").append(evt.getFixedEntries().get(key)).append("\n");
                    }
                    for (Map.Entry<ClusterNode, CacheConsistencyViolationEvent.EntryInfo> mapping : entry.getValue().getMapping().entrySet()) {
                        ClusterNode node = mapping.getKey();
                        CacheConsistencyViolationEvent.EntryInfo info = mapping.getValue();
                        sb.append("  Node: ").append(node).append("\n").append("    Value: ").append(info.getValue()).append("\n").append("    Version: ").append(info.getVersion()).append("\n").append("    On primary: ").append(info.isPrimary()).append("\n");
                        if (info.getVersion() != null) {
                            sb.append("    Other cluster version: ").append(info.getVersion().otherClusterVersion()).append("\n");
                        }
                        if (!info.isCorrect()) continue;
                        sb.append("    Considered as a CORRECT value!").append("\n");
                    }
                    if (!evt.getFixedEntries().containsKey(key)) continue;
                    ++fixed;
                }
            }
            String res = sb.toString();
            if (!res.isEmpty()) {
                this.log.warning("Cache consistency violations recorded.\n" + res);
                return "Consistency violations were FOUND [found=" + found + ", fixed=" + fixed + ", processed=" + cnt + "]";
            }
            return "Consistency violations were NOT found [processed=" + cnt + "]\n";
        }

        private class CacheConsistencyViolationEventListener
        implements IgnitePredicate<CacheConsistencyViolationEvent> {
            private static final long serialVersionUID = 0L;
            private final String cacheName;

            private CacheConsistencyViolationEventListener(String name) {
                this.cacheName = name;
            }

            @Override
            public boolean apply(CacheConsistencyViolationEvent evt) {
                assert (evt instanceof CacheConsistencyViolationEvent);
                if (!evt.getCacheName().equals(this.cacheName)) {
                    return true;
                }
                VisorConsistencyRepairJob.this.evts.add(evt);
                return true;
            }
        }
    }
}

