/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.IntMetricImpl;
import org.apache.ignite.internal.util.nio.GridNioException;
import org.apache.ignite.internal.util.nio.GridNioFilterAdapter;
import org.apache.ignite.internal.util.nio.GridNioFinishedFuture;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioFutureImpl;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.nio.ssl.GridNioSslHandler;
import org.apache.ignite.internal.util.nio.ssl.GridSslMeta;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class GridNioSslFilter
extends GridNioFilterAdapter {
    public static final int HANDSHAKE_FUT_META_KEY = GridNioSessionMetaKey.nextUniqueKey();
    public static final String SSL_HANDSHAKE_DURATION_HISTOGRAM_METRIC_NAME = "SslHandshakeDurationHistogram";
    public static final String SSL_REJECTED_SESSIONS_CNT_METRIC_NAME = "RejectedSslSessionsCount";
    private IgniteLogger log;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private String[] enabledCipherSuites;
    private String[] enabledProtos;
    private SSLContext sslCtx;
    private ByteOrder order;
    private boolean directBuf;
    private boolean directMode;
    @Nullable
    private final IntMetricImpl rejectedSesCnt;
    @Nullable
    private final HistogramMetricImpl handshakeDuration;

    public GridNioSslFilter(SSLContext sslCtx, boolean directBuf, ByteOrder order, IgniteLogger log, @Nullable MetricRegistry mreg) {
        super("SSL filter");
        this.log = log;
        this.sslCtx = sslCtx;
        this.directBuf = directBuf;
        this.order = order;
        this.handshakeDuration = mreg == null ? null : mreg.histogram(SSL_HANDSHAKE_DURATION_HISTOGRAM_METRIC_NAME, new long[]{250L, 500L, 1000L}, "SSL handshake duration in milliseconds.");
        this.rejectedSesCnt = mreg == null ? null : mreg.intMetric(SSL_REJECTED_SESSIONS_CNT_METRIC_NAME, "TCP sessions count that were rejected due to SSL errors.");
    }

    public void directMode(boolean directMode) {
        this.directMode = directMode;
    }

    public boolean directMode() {
        return this.directMode;
    }

    public void wantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public void needClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public void enabledCipherSuites(String ... enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public void enabledProtocols(String ... enabledProtos) {
        this.enabledProtos = enabledProtos;
    }

    @Override
    public void onSessionOpened(GridNioSession ses) throws IgniteCheckedException {
        boolean handshake;
        SSLEngine engine;
        GridSslMeta sslMeta;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remote client connected, creating SSL handler and performing initial handshake: " + ses);
        }
        if ((sslMeta = (GridSslMeta)ses.meta(GridNioSessionMetaKey.SSL_META.ordinal())) == null) {
            try {
                engine = this.sslCtx.createSSLEngine();
            }
            catch (IllegalArgumentException e) {
                throw new IgniteCheckedException("Failed connect to cluster. Check SSL configuration.", e);
            }
            boolean clientMode = !ses.accepted();
            engine.setUseClientMode(clientMode);
            if (!clientMode) {
                engine.setWantClientAuth(this.wantClientAuth);
                engine.setNeedClientAuth(this.needClientAuth);
            }
            if (this.enabledCipherSuites != null) {
                engine.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            if (this.enabledProtos != null) {
                engine.setEnabledProtocols(this.enabledProtos);
            }
            sslMeta = new GridSslMeta();
            sslMeta.sslEngine(engine);
            ses.addMeta(GridNioSessionMetaKey.SSL_META.ordinal(), sslMeta);
            handshake = true;
        } else {
            engine = sslMeta.sslEngine();
            assert (engine != null);
            handshake = false;
        }
        try {
            GridNioSslHandler hnd = new GridNioSslHandler(this, ses, engine, this.directBuf, this.order, this.log, handshake, sslMeta.encodedBuffer());
            sslMeta.handler(hnd);
            if (this.handshakeDuration != null) {
                GridNioFutureImpl fut = (GridNioFutureImpl)ses.meta(HANDSHAKE_FUT_META_KEY);
                if (fut == null) {
                    fut = new GridNioFutureImpl(null);
                    ses.addMeta(HANDSHAKE_FUT_META_KEY, fut);
                }
                long startTime = System.nanoTime();
                fut.listen(f -> this.handshakeDuration.value(U.nanosToMillis(System.nanoTime() - startTime)));
            }
            hnd.handshake();
            ByteBuffer alreadyDecoded = sslMeta.decodedBuffer();
            if (alreadyDecoded != null) {
                this.proceedMessageReceived(ses, alreadyDecoded);
            }
        }
        catch (SSLException e) {
            U.error(this.log, "Failed to start SSL handshake (will close inbound connection): " + ses, e);
            if (this.rejectedSesCnt != null) {
                this.rejectedSesCnt.increment();
            }
            ses.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSessionClosed(GridNioSession ses) throws IgniteCheckedException {
        try {
            GridNioFutureImpl fut = (GridNioFutureImpl)ses.removeMeta(HANDSHAKE_FUT_META_KEY);
            if (fut != null) {
                fut.onDone(new IgniteCheckedException("SSL handshake failed (connection closed)."));
            }
            if (ses.meta(GridNioSessionMetaKey.SSL_META.ordinal()) == null) {
                return;
            }
            GridNioSslHandler hnd = this.sslHandler(ses);
            hnd.shutdown();
        }
        finally {
            this.proceedSessionClosed(ses);
        }
    }

    @Override
    public void onExceptionCaught(GridNioSession ses, IgniteCheckedException ex) throws IgniteCheckedException {
        this.proceedExceptionCaught(ses, ex);
    }

    public boolean lock(GridNioSession ses) {
        GridNioSslHandler hnd = this.sslHandler(ses);
        hnd.lock();
        return hnd.isHandshakeFinished();
    }

    public void unlock(GridNioSession ses) {
        this.sslHandler(ses).unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer encrypt(GridNioSession ses, ByteBuffer input) throws SSLException {
        GridNioSslHandler hnd = this.sslHandler(ses);
        hnd.lock();
        try {
            assert (hnd.isHandshakeFinished());
            ByteBuffer byteBuffer = hnd.encrypt(input);
            return byteBuffer;
        }
        finally {
            hnd.unlock();
        }
    }

    @Override
    public GridNioFuture<?> onSessionWrite(GridNioSession ses, Object msg, boolean fut, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        if (this.directMode) {
            return this.proceedSessionWrite(ses, msg, fut, ackC);
        }
        ByteBuffer input = this.checkMessage(ses, msg);
        if (!input.hasRemaining()) {
            return new GridNioFinishedFuture(null);
        }
        GridNioSslHandler hnd = this.sslHandler(ses);
        hnd.lock();
        try {
            if (hnd.isOutboundDone()) {
                GridNioFinishedFuture gridNioFinishedFuture = new GridNioFinishedFuture(new IOException("Failed to send data (secure session was already closed): " + ses));
                return gridNioFinishedFuture;
            }
            if (hnd.isHandshakeFinished()) {
                hnd.encrypt(input);
                GridNioFuture<?> gridNioFuture = hnd.writeNetBuffer(ackC);
                return gridNioFuture;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Write request received during handshake, scheduling deferred write: " + ses);
            }
            GridNioFuture<?> gridNioFuture = hnd.deferredWrite(input, ackC);
            return gridNioFuture;
        }
        catch (SSLException e) {
            throw new GridNioException("Failed to encode SSL data: " + ses, e);
        }
        finally {
            hnd.unlock();
        }
    }

    @Override
    public void onMessageReceived(GridNioSession ses, Object msg) throws IgniteCheckedException {
        ByteBuffer input = this.checkMessage(ses, msg);
        GridNioSslHandler hnd = this.sslHandler(ses);
        hnd.lock();
        try {
            hnd.messageReceived(input);
            if (hnd.isHandshakeFinished()) {
                hnd.flushDeferredWrites();
            }
            ByteBuffer appBuf = hnd.getApplicationBuffer();
            appBuf.flip();
            if (appBuf.hasRemaining()) {
                this.proceedMessageReceived(ses, appBuf);
            }
            appBuf.compact();
            if (hnd.isInboundDone() && !hnd.isOutboundDone()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Remote peer closed secure session (will close connection): " + ses);
                }
                this.shutdownSession(ses, hnd);
            }
        }
        catch (SSLException e) {
            if (this.rejectedSesCnt != null) {
                this.rejectedSesCnt.increment();
            }
            throw new GridNioException("Failed to decode SSL data: " + ses, e);
        }
        finally {
            hnd.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridNioFuture<Boolean> onSessionClose(GridNioSession ses) throws IgniteCheckedException {
        GridNioSslHandler hnd = this.sslHandler(ses);
        hnd.lock();
        try {
            GridNioFuture<Boolean> gridNioFuture = this.shutdownSession(ses, hnd);
            return gridNioFuture;
        }
        finally {
            hnd.unlock();
        }
    }

    private GridNioFuture<Boolean> shutdownSession(GridNioSession ses, GridNioSslHandler hnd) throws IgniteCheckedException {
        try {
            hnd.closeOutbound();
            hnd.writeNetBuffer(null);
        }
        catch (SSLException e) {
            U.warn(this.log, "Failed to shutdown SSL session gracefully (will force close) [ex=" + e + ", ses=" + ses + ']');
        }
        return this.proceedSessionClose(ses);
    }

    @Override
    public void onSessionIdleTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionIdleTimeout(ses);
    }

    @Override
    public void onSessionWriteTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionWriteTimeout(ses);
    }

    private GridNioSslHandler sslHandler(GridNioSession ses) {
        GridSslMeta sslMeta = (GridSslMeta)ses.meta(GridNioSessionMetaKey.SSL_META.ordinal());
        assert (sslMeta != null);
        GridNioSslHandler hnd = sslMeta.handler();
        if (hnd == null) {
            throw new IgniteException("Failed to process incoming message (received message before SSL handler was created): " + ses);
        }
        return hnd;
    }

    private ByteBuffer checkMessage(GridNioSession ses, Object msg) throws GridNioException {
        if (!(msg instanceof ByteBuffer)) {
            throw new GridNioException("Invalid object type received (is SSL filter correctly placed in filter chain?) [ses=" + ses + ", msgClass=" + msg.getClass().getName() + ']');
        }
        return (ByteBuffer)msg;
    }
}

