/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.SqlListenerUtils;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolVersionFeature;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryNextPageRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheSqlFieldsQueryRequest;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheSqlQueryRequest;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxAwareRequest;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxContext;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityException;

public class ClientRequestHandler
implements ClientListenerRequestHandler {
    private final ClientConnectionContext ctx;
    private ClientProtocolContext protocolCtx;
    private final IgniteLogger log;

    ClientRequestHandler(ClientConnectionContext ctx, ClientProtocolContext protocolCtx) {
        assert (ctx != null);
        this.ctx = ctx;
        this.protocolCtx = protocolCtx;
        this.log = ctx.kernalContext().log(this.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClientListenerResponse handle(ClientListenerRequest req) {
        try {
            if (!(req instanceof ClientTxAwareRequest)) return ((ClientRequest)req).process(this.ctx);
            ClientTxAwareRequest req0 = (ClientTxAwareRequest)((Object)req);
            if (!req0.isTransactional()) return ((ClientRequest)req).process(this.ctx);
            int txId = req0.txId();
            ClientTxContext txCtx = this.ctx.txContext(txId);
            if (txCtx == null) return ((ClientRequest)req).process(this.ctx);
            try {
                txCtx.acquire(true);
                ClientResponse clientResponse = ((ClientRequest)req).process(this.ctx);
                return clientResponse;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteClientException(1, e.getMessage(), e);
            }
            finally {
                try {
                    txCtx.release(true);
                }
                catch (Exception e) {
                    this.log.warning("Failed to release client transaction context", e);
                }
            }
        }
        catch (SecurityException ex) {
            throw new IgniteClientException(1012, "Client is not authorized to perform this operation", ex);
        }
    }

    @Override
    public ClientListenerResponse handleException(Throwable e, ClientListenerRequest req) {
        assert (req != null);
        assert (e != null);
        int status = this.getStatus(e);
        String msg = e.getMessage();
        if (req instanceof ClientCacheSqlQueryRequest || req instanceof ClientCacheSqlFieldsQueryRequest || req instanceof ClientCacheQueryNextPageRequest) {
            String sqlState = IgniteQueryErrorCode.codeToSqlState(SqlListenerUtils.exceptionToSqlErrorCode(e));
            msg = sqlState + ": " + msg;
        }
        if (this.ctx.kernalContext().sqlListener().sendServerExceptionStackTraceToClient()) {
            msg = msg + U.nl() + X.getFullStackTrace(e);
        }
        return new ClientResponse(req.requestId(), status, msg);
    }

    @Override
    public void writeHandshake(BinaryWriterExImpl writer) {
        writer.writeBoolean(true);
        if (this.protocolCtx.isFeatureSupported(ClientProtocolVersionFeature.BITMAP_FEATURES)) {
            writer.writeByteArray(this.protocolCtx.featureBytes());
        }
        if (this.protocolCtx.isFeatureSupported(ClientProtocolVersionFeature.PARTITION_AWARENESS)) {
            writer.writeUuid(this.ctx.kernalContext().localNodeId());
        }
    }

    @Override
    public boolean isCancellationCommand(int cmdId) {
        return false;
    }

    @Override
    public boolean isCancellationSupported() {
        return false;
    }

    @Override
    public void registerRequest(long reqId, int cmdType) {
    }

    @Override
    public void unregisterRequest(long reqId) {
    }

    @Override
    public ClientListenerProtocolVersion protocolVersion() {
        return this.protocolCtx.version();
    }

    private int getStatus(Throwable e) {
        IllegalStateException ex;
        if (e instanceof IgniteClientException) {
            return ((IgniteClientException)e).statusCode();
        }
        if (e instanceof IgniteIllegalStateException && (ex = (IgniteIllegalStateException)e).getMessage().startsWith("Grid is in invalid state")) {
            return 10;
        }
        if (e instanceof IllegalStateException && (ex = (IllegalStateException)e).getMessage().contains("grid is stopping")) {
            return 10;
        }
        return 1;
    }
}

