/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.File;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.UnzipFileIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.AbstractWalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.Nullable;

public class FileDescriptor
implements Comparable<FileDescriptor>,
AbstractWalRecordsIterator.AbstractFileDescriptor {
    private static final String WAL_SEGMENT_FILE_EXT = ".wal";
    private static final int WAL_SEGMENT_FILE_NAME_LENGTH = 16;
    protected final File file;
    protected final long idx;

    public FileDescriptor(File file) {
        this(file, null);
    }

    public FileDescriptor(File file, @Nullable Long idx) {
        this.file = file;
        String fileName = file.getName();
        assert (fileName.contains(WAL_SEGMENT_FILE_EXT));
        this.idx = idx == null ? Long.parseLong(fileName.substring(0, 16)) : idx;
    }

    public static String fileName(long idx) {
        SB b = new SB();
        String segmentStr = Long.toString(idx);
        for (int i = segmentStr.length(); i < 16; ++i) {
            b.a('0');
        }
        b.a(segmentStr).a(WAL_SEGMENT_FILE_EXT);
        return b.toString();
    }

    @Override
    public int compareTo(FileDescriptor o) {
        return Long.compare(this.idx, o.idx);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileDescriptor)) {
            return false;
        }
        FileDescriptor that = (FileDescriptor)o;
        return this.idx == that.idx;
    }

    public int hashCode() {
        return (int)(this.idx ^ this.idx >>> 32);
    }

    public long getIdx() {
        return this.idx;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean isCompressed() {
        return this.file.getName().endsWith(".zip");
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public long idx() {
        return this.idx;
    }

    @Override
    public SegmentIO toReadOnlyIO(FileIOFactory fileIOFactory) throws IOException {
        UnzipFileIO fileIO = this.isCompressed() ? new UnzipFileIO(this.file()) : fileIOFactory.create(this.file(), StandardOpenOption.READ);
        return new SegmentIO(this.idx, fileIO);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [file=" + (this.file == null ? null : this.file.getAbsolutePath()) + ", idx=" + this.idx + ']';
    }
}

