/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.IntervalBasedMeasurement;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.ProgressSpeedCalculation;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.lang.IgniteOutClosure;
import org.jetbrains.annotations.NotNull;

class SpeedBasedMemoryConsumptionThrottlingStrategy {
    private static final double MAX_DIRTY_PAGES = 0.75;
    private static final double MIN_RATIO_NO_THROTTLE = 0.03;
    private final PageMemoryImpl pageMemory;
    private final IgniteOutClosure<CheckpointProgress> cpProgress;
    private final long totalPages;
    private volatile long speedForMarkAll;
    private volatile double targetDirtyRatio;
    private volatile double currDirtyRatio;
    private final Set<Long> threadIds = new GridConcurrentHashSet<Long>();
    private final AtomicInteger lastObservedWritten = new AtomicInteger(0);
    private volatile double initDirtyRatioAtCpBegin = 0.03;
    private final ProgressSpeedCalculation cpWriteSpeed = new ProgressSpeedCalculation();
    private final IntervalBasedMeasurement markSpeedAndAvgParkTime;

    SpeedBasedMemoryConsumptionThrottlingStrategy(PageMemoryImpl pageMemory, IgniteOutClosure<CheckpointProgress> cpProgress, IntervalBasedMeasurement markSpeedAndAvgParkTime) {
        this.pageMemory = pageMemory;
        this.cpProgress = cpProgress;
        this.markSpeedAndAvgParkTime = markSpeedAndAvgParkTime;
        this.totalPages = pageMemory.totalPages();
    }

    long protectionParkTime(long curNanoTime) {
        boolean checkpointProgressIsNotYetReported;
        CheckpointProgress progress = this.cpProgress.apply();
        AtomicInteger writtenPagesCounter = progress == null ? null : progress.writtenPagesCounter();
        boolean bl = checkpointProgressIsNotYetReported = writtenPagesCounter == null;
        if (checkpointProgressIsNotYetReported) {
            this.resetStatistics();
            return Long.MIN_VALUE;
        }
        this.threadIds.add(Thread.currentThread().getId());
        return this.computeParkTime(writtenPagesCounter, curNanoTime);
    }

    private void resetStatistics() {
        this.speedForMarkAll = 0L;
        this.targetDirtyRatio = -1.0;
        this.currDirtyRatio = -1.0;
    }

    private long computeParkTime(@NotNull AtomicInteger writtenPagesCounter, long curNanoTime) {
        int cpWrittenPages = writtenPagesCounter.get();
        long donePages = this.cpDonePagesEstimation(cpWrittenPages);
        long markDirtySpeed = this.markSpeedAndAvgParkTime.getSpeedOpsPerSec(curNanoTime);
        this.cpWriteSpeed.setProgress(donePages, curNanoTime);
        long curCpWriteSpeed = this.cpWriteSpeed.getOpsPerSecond(curNanoTime);
        int cpTotalPages = this.cpTotalPages();
        if (cpTotalPages == 0) {
            return this.parkTimeToThrottleByJustCPSpeed(markDirtySpeed, curCpWriteSpeed);
        }
        return this.speedBasedParkTime(cpWrittenPages, donePages, markDirtySpeed, curCpWriteSpeed, cpTotalPages);
    }

    private int cpDonePagesEstimation(int cpWrittenPages) {
        return (cpWrittenPages + this.cpSyncedPages()) / 2;
    }

    private long parkTimeToThrottleByJustCPSpeed(long markDirtySpeed, long curCpWriteSpeed) {
        boolean throttleByCpSpeed;
        boolean bl = throttleByCpSpeed = curCpWriteSpeed > 0L && markDirtySpeed > curCpWriteSpeed;
        if (throttleByCpSpeed) {
            return this.calcDelayTime(curCpWriteSpeed);
        }
        return 0L;
    }

    private long speedBasedParkTime(int cpWrittenPages, long donePages, long markDirtySpeed, long curCpWriteSpeed, int cpTotalPages) {
        double dirtyPagesRatio;
        this.currDirtyRatio = dirtyPagesRatio = this.pageMemory.getDirtyPagesRatio();
        this.detectCpPagesWriteStart(cpWrittenPages, dirtyPagesRatio);
        if (dirtyPagesRatio >= 0.75) {
            return 0L;
        }
        return this.getParkTime(dirtyPagesRatio, donePages, this.notEvictedPagesTotal(cpTotalPages), this.threadIdsCount(), markDirtySpeed, curCpWriteSpeed);
    }

    private int notEvictedPagesTotal(int cpTotalPages) {
        return Math.max(cpTotalPages - this.cpEvictedPages(), 0);
    }

    long getParkTime(double dirtyPagesRatio, long donePages, int cpTotalPages, int nThreads, long markDirtySpeed, long curCpWriteSpeed) {
        long targetSpeedToMarkAll = this.calcSpeedToMarkAllSpaceTillEndOfCp(dirtyPagesRatio, donePages, curCpWriteSpeed, cpTotalPages);
        double targetCurrentDirtyRatio = this.targetCurrentDirtyRatio(donePages, cpTotalPages);
        this.updateSpeedAndRatio(targetSpeedToMarkAll, targetCurrentDirtyRatio);
        long delayByCpWrite = this.delayIfMarkingFasterThanCPWriteSpeedAllows(markDirtySpeed, curCpWriteSpeed, dirtyPagesRatio, nThreads, targetSpeedToMarkAll, targetCurrentDirtyRatio);
        long delayByMarkAllWrite = this.delayIfMarkingFasterThanTargetSpeedAllows(markDirtySpeed, dirtyPagesRatio, nThreads, targetSpeedToMarkAll, targetCurrentDirtyRatio);
        return Math.max(delayByCpWrite, delayByMarkAllWrite);
    }

    private long delayIfMarkingFasterThanCPWriteSpeedAllows(long markDirtySpeed, long curCpWriteSpeed, double dirtyPagesRatio, int nThreads, long targetSpeedToMarkAll, double targetCurrentDirtyRatio) {
        boolean throttleByCpSpeed;
        double allowedCpWriteSpeedExcessMultiplier = this.allowedCpWriteSpeedExcessMultiplier(markDirtySpeed, dirtyPagesRatio, targetSpeedToMarkAll, targetCurrentDirtyRatio);
        boolean bl = throttleByCpSpeed = curCpWriteSpeed > 0L && (double)markDirtySpeed > allowedCpWriteSpeedExcessMultiplier * (double)curCpWriteSpeed;
        if (!throttleByCpSpeed) {
            return 0L;
        }
        int slowdown = this.slowdownIfLowSpaceLeft(dirtyPagesRatio, targetCurrentDirtyRatio);
        long nanosecsToMarkOnePage = TimeUnit.SECONDS.toNanos(1L) * (long)nThreads / markDirtySpeed;
        long nanosecsToWriteOneCPPage = this.calcDelayTime(curCpWriteSpeed, nThreads, slowdown);
        return nanosecsToWriteOneCPPage - nanosecsToMarkOnePage;
    }

    private double allowedCpWriteSpeedExcessMultiplier(long markDirtySpeed, double dirtyPagesRatio, long targetSpeedToMarkAll, double targetCurrentDirtyRatio) {
        boolean lowSpaceLeft = this.lowCleanSpaceLeft(dirtyPagesRatio, targetCurrentDirtyRatio);
        double allowWriteFasterThanCp = markDirtySpeed > 0L && markDirtySpeed < targetSpeedToMarkAll ? 0.1 * (double)targetSpeedToMarkAll / (double)markDirtySpeed : (dirtyPagesRatio > targetCurrentDirtyRatio ? 0.0 : 0.1);
        return lowSpaceLeft ? 1.0 : 1.0 + allowWriteFasterThanCp;
    }

    private int slowdownIfLowSpaceLeft(double dirtyPagesRatio, double targetCurrentDirtyRatio) {
        boolean lowSpaceLeft = this.lowCleanSpaceLeft(dirtyPagesRatio, targetCurrentDirtyRatio);
        return this.slowdownIfLowSpaceLeft(lowSpaceLeft);
    }

    private int slowdownIfLowSpaceLeft(boolean lowSpaceLeft) {
        return lowSpaceLeft ? 3 : 1;
    }

    private long delayIfMarkingFasterThanTargetSpeedAllows(long markDirtySpeed, double dirtyPagesRatio, int nThreads, long targetSpeedToMarkAll, double targetCurrentDirtyRatio) {
        boolean lowSpaceLeft = this.lowCleanSpaceLeft(dirtyPagesRatio, targetCurrentDirtyRatio);
        int slowdown = this.slowdownIfLowSpaceLeft(lowSpaceLeft);
        double multiplierForSpeedToMarkAll = lowSpaceLeft ? 0.8 : 1.0;
        boolean markingTooFastNow = targetSpeedToMarkAll > 0L && (double)markDirtySpeed > multiplierForSpeedToMarkAll * (double)targetSpeedToMarkAll;
        boolean markedTooFastSinceCPStart = dirtyPagesRatio > targetCurrentDirtyRatio;
        boolean markingTooFast = markedTooFastSinceCPStart && markingTooFastNow;
        return markingTooFast ? this.calcDelayTime(targetSpeedToMarkAll, nThreads, slowdown) : 0L;
    }

    private boolean lowCleanSpaceLeft(double dirtyPagesRatio, double targetDirtyRatio) {
        return dirtyPagesRatio > targetDirtyRatio && dirtyPagesRatio + 0.05 > 0.75;
    }

    private void updateSpeedAndRatio(long speedForMarkAll, double targetDirtyRatio) {
        this.speedForMarkAll = speedForMarkAll;
        this.targetDirtyRatio = targetDirtyRatio;
    }

    private long calcSpeedToMarkAllSpaceTillEndOfCp(double dirtyPagesRatio, long donePages, long curCpWriteSpeed, int cpTotalPages) {
        if (curCpWriteSpeed == 0L) {
            return 0L;
        }
        if (cpTotalPages <= 0) {
            return 0L;
        }
        if (dirtyPagesRatio >= 0.75) {
            return 0L;
        }
        double remainedClearPages = (0.75 - dirtyPagesRatio) * (double)this.totalPages;
        double secondsTillCPEnd = 1.0 * (double)((long)cpTotalPages - donePages) / (double)curCpWriteSpeed;
        return (long)(remainedClearPages / secondsTillCPEnd);
    }

    private double targetCurrentDirtyRatio(long donePages, int cpTotalPages) {
        double cpProgress = (double)donePages / (double)cpTotalPages;
        double constStart = this.initDirtyRatioAtCpBegin;
        double fractionToVaryDirtyRatio = 1.0 - constStart;
        return (cpProgress * fractionToVaryDirtyRatio + constStart) * 0.75;
    }

    public double getTargetDirtyRatio() {
        return this.targetDirtyRatio;
    }

    public double getCurrDirtyRatio() {
        double ratio = this.currDirtyRatio;
        if (ratio >= 0.0) {
            return ratio;
        }
        return this.pageMemory.getDirtyPagesRatio();
    }

    public long getLastEstimatedSpeedForMarkAll() {
        return this.speedForMarkAll;
    }

    public long getCpWriteSpeed() {
        return this.cpWriteSpeed.getOpsPerSecondReadOnly();
    }

    int threadIdsCount() {
        return this.threadIds.size();
    }

    int cpSyncedPages() {
        AtomicInteger syncedPagesCntr = this.cpProgress.apply().syncedPagesCounter();
        return syncedPagesCntr == null ? 0 : syncedPagesCntr.get();
    }

    int cpTotalPages() {
        return this.cpProgress.apply().currentCheckpointPagesCount();
    }

    int cpEvictedPages() {
        AtomicInteger evictedPagesCntr = this.cpProgress.apply().evictedPagesCounter();
        return evictedPagesCntr == null ? 0 : evictedPagesCntr.get();
    }

    long calcDelayTime(long baseSpeed) {
        return this.calcDelayTime(baseSpeed, this.threadIdsCount(), 1);
    }

    private long calcDelayTime(long baseSpeed, int nThreads, int factor) {
        if (factor <= 0) {
            throw new IllegalStateException("Coefficient should be positive");
        }
        if (baseSpeed <= 0L) {
            return 0L;
        }
        long updTimeNsForOnePage = TimeUnit.SECONDS.toNanos(1L) * (long)nThreads / baseSpeed;
        return (long)factor * updTimeNsForOnePage;
    }

    private void detectCpPagesWriteStart(int cpWrittenPages, double dirtyPagesRatio) {
        if (cpWrittenPages > 0 && this.lastObservedWritten.compareAndSet(0, cpWrittenPages)) {
            double newMinRatio = dirtyPagesRatio;
            if (newMinRatio < 0.03) {
                newMinRatio = 0.03;
            }
            if (newMinRatio > 1.0) {
                newMinRatio = 1.0;
            }
            this.initDirtyRatioAtCpBegin = newMinRatio;
        }
    }

    void reset() {
        this.cpWriteSpeed.setProgress(0L, System.nanoTime());
        this.initDirtyRatioAtCpBegin = 0.03;
        this.lastObservedWritten.set(0);
    }

    void finish() {
        this.cpWriteSpeed.closeInterval();
        this.threadIds.clear();
    }
}

