/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.expiry.EternalExpiryPolicy;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteDiagnosticAware;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteNeedReconnectException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.pagemem.wal.record.ExchangeRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignmentCache;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CachePartitionExchangeWorkerTask;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeFailureMessage;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.ExchangeContext;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.StateChangeRequest;
import org.apache.ignite.internal.processors.cache.WalStateAbstractMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CacheGroupAffinityMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionFullCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsAbstractMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionHistorySuppliersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtPartitionsToReloadMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.InitNewCoordinatorFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.SupplyPartitionInfo;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.latch.Latch;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridClientPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionsStateValidator;
import org.apache.ignite.internal.processors.cache.persistence.DatabaseLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.processors.tracing.NoopSpan;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanTags;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.TimeBag;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteRunnable;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionsExchangeFuture
extends GridDhtTopologyFutureAdapter
implements Comparable<GridDhtPartitionsExchangeFuture>,
CachePartitionExchangeWorkerTask,
IgniteDiagnosticAware {
    public static final String EXCHANGE_LOG = "org.apache.ignite.internal.exchange.time";
    public static final String PARTITION_STATE_FAILED_MSG = "Partition states validation has failed for group: %s, msg: %s";
    public static final int DFLT_PARTITION_RELEASE_FUTURE_DUMP_THRESHOLD = 0;
    private static final int RELEASE_FUTURE_DUMP_THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_PARTITION_RELEASE_FUTURE_DUMP_THRESHOLD", 0);
    private static final IgniteProductVersion FORCE_AFF_REASSIGNMENT_SINCE = IgniteProductVersion.fromString("2.4.3");
    private static final boolean SKIP_PARTITION_SIZE_VALIDATION = Boolean.getBoolean("IGNITE_SKIP_PARTITION_SIZE_VALIDATION");
    public static final String EXCHANGE_LATCH_ID = "exchange";
    private static final String EXCHANGE_FREE_LATCH_ID = "exchange-free";
    public static final int DFLT_LONG_OPERATIONS_DUMP_TIMEOUT_LIMIT = 1800000;
    @GridToStringExclude
    private final Object mux = new Object();
    @GridToStringExclude
    private volatile DiscoCache firstEvtDiscoCache;
    private volatile DiscoveryEvent firstDiscoEvt;
    @GridToStringExclude
    private final Set<UUID> remaining = new HashSet<UUID>();
    @GridToStringExclude
    private int pendingSingleUpdates;
    @GridToStringExclude
    private List<ClusterNode> srvNodes;
    private volatile ClusterNode crd;
    private final GridDhtPartitionExchangeId exchId;
    private final GridCacheSharedContext<?, ?> cctx;
    private ReadWriteLock busyLock;
    private AtomicBoolean added = new AtomicBoolean(false);
    private volatile ExchangeType exchangeType;
    @GridToStringExclude
    private final CountDownLatch evtLatch = new CountDownLatch(1);
    private GridFutureAdapter<Boolean> initFut;
    @GridToStringExclude
    private final List<IgniteRunnable> discoEvts = new ArrayList<IgniteRunnable>();
    private boolean init;
    private AtomicReference<GridCacheVersion> lastVer = new AtomicReference();
    @GridToStringExclude
    private GridDhtPartitionsSingleMessage pendingJoinMsg;
    private final Map<UUID, GridDhtPartitionsSingleMessage> pendingSingleMsgs = new ConcurrentHashMap<UUID, GridDhtPartitionsSingleMessage>();
    private final Map<ClusterNode, GridDhtPartitionsFullMessage> fullMsgs = new ConcurrentHashMap<ClusterNode, GridDhtPartitionsFullMessage>();
    @GridToStringInclude
    private volatile IgniteInternalFuture<?> partReleaseFut;
    private final IgniteLogger log;
    private ExchangeActions exchActions;
    @Nullable
    private final SecurityContext secCtx;
    private final IgniteLogger exchLog;
    private CacheAffinityChangeMessage affChangeMsg;
    private boolean centralizedAff;
    private boolean forceAffReassignment;
    private volatile Exception exchangeLocE;
    private final Map<UUID, Exception> exchangeGlobalExceptions = new ConcurrentHashMap<UUID, Exception>();
    private volatile boolean cacheChangeFailureMsgSent;
    private ConcurrentMap<UUID, GridDhtPartitionsSingleMessage> msgs = new ConcurrentHashMap<UUID, GridDhtPartitionsSingleMessage>();
    @GridToStringExclude
    private Map<UUID, GridDhtPartitionsSingleMessage> mergedJoinExchMsgs;
    @GridToStringExclude
    private int awaitMergedMsgs;
    @GridToStringExclude
    private final IgniteDhtPartitionHistorySuppliersMap partHistSuppliers = new IgniteDhtPartitionHistorySuppliersMap();
    private final Set<UUID> exclusionsFromHistoricalRebalance = ConcurrentHashMap.newKeySet();
    private final Map<T2<Integer, UUID>, Set<Integer>> exclusionsFromFullRebalance = new ConcurrentHashMap<T2<Integer, UUID>, Set<Integer>>();
    private volatile Map<Integer, Map<Integer, Long>> partHistReserved;
    @GridToStringExclude
    private final IgniteDhtPartitionsToReloadMap partsToReload = new IgniteDhtPartitionsToReloadMap();
    private final AtomicBoolean done = new AtomicBoolean();
    private ExchangeLocalState state;
    @GridToStringExclude
    private ExchangeContext exchCtx;
    @GridToStringExclude
    private FinishState finishState;
    @GridToStringExclude
    private InitNewCoordinatorFuture newCrdFut;
    @GridToStringExclude
    private GridDhtPartitionsExchangeFuture mergedWith;
    @GridToStringExclude
    private final GridDhtPartitionsStateValidator validator;
    private IgniteInternalFuture<?> registerCachesFuture;
    @GridToStringExclude
    private GridDhtPartitionsFullMessage delayedLatestMsg;
    @GridToStringExclude
    private final GridFutureAdapter<?> afterLsnrCompleteFut = new GridFutureAdapter();
    @GridToStringExclude
    private final TimeBag timeBag;
    private long startTime = System.currentTimeMillis();
    private volatile long initTime;
    private T2<Long, UUID> discoveryLag;
    private Map<Integer, Set<Integer>> clearingPartitions;
    private volatile boolean rebalanced;
    private volatile boolean affinityReassign;
    private Span span = NoopSpan.INSTANCE;

    public GridDhtPartitionsExchangeFuture(GridCacheSharedContext cctx, ReadWriteLock busyLock, GridDhtPartitionExchangeId exchId, ExchangeActions exchActions, CacheAffinityChangeMessage affChangeMsg) {
        assert (busyLock != null);
        assert (exchId != null);
        assert (exchId.topologyVersion() != null);
        assert (exchActions == null || !exchActions.empty());
        this.cctx = cctx;
        this.busyLock = busyLock;
        this.exchId = exchId;
        this.exchActions = exchActions;
        this.affChangeMsg = affChangeMsg;
        this.validator = new GridDhtPartitionsStateValidator(cctx);
        if (exchActions != null && exchActions.deactivate()) {
            this.clusterIsActive = false;
        }
        this.log = cctx.logger(this.getClass());
        this.exchLog = cctx.logger(EXCHANGE_LOG);
        this.secCtx = SecurityUtils.remoteSecurityContext(cctx.kernalContext());
        this.timeBag = new TimeBag(this.log.isInfoEnabled());
        this.initFut = new GridFutureAdapter<Boolean>(){

            @Override
            public IgniteLogger logger() {
                return GridDhtPartitionsExchangeFuture.this.log;
            }
        };
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating exchange future [localNode=" + cctx.localNodeId() + ", fut=" + this + ']');
        }
    }

    public void span(Span span) {
        this.span = span;
    }

    public Span span() {
        return this.span;
    }

    public Object mutex() {
        return this.mux;
    }

    public GridCacheSharedContext sharedContext() {
        return this.cctx;
    }

    @Override
    public boolean skipForExchangeMerge() {
        return false;
    }

    @Override
    @Nullable
    public SecurityContext securityContext() {
        return this.secCtx;
    }

    public ExchangeContext context() {
        assert (this.exchCtx != null) : this;
        return this.exchCtx;
    }

    public void exchangeActions(ExchangeActions exchActions) {
        assert (exchActions == null || !exchActions.empty()) : exchActions;
        assert (this.evtLatch != null && this.evtLatch.getCount() == 1L) : this;
        this.exchActions = exchActions;
    }

    @Nullable
    public ExchangeActions exchangeActions() {
        return this.exchActions;
    }

    public void affinityChangeMessage(CacheAffinityChangeMessage affChangeMsg) {
        this.affChangeMsg = affChangeMsg;
    }

    @Override
    public AffinityTopologyVersion initialVersion() {
        return this.exchId.topologyVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffinityTopologyVersion topologyVersion() {
        ExchangeContext exchCtx0;
        assert (this.exchangeDone()) : "Should not be called before exchange is finished";
        if (this.isDone()) {
            return (AffinityTopologyVersion)this.result();
        }
        Object object = this.mux;
        synchronized (object) {
            if (this.state == ExchangeLocalState.MERGED) {
                assert (this.mergedWith != null);
                exchCtx0 = this.mergedWith.exchCtx;
            } else {
                exchCtx0 = this.exchCtx;
            }
        }
        return exchCtx0.events().topologyVersion();
    }

    @Nullable
    public ExchangeType exchangeType() {
        return this.exchangeType;
    }

    public List<UUID> partitionHistorySupplier(int grpId, int partId, long cntrSince) {
        List<UUID> histSuppliers = this.partHistSuppliers.getSupplier(grpId, partId, cntrSince);
        histSuppliers.removeIf(this.exclusionsFromHistoricalRebalance::contains);
        return histSuppliers;
    }

    public void markNodeAsInapplicableForHistoricalRebalance(UUID nodeId) {
        this.exclusionsFromHistoricalRebalance.add(nodeId);
    }

    public void copyInapplicableNodesFrom(GridDhtPartitionsExchangeFuture fut) {
        fut.exclusionsFromFullRebalance.forEach((k, v) -> v.forEach(p -> this.markNodeAsInapplicableForFullRebalance((UUID)k.get2(), (Integer)k.get1(), (int)p)));
        fut.exclusionsFromHistoricalRebalance.forEach(this::markNodeAsInapplicableForHistoricalRebalance);
    }

    public void markNodeAsInapplicableForFullRebalance(UUID nodeId, int grpId, int p) {
        Set parts = this.exclusionsFromFullRebalance.computeIfAbsent(new T2<Integer, UUID>(grpId, nodeId), t2 -> ConcurrentHashMap.newKeySet());
        parts.add(p);
    }

    public boolean hasInapplicableNodesForHistoricalRebalance() {
        return !this.exclusionsFromHistoricalRebalance.isEmpty();
    }

    public boolean hasInapplicableNodesForFullRebalance() {
        return !this.exclusionsFromFullRebalance.isEmpty();
    }

    public boolean hasInapplicableNodesForRebalance() {
        return this.hasInapplicableNodesForHistoricalRebalance() || this.hasInapplicableNodesForFullRebalance();
    }

    public boolean isNodeApplicableForFullRebalance(UUID nodeId, int grpId, int p) {
        return Optional.ofNullable(this.exclusionsFromFullRebalance.get(new T2<Integer, UUID>(grpId, nodeId))).map(s -> !s.contains(p)).orElse(true);
    }

    public boolean cacheAddedOnExchange(int cacheId, UUID rcvdFrom) {
        return this.dynamicCacheStarted(cacheId) || this.exchCtx.events().nodeJoined(rcvdFrom);
    }

    public boolean cacheGroupAddedOnExchange(int grpId, UUID rcvdFrom) {
        return this.dynamicCacheGroupStarted(grpId) || this.exchCtx.events().nodeJoined(rcvdFrom);
    }

    private boolean dynamicCacheStarted(int cacheId) {
        return this.exchActions != null && this.exchActions.cacheStarted(cacheId);
    }

    public boolean dynamicCacheGroupStarted(int grpId) {
        return this.exchActions != null && this.exchActions.cacheGroupStarting(grpId);
    }

    public long currentPMEDuration(boolean blocked) {
        return this.isDone() || this.initTime == 0L || blocked && !this.changedAffinity() ? 0L : System.currentTimeMillis() - this.initTime;
    }

    public boolean onAdded() {
        return this.added.compareAndSet(false, true);
    }

    public void onEvent(GridDhtPartitionExchangeId exchId, DiscoveryEvent discoEvt, DiscoCache discoCache) {
        assert (exchId.equals(this.exchId));
        this.exchId.discoveryEvent(discoEvt);
        this.firstDiscoEvt = discoEvt;
        this.firstEvtDiscoCache = discoCache;
        this.evtLatch.countDown();
    }

    private boolean stateChangeExchange() {
        return this.exchActions != null && this.exchActions.stateChangeRequest() != null;
    }

    private boolean dynamicCacheStartExchange() {
        return this.exchActions != null && !this.exchActions.cacheStartRequests().isEmpty() && this.exchActions.cacheStopRequests().isEmpty();
    }

    public boolean resetLostPartitionFor(String cacheOrGroupName) {
        return this.exchActions != null && this.exchActions.cachesToResetLostPartitions().contains(cacheOrGroupName);
    }

    public boolean activateCluster() {
        return this.exchActions != null && this.exchActions.activate();
    }

    private boolean deactivateCluster() {
        return this.exchActions != null && this.exchActions.deactivate();
    }

    public boolean changedBaseline() {
        return this.exchActions != null && this.exchActions.changedBaseline();
    }

    @Override
    public boolean changedAffinity() {
        DiscoveryEvent firstDiscoEvt0 = this.firstDiscoEvt;
        assert (firstDiscoEvt0 != null);
        return firstDiscoEvt0.type() == 18 || !firstDiscoEvt0.eventNode().isClient() || firstDiscoEvt0.eventNode().isLocal() || this.firstDiscoEvt.type() == 10 && this.cctx.cache().hasCachesReceivedFromJoin(this.firstDiscoEvt.eventNode());
    }

    public boolean hasCachesToStart() {
        return this.exchActions != null && !this.exchActions.cacheStartRequests().isEmpty();
    }

    public DiscoveryEvent firstEvent() {
        return this.firstDiscoEvt;
    }

    public DiscoCache firstEventCache() {
        return this.firstEvtDiscoCache;
    }

    public ExchangeDiscoveryEvents events() {
        return this.exchCtx.events();
    }

    public GridDhtPartitionExchangeId exchangeId() {
        return this.exchId;
    }

    private boolean enterBusy() {
        if (this.busyLock.readLock().tryLock()) {
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Failed to enter busy state (exchanger is stopping): " + this);
        }
        return false;
    }

    private void leaveBusy() {
        this.busyLock.readLock().unlock();
    }

    private void initCoordinatorCaches(boolean newCrd) throws IgniteCheckedException {
        if (newCrd) {
            IgniteInternalFuture<?> fut = this.cctx.affinity().initCoordinatorCaches(this, false);
            if (fut != null) {
                fut.get();
                this.cctx.exchange().exchangerUpdateHeartbeat();
            }
            this.cctx.exchange().onCoordinatorInitialized();
            this.cctx.exchange().exchangerUpdateHeartbeat();
        }
    }

    public TimeBag timeBag() {
        return this.timeBag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(boolean newCrd) throws IgniteInterruptedCheckedException {
        block75: {
            if (this.isDone()) {
                return;
            }
            assert (!this.cctx.kernalContext().isDaemon());
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                U.await(this.evtLatch);
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
            assert (this.firstDiscoEvt != null) : this;
            assert (this.exchId.nodeId().equals(this.firstDiscoEvt.eventNode().id())) : this;
            try {
                ExchangeType exchange;
                AffinityTopologyVersion topVer = this.initialVersion();
                this.srvNodes = new ArrayList<ClusterNode>(this.firstEvtDiscoCache.serverNodes());
                this.remaining.addAll(F.nodeIds(F.view(this.srvNodes, F.remoteNodes(this.cctx.localNodeId()))));
                this.crd = this.srvNodes.isEmpty() ? null : this.srvNodes.get(0);
                boolean crdNode = this.crd != null && this.crd.isLocal();
                this.exchCtx = new ExchangeContext(this.cctx, crdNode, this);
                this.cctx.exchange().exchangerBlockingSectionBegin();
                assert (this.state == null) : this.state;
                this.state = crdNode ? ExchangeLocalState.CRD : (this.cctx.kernalContext().clientNode() ? ExchangeLocalState.CLIENT : ExchangeLocalState.SRV);
                this.initTime = System.currentTimeMillis();
                if (this.exchLog.isInfoEnabled()) {
                    this.exchLog.info("Started exchange init [topVer=" + topVer + ", crd=" + crdNode + ", evt=" + IgniteUtils.gridEventName(this.firstDiscoEvt.type()) + ", evtNode=" + this.firstDiscoEvt.eventNode().id() + ", customEvt=" + (this.firstDiscoEvt.type() == 18 ? ((DiscoveryCustomEvent)this.firstDiscoEvt).customMessage() : null) + ", allowMerge=" + this.exchCtx.mergeExchanges() + ", exchangeFreeSwitch=" + this.exchCtx.exchangeFreeSwitch() + ']');
                }
                this.span.addLog(() -> "Exchange parameters initialization");
                this.timeBag.finishGlobalStage("Exchange parameters initialization");
                if (this.exchCtx.exchangeFreeSwitch()) {
                    if (IgniteSnapshotManager.isSnapshotOperation(this.firstDiscoEvt)) {
                        if (this.wasRebalanced()) {
                            this.markRebalanced();
                        }
                        if (!this.forceAffReassignment) {
                            this.cctx.affinity().onCustomMessageNoAffinityChange(this, this.exchActions);
                        }
                        exchange = this.cctx.kernalContext().clientNode() ? ExchangeType.NONE : ExchangeType.ALL;
                    } else {
                        exchange = this.onExchangeFreeSwitchNodeLeft();
                    }
                    this.initCoordinatorCaches(newCrd);
                } else if (this.firstDiscoEvt.type() == 18) {
                    assert (!this.exchCtx.mergeExchanges());
                    DiscoveryCustomMessage msg = ((DiscoveryCustomEvent)this.firstDiscoEvt).customMessage();
                    boolean bl = this.forceAffReassignment = DiscoveryCustomEvent.requiresCentralizedAffinityAssignment(msg) && this.firstEventCache().minimumNodeVersion().compareToIgnoreTimestamp(FORCE_AFF_REASSIGNMENT_SINCE) >= 0;
                    if (msg instanceof ChangeGlobalStateMessage) {
                        assert (this.exchActions != null && !this.exchActions.empty());
                        exchange = this.onClusterStateChangeRequest(crdNode);
                    } else if (msg instanceof DynamicCacheChangeBatch) {
                        assert (this.exchActions != null && !this.exchActions.empty());
                        exchange = this.onCacheChangeRequest(crdNode);
                    } else if (msg instanceof SnapshotDiscoveryMessage) {
                        exchange = this.onCustomMessageNoAffinityChange();
                    } else if (msg instanceof WalStateAbstractMessage) {
                        exchange = this.onCustomMessageNoAffinityChange();
                    } else {
                        assert (this.affChangeMsg != null) : this;
                        exchange = this.onAffinityChangeRequest();
                    }
                    if (this.forceAffReassignment) {
                        this.cctx.affinity().onCentralizedAffinityChange(this, crdNode);
                    }
                    this.initCoordinatorCaches(newCrd);
                } else {
                    if (this.firstDiscoEvt.type() == 10) {
                        if (!this.firstDiscoEvt.eventNode().isLocal()) {
                            Collection<DynamicCacheDescriptor> receivedCaches = this.cctx.cache().startReceivedCaches(this.firstDiscoEvt.eventNode().id(), topVer);
                            this.registerCachesFuture = this.cctx.affinity().initStartedCaches(crdNode, this, receivedCaches);
                        } else {
                            this.registerCachesFuture = this.initCachesOnLocalJoin();
                        }
                    }
                    this.initCoordinatorCaches(newCrd);
                    if (this.exchCtx.mergeExchanges()) {
                        if (this.localJoinExchange()) {
                            if (this.cctx.kernalContext().clientNode()) {
                                this.onClientNodeEvent();
                                exchange = ExchangeType.CLIENT;
                            } else {
                                this.onServerNodeEvent(crdNode);
                                exchange = ExchangeType.ALL;
                            }
                        } else if (this.firstDiscoEvt.eventNode().isClient()) {
                            exchange = this.onClientNodeEvent();
                        } else {
                            ExchangeType exchangeType = exchange = this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                        }
                        if (this.exchId.isLeft()) {
                            this.onLeft();
                        }
                    } else {
                        exchange = this.firstDiscoEvt.eventNode().isClient() ? this.onClientNodeEvent() : this.onServerNodeEvent(crdNode);
                    }
                }
                this.cctx.cache().registrateProxyRestart(this.resolveCacheRequests(this.exchActions), this.afterLsnrCompleteFut);
                this.exchangeType = exchange;
                for (PartitionsExchangeAware comp : this.cctx.exchange().exchangeAwareComponents()) {
                    comp.onInitBeforeTopologyLock(this);
                }
                this.updateTopologies(crdNode);
                this.timeBag.finishGlobalStage("Determine exchange type");
                switch (exchange) {
                    case ALL: {
                        this.distributedExchange();
                        break;
                    }
                    case CLIENT: {
                        if (!this.exchCtx.mergeExchanges() && this.exchCtx.fetchAffinityOnJoin()) {
                            this.initTopologies();
                        }
                        this.clientOnlyExchange();
                        break;
                    }
                    case NONE: {
                        this.initTopologies();
                        Iterator<PartitionsExchangeAware> iterator = this.mux;
                        synchronized (iterator) {
                            this.state = ExchangeLocalState.DONE;
                        }
                        this.onDone(topVer);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.cctx.localNode().isClient()) {
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        this.tryToPerformLocalSnapshotOperation();
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                }
                for (PartitionsExchangeAware comp : this.cctx.exchange().exchangeAwareComponents()) {
                    comp.onInitAfterTopologyLock(this);
                }
                if (exchange == ExchangeType.ALL && this.context().exchangeFreeSwitch()) {
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        this.onDone(this.initialVersion());
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                }
                if (this.exchLog.isInfoEnabled()) {
                    this.exchLog.info("Finished exchange init [topVer=" + topVer + ", crd=" + crdNode + ']');
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                assert (this.cctx.kernalContext().isStopping() || this.cctx.kernalContext().clientDisconnected());
                if (this.cctx.kernalContext().clientDisconnected()) {
                    this.onDone(new IgniteCheckedException("Client disconnected"));
                } else {
                    this.onDone(new IgniteCheckedException("Node stopped"));
                }
                throw e;
            }
            catch (IgniteNeedReconnectException e) {
                this.onDone(e);
            }
            catch (Throwable e) {
                if (this.reconnectOnError(e)) {
                    this.onDone(new IgniteNeedReconnectException(this.cctx.localNode(), e));
                } else {
                    U.error(this.log, "Failed to reinitialize local partitions (rebalancing will be stopped): " + this.exchId, e);
                    this.onDone(e);
                }
                if (!(e instanceof Error)) break block75;
                throw (Error)e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IgniteInternalFuture<?> initCachesOnLocalJoin() throws IgniteCheckedException {
        if (!this.cctx.kernalContext().clientNode() && !this.isLocalNodeInBaseline()) {
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                List<DatabaseLifecycleListener> listeners = this.cctx.kernalContext().internalSubscriptionProcessor().getDatabaseListeners();
                for (DatabaseLifecycleListener lsnr : listeners) {
                    lsnr.onBaselineChange();
                }
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
            this.timeBag.finishGlobalStage("Baseline change callback");
        }
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            this.cctx.activate();
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
        this.timeBag.finishGlobalStage("Components activation");
        IgniteInternalFuture<?> cachesRegistrationFut = this.cctx.cache().startCachesOnLocalJoin(this.initialVersion(), this.exchActions == null ? null : this.exchActions.localJoinContext());
        if (!this.cctx.kernalContext().clientNode()) {
            this.cctx.cache().shutdownNotFinishedRecoveryCaches();
        }
        this.ensureClientCachesStarted();
        return cachesRegistrationFut;
    }

    private void ensureClientCachesStarted() {
        GridCacheProcessor cacheProcessor = this.cctx.cache();
        HashSet<String> cacheNames = new HashSet<String>(cacheProcessor.cacheNames());
        ArrayList<CacheConfiguration> notStartedCacheConfigs = new ArrayList<CacheConfiguration>();
        for (CacheConfiguration cCfg : this.cctx.gridConfig().getCacheConfiguration()) {
            if (cacheNames.contains(cCfg.getName()) || GridCacheUtils.isCacheTemplateName(cCfg.getName())) continue;
            notStartedCacheConfigs.add(cCfg);
        }
        if (!notStartedCacheConfigs.isEmpty()) {
            cacheProcessor.dynamicStartCaches(notStartedCacheConfigs, false, false, false);
        }
    }

    private boolean isLocalNodeInBaseline() {
        BaselineTopology topology = this.cctx.discovery().discoCache().state().baselineTopology();
        return topology != null && topology.consistentIds().contains(this.cctx.localNode().consistentId());
    }

    public boolean isBaselineNodeFailed() {
        BaselineTopology top = this.firstEvtDiscoCache.state().baselineTopology();
        return (this.firstDiscoEvt.type() == 11 || this.firstDiscoEvt.type() == 12) && !this.firstDiscoEvt.eventNode().isClient() && top != null && top.consistentIds().contains(this.firstDiscoEvt.eventNode().consistentId());
    }

    private void initTopologies() throws IgniteCheckedException {
        this.cctx.database().checkpointReadLock();
        try {
            if (this.crd != null) {
                for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                    if (grp.isLocal()) continue;
                    grp.topology().beforeExchange(this, !this.centralizedAff && !this.forceAffReassignment, false);
                    this.cctx.exchange().exchangerUpdateHeartbeat();
                }
            }
        }
        finally {
            this.cctx.database().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTopologies(boolean crd) throws IgniteCheckedException {
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            boolean updateTop;
            if (grp.isLocal()) continue;
            GridClientPartitionTopology clientTop = this.cctx.exchange().clearClientTopology(grp.groupId());
            long updSeq = clientTop == null ? -1L : clientTop.lastUpdateSequence();
            GridDhtPartitionTopology top = grp.topology();
            if (crd && (updateTop = this.exchId.topologyVersion().equals(grp.localStartVersion())) && clientTop != null) {
                this.cctx.exchange().exchangerBlockingSectionBegin();
                try {
                    top.update(null, clientTop.partitionMap(true), clientTop.fullUpdateCounters(), Collections.emptySet(), null, null, null, clientTop.lostPartitions());
                }
                finally {
                    this.cctx.exchange().exchangerBlockingSectionEnd();
                }
            }
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                top.updateTopologyVersion(this, this.events().discoveryCache(), updSeq, this.cacheGroupStopping(grp.groupId()));
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            for (GridClientPartitionTopology top : this.cctx.exchange().clientTopologies()) {
                top.updateTopologyVersion(this, this.events().discoveryCache(), -1L, this.cacheGroupStopping(top.groupId()));
            }
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExchangeType onClusterStateChangeRequest(boolean crd) {
        assert (this.exchActions != null && !this.exchActions.empty()) : this;
        StateChangeRequest req = this.exchActions.stateChangeRequest();
        assert (req != null) : this.exchActions;
        GridKernalContext kctx = this.cctx.kernalContext();
        DiscoveryDataClusterState state = kctx.state().clusterState();
        if (state.transitionError() != null) {
            this.exchangeLocE = state.transitionError();
        }
        if (req.activeChanged()) {
            if (req.state().active()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Start activation process [nodeId=" + this.cctx.localNodeId() + ", client=" + kctx.clientNode() + ", topVer=" + this.initialVersion() + "]. New state: " + (Object)((Object)req.state()));
                }
                try {
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        this.cctx.activate();
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                    assert (this.registerCachesFuture == null) : "No caches registration should be scheduled before new caches have started.";
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        this.registerCachesFuture = this.cctx.affinity().onCacheChangeRequest(this, crd, this.exchActions);
                        if (!kctx.clientNode()) {
                            this.cctx.cache().shutdownNotFinishedRecoveryCaches();
                        }
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                    if (!this.log.isInfoEnabled()) return kctx.clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                    this.log.info("Successfully activated caches [nodeId=" + this.cctx.localNodeId() + ", client=" + kctx.clientNode() + ", topVer=" + this.initialVersion() + ", newState=" + (Object)((Object)req.state()) + "]");
                    return kctx.clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                }
                catch (Exception e) {
                    U.error(this.log, "Failed to activate node components [nodeId=" + this.cctx.localNodeId() + ", client=" + kctx.clientNode() + ", topVer=" + this.initialVersion() + ", newState=" + (Object)((Object)req.state()) + "]", e);
                    this.exchangeLocE = e;
                    if (!crd) return kctx.clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        Object object = this.mux;
                        synchronized (object) {
                            this.exchangeGlobalExceptions.put(this.cctx.localNodeId(), e);
                            return kctx.clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                        }
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                }
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Start deactivation process [nodeId=" + this.cctx.localNodeId() + ", client=" + kctx.clientNode() + ", topVer=" + this.initialVersion() + "]");
            }
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                kctx.dataStructures().onDeActivate(kctx);
                assert (this.registerCachesFuture == null) : "No caches registration should be scheduled before new caches have started.";
                this.registerCachesFuture = this.cctx.affinity().onCacheChangeRequest(this, crd, this.exchActions);
                kctx.encryption().onDeActivate(kctx);
                ((IgniteChangeGlobalStateSupport)((Object)kctx.distributedMetastorage())).onDeActivate(kctx);
                if (!this.log.isInfoEnabled()) return kctx.clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
                this.log.info("Successfully deactivated data structures, services and caches [nodeId=" + this.cctx.localNodeId() + ", client=" + kctx.clientNode() + ", topVer=" + this.initialVersion() + "]");
                return kctx.clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
            }
            catch (Exception e) {
                U.error(this.log, "Failed to deactivate node components [nodeId=" + this.cctx.localNodeId() + ", client=" + kctx.clientNode() + ", topVer=" + this.initialVersion() + "]", e);
                this.exchangeLocE = e;
                return kctx.clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        if (!req.state().active()) return kctx.clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            if (!this.forceAffReassignment) {
                assert (this.firstEventCache().minimumNodeVersion().compareToIgnoreTimestamp(FORCE_AFF_REASSIGNMENT_SINCE) < 0) : this.firstEventCache().minimumNodeVersion();
                this.cctx.affinity().onBaselineTopologyChanged(this, crd);
            }
            if (!CU.isPersistenceEnabled(kctx.config()) || kctx.clientNode()) return kctx.clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
            kctx.state().onBaselineTopologyChanged(req.baselineTopology(), req.prevBaselineTopologyHistoryItem());
            return kctx.clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
        }
        catch (Exception e) {
            U.error(this.log, "Failed to change baseline topology [nodeId=" + this.cctx.localNodeId() + ", client=" + kctx.clientNode() + ", topVer=" + this.initialVersion() + "]", e);
            this.exchangeLocE = e;
            return kctx.clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
    }

    private ExchangeType onCacheChangeRequest(boolean crd) throws IgniteCheckedException {
        assert (this.exchActions != null && !this.exchActions.empty()) : this;
        assert (!this.exchActions.clientOnlyExchange()) : this.exchActions;
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            assert (this.registerCachesFuture == null) : "No caches registration should be scheduled before new caches have started.";
            this.registerCachesFuture = this.cctx.affinity().onCacheChangeRequest(this, crd, this.exchActions);
        }
        catch (Exception e) {
            if (this.reconnectOnError(e) || !this.isRollbackSupported()) {
                throw e;
            }
            U.error(this.log, "Failed to initialize cache(s) (will try to rollback) [exchId=" + this.exchId + ", caches=" + this.exchActions.cacheGroupsToStart() + ']', e);
            this.exchangeLocE = new IgniteCheckedException("Failed to initialize exchange locally [locNodeId=" + this.cctx.localNodeId() + "]", e);
            this.exchangeGlobalExceptions.put(this.cctx.localNodeId(), this.exchangeLocE);
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
        return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
    }

    private ExchangeType onCustomMessageNoAffinityChange() {
        if (!this.forceAffReassignment) {
            this.cctx.affinity().onCustomMessageNoAffinityChange(this, this.exchActions);
        }
        return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
    }

    private ExchangeType onAffinityChangeRequest() {
        assert (this.affChangeMsg != null) : this;
        this.cctx.affinity().onChangeAffinityMessage(this, this.affChangeMsg);
        if (this.cctx.kernalContext().clientNode()) {
            return ExchangeType.CLIENT;
        }
        return ExchangeType.ALL;
    }

    private ExchangeType onClientNodeEvent() throws IgniteCheckedException {
        assert (this.firstDiscoEvt.eventNode().isClient()) : this;
        if (this.firstDiscoEvt.type() == 11 || this.firstDiscoEvt.type() == 12) {
            this.onLeft();
            assert (!this.firstDiscoEvt.eventNode().isLocal()) : this.firstDiscoEvt;
        } else assert (this.firstDiscoEvt.type() == 10 || this.firstDiscoEvt.type() == 18) : this.firstDiscoEvt;
        this.cctx.affinity().onClientEvent(this);
        if (this.firstDiscoEvt.eventNode().isLocal()) {
            return ExchangeType.CLIENT;
        }
        if (this.wasRebalanced()) {
            this.keepRebalanced();
        }
        return ExchangeType.NONE;
    }

    private ExchangeType onServerNodeEvent(boolean crd) throws IgniteCheckedException {
        assert (!this.firstDiscoEvt.eventNode().isClient()) : this;
        if (this.firstDiscoEvt.type() == 11 || this.firstDiscoEvt.type() == 12) {
            this.onLeft();
            this.exchCtx.events().warnNoAffinityNodes(this.cctx);
            this.centralizedAff = this.cctx.affinity().onCentralizedAffinityChange(this, crd);
        } else {
            this.cctx.affinity().onServerJoin(this, crd);
        }
        return this.cctx.kernalContext().clientNode() ? ExchangeType.CLIENT : ExchangeType.ALL;
    }

    private ExchangeType onExchangeFreeSwitchNodeLeft() {
        assert (!this.firstDiscoEvt.eventNode().isClient()) : this;
        assert (this.firstDiscoEvt.type() == 11 || this.firstDiscoEvt.type() == 12);
        assert (this.exchCtx.exchangeFreeSwitch());
        this.keepRebalanced();
        this.onLeft();
        this.exchCtx.events().warnNoAffinityNodes(this.cctx);
        this.cctx.affinity().onExchangeFreeSwitch(this);
        return this.cctx.kernalContext().clientNode() ? ExchangeType.NONE : ExchangeType.ALL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientOnlyExchange() throws IgniteCheckedException {
        if (this.crd != null) {
            assert (!this.crd.isLocal()) : this.crd;
            assert (!this.exchCtx.exchangeFreeSwitch()) : this;
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                if (!this.centralizedAff) {
                    this.sendLocalPartitions(this.crd);
                }
                this.initDone();
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        if (this.centralizedAff) {
            for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                GridAffinityAssignmentCache aff = grp.affinity();
                aff.initialize(this.initialVersion(), aff.idealAssignmentRaw());
                this.cctx.exchange().exchangerUpdateHeartbeat();
            }
        } else {
            this.onAllServersLeft();
        }
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            this.onDone(this.initialVersion());
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distributedExchange() throws IgniteCheckedException {
        boolean skipWaitOnLocalJoin;
        assert (this.crd != null);
        assert (!this.cctx.kernalContext().clientNode());
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            if (grp.isLocal()) continue;
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                grp.preloader().onTopologyChanged(this);
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        this.timeBag.finishGlobalStage("Preloading notification");
        boolean bl = skipWaitOnLocalJoin = this.localJoinExchange() && this.cctx.exchange().latch().canSkipJoiningNodes(this.initialVersion());
        if (this.context().exchangeFreeSwitch() && this.isBaselineNodeFailed()) {
            if (this.cctx.kernalContext().coordinators().mvccEnabled()) {
                this.waitPartitionRelease(EXCHANGE_FREE_LATCH_ID, true, false);
            } else {
                this.waitPartitionRelease(null, false, false);
            }
        } else if (!skipWaitOnLocalJoin) {
            boolean distributed = true;
            if (this.activateCluster()) {
                distributed = false;
            }
            this.waitPartitionRelease(EXCHANGE_LATCH_ID, distributed, true);
            if (distributed) {
                this.waitPartitionRelease(EXCHANGE_LATCH_ID, false, false);
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Skipped waiting for partitions release future (local node is joining) [topVer=" + this.initialVersion() + "]");
        }
        boolean topChanged = this.firstDiscoEvt.type() != 18 || this.affChangeMsg != null;
        for (GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
            if (cacheCtx.isLocal() || this.cacheStopping(cacheCtx.cacheId()) || !topChanged) continue;
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                cacheCtx.store().forceFlush();
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            this.cctx.database().beforeExchange(this);
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
        if (!this.exchCtx.mergeExchanges() && !this.exchCtx.exchangeFreeSwitch()) {
            for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                if (grp.isLocal() || this.cacheGroupStopping(grp.groupId()) || grp.affinity().lastVersion().topologyVersion() <= 0L) continue;
                this.cctx.exchange().exchangerBlockingSectionBegin();
                try {
                    grp.topology().beforeExchange(this, !this.centralizedAff && !this.forceAffReassignment, false);
                }
                finally {
                    this.cctx.exchange().exchangerBlockingSectionEnd();
                }
            }
        }
        if (this.localJoinExchange() || this.activateCluster()) {
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                this.cctx.database().onStateRestored(this.initialVersion());
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
        this.timeBag.finishGlobalStage("After states restored callback");
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            this.cctx.database().releaseHistoryForPreloading();
            this.partHistReserved = this.cctx.database().reserveHistoryForExchange();
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
        this.clearingPartitions = new HashMap<Integer, Set<Integer>>();
        this.timeBag.finishGlobalStage("WAL history reservation");
        this.changeWalModeIfNeeded();
        if (this.events().hasServerLeft()) {
            this.finalizePartitionCounters();
        }
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            if (this.context().exchangeFreeSwitch()) {
                IgniteUtils.doInParallel(U.availableThreadCount(this.cctx.kernalContext(), (byte)2, 2), this.cctx.kernalContext().pools().getSystemExecutorService(), this.cctx.affinity().cacheGroups().values(), desc -> {
                    if (desc.config().getCacheMode() == CacheMode.LOCAL) {
                        return null;
                    }
                    CacheGroupContext grp = this.cctx.cache().cacheGroup(desc.groupId());
                    GridDhtPartitionTopology top = grp != null ? grp.topology() : this.cctx.exchange().clientTopology(desc.groupId(), this.events().discoveryCache());
                    top.beforeExchange(this, true, false);
                    return null;
                });
            } else {
                if (this.crd.isLocal()) {
                    if (this.remaining.isEmpty()) {
                        this.initFut.onDone(true);
                        this.onAllReceived(null);
                    }
                } else {
                    this.sendPartitions(this.crd);
                }
                this.initDone();
            }
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
    }

    private void tryToPerformLocalSnapshotOperation() {
        try {
            long start = System.nanoTime();
            IgniteInternalFuture fut = this.cctx.snapshot().tryStartLocalSnapshotOperation(this.firstDiscoEvt, this.exchId.topologyVersion());
            if (fut != null) {
                fut.get();
                long end = System.nanoTime();
                if (this.log.isInfoEnabled()) {
                    this.log.info("Snapshot initialization completed [topVer=" + this.exchangeId().topologyVersion() + ", time=" + U.nanosToMillis(end - start) + "ms]");
                }
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            U.error(this.log, "Error while starting snapshot operation", e);
        }
    }

    private void changeWalModeIfNeeded() {
        WalStateAbstractMessage msg = this.firstWalMessage();
        if (msg != null) {
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                this.cctx.walState().onProposeExchange(msg.exchangeMessage());
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
            }
        }
    }

    @Nullable
    private WalStateAbstractMessage firstWalMessage() {
        DiscoveryCustomMessage customMsg;
        if (this.firstDiscoEvt != null && this.firstDiscoEvt.type() == 18 && (customMsg = ((DiscoveryCustomEvent)this.firstDiscoEvt).customMessage()) instanceof WalStateAbstractMessage) {
            WalStateAbstractMessage msg0 = (WalStateAbstractMessage)customMsg;
            assert (msg0.needExchange());
            return msg0;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitPartitionRelease(String latchId, boolean distributed, boolean doRollback) throws IgniteCheckedException {
        IgniteInternalFuture<?> partReleaseFut;
        Latch releaseLatch = null;
        this.cctx.exchange().exchangerBlockingSectionBegin();
        try {
            if (distributed) {
                releaseLatch = this.cctx.exchange().latch().getOrCreate(latchId, this.initialVersion());
            }
            partReleaseFut = this.context().exchangeFreeSwitch() && this.isBaselineNodeFailed() ? this.cctx.partitionRecoveryFuture(this.initialVersion(), this.firstDiscoEvt.eventNode()) : this.cctx.partitionReleaseFuture(this.initialVersion());
            this.partReleaseFut = partReleaseFut;
        }
        finally {
            this.cctx.exchange().exchangerBlockingSectionEnd();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Before waiting for partition release future: " + this);
        }
        int dumpCnt = 0;
        long nextDumpTime = 0L;
        IgniteConfiguration cfg = this.cctx.gridConfig();
        long waitStartNanos = System.nanoTime();
        long waitTimeout = 2L * cfg.getNetworkTimeout();
        boolean txRolledBack = !doRollback;
        while (true) {
            long curTimeout = cfg.getTransactionConfiguration().getTxTimeoutOnPartitionMapExchange();
            this.cctx.exchange().exchangerBlockingSectionBegin();
            try {
                partReleaseFut.get(curTimeout > 0L && !txRolledBack ? Math.min(curTimeout, waitTimeout) : waitTimeout, TimeUnit.MILLISECONDS);
            }
            catch (IgniteFutureTimeoutCheckedException ignored) {
                if (nextDumpTime <= U.currentTimeMillis()) {
                    this.dumpPendingObjects(partReleaseFut, curTimeout <= 0L && !txRolledBack);
                    nextDumpTime = U.currentTimeMillis() + GridDhtPartitionsExchangeFuture.nextDumpTimeout(dumpCnt++, waitTimeout);
                }
                long passedMillis = U.millisSinceNanos(waitStartNanos);
                if (txRolledBack || curTimeout <= 0L || passedMillis < curTimeout) continue;
                txRolledBack = true;
                this.cctx.tm().rollbackOnTopologyChange(this.initialVersion());
                continue;
            }
            catch (IgniteCheckedException e) {
                U.warn(this.log, "Unable to await partitions release future", e);
                throw e;
            }
            finally {
                this.cctx.exchange().exchangerBlockingSectionEnd();
                continue;
            }
            break;
        }
        long waitEndNanos = System.nanoTime();
        if (this.log.isInfoEnabled()) {
            String mode;
            long waitTime = U.nanosToMillis(waitEndNanos - waitStartNanos);
            Iterator<IgniteTxKey> futInfo = RELEASE_FUTURE_DUMP_THRESHOLD > 0 && waitTime > (long)RELEASE_FUTURE_DUMP_THRESHOLD ? partReleaseFut.toString() : "NA";
            String string = mode = distributed ? "DISTRIBUTED" : "LOCAL";
            if (this.log.isInfoEnabled()) {
                this.log.info("Finished waiting for partition release future [topVer=" + this.exchangeId().topologyVersion() + ", waitTime=" + waitTime + "ms, futInfo=" + (String)((Object)futInfo) + ", mode=" + mode + "]");
            }
        }
        if (!this.context().exchangeFreeSwitch()) {
            IgniteInternalFuture<?> locksFut = this.cctx.mvcc().finishLocks(this.exchId.topologyVersion());
            nextDumpTime = 0L;
            dumpCnt = 0;
            while (true) {
                this.cctx.exchange().exchangerBlockingSectionBegin();
                try {
                    locksFut.get(50L, TimeUnit.MILLISECONDS);
                }
                catch (IgniteFutureTimeoutCheckedException ignored) {
                    if (nextDumpTime <= U.currentTimeMillis()) {
                        U.warn(this.log, "Failed to wait for locks release future. Dumping pending objects that might be the cause: " + this.cctx.localNodeId());
                        U.warn(this.log, "Locked keys:");
                        for (IgniteTxKey key : this.cctx.mvcc().lockedKeys()) {
                            U.warn(this.log, "Locked key: " + key);
                        }
                        for (IgniteTxKey key : this.cctx.mvcc().nearLockedKeys()) {
                            U.warn(this.log, "Locked near key: " + key);
                        }
                        Map<IgniteTxKey, Collection<GridCacheMvccCandidate>> locks = this.cctx.mvcc().unfinishedLocks(this.exchId.topologyVersion());
                        for (Map.Entry<IgniteTxKey, Collection<GridCacheMvccCandidate>> e : locks.entrySet()) {
                            U.warn(this.log, "Awaited locked entry [key=" + e.getKey() + ", mvcc=" + e.getValue() + ']');
                        }
                        nextDumpTime = U.currentTimeMillis() + GridDhtPartitionsExchangeFuture.nextDumpTimeout(dumpCnt++, waitTimeout);
                        if (IgniteSystemProperties.getBoolean("IGNITE_THREAD_DUMP_ON_EXCHANGE_TIMEOUT", false)) {
                            U.dumpThreads(this.log);
                        }
                    }
                    this.cctx.mvcc().recheckPendingLocks();
                    continue;
                }
                finally {
                    this.cctx.exchange().exchangerBlockingSectionEnd();
                    continue;
                }
                break;
            }
            this.timeBag.finishGlobalStage("Wait partitions release [latch=" + latchId + "]");
        }
        if (releaseLatch == null) {
            assert (!distributed) : "Partitions release latch must be initialized in distributed mode.";
            return;
        }
        releaseLatch.countDown();
        if (this.localJoinExchange() && !this.cctx.exchange().latch().canSkipJoiningNodes(this.initialVersion())) {
            return;
        }
        try {
            String troubleshootingHint = this.crd.isLocal() ? "Some nodes have not sent acknowledgement for latch completion. It's possible due to unfinishined atomic updates, transactions or not released explicit locks on that nodes. Please check logs for errors on nodes with ids reported in latch `pendingAcks` collection" : "For more details please check coordinator node logs [crdNode=" + this.crd.toString() + "]";
            while (true) {
                try {
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        releaseLatch.await(waitTimeout, TimeUnit.MILLISECONDS);
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Finished waiting for partitions release latch: " + releaseLatch);
                    }
                }
                catch (IgniteFutureTimeoutCheckedException ignored) {
                    U.warn(this.log, "Unable to await partitions release latch within timeout. " + troubleshootingHint + " [latch=" + releaseLatch + "]");
                    releaseLatch.countDown();
                    continue;
                }
                break;
            }
        }
        catch (IgniteCheckedException e) {
            U.warn(this.log, "Stop waiting for partitions release latch: " + e.getMessage());
        }
        this.timeBag.finishGlobalStage("Wait partitions release latch [latch=" + latchId + "]");
    }

    private void onLeft() {
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            if (grp.isLocal()) continue;
            grp.preloader().pause();
            try {
                grp.unwindUndeploys();
            }
            finally {
                grp.preloader().resume();
            }
            this.cctx.exchange().exchangerUpdateHeartbeat();
        }
    }

    private void dumpPendingObjects(IgniteInternalFuture<?> partReleaseFut, boolean txTimeoutNotifyFlag) {
        U.warn(this.cctx.kernalContext().cluster().diagnosticLog(), "Failed to wait for partition release future [topVer=" + this.initialVersion() + ", node=" + this.cctx.localNodeId() + "]");
        if (txTimeoutNotifyFlag) {
            U.warn(this.cctx.kernalContext().cluster().diagnosticLog(), "Consider changing TransactionConfiguration.txTimeoutOnPartitionMapExchange to non default value to avoid this message.");
        }
        U.warn(this.log, "Partition release future: " + partReleaseFut);
        U.warn(this.cctx.kernalContext().cluster().diagnosticLog(), "Dumping pending objects that might be the cause: ");
        try {
            this.cctx.exchange().dumpDebugInfo(this);
        }
        catch (Exception e) {
            U.error(this.cctx.kernalContext().cluster().diagnosticLog(), "Failed to dump debug information: " + e, e);
        }
    }

    private boolean cacheGroupStopping(int grpId) {
        return this.exchActions != null && this.exchActions.cacheGroupStopping(grpId);
    }

    private boolean cacheStopping(int cacheId) {
        return this.exchActions != null && this.exchActions.cacheStopped(cacheId);
    }

    public boolean localJoinExchange() {
        return this.firstDiscoEvt != null && this.firstDiscoEvt.type() == 10 && this.firstDiscoEvt.eventNode().isLocal();
    }

    private void sendLocalPartitions(ClusterNode node) throws IgniteCheckedException {
        GridDhtPartitionsSingleMessage msg;
        Set<String> caches;
        assert (node != null);
        if (this.exchActions != null && !F.isEmpty(caches = this.exchActions.cachesToResetLostPartitions())) {
            this.resetLostPartitions(caches);
        }
        if (this.cctx.kernalContext().clientNode() || this.dynamicCacheStartExchange() && this.exchangeLocE != null) {
            msg = new GridDhtPartitionsSingleMessage(this.exchangeId(), this.cctx.kernalContext().clientNode(), this.cctx.versions().last(), true);
        } else {
            msg = this.cctx.exchange().createPartitionsSingleMessage(this.exchangeId(), false, true, node.version().compareToIgnoreTimestamp(CachePartitionPartialCountersMap.PARTIAL_COUNTERS_MAP_SINCE) >= 0, this.exchActions);
            Map<Integer, Map<Integer, Long>> partHistReserved0 = this.partHistReserved;
            if (partHistReserved0 != null) {
                msg.partitionHistoryCounters(partHistReserved0);
            }
        }
        if ((this.stateChangeExchange() || this.dynamicCacheStartExchange()) && this.exchangeLocE != null) {
            msg.setError(this.exchangeLocE);
        } else if (this.localJoinExchange()) {
            msg.cacheGroupsAffinityRequest(this.exchCtx.groupsAffinityRequestOnJoin());
        }
        msg.exchangeStartTime(this.startTime);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sending local partitions [nodeId=" + node.id() + ", exchId=" + this.exchId + ", msg=" + msg + ']');
        }
        while (true) {
            try {
                this.cctx.io().send(node, (GridCacheMessage)msg, (byte)2);
            }
            catch (ClusterTopologyCheckedException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to send local partitions on exchange [nodeId=" + node.id() + ", exchId=" + this.exchId + ']');
                }
                if (!this.cctx.discovery().alive(node.id())) break;
                U.sleep(this.cctx.gridConfig().getNetworkSendRetryDelay());
                continue;
            }
            break;
        }
    }

    private GridDhtPartitionsFullMessage createPartitionsMessage(boolean compress, boolean newCntrMap) {
        GridCacheVersion last = this.lastVer.get();
        GridDhtPartitionsFullMessage m = this.cctx.exchange().createPartitionsFullMessage(compress, newCntrMap, this.exchangeId(), last != null ? last : this.cctx.versions().last(), this.partHistSuppliers, this.partsToReload);
        if (this.stateChangeExchange() && !F.isEmpty(this.exchangeGlobalExceptions)) {
            m.setErrorsMap(this.exchangeGlobalExceptions);
        }
        return m;
    }

    private void sendAllPartitions(GridDhtPartitionsFullMessage fullMsg, Collection<ClusterNode> nodes, Map<UUID, GridDhtPartitionsSingleMessage> mergedJoinExchMsgs, Map<Integer, CacheGroupAffinityMessage> affinityForJoinedNodes) {
        assert (!nodes.contains(this.cctx.localNode()));
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sending full partition map [nodeIds=" + F.viewReadOnly(nodes, F.node2id(), new IgnitePredicate[0]) + ", exchId=" + this.exchId + ", msg=" + fullMsg + ']');
        }
        Optional singleMsgWithAffinityReq = nodes.stream().flatMap(node -> Optional.ofNullable(this.msgs.get(node.id())).filter(singleMsg -> singleMsg.cacheGroupsAffinityRequest() != null).map(Stream::of).orElse(Stream.empty())).findAny();
        GridDhtPartitionsFullMessage fullMsgWithAffinity = singleMsgWithAffinityReq.filter(singleMessage -> affinityForJoinedNodes != null).map(singleMessage -> fullMsg.copy().joinedNodeAffinity(affinityForJoinedNodes)).orElse(null);
        nodes.stream().map(node -> {
            if (fullMsgWithAffinity == null) {
                return new T2<ClusterNode, GridDhtPartitionsFullMessage>((ClusterNode)node, fullMsg);
            }
            return new T2<ClusterNode, GridDhtPartitionsFullMessage>((ClusterNode)node, Optional.ofNullable(this.msgs.get(node.id())).filter(singleMsg -> singleMsg.cacheGroupsAffinityRequest() != null).map(singleMsg -> fullMsgWithAffinity).orElse(fullMsg));
        }).map(nodeAndMsg -> {
            GridDhtPartitionExchangeId sndExchId;
            ClusterNode node = (ClusterNode)nodeAndMsg.get1();
            GridDhtPartitionsFullMessage fullMsgToSend = (GridDhtPartitionsFullMessage)nodeAndMsg.get2();
            GridDhtPartitionExchangeId gridDhtPartitionExchangeId = sndExchId = mergedJoinExchMsgs != null ? Optional.ofNullable(mergedJoinExchMsgs.get(node.id())).map(GridDhtPartitionsAbstractMessage::exchangeId).orElse(this.exchangeId()) : this.exchangeId();
            if (sndExchId != null && !sndExchId.equals(this.exchangeId())) {
                GridDhtPartitionsFullMessage fullMsgWithUpdatedExchangeId = fullMsgToSend.copy();
                fullMsgWithUpdatedExchangeId.exchangeId(sndExchId);
                return new T2<ClusterNode, GridDhtPartitionsFullMessage>(node, fullMsgWithUpdatedExchangeId);
            }
            return new T2<ClusterNode, GridDhtPartitionsFullMessage>(node, fullMsgToSend);
        }).forEach(nodeAndMsg -> {
            ClusterNode node = (ClusterNode)nodeAndMsg.get1();
            GridDhtPartitionsFullMessage fullMsgToSend = (GridDhtPartitionsFullMessage)nodeAndMsg.get2();
            try {
                this.cctx.io().send(node, (GridCacheMessage)fullMsgToSend, (byte)2);
            }
            catch (ClusterTopologyCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to send partitions, node failed: " + node);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send partitions [node=" + node + ']', e);
            }
        });
    }

    private void sendPartitions(ClusterNode oldestNode) {
        assert (!this.exchCtx.exchangeFreeSwitch()) : this;
        try {
            this.sendLocalPartitions(oldestNode);
        }
        catch (ClusterTopologyCheckedException ignore) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Coordinator left during partition exchange [nodeId=" + oldestNode.id() + ", exchId=" + this.exchId + ']');
            }
        }
        catch (IgniteCheckedException e) {
            if (this.reconnectOnError(e)) {
                this.onDone(new IgniteNeedReconnectException(this.cctx.localNode(), (Throwable)e));
            }
            U.error(this.log, "Failed to send local partitions to coordinator [crd=" + oldestNode.id() + ", exchId=" + this.exchId + ']', e);
        }
    }

    public boolean serverNodeDiscoveryEvent() {
        assert (this.exchCtx != null);
        return this.exchCtx.events().hasServerJoin() || this.exchCtx.events().hasServerLeft();
    }

    @Override
    public boolean exchangeDone() {
        return this.done.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishMerged(AffinityTopologyVersion resVer, GridDhtPartitionsExchangeFuture exchFut) {
        Object object = this.mux;
        synchronized (object) {
            if (this.state == null) {
                this.state = ExchangeLocalState.MERGED;
                this.mergedWith = exchFut;
            }
        }
        this.done.set(true);
        super.onDone(resVer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMerged() {
        Object object = this.mux;
        synchronized (object) {
            return this.state == ExchangeLocalState.MERGED;
        }
    }

    private String exchangeTimingsLogMessage(String header, List<String> timings) {
        StringBuilder timingsToLog = new StringBuilder();
        timingsToLog.append(header).append(" [");
        timingsToLog.append("startVer=").append(this.initialVersion());
        timingsToLog.append(", resVer=").append(this.topologyVersion());
        for (String stageTiming : timings) {
            timingsToLog.append(", ").append(stageTiming);
        }
        timingsToLog.append(']');
        return timingsToLog.toString();
    }

    @Override
    public boolean onDone(@Nullable AffinityTopologyVersion res, @Nullable Throwable err) {
        assert (res != null || err != null) : "TopVer=" + res + ", err=" + err;
        if (this.isDone() || !this.done.compareAndSet(false, true)) {
            return false;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Finish exchange future [startVer=" + this.initialVersion() + ", resVer=" + res + ", err=" + err + ", rebalanced=" + this.rebalanced() + ", wasRebalanced=" + this.wasRebalanced() + ']');
        }
        if (res != null) {
            this.span.addTag(SpanTags.tag("result", "topology.version", "major"), () -> String.valueOf(res.topologyVersion()));
            this.span.addTag(SpanTags.tag("result", "topology.version", "minor"), () -> String.valueOf(res.minorTopologyVersion()));
        }
        if (err != null) {
            Throwable errf = err;
            this.span.addTag("error", errf::toString);
        }
        boolean cleanIdxRebuildFutures = true;
        try {
            boolean bl;
            this.waitUntilNewCachesAreRegistered();
            if (err == null && !this.cctx.kernalContext().clientNode() && (this.serverNodeDiscoveryEvent() || this.affChangeMsg != null)) {
                for (GridCacheContext gridCacheContext : this.cctx.cacheContexts()) {
                    if (!gridCacheContext.affinityNode() || gridCacheContext.isLocal()) continue;
                    gridCacheContext.continuousQueries().flushOnExchangeDone(res);
                }
            }
            if (err == null) {
                if (this.centralizedAff || this.forceAffReassignment) {
                    assert (!this.exchCtx.mergeExchanges());
                    HashSet grpToRefresh = U.newHashSet(this.cctx.cache().cacheGroups().size());
                    for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                        if (grp.isLocal()) continue;
                        try {
                            if (!grp.topology().initPartitionsWhenAffinityReady(res, this)) continue;
                            grpToRefresh.add(grp);
                        }
                        catch (IgniteInterruptedCheckedException e) {
                            U.error(this.log, "Failed to initialize partitions.", e);
                        }
                    }
                    if (!grpToRefresh.isEmpty()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Refresh partitions due to partitions initialized when affinity ready [" + grpToRefresh.stream().map(CacheGroupContext::name).collect(Collectors.toList()) + ']');
                        }
                        this.cctx.exchange().refreshPartitions(grpToRefresh);
                    }
                }
                for (GridCacheContext gridCacheContext : this.cctx.cacheContexts()) {
                    GridCacheContext drCacheCtx = gridCacheContext.isNear() ? gridCacheContext.near().dht().context() : gridCacheContext;
                    if (!drCacheCtx.isDrEnabled()) continue;
                    try {
                        drCacheCtx.dr().onExchange(res, this.exchId.isLeft(), this.activateCluster());
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.log, "Failed to notify DR: " + e, e);
                    }
                }
                if (this.exchCtx.events().hasServerLeft() || this.activateCluster()) {
                    this.detectLostPartitions(res);
                }
                HashMap m = U.newHashMap(this.cctx.cache().cacheGroups().size());
                for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                    GridDhtTopologyFutureAdapter.CacheGroupValidation valRes = this.validateCacheGroup(grp, this.events().lastEvent().topologyNodes());
                    if (valRes.isValid() && !valRes.hasLostPartitions()) continue;
                    m.put(grp.groupId(), valRes);
                }
                this.grpValidRes = m;
            }
            if (!this.cctx.localNode().isClient()) {
                this.tryToPerformLocalSnapshotOperation();
            }
            if (err == null) {
                this.cctx.coordinators().onExchangeDone(this.events().discoveryCache());
            }
            for (PartitionsExchangeAware partitionsExchangeAware : this.cctx.exchange().exchangeAwareComponents()) {
                partitionsExchangeAware.onDoneBeforeTopologyUnlock(this);
            }
            this.cctx.cache().onExchangeDone(this.initialVersion(), this.exchActions, err);
            Map<T2<Integer, Integer>, Long> localReserved = this.partHistSuppliers.getReservations(this.cctx.localNodeId());
            if (localReserved != null && !(bl = this.cctx.database().reserveHistoryForPreloading(localReserved))) {
                this.log.warning("Could not reserve history for historical rebalance (possible it happened because WAL space is exhausted).");
            }
            this.cctx.database().releaseHistoryForExchange();
            if (err == null) {
                this.cctx.database().rebuildIndexesIfNeeded(this);
                cleanIdxRebuildFutures = false;
                for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                    if (grp.isLocal()) continue;
                    grp.topology().onExchangeDone(this, grp.affinity().readyAffinity(res), false);
                }
                if (this.changedAffinity()) {
                    this.cctx.walState().disableGroupDurabilityForPreloading(this);
                }
            }
        }
        catch (Throwable t) {
            if (err != null) {
                t.addSuppressed(err);
            }
            err = t;
        }
        Throwable err0 = err;
        if (err0 != null && cleanIdxRebuildFutures) {
            this.cctx.kernalContext().query().removeIndexRebuildFuturesOnExchange(this, null);
        }
        this.listen(f -> {
            this.cctx.exchange().lastFinishedFuture(this);
            this.cctx.exchange().onExchangeDone(res, this.initialVersion(), err0);
            this.cctx.cache().completeProxyRestart(this.resolveCacheRequests(this.exchActions), this.initialVersion(), res);
            if (this.exchActions != null && err0 == null) {
                this.exchActions.completeRequestFutures(this.cctx, null);
            }
            if (this.stateChangeExchange() && err0 == null) {
                this.cctx.kernalContext().state().onStateChangeExchangeDone(this.exchActions.stateChangeRequest());
            }
        });
        if (super.onDone(res, err)) {
            this.afterLsnrCompleteFut.onDone();
            this.span.addLog(() -> "Completed partition exchange");
            this.span.end();
            if (err == null) {
                this.updateDurationHistogram(System.currentTimeMillis() - this.initTime);
                this.cctx.exchange().clusterRebalancedMetric().value(this.rebalanced());
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Completed partition exchange [localNode=" + this.cctx.localNodeId() + ", exchange=" + (this.log.isDebugEnabled() ? this : this.shortInfo()) + ", topVer=" + this.topologyVersion() + "]");
                if (err == null) {
                    this.timeBag.finishGlobalStage("Exchange done");
                    List<String> list = this.timeBag.stagesTimings();
                    if (this.discoveryLag != null && (Long)this.discoveryLag.get1() != 0L) {
                        list.add("Discovery lag=" + this.discoveryLag.get1() + " ms, Latest started node id=" + this.discoveryLag.get2());
                    }
                    this.log.info(this.exchangeTimingsLogMessage("Exchange timings", list));
                    List<String> localTimings = this.timeBag.longestLocalStagesTimings(3);
                    this.log.info(this.exchangeTimingsLogMessage("Exchange longest local stages", localTimings));
                }
            }
            this.initFut.onDone(err == null);
            this.cctx.exchange().latch().dropClientLatches(this.initialVersion());
            if (this.exchCtx != null && this.exchCtx.events().hasServerLeft()) {
                ExchangeDiscoveryEvents exchangeDiscoveryEvents = this.exchCtx.events();
                for (DiscoveryEvent evt : exchangeDiscoveryEvents.events()) {
                    if (!ExchangeDiscoveryEvents.serverLeftEvent(evt)) continue;
                    for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                        grp.affinityFunction().removeNode(evt.eventNode().id());
                    }
                }
            }
            for (PartitionsExchangeAware comp : this.cctx.exchange().exchangeAwareComponents()) {
                comp.onDoneAfterTopologyUnlock(this);
            }
            if (this.firstDiscoEvt instanceof DiscoveryCustomEvent) {
                ((DiscoveryCustomEvent)this.firstDiscoEvt).customMessage(null);
            }
            if (err == null && this.exchCtx != null && (this.exchCtx.events().hasServerLeft() || this.exchCtx.events().hasServerJoin())) {
                ExchangeDiscoveryEvents exchangeDiscoveryEvents = this.exchCtx.events();
                for (DiscoveryEvent evt : exchangeDiscoveryEvents.events()) {
                    if (!ExchangeDiscoveryEvents.serverLeftEvent(evt) && !ExchangeDiscoveryEvents.serverJoinEvent(evt)) continue;
                    this.logExchange(evt);
                }
            }
            return true;
        }
        return false;
    }

    public void validate(CacheGroupContext grp) {
        GridDhtTopologyFutureAdapter.CacheGroupValidation valRes;
        if (this.grpValidRes == null) {
            this.grpValidRes = new ConcurrentHashMap();
        }
        if (!(valRes = this.validateCacheGroup(grp, this.events().lastEvent().topologyNodes())).isValid() || valRes.hasLostPartitions()) {
            this.grpValidRes.put(grp.groupId(), valRes);
        }
    }

    private void updateDurationHistogram(long duration) {
        this.cctx.exchange().durationHistogram().value(duration);
        if (this.changedAffinity()) {
            this.cctx.exchange().blockingDurationHistogram().value(duration);
        }
    }

    private T2<Long, UUID> calculateDiscoveryLag(Map<UUID, GridDhtPartitionsSingleMessage> declared, Map<UUID, GridDhtPartitionsSingleMessage> merged) {
        HashMap<UUID, GridDhtPartitionsSingleMessage> msgs = new HashMap<UUID, GridDhtPartitionsSingleMessage>(declared);
        msgs.putAll(merged);
        long minStartTime = this.startTime;
        long maxStartTime = this.startTime;
        UUID latestStartedNode = this.cctx.localNodeId();
        for (Map.Entry msg : msgs.entrySet()) {
            UUID nodeId = (UUID)msg.getKey();
            long exchangeTime = ((GridDhtPartitionsSingleMessage)msg.getValue()).exchangeStartTime();
            if (exchangeTime != 0L) {
                minStartTime = Math.min(minStartTime, exchangeTime);
                maxStartTime = Math.max(maxStartTime, exchangeTime);
            }
            if (maxStartTime != exchangeTime) continue;
            latestStartedNode = nodeId;
        }
        return new T2<Long, UUID>(maxStartTime - minStartTime, latestStartedNode);
    }

    private Map<String, DynamicCacheChangeRequest> resolveCacheRequests(ExchangeActions exchangeActions) {
        if (exchangeActions == null) {
            return Collections.emptyMap();
        }
        return exchangeActions.cacheStartRequests().stream().map(ExchangeActions.CacheActionData::request).collect(Collectors.toMap(DynamicCacheChangeRequest::cacheName, r -> r));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilNewCachesAreRegistered() {
        block8: {
            try {
                IgniteInternalFuture<?> registerCachesFut = this.registerCachesFuture;
                if (registerCachesFut == null || registerCachesFut.isDone()) break block8;
                int timeout = Math.max(1000, (int)(this.cctx.kernalContext().config().getFailureDetectionTimeout() / 2L));
                while (true) {
                    this.cctx.exchange().exchangerBlockingSectionBegin();
                    try {
                        registerCachesFut.get(timeout, TimeUnit.SECONDS);
                    }
                    catch (IgniteFutureTimeoutCheckedException te) {
                        List cacheNames = this.exchActions.cacheStartRequests().stream().map(req -> req.descriptor().cacheName()).collect(Collectors.toList());
                        U.warn(this.log, "Failed to wait for caches configuration registration and saving within timeout. Probably disk is too busy or slow.[caches=" + cacheNames + "]");
                        continue;
                    }
                    finally {
                        this.cctx.exchange().exchangerBlockingSectionEnd();
                        continue;
                    }
                    break;
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to wait for caches registration and saving", e);
            }
        }
    }

    private void logExchange(DiscoveryEvent evt) {
        if (this.cctx.kernalContext().state().publicApiActiveState(false) && this.cctx.wal() != null && this.cctx.wal().serializerVersion() > 1) {
            try {
                Short constId;
                ExchangeRecord.Type type = null;
                if (evt.type() == 10) {
                    type = ExchangeRecord.Type.JOIN;
                } else if (evt.type() == 11 || evt.type() == 12) {
                    type = ExchangeRecord.Type.LEFT;
                }
                BaselineTopology blt = this.cctx.kernalContext().state().clusterState().baselineTopology();
                if (type != null && blt != null && (constId = blt.consistentIdMapping().get(evt.eventNode().consistentId())) != null) {
                    this.cctx.wal().log(new ExchangeRecord(constId, type));
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Fail during log exchange record.", e);
            }
        }
    }

    public void cleanUp() {
        this.pendingSingleMsgs.clear();
        this.fullMsgs.clear();
        this.msgs.clear();
        this.crd = null;
        this.partReleaseFut = null;
        this.exchActions = null;
        this.mergedJoinExchMsgs = null;
        this.pendingJoinMsg = null;
        this.exchCtx = null;
        this.newCrdFut = null;
        this.exchangeLocE = null;
        this.exchangeGlobalExceptions.clear();
        this.exclusionsFromHistoricalRebalance.clear();
        this.exclusionsFromFullRebalance.clear();
        if (this.finishState != null) {
            this.finishState.cleanUp();
        }
    }

    private void updateLastVersion(GridCacheVersion ver) {
        GridCacheVersion old;
        assert (ver != null);
        while (!((old = this.lastVer.get()) != null && Long.compare(old.order(), ver.order()) >= 0 || this.lastVer.compareAndSet(old, ver))) {
        }
    }

    private boolean addMergedJoinExchange(ClusterNode node, @Nullable GridDhtPartitionsSingleMessage msg) {
        assert (Thread.holdsLock(this.mux));
        assert (node != null);
        assert (this.state == ExchangeLocalState.CRD) : this.state;
        if (msg == null && this.newCrdFut != null) {
            msg = this.newCrdFut.joinExchangeMessage(node.id());
        }
        UUID nodeId = node.id();
        boolean wait = false;
        if (node.isClient()) {
            if (msg != null) {
                this.waitAndReplyToNode(nodeId, msg);
            }
        } else {
            if (this.mergedJoinExchMsgs == null) {
                this.mergedJoinExchMsgs = new LinkedHashMap<UUID, GridDhtPartitionsSingleMessage>();
            }
            if (msg != null) {
                assert (msg.exchangeId().topologyVersion().equals(new AffinityTopologyVersion(node.order())));
                if (this.log.isInfoEnabled()) {
                    this.log.info("Merge server join exchange, message received [curFut=" + this.initialVersion() + ", node=" + nodeId + ']');
                }
                this.mergedJoinExchMsgs.put(nodeId, msg);
            } else if (this.cctx.discovery().alive(nodeId)) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Merge server join exchange, wait for message [curFut=" + this.initialVersion() + ", node=" + nodeId + ']');
                }
                wait = true;
                this.mergedJoinExchMsgs.put(nodeId, null);
                ++this.awaitMergedMsgs;
            } else if (this.log.isInfoEnabled()) {
                this.log.info("Merge server join exchange, awaited node left [curFut=" + this.initialVersion() + ", node=" + nodeId + ']');
            }
        }
        return wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mergeJoinExchange(GridDhtPartitionsExchangeFuture fut) {
        boolean wait;
        Object object = this.mux;
        synchronized (object) {
            assert (!this.isDone() && !this.initFut.isDone() || this.cctx.kernalContext().isStopping()) : this;
            assert (this.mergedWith == null && this.state == null || this.cctx.kernalContext().isStopping()) : this;
            this.state = ExchangeLocalState.MERGED;
            this.mergedWith = fut;
            ClusterNode joinedNode = this.firstDiscoEvt.eventNode();
            wait = fut.addMergedJoinExchange(joinedNode, this.pendingJoinMsg);
        }
        return wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridDhtPartitionsSingleMessage mergeJoinExchangeOnDone(GridDhtPartitionsExchangeFuture fut) {
        Object object = this.mux;
        synchronized (object) {
            assert (!this.isDone());
            assert (!this.initFut.isDone());
            assert (this.mergedWith == null);
            assert (this.state == null);
            this.state = ExchangeLocalState.MERGED;
            this.mergedWith = fut;
            return this.pendingJoinMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMergedMessage(ClusterNode node, GridDhtPartitionsSingleMessage msg) {
        if (msg.client()) {
            this.waitAndReplyToNode(node.id(), msg);
            return;
        }
        boolean done = false;
        FinishState finishState0 = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.state == ExchangeLocalState.DONE) {
                assert (this.finishState != null);
                finishState0 = this.finishState;
            } else {
                boolean process;
                boolean bl = process = this.mergedJoinExchMsgs != null && this.mergedJoinExchMsgs.containsKey(node.id()) && this.mergedJoinExchMsgs.get(node.id()) == null;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Merge server join exchange, received message [curFut=" + this.initialVersion() + ", node=" + node.id() + ", msgVer=" + msg.exchangeId().topologyVersion() + ", process=" + process + ", awaited=" + this.awaitMergedMsgs + ']');
                }
                if (process) {
                    this.mergedJoinExchMsgs.put(node.id(), msg);
                    assert (this.awaitMergedMsgs > 0) : this.awaitMergedMsgs;
                    --this.awaitMergedMsgs;
                    done = this.awaitMergedMsgs == 0;
                }
            }
        }
        if (finishState0 != null) {
            this.sendAllPartitionsToNode(finishState0, msg, node.id());
            return;
        }
        if (done) {
            this.finishExchangeOnCoordinator(null);
        }
    }

    public void forceClientReconnect(ClusterNode node, GridDhtPartitionsSingleMessage msg) {
        IgniteNeedReconnectException reconnectException = new IgniteNeedReconnectException(node, null);
        this.exchangeGlobalExceptions.put(node.id(), reconnectException);
        this.onDone(null, (Throwable)reconnectException);
        GridDhtPartitionsFullMessage fullMsg = this.createPartitionsMessage(true, false);
        fullMsg.setErrorsMap(this.exchangeGlobalExceptions);
        fullMsg.rebalanced(this.rebalanced());
        try {
            this.cctx.io().send(node, (GridCacheMessage)fullMsg, (byte)2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Full message for reconnect client was sent to node: " + node + ", fullMsg: " + fullMsg);
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send reconnect client message [node=" + node + ']', e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceiveSingleMessage(final ClusterNode node, final GridDhtPartitionsSingleMessage msg) {
        assert (!node.isDaemon()) : node;
        assert (msg != null);
        assert (this.exchId.equals(msg.exchangeId())) : msg;
        assert (!this.cctx.kernalContext().clientNode());
        if (msg.restoreState()) {
            InitNewCoordinatorFuture newCrdFut0;
            Object object = this.mux;
            synchronized (object) {
                assert (this.newCrdFut != null);
                newCrdFut0 = this.newCrdFut;
            }
            newCrdFut0.onMessage(node, msg);
            return;
        }
        if (!msg.client()) {
            assert (msg.lastVersion() != null) : msg;
            this.updateLastVersion(msg.lastVersion());
        }
        GridDhtPartitionsExchangeFuture mergedWith0 = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.state == ExchangeLocalState.MERGED) {
                assert (this.mergedWith != null);
                mergedWith0 = this.mergedWith;
            } else {
                assert (this.state != ExchangeLocalState.CLIENT);
                if (this.exchangeId().isJoined() && node.id().equals(this.exchId.nodeId())) {
                    this.pendingJoinMsg = msg;
                }
            }
        }
        if (mergedWith0 != null) {
            mergedWith0.processMergedMessage(node, msg);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Merged message processed, message handling finished: " + msg);
            }
            return;
        }
        this.initFut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

            @Override
            public void apply(IgniteInternalFuture<Boolean> f) {
                try {
                    if (!f.get().booleanValue()) {
                        return;
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(GridDhtPartitionsExchangeFuture.this.log, "Failed to initialize exchange future: " + this, e);
                    return;
                }
                GridDhtPartitionsExchangeFuture.this.processSingleMessage(node.id(), msg);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fastReplyOnSingleMessage(ClusterNode node, GridDhtPartitionsSingleMessage msg) {
        ExchangeLocalState currState;
        GridDhtPartitionsExchangeFuture futToFastReply = this;
        Object object = this.mux;
        synchronized (object) {
            currState = this.state;
            if (currState == ExchangeLocalState.MERGED) {
                futToFastReply = this.mergedWith;
            }
        }
        if (currState == ExchangeLocalState.DONE) {
            futToFastReply.processSingleMessage(node.id(), msg);
        } else if (currState == ExchangeLocalState.MERGED) {
            futToFastReply.processMergedMessage(node, msg);
        }
        return currState == ExchangeLocalState.MERGED || currState == ExchangeLocalState.DONE;
    }

    public void waitAndReplyToNode(final UUID nodeId, final GridDhtPartitionsSingleMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Single message will be handled on completion of exchange future: " + this);
        }
        this.listen(this.failureHandlerWrapper(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void apply(IgniteInternalFuture<AffinityTopologyVersion> fut) {
                FinishState finishState0;
                if (GridDhtPartitionsExchangeFuture.this.cctx.kernalContext().isStopping()) {
                    return;
                }
                if (GridDhtPartitionsExchangeFuture.this.cacheChangeFailureMsgSent) {
                    return;
                }
                Object object = GridDhtPartitionsExchangeFuture.this.mux;
                synchronized (object) {
                    finishState0 = GridDhtPartitionsExchangeFuture.this.finishState;
                }
                if (finishState0 == null) {
                    assert (GridDhtPartitionsExchangeFuture.this.firstDiscoEvt.type() == 10 && GridDhtPartitionsExchangeFuture.this.firstDiscoEvt.eventNode().isClient()) : GridDhtPartitionsExchangeFuture.this;
                    ClusterNode node = GridDhtPartitionsExchangeFuture.this.cctx.node(nodeId);
                    if (node == null) {
                        if (GridDhtPartitionsExchangeFuture.this.log.isDebugEnabled()) {
                            GridDhtPartitionsExchangeFuture.this.log.debug("No node found for nodeId: " + nodeId + ", handling of single message will be stopped: " + msg);
                        }
                        return;
                    }
                    GridDhtPartitionsFullMessage msg2 = GridDhtPartitionsExchangeFuture.this.createPartitionsMessage(true, node.version().compareToIgnoreTimestamp(CachePartitionPartialCountersMap.PARTIAL_COUNTERS_MAP_SINCE) >= 0);
                    msg2.rebalanced(GridDhtPartitionsExchangeFuture.this.rebalanced());
                    finishState0 = new FinishState(GridDhtPartitionsExchangeFuture.this.cctx.localNodeId(), GridDhtPartitionsExchangeFuture.this.initialVersion(), msg2);
                }
                GridDhtPartitionsExchangeFuture.this.sendAllPartitionsToNode(finishState0, msg, nodeId);
            }
        }));
    }

    private <T extends IgniteInternalFuture<?>> IgniteInClosure<T> failureHandlerWrapper(IgniteInClosure<T> clsr) {
        try {
            return clsr::apply;
        }
        catch (Error e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSingleMessage(UUID nodeId, GridDhtPartitionsSingleMessage msg) {
        if (msg.client()) {
            this.waitAndReplyToNode(nodeId, msg);
            return;
        }
        boolean allReceived = false;
        boolean updateSingleMap = false;
        FinishState finishState0 = null;
        Object object = this.mux;
        synchronized (object) {
            assert (this.crd != null);
            switch (this.state) {
                case DONE: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Received single message, already done [ver=" + this.initialVersion() + ", node=" + nodeId + ']');
                    }
                    assert (this.finishState != null);
                    finishState0 = this.finishState;
                    break;
                }
                case CRD: {
                    assert (this.crd.isLocal()) : this.crd;
                    if (this.remaining.remove(nodeId)) {
                        updateSingleMap = true;
                        ++this.pendingSingleUpdates;
                        if ((this.stateChangeExchange() || this.dynamicCacheStartExchange()) && msg.getError() != null) {
                            this.exchangeGlobalExceptions.put(nodeId, msg.getError());
                        }
                        allReceived = this.remaining.isEmpty();
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info("Coordinator received single message [ver=" + this.initialVersion() + ", node=" + nodeId + (allReceived ? "" : ", remainingNodes=" + this.remaining.size()) + ", allReceived=" + allReceived + ']');
                        break;
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Coordinator received single message it didn't expect to receive: " + msg);
                    break;
                }
                case SRV: 
                case BECOME_CRD: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Non-coordinator received single message [ver=" + this.initialVersion() + ", node=" + nodeId + ", state=" + (Object)((Object)this.state) + ']');
                    }
                    this.pendingSingleMsgs.put(nodeId, msg);
                    break;
                }
                default: {
                    assert (false) : this.state;
                    break;
                }
            }
        }
        if (finishState0 != null) {
            if (!this.cacheChangeFailureMsgSent) {
                this.sendAllPartitionsToNode(finishState0, msg, nodeId);
            }
            return;
        }
        if (updateSingleMap) {
            try {
                if (!this.deactivateCluster()) {
                    this.updatePartitionSingleMap(nodeId, msg);
                }
            }
            finally {
                object = this.mux;
                synchronized (object) {
                    assert (this.pendingSingleUpdates > 0);
                    --this.pendingSingleUpdates;
                    if (this.pendingSingleUpdates == 0) {
                        this.mux.notifyAll();
                    }
                }
            }
        }
        if (allReceived) {
            if (!this.awaitSingleMapUpdates()) {
                return;
            }
            this.onAllReceived(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean awaitSingleMapUpdates() {
        try {
            Object object = this.mux;
            synchronized (object) {
                while (this.pendingSingleUpdates > 0) {
                    U.wait(this.mux);
                }
            }
            return true;
        }
        catch (IgniteInterruptedCheckedException e) {
            U.warn(this.log, "Failed to wait for partition map updates, thread was interrupted: " + e);
            return false;
        }
    }

    private void onAffinityInitialized(IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>> fut) {
        try {
            assert (fut.isDone());
            Map<Integer, Map<Integer, List<UUID>>> assignmentChange = fut.get();
            GridDhtPartitionsFullMessage m = this.createPartitionsMessage(false, false);
            CacheAffinityChangeMessage msg = new CacheAffinityChangeMessage(this.exchId, m, assignmentChange);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Centralized affinity exchange, send affinity change message: " + msg);
            }
            this.cctx.discovery().sendCustomEvent(msg);
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
    }

    private void assignPartitionSizes(GridDhtPartitionTopology top) {
        HashMap<Integer, Long> partSizes = new HashMap<Integer, Long>();
        for (Map.Entry e : this.msgs.entrySet()) {
            GridDhtPartitionsSingleMessage singleMsg = (GridDhtPartitionsSingleMessage)e.getValue();
            GridDhtPartitionMap partMap = singleMsg.partitions().get(top.groupId());
            if (partMap == null) continue;
            for (Map.Entry<Integer, GridDhtPartitionState> e0 : partMap.entrySet()) {
                int p = e0.getKey();
                GridDhtPartitionState state = e0.getValue();
                if (state != GridDhtPartitionState.OWNING) continue;
                partSizes.put(p, singleMsg.partitionSizes(top.groupId()).get(p));
            }
        }
        for (GridDhtLocalPartition locPart : top.currentLocalPartitions()) {
            if (locPart.state() != GridDhtPartitionState.OWNING) continue;
            partSizes.put(locPart.id(), locPart.fullSize());
        }
        top.globalPartSizes(partSizes);
    }

    private List<SupplyPartitionInfo> assignPartitionStates(GridDhtPartitionTopology top, boolean resetOwners) {
        HashMap<Integer, CounterWithNodes> maxCntrs = new HashMap<Integer, CounterWithNodes>();
        HashMap<Integer, TreeSet<Long>> varCntrs = new HashMap<Integer, TreeSet<Long>>();
        for (Map.Entry e : this.msgs.entrySet()) {
            CachePartitionPartialCountersMap nodeCntrs = ((GridDhtPartitionsSingleMessage)e.getValue()).partitionUpdateCounters(top.groupId(), top.partitions());
            assert (nodeCntrs != null);
            for (int i = 0; i < nodeCntrs.size(); ++i) {
                int p = nodeCntrs.partitionAt(i);
                UUID remoteNodeId = (UUID)e.getKey();
                GridDhtPartitionState state = top.partitionState(remoteNodeId, p);
                if (state != GridDhtPartitionState.OWNING && state != GridDhtPartitionState.MOVING) continue;
                long cntr = state == GridDhtPartitionState.MOVING ? nodeCntrs.initialUpdateCounterAt(i) : nodeCntrs.updateCounterAt(i);
                varCntrs.computeIfAbsent(p, key -> new TreeSet()).add(cntr);
                if (state != GridDhtPartitionState.OWNING) continue;
                CounterWithNodes maxCntr = (CounterWithNodes)maxCntrs.get(p);
                if (maxCntr == null || cntr > maxCntr.cnt) {
                    maxCntrs.put(p, new CounterWithNodes(cntr, ((GridDhtPartitionsSingleMessage)e.getValue()).partitionSizes(top.groupId()).get(p), remoteNodeId));
                    continue;
                }
                if (cntr != maxCntr.cnt) continue;
                maxCntr.nodes.add(remoteNodeId);
            }
        }
        for (GridDhtLocalPartition part : top.currentLocalPartitions()) {
            GridDhtPartitionState state = top.partitionState(this.cctx.localNodeId(), part.id());
            if (state != GridDhtPartitionState.OWNING && state != GridDhtPartitionState.MOVING) continue;
            long cntr = state == GridDhtPartitionState.MOVING ? part.initialUpdateCounter() : part.updateCounter();
            varCntrs.computeIfAbsent(part.id(), key -> new TreeSet()).add(cntr);
            if (state != GridDhtPartitionState.OWNING) continue;
            CounterWithNodes maxCntr = (CounterWithNodes)maxCntrs.get(part.id());
            if (maxCntr == null && cntr == 0L) {
                CounterWithNodes cntrObj = new CounterWithNodes(0L, 0L, this.cctx.localNodeId());
                for (UUID nodeId : this.msgs.keySet()) {
                    if (top.partitionState(nodeId, part.id()) != GridDhtPartitionState.OWNING) continue;
                    cntrObj.nodes.add(nodeId);
                }
                maxCntrs.put(part.id(), cntrObj);
                continue;
            }
            if (maxCntr == null || cntr > maxCntr.cnt) {
                maxCntrs.put(part.id(), new CounterWithNodes(cntr, part.fullSize(), this.cctx.localNodeId()));
                continue;
            }
            if (cntr != maxCntr.cnt) continue;
            maxCntr.nodes.add(this.cctx.localNodeId());
        }
        HashSet<Integer> haveHistory = new HashSet<Integer>();
        List<SupplyPartitionInfo> list = this.assignHistoricalSuppliers(top, maxCntrs, varCntrs, haveHistory);
        if (resetOwners) {
            this.resetOwnersByCounter(top, maxCntrs, haveHistory);
        }
        return list;
    }

    private void resetOwnersByCounter(GridDhtPartitionTopology top, Map<Integer, CounterWithNodes> maxCntrs, Set<Integer> haveHistory) {
        HashMap<Integer, Set<UUID>> ownersByUpdCounters = U.newHashMap(maxCntrs.size());
        HashMap<Integer, Long> partSizes = U.newHashMap(maxCntrs.size());
        for (Map.Entry<Integer, CounterWithNodes> e : maxCntrs.entrySet()) {
            ownersByUpdCounters.put(e.getKey(), e.getValue().nodes);
            partSizes.put(e.getKey(), e.getValue().size);
        }
        top.globalPartSizes(partSizes);
        Map<UUID, Set<Integer>> partitionsToRebalance = top.resetOwners(ownersByUpdCounters, haveHistory, this);
        for (Map.Entry<UUID, Set<Integer>> e : partitionsToRebalance.entrySet()) {
            UUID nodeId = e.getKey();
            Set<Integer> parts = e.getValue();
            for (int part : parts) {
                this.partsToReload.put(nodeId, top.groupId(), part);
            }
        }
    }

    private List<SupplyPartitionInfo> assignHistoricalSuppliers(GridDhtPartitionTopology top, Map<Integer, CounterWithNodes> maxCntrs, Map<Integer, TreeSet<Long>> varCntrs, Set<Integer> haveHistory) {
        Map<Integer, Map<Integer, Long>> partHistReserved0 = this.partHistReserved;
        int grpId = top.groupId();
        Map<Integer, Long> localReserved = partHistReserved0 != null ? partHistReserved0.get(grpId) : null;
        ArrayList<SupplyPartitionInfo> list = new ArrayList<SupplyPartitionInfo>();
        for (Map.Entry<Integer, TreeSet<Long>> e : varCntrs.entrySet()) {
            Long localHistCntr;
            int p = e.getKey();
            CounterWithNodes maxCntrObj = maxCntrs.get(p);
            long maxCntr = maxCntrObj != null ? maxCntrObj.cnt : 0L;
            NavigableSet<Long> nonMaxCntrs = e.getValue().headSet(maxCntr, false).tailSet(0L, false);
            if (nonMaxCntrs.isEmpty()) continue;
            T2<Object, Long> deepestReserved = new T2<Object, Long>(null, Long.MAX_VALUE);
            if (localReserved != null && (localHistCntr = localReserved.get(p)) != null && maxCntrObj.nodes.contains(this.cctx.localNodeId())) {
                this.findCounterForReservation(grpId, p, maxCntr, localHistCntr, maxCntrObj.size, this.cctx.localNodeId(), nonMaxCntrs, haveHistory, deepestReserved);
            }
            for (Map.Entry e0 : this.msgs.entrySet()) {
                Long histCntr = ((GridDhtPartitionsSingleMessage)e0.getValue()).partitionHistoryCounters(grpId).get(p);
                if (histCntr == null || !maxCntrObj.nodes.contains(e0.getKey())) continue;
                this.findCounterForReservation(grpId, p, maxCntr, histCntr, maxCntrObj.size, (UUID)e0.getKey(), nonMaxCntrs, haveHistory, deepestReserved);
            }
            if (haveHistory.contains(p)) continue;
            list.add(new SupplyPartitionInfo(p, (Long)nonMaxCntrs.last(), (Long)deepestReserved.get2(), (UUID)deepestReserved.get1()));
        }
        return list;
    }

    private void findCounterForReservation(int grpId, int p, long maxOwnerCntr, Long ownerReservedHistCntr, long ownerSize, UUID ownerId, NavigableSet<Long> nonMaxCntrs, Set<Integer> haveHistory, T2<UUID, Long> deepestReserved) {
        Long ceilingMinReserved;
        boolean preferWalRebalance = ((GridCacheDatabaseSharedManager)this.cctx.database()).preferWalRebalance();
        while (!nonMaxCntrs.isEmpty() && (ceilingMinReserved = nonMaxCntrs.ceiling(ownerReservedHistCntr)) != null) {
            if (preferWalRebalance || maxOwnerCntr - ceilingMinReserved < ownerSize) {
                this.partHistSuppliers.put(ownerId, grpId, p, ceilingMinReserved);
                haveHistory.add(p);
                break;
            }
            nonMaxCntrs = nonMaxCntrs.tailSet(ceilingMinReserved, false);
        }
        if ((Long)deepestReserved.get2() > ownerReservedHistCntr) {
            deepestReserved.set(ownerId, ownerReservedHistCntr);
        }
    }

    private void detectLostPartitions(AffinityTopologyVersion resTopVer) {
        try {
            IgniteUtils.doInParallelUninterruptibly(U.availableThreadCount(this.cctx.kernalContext(), (byte)2, 2), this.cctx.kernalContext().pools().getSystemExecutorService(), this.cctx.affinity().cacheGroups().values(), desc -> {
                if (desc.config().getCacheMode() == CacheMode.LOCAL) {
                    return null;
                }
                CacheGroupContext grp = this.cctx.cache().cacheGroup(desc.groupId());
                GridDhtPartitionTopology top = grp != null ? grp.topology() : this.cctx.exchange().clientTopology(desc.groupId(), this.events().discoveryCache());
                top.detectLostPartitions(resTopVer, this);
                return null;
            });
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        this.timeBag.finishGlobalStage("Detect lost partitions");
    }

    private void resetLostPartitions(Collection<String> cacheNames) {
        assert (!this.exchCtx.mergeExchanges());
        try {
            IgniteUtils.doInParallelUninterruptibly(U.availableThreadCount(this.cctx.kernalContext(), (byte)2, 2), this.cctx.kernalContext().pools().getSystemExecutorService(), this.cctx.affinity().caches().values(), desc -> {
                if (desc.cacheConfiguration().getCacheMode() == CacheMode.LOCAL) {
                    return null;
                }
                if (cacheNames.contains(desc.cacheName())) {
                    CacheGroupContext grp = this.cctx.cache().cacheGroup(desc.groupId());
                    GridDhtPartitionTopology top = grp != null ? grp.topology() : this.cctx.exchange().clientTopology(desc.groupId(), this.events().discoveryCache());
                    top.resetLostPartitions(this.initialVersion());
                }
                return null;
            });
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    private IgniteCheckedException createExchangeException(Map<UUID, Exception> globalExceptions) {
        IgniteCheckedException ex = new IgniteCheckedException("Failed to complete exchange process.");
        for (Map.Entry<UUID, Exception> entry : globalExceptions.entrySet()) {
            if (ex == entry.getValue()) continue;
            ex.addSuppressed(entry.getValue());
        }
        return ex;
    }

    private boolean isRollbackSupported() {
        if (!this.firstEvtDiscoCache.checkAttribute("org.apache.ignite.dynamic.cache.start.rollback.supported", Boolean.TRUE)) {
            return false;
        }
        return this.firstDiscoEvt.type() == 18 && this.dynamicCacheStartExchange();
    }

    private void sendExchangeFailureMessage() {
        assert (this.crd != null && this.crd.isLocal());
        try {
            IgniteCheckedException err = this.createExchangeException(this.exchangeGlobalExceptions);
            ArrayList<String> cacheNames = new ArrayList<String>(this.exchActions.cacheStartRequests().size());
            for (ExchangeActions.CacheActionData actionData : this.exchActions.cacheStartRequests()) {
                cacheNames.add(actionData.request().cacheName());
            }
            DynamicCacheChangeFailureMessage msg = new DynamicCacheChangeFailureMessage(this.cctx.localNode(), this.exchId, err, cacheNames);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dynamic cache change failed (send message to all participating nodes): " + msg);
            }
            this.cacheChangeFailureMsgSent = true;
            this.cctx.discovery().sendCustomEvent(msg);
            return;
        }
        catch (IgniteCheckedException e) {
            if (this.reconnectOnError(e)) {
                this.onDone(new IgniteNeedReconnectException(this.cctx.localNode(), (Throwable)e));
            } else {
                this.onDone(e);
            }
            return;
        }
    }

    private void onAllReceived(@Nullable Collection<ClusterNode> sndResNodes) {
        try {
            this.initFut.get();
            this.span.addLog(() -> "Waiting for all single messages");
            this.timeBag.finishGlobalStage("Waiting for all single messages");
            assert (this.crd.isLocal());
            assert (this.partHistSuppliers.isEmpty()) : this.partHistSuppliers;
            if (!this.exchCtx.mergeExchanges() && !this.crd.equals(this.events().discoveryCache().serverNodes().get(0))) {
                for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                    if (grp.isLocal()) continue;
                    if (grp.affinity().lastVersion().topologyVersion() > 0L) {
                        grp.topology().beforeExchange(this, !this.centralizedAff && !this.forceAffReassignment, false);
                        continue;
                    }
                    assert (this.exchangeLocE != null) : "Affinity is not calculated for the cache group [groupName=" + grp.name() + "]";
                }
            }
            if (this.exchCtx.mergeExchanges()) {
                AffinityTopologyVersion threshold;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Coordinator received all messages, try merge [ver=" + this.initialVersion() + ']');
                }
                AffinityTopologyVersion affinityTopologyVersion = threshold = this.newCrdFut != null ? this.newCrdFut.resultTopologyVersion() : null;
                if (threshold != null) assert (this.newCrdFut.fullMessage() == null) : "There is full message in new coordinator future, but exchange was not finished using it: " + this.newCrdFut.fullMessage();
                boolean finish = this.cctx.exchange().mergeExchangesOnCoordinator(this, threshold);
                this.timeBag.finishGlobalStage("Exchanges merge");
                if (!finish) {
                    return;
                }
            }
            this.finishExchangeOnCoordinator(sndResNodes);
        }
        catch (IgniteCheckedException e) {
            if (this.reconnectOnError(e)) {
                this.onDone(new IgniteNeedReconnectException(this.cctx.localNode(), (Throwable)e));
            }
            this.onDone(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishExchangeOnCoordinator(@Nullable Collection<ClusterNode> sndResNodes) {
        if (this.isDone() || !this.enterBusy()) {
            return;
        }
        try {
            Object cacheGroupsToResetOwners;
            if (!F.isEmpty(this.exchangeGlobalExceptions) && this.dynamicCacheStartExchange() && this.isRollbackSupported()) {
                this.sendExchangeFailureMessage();
                return;
            }
            AffinityTopologyVersion resTopVer = this.exchCtx.events().topologyVersion();
            if (this.log.isInfoEnabled()) {
                this.log.info("finishExchangeOnCoordinator [topVer=" + this.initialVersion() + ", resVer=" + resTopVer + ']');
            }
            Map<Integer, CacheGroupAffinityMessage> idealAffDiff = null;
            int parallelismLvl = U.availableThreadCount(this.cctx.kernalContext(), (byte)2, 2);
            if (this.exchCtx.mergeExchanges()) {
                Object object = this.mux;
                synchronized (object) {
                    if (this.mergedJoinExchMsgs != null) {
                        for (Map.Entry<UUID, GridDhtPartitionsSingleMessage> e : this.mergedJoinExchMsgs.entrySet()) {
                            this.msgs.put(e.getKey(), e.getValue());
                            this.updatePartitionSingleMap(e.getKey(), e.getValue());
                        }
                    }
                }
                assert (this.exchCtx.events().hasServerJoin() || this.exchCtx.events().hasServerLeft());
                this.exchCtx.events().processEvents(this);
                if (this.exchCtx.events().hasServerLeft()) {
                    idealAffDiff = this.cctx.affinity().onServerLeftWithExchangeMergeProtocol(this);
                } else {
                    this.cctx.affinity().onServerJoinWithExchangeMergeProtocol(this, true);
                }
                IgniteUtils.doInParallel(parallelismLvl, this.cctx.kernalContext().pools().getSystemExecutorService(), this.cctx.affinity().cacheGroups().values(), desc -> {
                    if (desc.config().getCacheMode() == CacheMode.LOCAL) {
                        return null;
                    }
                    CacheGroupContext grp = this.cctx.cache().cacheGroup(desc.groupId());
                    GridDhtPartitionTopology top = grp != null ? grp.topology() : this.cctx.exchange().clientTopology(desc.groupId(), this.events().discoveryCache());
                    top.beforeExchange(this, true, true);
                    return null;
                });
            }
            this.span.addLog(() -> "Affinity recalculation (crd)");
            this.timeBag.finishGlobalStage("Affinity recalculation (crd)");
            ConcurrentHashMap<Integer, CacheGroupAffinityMessage> joinedNodeAff = new ConcurrentHashMap<Integer, CacheGroupAffinityMessage>(this.cctx.cache().cacheGroups().size());
            IgniteUtils.doInParallel(parallelismLvl, this.cctx.kernalContext().pools().getSystemExecutorService(), this.msgs.values(), msg -> {
                this.processSingleMessageOnCrdFinish((GridDhtPartitionsSingleMessage)msg, (Map<Integer, CacheGroupAffinityMessage>)joinedNodeAff);
                return null;
            });
            this.timeBag.finishGlobalStage("Collect update counters and create affinity messages");
            if (this.firstDiscoEvt.type() == 18) {
                Object discoveryCustomMessage;
                assert (this.firstDiscoEvt instanceof DiscoveryCustomEvent);
                if (this.activateCluster() || this.changedBaseline()) {
                    this.assignPartitionsStates(null);
                }
                if ((discoveryCustomMessage = ((DiscoveryCustomEvent)this.firstDiscoEvt).customMessage()) instanceof DynamicCacheChangeBatch) {
                    if (this.exchActions != null) {
                        Set<String> caches = this.exchActions.cachesToResetLostPartitions();
                        if (!F.isEmpty(caches)) {
                            this.resetLostPartitions(caches);
                        }
                        cacheGroupsToResetOwners = Stream.concat(this.exchActions.cacheGroupsToStart().stream().map(grp -> grp.descriptor().groupId()), this.exchActions.cachesToResetLostPartitions().stream().map(GridCacheUtils::cacheId)).collect(Collectors.toSet());
                        this.assignPartitionsStates((Set<Integer>)cacheGroupsToResetOwners);
                    }
                } else if (discoveryCustomMessage instanceof SnapshotDiscoveryMessage && ((SnapshotDiscoveryMessage)discoveryCustomMessage).needAssignPartitions()) {
                    this.markAffinityReassign();
                    this.assignPartitionsStates(null);
                }
            } else if (this.exchCtx.events().hasServerJoin()) {
                this.assignPartitionsStates(null);
            } else if (this.exchCtx.events().hasServerLeft()) {
                this.assignPartitionsStates(Collections.emptySet());
            }
            this.validatePartitionsState();
            if (!this.exchCtx.mergeExchanges() && this.forceAffReassignment) {
                idealAffDiff = this.cctx.affinity().onCustomEventWithEnforcedAffinityReassignment(this);
                this.timeBag.finishGlobalStage("Ideal affinity diff calculation (enforced)");
            }
            for (CacheGroupContext grpCtx : this.cctx.cache().cacheGroups()) {
                if (grpCtx.isLocal()) continue;
                grpCtx.topology().applyUpdateCounters();
            }
            this.timeBag.finishGlobalStage("Apply update counters");
            this.updateLastVersion(this.cctx.versions().last());
            this.cctx.versions().onExchange(this.lastVer.get().order());
            IgniteProductVersion minVer = this.exchCtx.events().discoveryCache().minimumNodeVersion();
            GridDhtPartitionsFullMessage msg2 = this.createPartitionsMessage(true, minVer.compareToIgnoreTimestamp(CachePartitionPartialCountersMap.PARTIAL_COUNTERS_MAP_SINCE) >= 0);
            if (!this.cctx.affinity().rebalanceRequired() && !this.deactivateCluster()) {
                msg2.rebalanced(true);
            }
            if (this.exchCtx.mergeExchanges()) {
                assert (!this.centralizedAff);
                msg2.resultTopologyVersion(resTopVer);
                if (this.exchCtx.events().hasServerLeft()) {
                    msg2.idealAffinityDiff(idealAffDiff);
                }
            } else if (this.forceAffReassignment) {
                msg2.idealAffinityDiff(idealAffDiff);
            }
            msg2.prepareMarshal(this.cctx);
            this.timeBag.finishGlobalStage("Full message preparing");
            cacheGroupsToResetOwners = this.mux;
            synchronized (cacheGroupsToResetOwners) {
                this.finishState = new FinishState(this.crd.id(), resTopVer, msg2);
                this.state = ExchangeLocalState.DONE;
            }
            if (this.centralizedAff) {
                assert (!this.exchCtx.mergeExchanges());
                IgniteInternalFuture<Map<Integer, Map<Integer, List<UUID>>>> fut = this.cctx.affinity().initAffinityOnNodeLeft(this);
                if (!fut.isDone()) {
                    fut.listen(this::onAffinityInitialized);
                } else {
                    this.onAffinityInitialized(fut);
                }
            } else {
                Map<UUID, GridDhtPartitionsSingleMessage> mergedJoinExchMsgs0;
                LinkedHashSet<ClusterNode> nodes;
                Iterator<Map.Entry<UUID, GridDhtPartitionsSingleMessage>> iterator = this.mux;
                synchronized (iterator) {
                    this.srvNodes.remove(this.cctx.localNode());
                    nodes = new LinkedHashSet<ClusterNode>(this.srvNodes);
                    mergedJoinExchMsgs0 = this.mergedJoinExchMsgs;
                    if (this.mergedJoinExchMsgs != null) {
                        for (Map.Entry<UUID, GridDhtPartitionsSingleMessage> e : this.mergedJoinExchMsgs.entrySet()) {
                            ClusterNode node;
                            if (e.getValue() == null || (node = this.cctx.discovery().node(e.getKey())) == null) continue;
                            nodes.add(node);
                        }
                    } else {
                        mergedJoinExchMsgs0 = Collections.emptyMap();
                    }
                    if (!F.isEmpty(sndResNodes)) {
                        nodes.addAll(sndResNodes);
                    }
                }
                if (msg2.rebalanced()) {
                    this.markRebalanced();
                }
                if (!nodes.isEmpty()) {
                    this.sendAllPartitions(msg2, nodes, mergedJoinExchMsgs0, joinedNodeAff);
                }
                this.timeBag.finishGlobalStage("Full message sending");
                this.discoveryLag = this.calculateDiscoveryLag(this.msgs, mergedJoinExchMsgs0);
                if (!this.stateChangeExchange()) {
                    this.onDone(this.exchCtx.events().topologyVersion(), (Throwable)null);
                }
                for (Map.Entry<UUID, GridDhtPartitionsSingleMessage> e : this.pendingSingleMsgs.entrySet()) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Process pending message on coordinator [node=" + e.getKey() + ", ver=" + this.initialVersion() + ", resVer=" + resTopVer + ']');
                    }
                    this.processSingleMessage(e.getKey(), e.getValue());
                }
            }
            if (this.stateChangeExchange()) {
                StateChangeRequest req = this.exchActions.stateChangeRequest();
                assert (req != null) : this.exchActions;
                boolean stateChangeErr = false;
                if (!F.isEmpty(this.exchangeGlobalExceptions)) {
                    stateChangeErr = true;
                    this.cctx.kernalContext().state().onStateChangeError(this.exchangeGlobalExceptions, req);
                } else {
                    boolean hasMoving = !this.partsToReload.isEmpty();
                    Set<Integer> waitGrps = this.cctx.affinity().waitGroups();
                    if (!hasMoving) {
                        for (CacheGroupContext grpCtx : this.cctx.cache().cacheGroups()) {
                            if (!waitGrps.contains(grpCtx.groupId()) || !grpCtx.topology().hasMovingPartitions()) continue;
                            hasMoving = true;
                            break;
                        }
                    }
                    this.cctx.kernalContext().state().onExchangeFinishedOnCoordinator(this, hasMoving);
                }
                if (!this.cctx.kernalContext().state().clusterState().localBaselineAutoAdjustment()) {
                    ClusterState state = stateChangeErr ? ClusterState.INACTIVE : req.state();
                    ChangeGlobalStateFinishMessage stateFinishMsg = new ChangeGlobalStateFinishMessage(req.requestId(), state, !stateChangeErr);
                    this.cctx.discovery().sendCustomEvent(stateFinishMsg);
                }
                this.timeBag.finishGlobalStage("State finish message sending");
                if (!this.centralizedAff) {
                    this.onDone(this.exchCtx.events().topologyVersion(), (Throwable)null);
                }
            }
            if (!this.centralizedAff && this.isDone() && this.error() == null && !this.cctx.kernalContext().isStopping()) {
                this.cctx.exchange().checkRebalanceState();
            }
        }
        catch (IgniteCheckedException e) {
            if (this.reconnectOnError(e)) {
                this.onDone(new IgniteNeedReconnectException(this.cctx.localNode(), (Throwable)e));
            } else {
                this.onDone(e);
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    private void processSingleMessageOnCrdFinish(GridDhtPartitionsSingleMessage msg, Map<Integer, CacheGroupAffinityMessage> messageAccumulator) {
        for (Map.Entry<Integer, GridDhtPartitionMap> e : msg.partitions().entrySet()) {
            GridDhtPartitionTopology top;
            Integer grpId = e.getKey();
            CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId);
            GridDhtPartitionTopology gridDhtPartitionTopology = top = grp != null ? grp.topology() : this.cctx.exchange().clientTopology(grpId, this.events().discoveryCache());
            CachePartitionPartialCountersMap cntrs = msg.partitionUpdateCounters(grpId, top.partitions());
            if (cntrs == null) continue;
            top.collectUpdateCounters(cntrs);
        }
        Collection<Integer> affReq = msg.cacheGroupsAffinityRequest();
        if (affReq != null) {
            CacheGroupAffinityMessage.createAffinityMessages(this.cctx, this.exchCtx.events().topologyVersion(), affReq, messageAccumulator);
        }
    }

    private List<CacheGroupDescriptor> nonLocalCacheGroupDescriptors() {
        return this.cctx.affinity().cacheGroups().values().stream().filter(grpDesc -> grpDesc.config().getCacheMode() != CacheMode.LOCAL).collect(Collectors.toList());
    }

    private List<CacheGroupContext> nonLocalCacheGroups() {
        return this.cctx.cache().cacheGroups().stream().filter(grp -> !grp.isLocal() && !this.cacheGroupStopping(grp.groupId())).collect(Collectors.toList());
    }

    private void validatePartitionsState() {
        try {
            U.doInParallel(this.cctx.kernalContext().pools().getSystemExecutorService(), this.nonLocalCacheGroupDescriptors(), grpDesc -> {
                CacheGroupContext grpCtx = this.cctx.cache().cacheGroup(grpDesc.groupId());
                GridDhtPartitionTopology top = grpCtx != null ? grpCtx.topology() : this.cctx.exchange().clientTopology(grpDesc.groupId(), this.events().discoveryCache());
                boolean customExpiryPlc = Optional.ofNullable(grpCtx).map(CacheGroupContext::caches).orElseGet(Collections::emptyList).stream().anyMatch(ctx -> ctx.expiry() != null && !(ctx.expiry() instanceof EternalExpiryPolicy));
                if (grpCtx == null || grpCtx.config().isReadThrough() || grpCtx.config().isWriteThrough() || grpCtx.config().getCacheStoreFactory() != null || grpCtx.config().getRebalanceDelay() == -1L || grpCtx.config().getRebalanceMode() == CacheRebalanceMode.NONE || customExpiryPlc || SKIP_PARTITION_SIZE_VALIDATION) {
                    return null;
                }
                try {
                    this.validator.validatePartitionCountersAndSizes(this, top, this.msgs);
                }
                catch (IgniteCheckedException ex) {
                    this.log.warning(String.format(PARTITION_STATE_FAILED_MSG, grpCtx.cacheOrGroupName(), ex.getMessage()));
                }
                return null;
            });
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to validate partitions state", e);
        }
        this.timeBag.finishGlobalStage("Validate partitions states");
    }

    private void assignPartitionsStates(Set<Integer> cacheGroupsToResetOwners) {
        ConcurrentHashMap<String, List<SupplyPartitionInfo>> supplyInfoMap = this.log.isInfoEnabled() ? new ConcurrentHashMap<String, List<SupplyPartitionInfo>>() : null;
        try {
            U.doInParallel(this.cctx.kernalContext().pools().getSystemExecutorService(), this.nonLocalCacheGroupDescriptors(), grpDesc -> {
                GridDhtPartitionTopology top;
                CacheGroupContext grpCtx = this.cctx.cache().cacheGroup(grpDesc.groupId());
                GridDhtPartitionTopology gridDhtPartitionTopology = top = grpCtx != null ? grpCtx.topology() : this.cctx.exchange().clientTopology(grpDesc.groupId(), this.events().discoveryCache());
                if (CU.isPersistentCache(grpDesc.config(), this.cctx.gridConfig().getDataStorageConfiguration())) {
                    List<SupplyPartitionInfo> list = cacheGroupsToResetOwners == null || cacheGroupsToResetOwners.contains(grpDesc.groupId()) ? this.assignPartitionStates(top, true) : this.assignPartitionStates(top, false);
                    if (supplyInfoMap != null && !F.isEmpty(list)) {
                        supplyInfoMap.put(grpDesc.cacheOrGroupName(), list);
                    }
                } else if (cacheGroupsToResetOwners == null) {
                    this.assignPartitionSizes(top);
                }
                return null;
            });
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to assign partition states", e);
        }
        if (!F.isEmpty(supplyInfoMap)) {
            this.printPartitionRebalancingFully(supplyInfoMap);
        }
        this.timeBag.finishGlobalStage("Assign partitions states");
    }

    private void printPartitionRebalancingFully(Map<String, List<SupplyPartitionInfo>> supplyInfoMap) {
        try {
            if (this.hasPartitionToLog(supplyInfoMap, false)) {
                this.log.info("Partitions weren't present in any history reservation: [" + supplyInfoMap.entrySet().stream().map(entry -> "[grp=" + (String)entry.getKey() + " part=[" + S.compact(((List)entry.getValue()).stream().filter(info -> !info.isHistoryReserved()).map(info -> info.part()).collect(Collectors.toSet())) + "]]").collect(Collectors.joining(", ")) + ']');
            }
            if (this.hasPartitionToLog(supplyInfoMap, true)) {
                this.log.info("Partitions were reserved, but maximum available counter is greater than demanded or WAL contains too many updates: [" + supplyInfoMap.entrySet().stream().map(entry -> "[grp=" + (String)entry.getKey() + ' ' + ((List)entry.getValue()).stream().filter(SupplyPartitionInfo::isHistoryReserved).map(info -> "[part=" + info.part() + ", minCntr=" + info.minCntr() + ", maxReserved=" + info.maxReserved() + ", maxReservedNodeId=" + info.maxReservedNodeId() + ']').collect(Collectors.joining(", ")) + ']').collect(Collectors.joining(", ")) + ']');
            }
        }
        catch (Exception e) {
            this.log.error("An error happened during printing partitions that have no history.", e);
        }
    }

    private boolean hasPartitionToLog(Map<String, List<SupplyPartitionInfo>> supplyInfoMap, boolean reserved) {
        for (List<SupplyPartitionInfo> infos : supplyInfoMap.values()) {
            for (SupplyPartitionInfo info : infos) {
                if (info.isHistoryReserved() != reserved) continue;
                return true;
            }
        }
        return false;
    }

    private void finalizePartitionCounters() {
        int parallelismLvl = U.availableThreadCount(this.cctx.kernalContext(), (byte)2, 2);
        try {
            U.doInParallelUninterruptibly(parallelismLvl, this.cctx.kernalContext().pools().getSystemExecutorService(), this.nonLocalCacheGroups(), grp -> {
                Set<Integer> parts;
                if (this.exchCtx.exchangeFreeSwitch()) {
                    assert (!IgniteSnapshotManager.isSnapshotOperation(this.firstDiscoEvt)) : "Not allowed for taking snapshots: " + this;
                    AffinityTopologyVersion topVer = this.sharedContext().exchange().readyAffinityVersion();
                    parts = grp.affinity().primaryPartitions(this.firstDiscoEvt.eventNode().id(), topVer);
                } else {
                    parts = grp.topology().localPartitionMap().keySet();
                }
                grp.topology().finalizeUpdateCounters(parts);
                return null;
            });
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to finalize partition counters", e);
        }
        this.timeBag.finishGlobalStage("Finalize update counters");
    }

    private void sendAllPartitionsToNode(FinishState finishState, GridDhtPartitionsSingleMessage msg, UUID nodeId) {
        ClusterNode node = this.cctx.node(nodeId);
        if (node == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send partitions, node failed: " + nodeId);
            }
            return;
        }
        GridDhtPartitionsFullMessage fullMsg = finishState.msg.copy();
        Collection<Integer> affReq = msg.cacheGroupsAffinityRequest();
        if (affReq != null) {
            try {
                HashMap<Integer, CacheGroupAffinityMessage> cachesAff = U.newHashMap(affReq.size());
                CacheGroupAffinityMessage.createAffinityMessages(this.cctx, finishState.resTopVer, affReq, cachesAff);
                fullMsg.joinedNodeAffinity(cachesAff);
            }
            catch (IllegalStateException e) {
                Map<UUID, Exception> errs = Collections.singletonMap(nodeId, node.isClient() ? new IgniteNeedReconnectException(node, (Throwable)e) : new IgniteCheckedException(e));
                fullMsg.setErrorsMap(errs);
            }
        }
        if (!fullMsg.exchangeId().equals(msg.exchangeId())) {
            fullMsg = fullMsg.copy();
            fullMsg.exchangeId(msg.exchangeId());
        }
        try {
            this.cctx.io().send(node, (GridCacheMessage)fullMsg, (byte)2);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Full message was sent to node: " + node + ", fullMsg: " + fullMsg);
            }
        }
        catch (ClusterTopologyCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send partitions, node failed: " + node);
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send partitions [node=" + node + ']', e);
        }
    }

    public void onReceiveFullMessage(final ClusterNode node, final GridDhtPartitionsFullMessage msg) {
        assert (msg != null);
        assert (msg.exchangeId() != null) : msg;
        assert (!node.isDaemon()) : node;
        this.initFut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

            @Override
            public void apply(IgniteInternalFuture<Boolean> f) {
                try {
                    if (!f.get().booleanValue()) {
                        return;
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(GridDhtPartitionsExchangeFuture.this.log, "Failed to initialize exchange future: " + this, e);
                    return;
                }
                GridDhtPartitionsExchangeFuture.this.processFullMessage(true, node, msg);
            }
        });
    }

    public void onReceivePartitionRequest(final ClusterNode node, final GridDhtPartitionsSingleRequest msg) {
        assert (!this.cctx.kernalContext().clientNode() || msg.restoreState());
        assert (!node.isDaemon() && !node.isClient()) : node;
        this.initFut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

            @Override
            public void apply(IgniteInternalFuture<Boolean> fut) {
                GridDhtPartitionsExchangeFuture.this.processSinglePartitionRequest(node, msg);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSinglePartitionRequest(ClusterNode node, GridDhtPartitionsSingleRequest msg) {
        FinishState finishState0 = null;
        Object object = this.mux;
        synchronized (object) {
            if (this.crd == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Ignore partitions request, no coordinator [node=" + node.id() + ']');
                }
                return;
            }
            switch (this.state) {
                case DONE: {
                    assert (this.finishState != null);
                    if (node.id().equals(this.finishState.crdId)) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Ignore partitions request, finished exchange with this coordinator: " + msg);
                        }
                        return;
                    }
                    finishState0 = this.finishState;
                    break;
                }
                case CRD: 
                case BECOME_CRD: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Ignore partitions request, node is coordinator: " + msg);
                    }
                    return;
                }
                case SRV: 
                case CLIENT: {
                    if (!this.cctx.discovery().alive(node)) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Ignore partitions request, node is not alive [node=" + node.id() + ']');
                        }
                        return;
                    }
                    if (!msg.restoreState() || node.equals(this.crd)) break;
                    if (node.order() > this.crd.order()) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Received partitions request, change coordinator [oldCrd=" + this.crd.id() + ", newCrd=" + node.id() + ']');
                        }
                        this.crd = node;
                        this.processNonLocalCoordinatorChange(this.crd, node);
                        break;
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Ignore restore state request, coordinator changed [oldCrd=" + this.crd.id() + ", newCrd=" + node.id() + ']');
                    }
                    return;
                }
                default: {
                    assert (false) : this.state;
                    break;
                }
            }
        }
        if (msg.restoreState()) {
            try {
                GridDhtPartitionsSingleMessage res;
                assert (msg.restoreExchangeId() != null) : msg;
                if (this.dynamicCacheStartExchange() && this.exchangeLocE != null) {
                    res = new GridDhtPartitionsSingleMessage(msg.restoreExchangeId(), this.cctx.kernalContext().clientNode(), this.cctx.versions().last(), true);
                    res.setError(this.exchangeLocE);
                } else {
                    res = this.cctx.exchange().createPartitionsSingleMessage(msg.restoreExchangeId(), this.cctx.kernalContext().clientNode(), true, node.version().compareToIgnoreTimestamp(CachePartitionPartialCountersMap.PARTIAL_COUNTERS_MAP_SINCE) >= 0, this.exchActions);
                    if (this.localJoinExchange() && finishState0 == null) {
                        res.cacheGroupsAffinityRequest(this.exchCtx.groupsAffinityRequestOnJoin());
                    }
                }
                res.restoreState(true);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Send restore state response [node=" + node.id() + ", exchVer=" + msg.restoreExchangeId().topologyVersion() + ", hasState=" + (finishState0 != null) + ", affReq=" + !F.isEmpty(res.cacheGroupsAffinityRequest()) + ']');
                }
                res.finishMessage(finishState0 != null ? finishState0.msg : null);
                this.cctx.io().send(node, (GridCacheMessage)res, (byte)2);
            }
            catch (ClusterTopologyCheckedException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Node left during partition exchange [nodeId=" + node.id() + ", exchId=" + this.exchId + ']');
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to send partitions message [node=" + node + ", msg=" + msg + ']', e);
            }
            return;
        }
        try {
            this.sendLocalPartitions(node);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send message to coordinator: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFullMessage(boolean checkCrd, ClusterNode node, GridDhtPartitionsFullMessage msg) {
        try {
            DiscoveryCustomMessage discoveryCustomMessage;
            assert (this.exchId.equals(msg.exchangeId())) : msg;
            assert (msg.lastVersion() != null) : msg;
            this.timeBag.finishGlobalStage("Waiting for Full message");
            if (checkCrd) {
                assert (node != null);
                Object object = this.mux;
                synchronized (object) {
                    if (this.crd == null) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Ignore full message, all server nodes left: " + msg);
                        }
                        return;
                    }
                    switch (this.state) {
                        case CRD: 
                        case BECOME_CRD: {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Ignore full message, node is coordinator: " + msg);
                            }
                            return;
                        }
                        case DONE: {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Ignore full message, future is done: " + msg);
                            }
                            return;
                        }
                        case SRV: 
                        case CLIENT: {
                            AffinityTopologyVersion resVer;
                            Exception e;
                            if (!this.crd.equals(node)) {
                                if (this.log.isInfoEnabled()) {
                                    this.log.info("Received full message from non-coordinator [node=" + node.id() + ", nodeOrder=" + node.order() + ", crd=" + this.crd.id() + ", crdOrder=" + this.crd.order() + ']');
                                }
                                if (node.order() > this.crd.order()) {
                                    this.fullMsgs.put(node, msg);
                                }
                                return;
                            }
                            if (!F.isEmpty(msg.getErrorsMap()) && (e = msg.getErrorsMap().get(this.cctx.localNodeId())) instanceof IgniteNeedReconnectException) {
                                this.onDone(e);
                                return;
                            }
                            AffinityTopologyVersion affinityTopologyVersion = resVer = msg.resultTopologyVersion() != null ? msg.resultTopologyVersion() : this.initialVersion();
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Received full message, will finish exchange [node=" + node.id() + ", resVer=" + resVer + ']');
                            }
                            this.finishState = new FinishState(this.crd.id(), resVer, msg);
                            this.state = ExchangeLocalState.DONE;
                            break;
                        }
                    }
                }
            } else assert (node == null) : node;
            AffinityTopologyVersion resTopVer = this.initialVersion();
            if (this.exchCtx.mergeExchanges()) {
                if (msg.resultTopologyVersion() != null && !this.initialVersion().equals(msg.resultTopologyVersion())) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Received full message, need merge [curFut=" + this.initialVersion() + ", resVer=" + msg.resultTopologyVersion() + ']');
                    }
                    resTopVer = msg.resultTopologyVersion();
                    if (this.cctx.exchange().mergeExchanges(this, msg)) {
                        assert (this.cctx.kernalContext().isStopping() || this.cctx.kernalContext().clientDisconnected());
                        return;
                    }
                    assert (resTopVer.equals(this.exchCtx.events().topologyVersion())) : "Unexpected result version [msgVer=" + resTopVer + ", locVer=" + this.exchCtx.events().topologyVersion() + ']';
                }
                this.exchCtx.events().processEvents(this);
                if (this.localJoinExchange()) {
                    Set<Integer> noAffinityGroups = this.cctx.affinity().onLocalJoin(this, msg.joinedNodeAffinity(), resTopVer);
                    if (!noAffinityGroups.isEmpty()) {
                        List<GridCacheAdapter> closedCaches = this.cctx.cache().blockGateways(noAffinityGroups);
                        closedCaches.forEach(cache -> this.log.warning("Affinity for cache " + cache.context().name() + " has not received from coordinator during local join.  Probably cache is already stopped but not processed on local node yet. Cache proxy will be closed for user interactions for safety."));
                    }
                } else {
                    if (this.exchCtx.events().hasServerLeft()) {
                        this.cctx.affinity().applyAffinityFromFullMessage(this, msg.idealAffinityDiff());
                    } else {
                        this.cctx.affinity().onServerJoinWithExchangeMergeProtocol(this, false);
                    }
                    for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
                        if (grp.isLocal() || this.cacheGroupStopping(grp.groupId())) continue;
                        grp.topology().beforeExchange(this, true, false);
                    }
                }
            } else if (this.localJoinExchange() && !this.exchCtx.fetchAffinityOnJoin()) {
                this.cctx.affinity().onLocalJoin(this, msg.joinedNodeAffinity(), resTopVer);
            } else if (this.forceAffReassignment) {
                this.cctx.affinity().applyAffinityFromFullMessage(this, msg.idealAffinityDiff());
            }
            this.timeBag.finishGlobalStage("Affinity recalculation");
            if (this.dynamicCacheStartExchange() && !F.isEmpty(this.exchangeGlobalExceptions)) {
                assert (this.cctx.localNode().isClient());
                this.onDone(this.exchangeLocE);
                return;
            }
            this.updatePartitionFullMap(resTopVer, msg);
            if (msg.rebalanced()) {
                this.markRebalanced();
            }
            if (this.stateChangeExchange() && !F.isEmpty(msg.getErrorsMap())) {
                this.cctx.kernalContext().state().onStateChangeError(msg.getErrorsMap(), this.exchActions.stateChangeRequest());
            }
            if (this.firstDiscoEvt.type() == 18 && (discoveryCustomMessage = ((DiscoveryCustomEvent)this.firstDiscoEvt).customMessage()) instanceof SnapshotDiscoveryMessage && ((SnapshotDiscoveryMessage)discoveryCustomMessage).needAssignPartitions()) {
                this.markAffinityReassign();
            }
            this.onDone(resTopVer, (Throwable)null);
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
    }

    private void updatePartitionFullMap(AffinityTopologyVersion resTopVer, GridDhtPartitionsFullMessage msg) {
        this.cctx.versions().onExchange(msg.lastVersion().order());
        assert (this.partHistSuppliers.isEmpty());
        this.partHistSuppliers.putAll(msg.partitionHistorySuppliers());
        int parallelismLvl = U.availableThreadCount(this.cctx.kernalContext(), (byte)2, 2);
        try {
            Map<Integer, Map<Integer, Long>> partsSizes = msg.partitionSizes(this.cctx);
            IgniteUtils.doInParallel(parallelismLvl, this.cctx.kernalContext().pools().getSystemExecutorService(), msg.partitions().keySet(), grpId -> {
                CacheGroupContext grp = this.cctx.cache().cacheGroup((int)grpId);
                if (grp != null) {
                    CachePartitionFullCountersMap cntrMap = msg.partitionUpdateCounters((int)grpId, grp.topology().partitions());
                    grp.topology().update(resTopVer, msg.partitions().get(grpId), cntrMap, msg.partsToReload(this.cctx.localNodeId(), (int)grpId), partsSizes.getOrDefault(grpId, Collections.emptyMap()), null, this, msg.lostPartitions((int)grpId));
                } else {
                    GridDhtPartitionTopology top = this.cctx.exchange().clientTopology((int)grpId, this.events().discoveryCache());
                    CachePartitionFullCountersMap cntrMap = msg.partitionUpdateCounters((int)grpId, top.partitions());
                    top.update(resTopVer, msg.partitions().get(grpId), cntrMap, Collections.emptySet(), null, null, this, msg.lostPartitions((int)grpId));
                }
                return null;
            });
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        this.timeBag.finishGlobalStage("Full map updating");
    }

    private void updatePartitionSingleMap(UUID nodeId, GridDhtPartitionsSingleMessage msg) {
        this.msgs.put(nodeId, msg);
        for (Map.Entry<Integer, GridDhtPartitionMap> entry : msg.partitions().entrySet()) {
            Integer grpId = entry.getKey();
            CacheGroupContext grp = this.cctx.cache().cacheGroup(grpId);
            GridDhtPartitionTopology top = grp != null ? grp.topology() : this.cctx.exchange().clientTopology(grpId, this.events().discoveryCache());
            top.update(this.exchId, entry.getValue(), false);
        }
    }

    public void onDynamicCacheChangeFail(ClusterNode node, final DynamicCacheChangeFailureMessage msg) {
        assert (this.exchId.equals(msg.exchangeId())) : msg;
        assert (this.firstDiscoEvt.type() == 18 && this.dynamicCacheStartExchange());
        final ExchangeActions actions = this.exchangeActions();
        this.onDiscoveryEvent(new IgniteRunnable(){

            @Override
            public void run() {
                GridDhtPartitionsExchangeFuture.this.cctx.kernalContext().pools().getSystemExecutorService().submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (GridDhtPartitionsExchangeFuture.this.isDone() || !GridDhtPartitionsExchangeFuture.this.enterBusy()) {
                            return;
                        }
                        try {
                            assert (msg.error() != null) : msg;
                            GridDhtPartitionsExchangeFuture.this.cctx.affinity().forceCloseCaches(GridDhtPartitionsExchangeFuture.this, GridDhtPartitionsExchangeFuture.this.crd.isLocal(), msg.exchangeActions());
                            Object object = GridDhtPartitionsExchangeFuture.this.mux;
                            synchronized (object) {
                                GridDhtPartitionsExchangeFuture.this.finishState = new FinishState(GridDhtPartitionsExchangeFuture.this.crd.id(), GridDhtPartitionsExchangeFuture.this.initialVersion(), null);
                                GridDhtPartitionsExchangeFuture.this.state = ExchangeLocalState.DONE;
                            }
                            if (actions != null) {
                                actions.completeRequestFutures(GridDhtPartitionsExchangeFuture.this.cctx, msg.error());
                            }
                            GridDhtPartitionsExchangeFuture.this.onDone(GridDhtPartitionsExchangeFuture.this.exchId.topologyVersion());
                        }
                        catch (Throwable e) {
                            GridDhtPartitionsExchangeFuture.this.onDone(e);
                        }
                        finally {
                            GridDhtPartitionsExchangeFuture.this.leaveBusy();
                        }
                    }
                });
            }
        });
    }

    public void onAffinityChangeMessage(final ClusterNode node, final CacheAffinityChangeMessage msg) {
        assert (this.exchId.equals(msg.exchangeId())) : msg;
        this.onDiscoveryEvent(new IgniteRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (GridDhtPartitionsExchangeFuture.this.isDone() || !GridDhtPartitionsExchangeFuture.this.enterBusy()) {
                    return;
                }
                try {
                    assert (GridDhtPartitionsExchangeFuture.this.centralizedAff);
                    if (GridDhtPartitionsExchangeFuture.this.crd.equals(node)) {
                        IgniteCheckedException err;
                        AffinityTopologyVersion resTopVer = GridDhtPartitionsExchangeFuture.this.initialVersion();
                        GridDhtPartitionsExchangeFuture.this.cctx.affinity().onExchangeChangeAffinityMessage(GridDhtPartitionsExchangeFuture.this, msg);
                        IgniteCheckedException igniteCheckedException = err = !F.isEmpty(msg.partitionsMessage().getErrorsMap()) ? new IgniteCheckedException("Cluster state change failed.") : null;
                        if (!GridDhtPartitionsExchangeFuture.this.crd.isLocal()) {
                            GridDhtPartitionsFullMessage partsMsg = msg.partitionsMessage();
                            assert (partsMsg != null) : msg;
                            assert (partsMsg.lastVersion() != null) : partsMsg;
                            GridDhtPartitionsExchangeFuture.this.updatePartitionFullMap(resTopVer, partsMsg);
                            if (GridDhtPartitionsExchangeFuture.this.exchActions != null && GridDhtPartitionsExchangeFuture.this.exchActions.stateChangeRequest() != null && err != null) {
                                GridDhtPartitionsExchangeFuture.this.cctx.kernalContext().state().onStateChangeError(msg.partitionsMessage().getErrorsMap(), GridDhtPartitionsExchangeFuture.this.exchActions.stateChangeRequest());
                            }
                        }
                        GridDhtPartitionsExchangeFuture.this.onDone(resTopVer, (Throwable)err);
                    } else if (GridDhtPartitionsExchangeFuture.this.log.isDebugEnabled()) {
                        GridDhtPartitionsExchangeFuture.this.log.debug("Ignore affinity change message, coordinator changed [node=" + node.id() + ", crd=" + GridDhtPartitionsExchangeFuture.this.crd.id() + ", msg=" + msg + ']');
                    }
                }
                finally {
                    GridDhtPartitionsExchangeFuture.this.leaveBusy();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDiscoveryEvent(IgniteRunnable c) {
        List<IgniteRunnable> list = this.discoEvts;
        synchronized (list) {
            if (!this.init) {
                this.discoEvts.add(c);
                return;
            }
            assert (this.discoEvts.isEmpty()) : this.discoEvts;
        }
        c.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDone() {
        while (!this.isDone()) {
            ArrayList<IgniteRunnable> evts;
            List<IgniteRunnable> list = this.discoEvts;
            synchronized (list) {
                if (this.discoEvts.isEmpty()) {
                    this.init = true;
                    break;
                }
                evts = new ArrayList<IgniteRunnable>(this.discoEvts);
                this.discoEvts.clear();
            }
            for (IgniteRunnable c : evts) {
                c.run();
            }
        }
        this.initFut.onDone(true);
    }

    private void onAllServersLeft() {
        assert (this.cctx.kernalContext().clientNode()) : this.cctx.localNode();
        List empty = Collections.emptyList();
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            ArrayList<List<ClusterNode>> affAssignment = new ArrayList<List<ClusterNode>>(grp.affinity().partitions());
            for (int i = 0; i < grp.affinity().partitions(); ++i) {
                affAssignment.add(empty);
            }
            grp.affinity().idealAssignment(this.initialVersion(), affAssignment);
            grp.affinity().initialize(this.initialVersion(), affAssignment);
            this.cctx.exchange().exchangerUpdateHeartbeat();
        }
    }

    public void onNodeLeft(final ClusterNode node) {
        if (this.isDone() || !this.enterBusy()) {
            return;
        }
        try {
            this.onDiscoveryEvent(new IgniteRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (GridDhtPartitionsExchangeFuture.this.isDone()) return;
                    if (!GridDhtPartitionsExchangeFuture.this.enterBusy()) {
                        return;
                    }
                    try {
                        boolean crdChanged = false;
                        boolean allReceived = false;
                        boolean wasMerged = false;
                        GridDhtPartitionsExchangeFuture.this.events().discoveryCache().updateAlives(node);
                        Object object = GridDhtPartitionsExchangeFuture.this.mux;
                        // MONITORENTER : object
                        InitNewCoordinatorFuture newCrdFut0 = GridDhtPartitionsExchangeFuture.this.newCrdFut;
                        // MONITOREXIT : object
                        if (newCrdFut0 != null) {
                            newCrdFut0.onNodeLeft(node.id());
                        }
                        object = GridDhtPartitionsExchangeFuture.this.mux;
                        // MONITORENTER : object
                        GridDhtPartitionsExchangeFuture.this.srvNodes.remove(node);
                        boolean rmvd = GridDhtPartitionsExchangeFuture.this.remaining.remove(node.id());
                        if (!rmvd && GridDhtPartitionsExchangeFuture.this.mergedJoinExchMsgs != null && GridDhtPartitionsExchangeFuture.this.mergedJoinExchMsgs.containsKey(node.id()) && GridDhtPartitionsExchangeFuture.this.mergedJoinExchMsgs.get(node.id()) == null) {
                            GridDhtPartitionsExchangeFuture.this.mergedJoinExchMsgs.remove(node.id());
                            wasMerged = true;
                            rmvd = true;
                            GridDhtPartitionsExchangeFuture.this.awaitMergedMsgs--;
                            assert (GridDhtPartitionsExchangeFuture.this.awaitMergedMsgs >= 0) : "exchFut=" + this + ", node=" + node;
                        }
                        if (node.equals(GridDhtPartitionsExchangeFuture.this.crd)) {
                            crdChanged = true;
                            GridDhtPartitionsExchangeFuture.this.crd = !GridDhtPartitionsExchangeFuture.this.srvNodes.isEmpty() ? (ClusterNode)GridDhtPartitionsExchangeFuture.this.srvNodes.get(0) : null;
                        }
                        switch (GridDhtPartitionsExchangeFuture.this.state) {
                            case DONE: {
                                // MONITOREXIT : object
                                return;
                            }
                            case CRD: {
                                allReceived = rmvd && GridDhtPartitionsExchangeFuture.this.remaining.isEmpty() && GridDhtPartitionsExchangeFuture.this.awaitMergedMsgs == 0;
                                break;
                            }
                            case SRV: {
                                assert (GridDhtPartitionsExchangeFuture.this.crd != null);
                                if (!crdChanged || !GridDhtPartitionsExchangeFuture.this.crd.isLocal()) break;
                                GridDhtPartitionsExchangeFuture.this.state = ExchangeLocalState.BECOME_CRD;
                                GridDhtPartitionsExchangeFuture.this.newCrdFut = new InitNewCoordinatorFuture(GridDhtPartitionsExchangeFuture.this.cctx);
                                break;
                            }
                        }
                        ClusterNode crd0 = GridDhtPartitionsExchangeFuture.this.crd;
                        if (crd0 == null) {
                            GridDhtPartitionsExchangeFuture.this.finishState = new FinishState(null, GridDhtPartitionsExchangeFuture.this.initialVersion(), null);
                        }
                        if (GridDhtPartitionsExchangeFuture.this.dynamicCacheStartExchange() && GridDhtPartitionsExchangeFuture.this.exchangeLocE == null && GridDhtPartitionsExchangeFuture.this.exchActions.cacheStartRequiredAliveNodes().contains(node.id())) {
                            GridDhtPartitionsExchangeFuture.this.exchangeGlobalExceptions.put(GridDhtPartitionsExchangeFuture.this.cctx.localNodeId(), GridDhtPartitionsExchangeFuture.this.exchangeLocE = new ClusterTopologyCheckedException("Required node has left the cluster [nodeId=" + node.id() + ']'));
                        }
                        // MONITOREXIT : object
                        if (crd0 == null) {
                            GridDhtPartitionsExchangeFuture.this.onAllServersLeft();
                            GridDhtPartitionsExchangeFuture.this.onDone(GridDhtPartitionsExchangeFuture.this.initialVersion());
                            return;
                        }
                        if (crd0.isLocal()) {
                            if (GridDhtPartitionsExchangeFuture.this.stateChangeExchange() && GridDhtPartitionsExchangeFuture.this.exchangeLocE != null) {
                                GridDhtPartitionsExchangeFuture.this.exchangeGlobalExceptions.put(crd0.id(), GridDhtPartitionsExchangeFuture.this.exchangeLocE);
                            }
                            if (!crdChanged) {
                                if (!allReceived) return;
                                final boolean wasMerged0 = wasMerged;
                                GridDhtPartitionsExchangeFuture.this.cctx.kernalContext().pools().getSystemExecutorService().submit(new Runnable(){

                                    @Override
                                    public void run() {
                                        GridDhtPartitionsExchangeFuture.this.awaitSingleMapUpdates();
                                        if (wasMerged0) {
                                            GridDhtPartitionsExchangeFuture.this.finishExchangeOnCoordinator(null);
                                        } else {
                                            GridDhtPartitionsExchangeFuture.this.onAllReceived(null);
                                        }
                                    }
                                });
                                return;
                            }
                            if (GridDhtPartitionsExchangeFuture.this.log.isInfoEnabled()) {
                                GridDhtPartitionsExchangeFuture.this.log.info("Coordinator failed, node is new coordinator [ver=" + GridDhtPartitionsExchangeFuture.this.initialVersion() + ", prev=" + node.id() + ']');
                            }
                            assert (GridDhtPartitionsExchangeFuture.this.newCrdFut != null);
                            GridDhtPartitionsExchangeFuture.this.cctx.kernalContext().closure().callLocal(new GridPlainCallable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    try {
                                        GridDhtPartitionsExchangeFuture.this.newCrdFut.init(GridDhtPartitionsExchangeFuture.this);
                                    }
                                    catch (Throwable t) {
                                        U.error(GridDhtPartitionsExchangeFuture.this.log, "Failed to initialize new coordinator future [topVer=" + GridDhtPartitionsExchangeFuture.this.initialVersion() + "]", t);
                                        GridDhtPartitionsExchangeFuture.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, t));
                                        throw t;
                                    }
                                    GridDhtPartitionsExchangeFuture.this.newCrdFut.listen(new CI1<IgniteInternalFuture>(){

                                        @Override
                                        public void apply(IgniteInternalFuture fut) {
                                            if (GridDhtPartitionsExchangeFuture.this.isDone()) {
                                                return;
                                            }
                                            Lock lock = GridDhtPartitionsExchangeFuture.this.cctx.io().readLock();
                                            if (lock == null) {
                                                return;
                                            }
                                            try {
                                                GridDhtPartitionsExchangeFuture.this.onBecomeCoordinator((InitNewCoordinatorFuture)fut);
                                            }
                                            finally {
                                                lock.unlock();
                                            }
                                        }
                                    });
                                    return null;
                                }
                            }, (byte)2);
                            return;
                        }
                        if (!crdChanged) return;
                        if (!GridDhtPartitionsExchangeFuture.this.processNonLocalCoordinatorChange(crd0, node)) return;
                        return;
                    }
                    catch (IgniteCheckedException e) {
                        if (GridDhtPartitionsExchangeFuture.this.reconnectOnError(e)) {
                            GridDhtPartitionsExchangeFuture.this.onDone(new IgniteNeedReconnectException(GridDhtPartitionsExchangeFuture.this.cctx.localNode(), (Throwable)e));
                            return;
                        }
                        U.error(GridDhtPartitionsExchangeFuture.this.log, "Failed to process node left event: " + e, e);
                        return;
                    }
                    finally {
                        GridDhtPartitionsExchangeFuture.this.leaveBusy();
                    }
                }
            });
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBecomeCoordinator(InitNewCoordinatorFuture newCrdFut) {
        boolean allRcvd = false;
        this.cctx.exchange().onCoordinatorInitialized();
        if (newCrdFut.restoreState()) {
            GridDhtPartitionsFullMessage fullMsg = newCrdFut.fullMessage();
            assert (this.msgs.isEmpty()) : this.msgs;
            if (fullMsg != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("New coordinator restored state [ver=" + this.initialVersion() + ", resVer=" + fullMsg.resultTopologyVersion() + ']');
                }
                Object object = this.mux;
                synchronized (object) {
                    this.state = ExchangeLocalState.DONE;
                    this.finishState = new FinishState(this.crd.id(), fullMsg.resultTopologyVersion(), fullMsg);
                }
                fullMsg.exchangeId(this.exchId);
                this.processFullMessage(false, null, fullMsg);
                Map<ClusterNode, GridDhtPartitionsSingleMessage> msgs = newCrdFut.messages();
                if (!F.isEmpty(msgs)) {
                    ConcurrentHashMap<Integer, CacheGroupAffinityMessage> joinedNodeAff = new ConcurrentHashMap<Integer, CacheGroupAffinityMessage>();
                    int n = U.availableThreadCount(this.cctx.kernalContext(), (byte)2, 2);
                    try {
                        U.doInParallel(n, this.cctx.kernalContext().pools().getSystemExecutorService(), msgs.entrySet(), entry -> {
                            this.msgs.put(((ClusterNode)entry.getKey()).id(), (GridDhtPartitionsSingleMessage)entry.getValue());
                            GridDhtPartitionsSingleMessage msg = (GridDhtPartitionsSingleMessage)entry.getValue();
                            Collection<Integer> affReq = msg.cacheGroupsAffinityRequest();
                            if (!F.isEmpty(affReq)) {
                                CacheGroupAffinityMessage.createAffinityMessages(this.cctx, fullMsg.resultTopologyVersion(), affReq, joinedNodeAff);
                            }
                            return null;
                        });
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                    Map<UUID, GridDhtPartitionsSingleMessage> mergedJoins = newCrdFut.mergedJoinExchangeMessages();
                    if (this.log.isInfoEnabled()) {
                        this.log.info("New coordinator sends full message [ver=" + this.initialVersion() + ", resVer=" + fullMsg.resultTopologyVersion() + ", nodes=" + F.nodeIds(msgs.keySet()) + ", mergedJoins=" + (mergedJoins != null ? mergedJoins.keySet() : null) + ']');
                    }
                    this.sendAllPartitions(fullMsg, msgs.keySet(), mergedJoins, joinedNodeAff);
                }
                return;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("New coordinator restore state finished [ver=" + this.initialVersion() + ']');
            }
            for (Map.Entry<ClusterNode, GridDhtPartitionsSingleMessage> e : newCrdFut.messages().entrySet()) {
                GridDhtPartitionsSingleMessage gridDhtPartitionsSingleMessage = e.getValue();
                if (gridDhtPartitionsSingleMessage.client()) continue;
                this.msgs.put(e.getKey().id(), e.getValue());
                if (this.dynamicCacheStartExchange() && gridDhtPartitionsSingleMessage.getError() != null) {
                    this.exchangeGlobalExceptions.put(e.getKey().id(), gridDhtPartitionsSingleMessage.getError());
                }
                this.updatePartitionSingleMap(e.getKey().id(), gridDhtPartitionsSingleMessage);
            }
            allRcvd = true;
            Object msgs = this.mux;
            synchronized (msgs) {
                this.remaining.clear();
                assert (this.crd != null && this.crd.isLocal());
                this.state = ExchangeLocalState.CRD;
                assert (this.mergedJoinExchMsgs == null);
            }
        }
        HashSet<UUID> remaining0 = null;
        Object msgs = this.mux;
        synchronized (msgs) {
            assert (this.crd != null && this.crd.isLocal());
            this.state = ExchangeLocalState.CRD;
            assert (this.mergedJoinExchMsgs == null);
            if (this.log.isInfoEnabled()) {
                this.log.info("New coordinator initialization finished [ver=" + this.initialVersion() + ", remaining=" + this.remaining + ']');
            }
            if (!this.remaining.isEmpty()) {
                remaining0 = new HashSet<UUID>(this.remaining);
            }
        }
        if (remaining0 != null) {
            GridDhtPartitionsSingleRequest req = new GridDhtPartitionsSingleRequest(this.exchId);
            for (UUID uUID : remaining0) {
                try {
                    if (this.pendingSingleMsgs.containsKey(uUID)) continue;
                    if (this.log.isInfoEnabled()) {
                        this.log.info("New coordinator sends request [ver=" + this.initialVersion() + ", node=" + uUID + ']');
                    }
                    this.cctx.io().send(uUID, (GridCacheMessage)req, (byte)2);
                }
                catch (ClusterTopologyCheckedException ignored) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Node left during partition exchange [nodeId=" + uUID + ", exchId=" + this.exchId + ']');
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to request partitions from node: " + uUID, e);
                }
            }
            for (Map.Entry entry2 : this.pendingSingleMsgs.entrySet()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("New coordinator process pending message [ver=" + this.initialVersion() + ", node=" + entry2.getKey() + ']');
                }
                this.processSingleMessage((UUID)entry2.getKey(), (GridDhtPartitionsSingleMessage)entry2.getValue());
            }
        }
        if (allRcvd) {
            this.awaitSingleMapUpdates();
            this.onAllReceived(newCrdFut.messages().keySet());
        }
    }

    public boolean reconnectOnError(Throwable e) {
        return (e instanceof IgniteNeedReconnectException || X.hasCause(e, IOException.class, IgniteClientDisconnectedCheckedException.class)) && this.cctx.discovery().reconnectSupported();
    }

    public boolean rebalanced() {
        return this.rebalanced;
    }

    public boolean wasRebalanced() {
        GridDhtPartitionsExchangeFuture prev = this.sharedContext().exchange().lastFinishedFuture();
        assert (prev != this);
        return prev != null && prev.rebalanced();
    }

    private void markRebalanced() {
        assert (!this.rebalanced());
        this.rebalanced = true;
    }

    private void keepRebalanced() {
        assert (this.wasRebalanced());
        this.markRebalanced();
    }

    public void markAffinityReassign() {
        this.affinityReassign = true;
    }

    public boolean affinityReassign() {
        return this.affinityReassign;
    }

    public synchronized boolean addOrMergeDelayedFullMessage(ClusterNode node, GridDhtPartitionsFullMessage fullMsg) {
        assert (fullMsg.exchangeId() == null) : fullMsg.exchangeId();
        if (this.isDone()) {
            return false;
        }
        GridDhtPartitionsFullMessage prev = this.delayedLatestMsg;
        if (prev == null) {
            this.delayedLatestMsg = fullMsg;
            this.listen(f -> {
                GridDhtPartitionsFullMessage msg;
                GridDhtPartitionsExchangeFuture gridDhtPartitionsExchangeFuture = this;
                synchronized (gridDhtPartitionsExchangeFuture) {
                    msg = this.delayedLatestMsg;
                    this.delayedLatestMsg = null;
                }
                if (msg != null) {
                    this.cctx.exchange().processFullPartitionUpdate(node, msg);
                }
            });
        } else {
            this.delayedLatestMsg.merge(fullMsg, this.cctx.discovery());
        }
        return true;
    }

    @Override
    public int compareTo(GridDhtPartitionsExchangeFuture fut) {
        return this.exchId.compareTo(fut.exchId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GridDhtPartitionsExchangeFuture fut = (GridDhtPartitionsExchangeFuture)o;
        return this.exchId.equals(fut.exchId);
    }

    public int hashCode() {
        return this.exchId.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiagnosticRequest(IgniteDiagnosticPrepareContext diagCtx) {
        if (!this.isDone()) {
            InitNewCoordinatorFuture newCrdFut;
            HashSet<UUID> remaining;
            ClusterNode crd;
            Object object = this.mux;
            synchronized (object) {
                crd = this.crd;
                remaining = new HashSet<UUID>(this.remaining);
                newCrdFut = this.newCrdFut;
            }
            if (newCrdFut != null) {
                newCrdFut.addDiagnosticRequest(diagCtx);
            }
            if (crd != null) {
                if (!crd.isLocal()) {
                    diagCtx.exchangeInfo(crd.id(), this.initialVersion(), "Exchange future waiting for coordinator response [crd=" + crd.id() + ", topVer=" + this.initialVersion() + ']');
                } else if (!remaining.isEmpty()) {
                    UUID nodeId = (UUID)remaining.iterator().next();
                    diagCtx.exchangeInfo(nodeId, this.initialVersion(), "Exchange future on coordinator waiting for server response [node=" + nodeId + ", topVer=" + this.initialVersion() + ']');
                }
            }
        }
    }

    public String shortInfo() {
        return "GridDhtPartitionsExchangeFuture [topVer=" + this.initialVersion() + ", evt=" + (this.firstDiscoEvt != null ? IgniteUtils.gridEventName(this.firstDiscoEvt.type()) : Integer.valueOf(-1)) + ", evtNode=" + (this.firstDiscoEvt != null ? this.firstDiscoEvt.eventNode() : null) + ", rebalanced=" + this.rebalanced() + ", done=" + this.isDone() + ", newCrdFut=" + this.newCrdFut + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        int awaitMergedMsgs;
        HashSet<UUID> mergedJoinExch;
        HashSet<UUID> remaining;
        Object object = this.mux;
        synchronized (object) {
            remaining = new HashSet<UUID>(this.remaining);
            mergedJoinExch = this.mergedJoinExchMsgs == null ? null : new HashSet<UUID>(this.mergedJoinExchMsgs.keySet());
            awaitMergedMsgs = this.awaitMergedMsgs;
        }
        return S.toString(GridDhtPartitionsExchangeFuture.class, this, "evtLatch", this.evtLatch == null ? "null" : Long.valueOf(this.evtLatch.getCount()), "remaining", remaining, "mergedJoinExchMsgs", mergedJoinExch, "awaitMergedMsgs", (Object)awaitMergedMsgs, "super", (Object)super.toString());
    }

    public static long nextDumpTimeout(int step, long timeout) {
        long limit = IgniteSystemProperties.getLong("IGNITE_LONG_OPERATIONS_DUMP_TIMEOUT_LIMIT", 1800000L);
        if (limit <= 0L) {
            limit = 1800000L;
        }
        assert (step >= 0) : step;
        long dumpFactor = Math.round(Math.pow(2.0, step));
        long nextTimeout = timeout * dumpFactor;
        if (nextTimeout <= 0L) {
            return limit;
        }
        return nextTimeout <= limit ? nextTimeout : limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClearingPartition(CacheGroupContext grp, int part) {
        if (!grp.persistenceEnabled()) {
            return false;
        }
        Object object = this.mux;
        synchronized (object) {
            if (this.clearingPartitions == null) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
            Set<Integer> parts = this.clearingPartitions.get(grp.groupId());
            return parts != null && parts.contains(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClearingPartition(CacheGroupContext grp, int part) {
        if (!grp.persistenceEnabled()) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            this.clearingPartitions.computeIfAbsent(grp.groupId(), k -> new HashSet()).add(part);
        }
    }

    private boolean processNonLocalCoordinatorChange(ClusterNode crd, ClusterNode node) {
        for (Map.Entry<ClusterNode, GridDhtPartitionsFullMessage> m : this.fullMsgs.entrySet()) {
            if (!crd.equals(m.getKey())) continue;
            if (this.log.isInfoEnabled()) {
                this.log.info("Coordinator changed, process pending full message [ver=" + this.initialVersion() + ", crd=" + node.id() + ", pendingMsgNode=" + m.getKey() + ']');
            }
            this.processFullMessage(true, m.getKey(), m.getValue());
            if (!this.isDone()) continue;
            return true;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Coordinator changed, send partitions to new coordinator [ver=" + this.initialVersion() + ", crd=" + node.id() + ", newCrd=" + crd.id() + ']');
        }
        final ClusterNode newCrd = crd;
        this.cctx.kernalContext().pools().getSystemExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                GridDhtPartitionsExchangeFuture.this.sendPartitions(newCrd);
            }
        });
        return false;
    }

    private static enum ExchangeLocalState {
        CRD,
        SRV,
        CLIENT,
        BECOME_CRD,
        DONE,
        MERGED;

    }

    public static enum ExchangeType {
        CLIENT,
        ALL,
        NONE;

    }

    private static class FinishState {
        private final UUID crdId;
        private final AffinityTopologyVersion resTopVer;
        private final GridDhtPartitionsFullMessage msg;

        FinishState(UUID crdId, AffinityTopologyVersion resTopVer, GridDhtPartitionsFullMessage msg) {
            this.crdId = crdId;
            this.resTopVer = resTopVer;
            this.msg = msg;
        }

        public void cleanUp() {
            if (this.msg != null) {
                this.msg.cleanUp();
            }
        }
    }

    private static class CounterWithNodes {
        private final long cnt;
        private final long size;
        private final Set<UUID> nodes = new HashSet<UUID>();

        private CounterWithNodes(long cnt, @Nullable Long size, UUID firstNode) {
            this.cnt = cnt;
            this.size = size != null ? size : 0L;
            this.nodes.add(firstNode);
        }

        public String toString() {
            return S.toString(CounterWithNodes.class, this);
        }
    }
}

