/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheFilterFailedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheReturnCompletableWrapper;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateTxResult;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteEx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxState;
import org.apache.ignite.internal.processors.cache.transactions.TxCounters;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionConflictContext;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionEx;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public abstract class GridDistributedTxRemoteAdapter
extends IgniteTxAdapter
implements IgniteTxRemoteEx {
    private static final AtomicIntegerFieldUpdater<GridDistributedTxRemoteAdapter> COMMIT_ALLOWED_UPD = AtomicIntegerFieldUpdater.newUpdater(GridDistributedTxRemoteAdapter.class, "commitAllowed");
    @GridToStringInclude
    private List<GridCacheVersion> explicitVers;
    @GridToStringInclude
    private boolean started;
    @GridToStringInclude
    private volatile int commitAllowed;
    @GridToStringInclude
    protected IgniteTxRemoteState txState;
    @GridToStringInclude
    @Nullable
    private String txLbl;

    public GridDistributedTxRemoteAdapter(GridCacheSharedContext<?, ?> ctx, UUID nodeId, GridCacheVersion xidVer, GridCacheVersion commitVer, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, boolean invalidate, long timeout, int txSize, @Nullable UUID subjId, int taskNameHash, String txLbl) {
        super(ctx, nodeId, xidVer, null, Thread.currentThread().getId(), sys, plc, concurrency, isolation, timeout, txSize, subjId, taskNameHash);
        this.invalidate = invalidate;
        this.txLbl = txLbl;
        this.commitVersion(commitVer);
        this.started = true;
    }

    @Override
    public IgniteTxState txState() {
        return this.txState;
    }

    @Override
    public UUID eventNodeId() {
        return this.nodeId;
    }

    @Override
    public UUID originatingNodeId() {
        return this.nodeId;
    }

    @Override
    public boolean activeCachesDeploymentEnabled() {
        return false;
    }

    @Override
    public void activeCachesDeploymentEnabled(boolean depEnabled) {
        throw new UnsupportedOperationException("Remote tx doesn't support deployment.");
    }

    @Override
    public void addActiveCache(GridCacheContext cacheCtx, boolean recovery) throws IgniteCheckedException {
        this.txState.addActiveCache(cacheCtx, recovery, this);
    }

    @Override
    public boolean empty() {
        return this.txState.empty();
    }

    @Override
    public void invalidate(boolean invalidate) {
        this.invalidate = invalidate;
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> writeMap() {
        return this.txState.writeMap();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> readMap() {
        return this.txState.readMap();
    }

    @Override
    public void seal() {
    }

    @Override
    public GridTuple<CacheObject> peek(GridCacheContext cacheCtx, boolean failFast, KeyCacheObject key) throws GridCacheFilterFailedException {
        assert (false) : "Method peek can only be called on user transaction: " + this;
        throw new IllegalStateException("Method peek can only be called on user transaction: " + this);
    }

    @Override
    public IgniteTxEntry entry(IgniteTxKey key) {
        return this.txState.entry(key);
    }

    public void clearEntry(IgniteTxKey key) {
        this.txState.clearEntry(key);
    }

    @Override
    public void doneRemote(GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, Collection<GridCacheVersion> pendingVers) throws GridDhtInvalidPartitionException {
        Map<IgniteTxKey, IgniteTxEntry> writeMap;
        Map<IgniteTxKey, IgniteTxEntry> readMap = this.txState.readMap();
        if (readMap != null && !readMap.isEmpty()) {
            for (IgniteTxEntry txEntry : readMap.values()) {
                this.doneRemote(txEntry, baseVer, committedVers, rolledbackVers, pendingVers);
            }
        }
        if ((writeMap = this.txState.writeMap()) != null && !writeMap.isEmpty()) {
            for (IgniteTxEntry txEntry : writeMap.values()) {
                this.doneRemote(txEntry, baseVer, committedVers, rolledbackVers, pendingVers);
            }
        }
    }

    @Override
    public void setPartitionUpdateCounters(long[] cntrs) {
        if (this.writeMap() != null && !this.writeMap().isEmpty() && cntrs != null && cntrs.length > 0) {
            int i = 0;
            for (IgniteTxEntry txEntry : this.writeMap().values()) {
                txEntry.updateCounter(cntrs[i]);
                ++i;
            }
        }
    }

    private void doneRemote(IgniteTxEntry txEntry, GridCacheVersion baseVer, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers, Collection<GridCacheVersion> pendingVers) throws GridDhtInvalidPartitionException {
        while (true) {
            GridDistributedCacheEntry entry = (GridDistributedCacheEntry)txEntry.cached();
            try {
                GridCacheVersion doneVer = txEntry.explicitVersion() != null ? txEntry.explicitVersion() : this.xidVer;
                entry.doneRemote(doneVer, baseVer, pendingVers, committedVers, rolledbackVers, this.isSystemInvalidate());
            }
            catch (GridCacheEntryRemovedException ignored) {
                assert (entry.obsoleteVersion() != null);
                if (log.isDebugEnabled()) {
                    log.debug("Replacing obsolete entry in remote transaction [entry=" + entry + ", tx=" + this + ']');
                }
                txEntry.cached(txEntry.context().cache().entryEx(txEntry.key(), this.topologyVersion()));
                continue;
            }
            break;
        }
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        if (!this.hasWriteKey(entry.txKey())) {
            return false;
        }
        try {
            this.commitIfLocked();
            return true;
        }
        catch (IgniteCheckedException e) {
            U.error(log, "Failed to commit remote transaction: " + this, e);
            this.invalidate(true);
            this.systemInvalidate(true);
            this.rollbackRemoteTx();
            return false;
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean hasWriteKey(IgniteTxKey key) {
        return this.txState.hasWriteKey(key);
    }

    @Override
    public Set<IgniteTxKey> readSet() {
        return this.txState.readSet();
    }

    @Override
    public Set<IgniteTxKey> writeSet() {
        return this.txState.writeSet();
    }

    @Override
    public Collection<IgniteTxEntry> allEntries() {
        return this.txState.allEntries();
    }

    @Override
    public Collection<IgniteTxEntry> writeEntries() {
        return this.txState.writeEntries();
    }

    @Override
    public Collection<IgniteTxEntry> readEntries() {
        return this.txState.readEntries();
    }

    public final void prepareRemoteTx() throws IgniteCheckedException {
        if (!(this.state(TransactionState.PREPARING) || this.state() == TransactionState.PREPARING && this.optimistic())) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid transaction state for prepare: " + this);
            }
            return;
        }
        try {
            this.cctx.tm().prepareTx(this, null);
            if (this.pessimistic() || this.isSystemInvalidate()) {
                this.state(TransactionState.PREPARED);
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    private void commitIfLocked() throws IgniteCheckedException {
        if (this.state() == TransactionState.COMMITTING) {
            block14: for (IgniteTxEntry txEntry : this.writeEntries()) {
                assert (txEntry != null) : "Missing transaction entry for tx: " + this;
                while (true) {
                    GridCacheEntryEx entry = txEntry.cached();
                    assert (entry != null) : "Missing cached entry for transaction entry: " + txEntry;
                    try {
                        GridCacheVersion ver = txEntry.explicitVersion() != null ? txEntry.explicitVersion() : this.xidVer;
                        if (entry.lockedBy(ver)) continue block14;
                        if (log.isDebugEnabled()) {
                            log.debug("Transaction does not own lock for entry (will wait) [entry=" + entry + ", tx=" + this + ']');
                        }
                        return;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (log.isDebugEnabled()) {
                            log.debug("Got removed entry while committing (will retry): " + txEntry);
                        }
                        try {
                            txEntry.cached(txEntry.context().cache().entryEx(txEntry.key(), this.topologyVersion()));
                        }
                        catch (GridDhtInvalidPartitionException e) {
                            continue block14;
                        }
                    }
                }
            }
            if (COMMIT_ALLOWED_UPD.compareAndSet(this, 0, 1)) {
                IgniteCheckedException err = null;
                Map<IgniteTxKey, IgniteTxEntry> writeMap = this.txState.writeMap();
                GridCacheReturnCompletableWrapper wrapper = null;
                if (!F.isEmpty(writeMap) || this.mvccSnapshot != null) {
                    GridCacheReturn ret = null;
                    if (!this.near() && !this.local() && this.onePhaseCommit()) {
                        if (this.needReturnValue()) {
                            ret = new GridCacheReturn(null, this.cctx.localNodeId().equals(this.otherNodeId()), true, null, null, true);
                            UUID origNodeId = this.otherNodeId();
                            wrapper = new GridCacheReturnCompletableWrapper(!this.cctx.localNodeId().equals(origNodeId) ? origNodeId : null);
                            this.cctx.tm().addCommittedTxReturn(this, wrapper);
                        } else {
                            this.cctx.tm().addCommittedTx(this, this.nearXidVersion(), null);
                        }
                    }
                    this.cctx.tm().addCommittedTx(this);
                    AffinityTopologyVersion topVer = this.topologyVersion();
                    WALPointer ptr = null;
                    this.cctx.database().checkpointReadLock();
                    HashSet<GridDhtLocalPartition> reservedParts = new HashSet<GridDhtLocalPartition>();
                    try {
                        assert (!this.txState.mvccEnabled() || this.mvccSnapshot != null) : "Mvcc is not initialized: " + this;
                        Collection<IgniteTxEntry> entries = this.near() || this.cctx.snapshot().needTxReadLogging() ? this.allEntries() : this.writeEntries();
                        ArrayList<T2<DataEntry, IgniteTxEntry>> dataEntries = null;
                        this.batchStoreCommit(this.writeMap().values());
                        Iterator<IgniteTxEntry> iterator = entries.iterator();
                        block16: while (iterator.hasNext()) {
                            IgniteTxEntry txEntry = iterator.next();
                            GridCacheContext<?, ?> cacheCtx = txEntry.context();
                            GridDhtLocalPartition locPart = cacheCtx.group().topology().localPartition(txEntry.cached().partition());
                            if (!this.near()) {
                                if (locPart == null) continue;
                                if (!reservedParts.contains(locPart) && locPart.reserve()) {
                                    assert (locPart.state() != GridDhtPartitionState.EVICTED && locPart.reservations() > 0) : locPart;
                                    reservedParts.add(locPart);
                                }
                                if (locPart.state() == GridDhtPartitionState.RENTING || locPart.state() == GridDhtPartitionState.EVICTED) {
                                    LT.warn(this.log(), "Skipping update to partition that is concurrently evicting [grp=" + cacheCtx.group().cacheOrGroupName() + ", part=" + locPart + "]");
                                    continue;
                                }
                            }
                            boolean replicate = cacheCtx.isDrEnabled();
                            while (true) {
                                try {
                                    GridCacheUpdateTxResult updRes;
                                    GridCacheVersion dhtVer;
                                    GridCacheEntryEx cached = txEntry.cached();
                                    if (cached == null) {
                                        cached = cacheCtx.cache().entryEx(txEntry.key(), this.topologyVersion());
                                        txEntry.cached(cached);
                                    }
                                    if (this.near() && cacheCtx.dr().receiveEnabled()) {
                                        cached.markObsolete(this.xidVer);
                                        continue block16;
                                    }
                                    GridNearCacheEntry nearCached = null;
                                    if (this.updateNearCache(cacheCtx, txEntry.key(), topVer)) {
                                        nearCached = cacheCtx.dht().near().peekExx(txEntry.key());
                                    }
                                    if (!F.isEmpty(txEntry.entryProcessors())) {
                                        txEntry.cached().unswap(false);
                                    }
                                    IgniteBiTuple<GridCacheOperation, CacheObject> res = this.applyTransformClosures(txEntry, false, ret);
                                    GridCacheOperation op = res.get1();
                                    CacheObject val = res.get2();
                                    GridCacheVersion explicitVer = txEntry.conflictVersion();
                                    if (explicitVer == null) {
                                        explicitVer = this.writeVersion();
                                    }
                                    if (txEntry.ttl() == -2L) {
                                        op = GridCacheOperation.DELETE;
                                    }
                                    boolean conflictNeedResolve = cacheCtx.conflictNeedResolve();
                                    GridCacheVersionConflictContext conflictCtx = null;
                                    if (conflictNeedResolve) {
                                        IgniteBiTuple<GridCacheOperation, GridCacheVersionConflictContext> drRes = this.conflictResolve(op, txEntry, val, explicitVer, cached);
                                        assert (drRes != null);
                                        conflictCtx = drRes.get2();
                                        if (conflictCtx.isUseOld()) {
                                            op = GridCacheOperation.NOOP;
                                        } else if (conflictCtx.isUseNew()) {
                                            txEntry.ttl(conflictCtx.ttl());
                                            txEntry.conflictExpireTime(conflictCtx.expireTime());
                                        } else if (conflictCtx.isMerge()) {
                                            op = drRes.get1();
                                            val = txEntry.context().toCacheObject(conflictCtx.mergeValue());
                                            explicitVer = this.writeVersion();
                                            txEntry.ttl(conflictCtx.ttl());
                                            txEntry.conflictExpireTime(conflictCtx.expireTime());
                                        }
                                    } else {
                                        explicitVer = null;
                                    }
                                    GridCacheVersion gridCacheVersion = dhtVer = cached.isNear() ? this.writeVersion() : null;
                                    if (!this.near() && cacheCtx.group().logDataRecords() && op != GridCacheOperation.NOOP && op != GridCacheOperation.RELOAD && (op != GridCacheOperation.READ || this.cctx.snapshot().needTxReadLogging())) {
                                        if (dataEntries == null) {
                                            dataEntries = new ArrayList<T2<DataEntry, IgniteTxEntry>>(entries.size());
                                        }
                                        dataEntries.add(new T2<DataEntry, IgniteTxEntry>(new DataEntry(cacheCtx.cacheId(), txEntry.key(), val, op, this.nearXidVersion(), GridCacheVersionEx.addConflictVersion(this.writeVersion(), txEntry.conflictVersion()), 0L, txEntry.key().partition(), txEntry.updateCounter(), DataEntry.flags(CU.txOnPrimary(this))), txEntry));
                                    }
                                    if (op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE) {
                                        if (this.isSystemInvalidate() || this.isInvalidate() && cacheCtx.isNear()) {
                                            cached.innerRemove(this, this.eventNodeId(), this.nodeId, false, true, true, txEntry.keepBinary(), txEntry.hasOldValue(), txEntry.oldValue(), topVer, null, replicate ? GridDrType.DR_BACKUP : GridDrType.DR_NONE, this.near() ? null : explicitVer, this.resolveTaskName(), dhtVer, txEntry.updateCounter());
                                        } else {
                                            assert (val != null) : txEntry;
                                            updRes = cached.innerSet(this, this.eventNodeId(), this.nodeId, val, false, false, txEntry.ttl(), true, true, txEntry.keepBinary(), txEntry.hasOldValue(), txEntry.oldValue(), topVer, null, replicate ? GridDrType.DR_BACKUP : GridDrType.DR_NONE, txEntry.conflictExpireTime(), this.near() ? null : explicitVer, this.resolveTaskName(), dhtVer, txEntry.updateCounter());
                                            txEntry.updateCounter(updRes.updateCounter());
                                            if (updRes.loggedPointer() != null) {
                                                ptr = updRes.loggedPointer();
                                            }
                                            if (nearCached != null) {
                                                CacheObject val0 = cached.valueBytes();
                                                nearCached.updateOrEvict(this.xidVer, val0, cached.expireTime(), cached.ttl(), this.nodeId, topVer);
                                            }
                                        }
                                    } else if (op == GridCacheOperation.DELETE) {
                                        updRes = cached.innerRemove(this, this.eventNodeId(), this.nodeId, false, true, true, txEntry.keepBinary(), txEntry.hasOldValue(), txEntry.oldValue(), topVer, null, replicate ? GridDrType.DR_BACKUP : GridDrType.DR_NONE, this.near() ? null : explicitVer, this.resolveTaskName(), dhtVer, txEntry.updateCounter());
                                        txEntry.updateCounter(updRes.updateCounter());
                                        if (updRes.loggedPointer() != null) {
                                            ptr = updRes.loggedPointer();
                                        }
                                        if (nearCached != null) {
                                            nearCached.updateOrEvict(this.xidVer, null, 0L, 0L, this.nodeId, topVer);
                                        }
                                    } else if (op == GridCacheOperation.RELOAD) {
                                        CacheObject reloaded = cached.innerReload();
                                        if (nearCached != null) {
                                            nearCached.innerReload();
                                            nearCached.updateOrEvict(cached.version(), reloaded, cached.expireTime(), cached.ttl(), this.nodeId, topVer);
                                        }
                                    } else if (op == GridCacheOperation.READ) {
                                        assert (this.near());
                                        if (log.isDebugEnabled()) {
                                            log.debug("Ignoring READ entry when committing: " + txEntry);
                                        }
                                    } else if (conflictCtx == null || !conflictCtx.isUseOld()) {
                                        if (txEntry.ttl() != -1L) {
                                            cached.updateTtl(null, txEntry.ttl());
                                        }
                                        if (nearCached != null) {
                                            CacheObject val0 = cached.valueBytes();
                                            nearCached.updateOrEvict(this.xidVer, val0, cached.expireTime(), cached.ttl(), this.nodeId, topVer);
                                        }
                                    }
                                    assert (txEntry.op() == GridCacheOperation.READ || this.onePhaseCommit() || !cached.hasLockCandidateUnsafe(this.xidVer) || cached.lockedByUnsafe(this.xidVer)) : "Transaction does not own lock for commit [entry=" + cached + ", tx=" + this + ']';
                                    continue block16;
                                }
                                catch (GridCacheEntryRemovedException ignored) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Attempting to commit a removed entry (will retry): " + txEntry);
                                    }
                                    txEntry.cached(cacheCtx.cache().entryEx(txEntry.key(), this.topologyVersion()));
                                    continue;
                                }
                                break;
                            }
                        }
                        this.applyTxSizes();
                        TxCounters txCntrs = this.txCounters(false);
                        if (txCntrs != null) {
                            this.cctx.tm().txHandler().applyPartitionsUpdatesCounters(txCntrs.updateCounters());
                        }
                        this.cctx.mvccCaching().onTxFinished(this, true);
                        if (!this.near() && !F.isEmpty(dataEntries) && this.cctx.wal(true) != null) {
                            List<DataEntry> entriesWithCounters = dataEntries.stream().map(tuple -> ((DataEntry)tuple.get1()).partitionCounter(((IgniteTxEntry)tuple.get2()).updateCounter())).collect(Collectors.toList());
                            ptr = this.cctx.wal(true).log(new DataRecord(entriesWithCounters));
                        }
                        if (ptr != null) {
                            this.cctx.wal(true).flush(ptr, false);
                        }
                    }
                    catch (Throwable ex) {
                        this.state(TransactionState.UNKNOWN);
                        if (X.hasCause(ex, NodeStoppingException.class)) {
                            U.warn(log, "Failed to commit transaction, node is stopping [tx=" + CU.txString(this) + ", err=" + ex + ']');
                            return;
                        }
                        err = this.heuristicException(ex);
                        try {
                            this.uncommit();
                        }
                        catch (Throwable e) {
                            err.addSuppressed(e);
                        }
                        throw err;
                    }
                    finally {
                        for (GridDhtLocalPartition locPart : reservedParts) {
                            locPart.release();
                        }
                        this.cctx.database().checkpointReadUnlock();
                        if (wrapper != null) {
                            wrapper.initialize(ret);
                        }
                    }
                }
                this.cctx.tm().commitTx(this);
                this.state(TransactionState.COMMITTED);
            }
        }
    }

    @Override
    public final void commitRemoteTx() throws IgniteCheckedException {
        if (this.optimistic()) {
            this.state(TransactionState.PREPARED);
        }
        if (!this.state(TransactionState.COMMITTING)) {
            TransactionState state = this.state();
            if (state == TransactionState.COMMITTING || state == TransactionState.COMMITTED) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Failed to set COMMITTING transaction state (will rollback): " + this);
            }
            this.setRollbackOnly();
            if (!this.isSystemInvalidate()) {
                throw new IgniteCheckedException("Invalid transaction state for commit [state=" + (Object)((Object)state) + ", tx=" + this + ']');
            }
            this.rollbackRemoteTx();
            return;
        }
        try {
            this.commitIfLocked();
        }
        catch (IgniteTxHeuristicCheckedException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    public void forceCommit() throws IgniteCheckedException {
        this.commitIfLocked();
    }

    @Override
    public IgniteInternalFuture<IgniteInternalTx> commitAsync() {
        try {
            this.commitRemoteTx();
            return new GridFinishedFuture<IgniteInternalTx>(this);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<IgniteInternalTx>(e);
        }
    }

    @Override
    public final IgniteInternalFuture<?> salvageTx() {
        try {
            this.systemInvalidate(true);
            this.prepareRemoteTx();
            if (this.state() == TransactionState.PREPARING) {
                if (log.isDebugEnabled()) {
                    log.debug("Ignoring transaction in PREPARING state as it is currently handled by another thread: " + this);
                }
                return null;
            }
            this.doneRemote(this.xidVersion(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            this.commitRemoteTx();
        }
        catch (IgniteCheckedException e) {
            U.error(log, "Failed to invalidate transaction: " + this.xidVersion(), e);
        }
        return null;
    }

    @Override
    public final void rollbackRemoteTx() {
        try {
            if (this.state(TransactionState.ROLLING_BACK) || this.state() == TransactionState.UNKNOWN) {
                this.cctx.tm().rollbackTx(this, false, this.skipCompletedVersions());
                TxCounters counters = this.txCounters(false);
                if (counters != null) {
                    this.cctx.tm().txHandler().applyPartitionsUpdatesCounters(counters.updateCounters(), true, false);
                }
                this.state(TransactionState.ROLLED_BACK);
                this.cctx.mvccCaching().onTxFinished(this, false);
            }
        }
        catch (Error | RuntimeException | IgniteCheckedException e) {
            this.state(TransactionState.UNKNOWN);
            U.error(log, "Error during tx rollback.", e);
            if (e instanceof IgniteCheckedException) {
                throw new IgniteException(e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw (Error)e;
        }
    }

    @Override
    public IgniteInternalFuture<IgniteInternalTx> rollbackAsync() {
        this.rollbackRemoteTx();
        return new GridFinishedFuture<IgniteInternalTx>(this);
    }

    @Override
    public Collection<GridCacheVersion> alternateVersions() {
        return this.explicitVers == null ? Collections.emptyList() : this.explicitVers;
    }

    @Override
    public void commitError(Throwable e) {
    }

    protected void addExplicit(IgniteTxEntry e) {
        if (e.explicitVersion() != null) {
            if (this.explicitVers == null) {
                this.explicitVers = new LinkedList<GridCacheVersion>();
            }
            if (!this.explicitVers.contains(e.explicitVersion())) {
                this.explicitVers.add(e.explicitVersion());
                if (log.isDebugEnabled()) {
                    log.debug("Added explicit version to transaction [explicitVer=" + e.explicitVersion() + ", tx=" + this + ']');
                }
                this.cctx.tm().addAlternateVersion(e.explicitVersion(), this);
            }
        }
    }

    @Override
    public String label() {
        return this.txLbl;
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridDistributedTxRemoteAdapter.class, this, "super", (Object)super.toString());
    }
}

