/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class RollbackRecord
extends WALRecord {
    @GridToStringInclude
    protected int grpId;
    @GridToStringInclude
    protected int partId;
    @GridToStringInclude
    protected long start;
    @GridToStringInclude
    protected long range;

    public RollbackRecord(int grpId, int partId, long start, long range) {
        this.grpId = grpId;
        this.partId = partId;
        this.start = start;
        this.range = range;
    }

    public int groupId() {
        return this.grpId;
    }

    public int partitionId() {
        return this.partId;
    }

    public long start() {
        return this.start;
    }

    public long range() {
        return this.range;
    }

    public long overlap(long from, long to) {
        long to0 = this.start + this.range;
        if (this.start <= from && from < to0) {
            return Math.min(to0 - from, to - from);
        }
        if (from <= this.start && this.start < to) {
            return Math.min(to - this.start, this.range);
        }
        return 0L;
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.ROLLBACK_TX_RECORD;
    }

    @Override
    public String toString() {
        return S.toString(RollbackRecord.class, this);
    }
}

