/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;

public class BytesIndexKey
implements IndexKey {
    protected final byte[] key;

    public BytesIndexKey(byte[] key) {
        this.key = key;
    }

    @Override
    public Object key() {
        return this.key;
    }

    @Override
    public int type() {
        return 12;
    }

    @Override
    public int compare(IndexKey o) {
        byte[] arr0 = this.key;
        byte[] arr1 = ((BytesIndexKey)o).key;
        if (arr0 == arr1) {
            return 0;
        }
        int commonLen = Math.min(arr0.length, arr1.length);
        for (int i = 0; i < commonLen; ++i) {
            int unSignArr0 = arr0[i] & 0xFF;
            int unSignArr1 = arr1[i] & 0xFF;
            if (unSignArr0 == unSignArr1) continue;
            return unSignArr0 > unSignArr1 ? 1 : -1;
        }
        return Integer.signum(Integer.compare(arr0.length, arr1.length));
    }
}

