/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.BooleanInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.ByteInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.BytesInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.DateInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.DoubleInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.FloatInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.IntegerInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.LongInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.ObjectByteArrayInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.ObjectHashInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.ShortInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.SignedBytesInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.StringInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.StringNoCompareInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.TimeInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.TimestampInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.UuidInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;

public class InlineIndexKeyTypeRegistry {
    private static final Map<Integer, InlineIndexKeyType> typeMapping = new ConcurrentHashMap<Integer, InlineIndexKeyType>();
    private static final ObjectHashInlineIndexKeyType hashObjectType = new ObjectHashInlineIndexKeyType();
    private static final StringInlineIndexKeyType optimizedCompareStringType = new StringInlineIndexKeyType();
    private static final StringNoCompareInlineIndexKeyType noCompareStringType = new StringNoCompareInlineIndexKeyType();
    private static final BytesInlineIndexKeyType bytesType = new BytesInlineIndexKeyType();
    private static final SignedBytesInlineIndexKeyType signedBytesType = new SignedBytesInlineIndexKeyType();
    private static final ObjectByteArrayInlineIndexKeyType bytesObjectType = new ObjectByteArrayInlineIndexKeyType(new BytesInlineIndexKeyType(19));
    private static final ObjectByteArrayInlineIndexKeyType signedBytesObjectType = new ObjectByteArrayInlineIndexKeyType(new SignedBytesInlineIndexKeyType(19));

    private static void register(int type, InlineIndexKeyType keyType) {
        typeMapping.put(type, keyType);
    }

    public static InlineIndexKeyType get(int expType, IndexKeyTypeSettings keyTypeSettings) {
        return InlineIndexKeyTypeRegistry.type(expType, keyTypeSettings);
    }

    public static InlineIndexKeyType get(IndexKey key, int expType, IndexKeyTypeSettings keyTypeSettings) {
        return key == NullIndexKey.INSTANCE ? InlineIndexKeyTypeRegistry.type(expType, keyTypeSettings) : InlineIndexKeyTypeRegistry.type(key.type(), keyTypeSettings);
    }

    private static InlineIndexKeyType type(int type, IndexKeyTypeSettings keyTypeSettings) {
        if (type == 19) {
            return InlineIndexKeyTypeRegistry.javaObjectType(keyTypeSettings);
        }
        if (type == 13) {
            return InlineIndexKeyTypeRegistry.stringType(keyTypeSettings);
        }
        if (type == 12) {
            return InlineIndexKeyTypeRegistry.bytesType(keyTypeSettings);
        }
        return typeMapping.get(type);
    }

    private static boolean supportInline(int type, IndexKeyTypeSettings keyTypeSettings) {
        if (type == 19 && !keyTypeSettings.inlineObjSupported()) {
            return false;
        }
        return typeMapping.containsKey(type);
    }

    private static InlineIndexKeyType javaObjectType(IndexKeyTypeSettings keyTypeSettings) {
        if (keyTypeSettings.inlineObjHash()) {
            return hashObjectType;
        }
        return keyTypeSettings.binaryUnsigned() ? bytesObjectType : signedBytesObjectType;
    }

    private static InlineIndexKeyType stringType(IndexKeyTypeSettings keyTypeSettings) {
        return keyTypeSettings.stringOptimizedCompare() ? optimizedCompareStringType : noCompareStringType;
    }

    private static InlineIndexKeyType bytesType(IndexKeyTypeSettings keyTypeSettings) {
        return keyTypeSettings.binaryUnsigned() ? bytesType : signedBytesType;
    }

    public static List<InlineIndexKeyType> types(Collection<IndexKeyDefinition> keyDefs, IndexKeyTypeSettings settings) {
        ArrayList<InlineIndexKeyType> keyTypes = new ArrayList<InlineIndexKeyType>();
        for (IndexKeyDefinition keyDef : keyDefs) {
            if (!InlineIndexKeyTypeRegistry.supportInline(keyDef.idxType(), settings)) break;
            keyTypes.add(InlineIndexKeyTypeRegistry.type(keyDef.idxType(), settings));
        }
        return Collections.unmodifiableList(keyTypes);
    }

    static {
        InlineIndexKeyTypeRegistry.register(1, new BooleanInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(2, new ByteInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(10, new DateInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(7, new DoubleInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(8, new FloatInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(4, new IntegerInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(3, new ShortInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(5, new LongInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(9, new TimeInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(11, new TimestampInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(20, new UuidInlineIndexKeyType());
        InlineIndexKeyTypeRegistry.register(19, hashObjectType);
        InlineIndexKeyTypeRegistry.register(13, optimizedCompareStringType);
        InlineIndexKeyTypeRegistry.register(12, bytesType);
    }
}

