/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;

public class IndexRowCompartorImpl
implements IndexRowComparator {
    protected final IndexKeyTypeSettings keyTypeSettings;

    public IndexRowCompartorImpl(IndexKeyTypeSettings settings) {
        this.keyTypeSettings = settings;
    }

    @Override
    public int compareKey(long pageAddr, int off, int maxSize, IndexKey key, InlineIndexKeyType type) {
        if (type.type() == -1) {
            return -2;
        }
        if (this.sameType(key, type.type())) {
            if (type.type() != 19 || this.keyTypeSettings.inlineObjSupported()) {
                return type.compare(pageAddr, off, maxSize, key);
            }
            return -2;
        }
        return Integer.MIN_VALUE;
    }

    private boolean sameType(IndexKey key, int idxType) {
        if (key == NullIndexKey.INSTANCE) {
            return true;
        }
        return idxType == key.type();
    }

    @Override
    public int compareRow(IndexRow left, IndexRow right, int idx) throws IgniteCheckedException {
        return this.compare(left.key(idx), right.key(idx));
    }

    @Override
    public int compareKey(IndexKey left, IndexKey right) throws IgniteCheckedException {
        if (left == right) {
            return 0;
        }
        return this.compare(left, right);
    }

    private int compare(IndexKey lkey, IndexKey rkey) {
        if (lkey == NullIndexKey.INSTANCE) {
            return lkey.compare(rkey);
        }
        if (rkey == NullIndexKey.INSTANCE) {
            return 1;
        }
        if (lkey.type() == rkey.type()) {
            return lkey.compare(rkey);
        }
        return Integer.MIN_VALUE;
    }
}

