/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.internal.cache.query.RangeIndexQueryCriterion;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.IndexDefinition;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.cache.query.index.IndexQueryResult;
import org.apache.ignite.internal.cache.query.index.IndexQueryResultMeta;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.IndexSearchRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.SortedSegmentedIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexTree;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.query.IndexQueryDesc;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.jetbrains.annotations.Nullable;

public class IndexQueryProcessor {
    private final IndexProcessor idxProc;

    public IndexQueryProcessor(IndexProcessor idxProc) {
        this.idxProc = idxProc;
    }

    public <K, V> IndexQueryResult<K, V> queryLocal(final GridCacheContext<K, V> cctx, IndexQueryDesc idxQryDesc, final @Nullable IgniteBiPredicate<K, V> filter, IndexingQueryFilter cacheFilter, final boolean keepBinary) throws IgniteCheckedException {
        SortedSegmentedIndex idx = this.findSortedIndex(cctx, idxQryDesc);
        IndexRangeQuery qry = this.prepareQuery(idx, idxQryDesc);
        final GridCursor<IndexRow> cursor = this.querySortedIndex(cctx, idx, cacheFilter, qry);
        SortedIndexDefinition def = (SortedIndexDefinition)this.idxProc.indexDefinition(idx.id());
        IndexQueryResultMeta meta = new IndexQueryResultMeta(def, qry.criteria.length);
        return new IndexQueryResult(meta, new GridCloseableIteratorAdapter<IgniteBiTuple<K, V>>(){
            private IgniteBiTuple<K, V> currVal;
            private final CacheObjectContext coctx;
            {
                this.coctx = cctx.cacheObjectContext();
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.currVal != null) {
                    return true;
                }
                while (this.currVal == null && cursor.next()) {
                    IndexRow r = (IndexRow)cursor.get();
                    Object k = this.unwrap(r.cacheDataRow().key(), true);
                    Object v = this.unwrap(r.cacheDataRow().value(), true);
                    if (filter != null) {
                        Object v0;
                        Object k0 = keepBinary ? k : this.unwrap(r.cacheDataRow().key(), false);
                        Object t = v0 = keepBinary ? v : this.unwrap(r.cacheDataRow().value(), false);
                        if (!filter.apply(k0, v0)) continue;
                    }
                    this.currVal = new IgniteBiTuple(k, v);
                }
                return this.currVal != null;
            }

            @Override
            protected IgniteBiTuple<K, V> onNext() {
                if (this.currVal == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IgniteBiTuple row = this.currVal;
                this.currVal = null;
                return row;
            }

            private <T> T unwrap(CacheObject o, boolean keepBinary2) {
                return (T)CacheObjectUtils.unwrapBinaryIfNeeded(this.coctx, o, keepBinary2, false);
            }
        });
    }

    private SortedSegmentedIndex findSortedIndex(GridCacheContext<?, ?> cctx, IndexQueryDesc idxQryDesc) throws IgniteCheckedException {
        String tableName = cctx.kernalContext().query().tableName(cctx.name(), idxQryDesc.valType());
        if (tableName == null) {
            throw this.failIndexQuery("No table found for type: " + idxQryDesc.valType(), null, idxQryDesc);
        }
        Map<String, String> critFlds = !F.isEmpty(idxQryDesc.criteria()) ? idxQryDesc.criteria().stream().map(IndexQueryCriterion::field).flatMap(f -> {
            String norm = QueryUtils.normalizeObjectName(f, false);
            if (f.equals(norm)) {
                return Stream.of(new T2<String, String>((String)f, (String)f));
            }
            return Stream.of(new T2<String, String>((String)f, norm), new T2<String, String>(norm, (String)f));
        }).collect(Collectors.toMap(IgniteBiTuple::get1, IgniteBiTuple::get2, (l, r) -> l)) : Collections.emptyMap();
        if (idxQryDesc.idxName() == null && !critFlds.isEmpty()) {
            return this.indexByCriteria(cctx, critFlds, tableName, idxQryDesc);
        }
        String name = idxQryDesc.idxName() == null ? "_key_PK" : idxQryDesc.idxName();
        IndexName idxName = new IndexName(cctx.name(), cctx.kernalContext().query().schemaName(cctx), tableName, name);
        return this.indexByName(idxName, idxQryDesc, critFlds);
    }

    private SortedSegmentedIndex indexByName(IndexName idxName, IndexQueryDesc idxQryDesc, Map<String, String> criteriaFlds) throws IgniteCheckedException {
        SortedSegmentedIndex idx = this.assertSortedIndex(this.idxProc.index(idxName), idxQryDesc);
        if (idx == null && !"_key_PK".equals(idxName.idxName())) {
            String normIdxName = QueryUtils.normalizeObjectName(idxName.idxName(), false);
            idxName = new IndexName(idxName.cacheName(), idxName.schemaName(), idxName.tableName(), normIdxName);
            idx = this.assertSortedIndex(this.idxProc.index(idxName), idxQryDesc);
        }
        if (idx == null) {
            throw this.failIndexQuery("No index found for name: " + idxName.idxName(), null, idxQryDesc);
        }
        if (!this.checkIndex(idx, idxName.tableName(), criteriaFlds)) {
            throw this.failIndexQuery("Index doesn't match criteria", null, idxQryDesc);
        }
        return idx;
    }

    private SortedSegmentedIndex indexByCriteria(GridCacheContext<?, ?> cctx, Map<String, String> criteriaFlds, String tableName, IndexQueryDesc idxQryDesc) throws IgniteCheckedException {
        Collection<Index> idxs = this.idxProc.indexes(cctx);
        for (Index idx : idxs) {
            SortedSegmentedIndex sortedIdx = this.assertSortedIndex(idx, idxQryDesc);
            if (!this.checkIndex(sortedIdx, tableName, criteriaFlds)) continue;
            return sortedIdx;
        }
        throw this.failIndexQuery("No index found for criteria", null, idxQryDesc);
    }

    private SortedSegmentedIndex assertSortedIndex(Index idx, IndexQueryDesc idxQryDesc) throws IgniteCheckedException {
        if (idx == null) {
            return null;
        }
        if (!(idx instanceof SortedSegmentedIndex)) {
            throw this.failIndexQuery("IndexQuery is not supported for index: " + idx.name(), null, idxQryDesc);
        }
        return (SortedSegmentedIndex)idx;
    }

    private boolean checkIndex(SortedSegmentedIndex idx, String tblName, Map<String, String> criteriaFlds) {
        IndexDefinition idxDef = this.idxProc.indexDefinition(idx.id());
        if (!tblName.equals(idxDef.idxName().tableName())) {
            return false;
        }
        if (F.isEmpty(criteriaFlds)) {
            return true;
        }
        HashMap<String, String> flds = new HashMap<String, String>(criteriaFlds);
        for (String idxFldName : idxDef.indexKeyDefinitions().keySet()) {
            String alias = (String)flds.remove(idxFldName);
            if (alias == null) {
                return false;
            }
            flds.remove(alias);
            if (!flds.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private IgniteCheckedException failIndexQuery(String msg, IndexDefinition idxDef, IndexQueryDesc desc) {
        String exMsg = "Failed to parse IndexQuery. " + msg + ".";
        if (idxDef != null) {
            exMsg = exMsg + " Index=" + idxDef;
        }
        return new IgniteCheckedException(exMsg + " Query=" + desc);
    }

    private Map<String, RangeIndexQueryCriterion> mergeIndexQueryCriteria(InlineIndexImpl idx, SortedIndexDefinition idxDef, IndexQueryDesc idxQryDesc) throws IgniteCheckedException {
        HashMap<String, RangeIndexQueryCriterion> mergedCriteria = new HashMap<String, RangeIndexQueryCriterion>();
        LinkedHashMap<String, IndexKeyDefinition> idxFlds = idxDef.indexKeyDefinitions();
        IndexKeyTypeSettings keyTypeSettings = idx.segment(0).rowHandler().indexKeyTypeSettings();
        CacheObjectContext coctx = idx.segment(0).cacheGroupContext().cacheObjectContext();
        IndexRowComparator keyCmp = idxDef.rowComparator();
        for (IndexQueryCriterion c : idxQryDesc.criteria()) {
            RangeIndexQueryCriterion crit = (RangeIndexQueryCriterion)c;
            String fldName = idxFlds.containsKey(crit.field()) ? crit.field() : QueryUtils.normalizeObjectName(crit.field(), false);
            IndexKeyDefinition keyDef = (IndexKeyDefinition)idxFlds.get(fldName);
            if (keyDef == null) {
                throw this.failIndexQuery("Index doesn't match criteria", idxDef, idxQryDesc);
            }
            IndexKey l = this.key(crit.lower(), crit.lowerNull(), keyDef, keyTypeSettings, coctx);
            IndexKey u = this.key(crit.upper(), crit.upperNull(), keyDef, keyTypeSettings, coctx);
            if (l != null && u != null && keyCmp.compareKey(l, u) > 0) {
                throw this.failIndexQuery("Illegal criterion: lower boundary is greater than the upper boundary: " + IndexQueryProcessor.rangeDesc(crit, fldName, null, null), idxDef, idxQryDesc);
            }
            boolean lowIncl = crit.lowerIncl();
            boolean upIncl = crit.upperIncl();
            boolean lowNull = crit.lowerNull();
            boolean upNull = crit.upperNull();
            if (mergedCriteria.containsKey(fldName)) {
                RangeIndexQueryCriterion prev = (RangeIndexQueryCriterion)mergedCriteria.get(fldName);
                IndexKey prevLower = (IndexKey)prev.lower();
                IndexKey prevUpper = (IndexKey)prev.upper();
                if (!this.checkBoundaries(l, prevUpper, crit.lowerIncl(), prev.upperIncl(), keyCmp) || !this.checkBoundaries(prevLower, u, prev.lowerIncl(), crit.upperIncl(), keyCmp)) {
                    String prevDesc = IndexQueryProcessor.rangeDesc(prev, null, prevLower == null ? null : prevLower.key(), prevUpper == null ? null : prevUpper.key());
                    throw this.failIndexQuery("Failed to merge criterion " + IndexQueryProcessor.rangeDesc(crit, fldName, null, null) + " with previous criteria range " + prevDesc, idxDef, idxQryDesc);
                }
                int lowCmp = 0;
                if (l == null || prevLower != null && (lowCmp = keyCmp.compareKey(prevLower, l)) >= 0) {
                    l = prevLower;
                    lowIncl = lowCmp != 0 ? prev.lowerIncl() : (prev.lowerIncl() ? lowIncl : prev.lowerIncl());
                    lowNull = prev.lowerNull();
                }
                int upCmp = 0;
                if (u == null || prevUpper != null && (upCmp = keyCmp.compareKey(prevUpper, u)) <= 0) {
                    u = prevUpper;
                    upIncl = upCmp != 0 ? prev.upperIncl() : (prev.upperIncl() ? upIncl : prev.upperIncl());
                    upNull = prev.upperNull();
                }
            }
            RangeIndexQueryCriterion idxKeyCrit = new RangeIndexQueryCriterion(fldName, l, u);
            idxKeyCrit.lowerIncl(lowIncl);
            idxKeyCrit.upperIncl(upIncl);
            idxKeyCrit.lowerNull(lowNull);
            idxKeyCrit.upperNull(upNull);
            mergedCriteria.put(fldName, idxKeyCrit);
        }
        return mergedCriteria;
    }

    private boolean checkBoundaries(IndexKey left, IndexKey right, boolean leftIncl, boolean rightIncl, IndexRowComparator keyCmp) throws IgniteCheckedException {
        boolean boundaryCheck;
        boolean bl = boundaryCheck = left != null && right != null;
        if (boundaryCheck) {
            int cmp = keyCmp.compareKey(left, right);
            return cmp < 0 || cmp == 0 && leftIncl && rightIncl;
        }
        return true;
    }

    private IndexRangeQuery alignCriteriaWithIndex(InlineIndexImpl idx, Map<String, RangeIndexQueryCriterion> criteria, IndexDefinition idxDef) {
        IndexKey[] lowerBounds = new IndexKey[idxDef.indexKeyDefinitions().size()];
        IndexKey[] upperBounds = new IndexKey[idxDef.indexKeyDefinitions().size()];
        boolean lowerAllNulls = true;
        boolean upperAllNulls = true;
        IndexRangeQuery qry = new IndexRangeQuery(criteria.size());
        int i = 0;
        for (Map.Entry<String, IndexKeyDefinition> keyDef : idxDef.indexKeyDefinitions().entrySet()) {
            RangeIndexQueryCriterion criterion = criteria.remove(keyDef.getKey());
            if (keyDef.getValue().order().sortOrder() == SortOrder.DESC) {
                criterion = criterion.swap();
            }
            ((IndexRangeQuery)qry).criteria[i] = criterion;
            IndexKey l = (IndexKey)criterion.lower();
            IndexKey u = (IndexKey)criterion.upper();
            if (l != null) {
                lowerAllNulls = false;
            }
            if (u != null) {
                upperAllNulls = false;
            }
            lowerBounds[i] = l;
            upperBounds[i++] = u;
            if (!criteria.isEmpty()) continue;
            break;
        }
        InlineIndexRowHandler hnd = idx.segment(0).rowHandler();
        qry.lower = lowerAllNulls ? null : new IndexSearchRowImpl(lowerBounds, hnd);
        qry.upper = upperAllNulls ? null : new IndexSearchRowImpl(upperBounds, hnd);
        return qry;
    }

    private IndexRangeQuery prepareQuery(SortedSegmentedIndex idx, IndexQueryDesc idxQryDesc) throws IgniteCheckedException {
        SortedIndexDefinition idxDef = (SortedIndexDefinition)this.idxProc.indexDefinition(idx.id());
        if (F.isEmpty(idxQryDesc.criteria())) {
            return new IndexRangeQuery(1);
        }
        InlineIndexImpl sortedIdx = (InlineIndexImpl)idx;
        Map<String, RangeIndexQueryCriterion> merged = this.mergeIndexQueryCriteria(sortedIdx, idxDef, idxQryDesc);
        return this.alignCriteriaWithIndex(sortedIdx, merged, idxDef);
    }

    private GridCursor<IndexRow> querySortedIndex(GridCacheContext<?, ?> cctx, SortedSegmentedIndex idx, IndexingQueryFilter cacheFilter, IndexRangeQuery qry) throws IgniteCheckedException {
        int segmentsCnt = cctx.isPartitioned() ? cctx.config().getQueryParallelism() : 1;
        IndexQueryCriteriaClosure treeFilter = null;
        if (qry.criteria.length > 1 && (qry.lower != null || qry.upper != null)) {
            LinkedHashMap<String, IndexKeyDefinition> idxDef = this.idxProc.indexDefinition(idx.id()).indexKeyDefinitions();
            treeFilter = new IndexQueryCriteriaClosure(qry, idxDef, ((SortedIndexDefinition)this.idxProc.indexDefinition(idx.id())).rowComparator());
        }
        IndexQueryContext qryCtx = new IndexQueryContext(cacheFilter, treeFilter, null);
        if (segmentsCnt == 1) {
            return this.treeIndexRange(idx, 0, qry, qryCtx);
        }
        GridCursor[] segmentCursors = new GridCursor[segmentsCnt];
        for (int i = 0; i < segmentsCnt; ++i) {
            segmentCursors[i] = this.treeIndexRange(idx, i, qry, qryCtx);
        }
        return new SegmentedIndexCursor(segmentCursors, (SortedIndexDefinition)this.idxProc.indexDefinition(idx.id()));
    }

    private GridCursor<IndexRow> treeIndexRange(SortedSegmentedIndex idx, int segment, IndexRangeQuery qry, IndexQueryContext qryCtx) throws IgniteCheckedException {
        boolean lowIncl = this.inclBoundary(qry, true);
        boolean upIncl = this.inclBoundary(qry, false);
        return idx.find(qry.lower, qry.upper, lowIncl, upIncl, segment, qryCtx);
    }

    private boolean inclBoundary(IndexRangeQuery qry, boolean lower) {
        for (RangeIndexQueryCriterion c : qry.criteria) {
            if (c == null || (lower ? c.lower() : c.upper()) == null) break;
            if (!lower ? c.upperIncl() : c.lowerIncl()) continue;
            return false;
        }
        return true;
    }

    private IndexKey key(Object val, boolean isNull, IndexKeyDefinition def, IndexKeyTypeSettings settings, CacheObjectContext coctx) {
        IndexKey key = null;
        if (val != null || isNull) {
            key = IndexKeyFactory.wrap(val, def.idxType(), coctx, settings);
        }
        return key;
    }

    private static String rangeDesc(RangeIndexQueryCriterion c, String fldName, Object lower, Object upper) {
        String fld = fldName == null ? c.field() : fldName;
        Object l = lower == null ? c.lower() : lower;
        Object u = upper == null ? c.upper() : upper;
        RangeIndexQueryCriterion r = new RangeIndexQueryCriterion(fld, l, u);
        r.lowerIncl(c.lowerIncl());
        r.upperIncl(c.upperIncl());
        return r.toString();
    }

    private static class InlineIndexRow {
        private final long pageAddr;
        private final int idx;
        private final InlineIndexTree tree;
        private final BPlusIO<IndexRow> io;
        private IndexRow currRow;

        private InlineIndexRow(InlineIndexTree tree, BPlusIO<IndexRow> io, long addr, int idx) {
            this.pageAddr = addr;
            this.idx = idx;
            this.tree = tree;
            this.io = io;
        }

        private int compare(IndexRowComparator rowCmp, IndexRow o, int keyIdx, int off, int maxSize, @Nullable InlineIndexKeyType keyType) throws IgniteCheckedException {
            if (this.currRow == null) {
                int cmp = Integer.MIN_VALUE;
                if (keyType != null) {
                    cmp = rowCmp.compareKey(this.pageAddr, off, maxSize, o.key(keyIdx), keyType);
                }
                if (cmp == Integer.MIN_VALUE || cmp == -2) {
                    this.currRow = (IndexRow)this.tree.getRow(this.io, this.pageAddr, this.idx);
                } else {
                    return cmp;
                }
            }
            return rowCmp.compareRow(this.currRow, o, keyIdx);
        }
    }

    private static class IndexRangeQuery {
        private final RangeIndexQueryCriterion[] criteria;
        private IndexRow lower;
        private IndexRow upper;

        private IndexRangeQuery(int critSize) {
            this.criteria = new RangeIndexQueryCriterion[critSize];
        }
    }

    private static class IndexQueryCriteriaClosure
    implements BPlusTree.TreeRowClosure<IndexRow, IndexRow> {
        private final IndexRangeQuery qry;
        private final IndexRowComparator rowCmp;
        private final boolean[] descOrderCache;

        IndexQueryCriteriaClosure(IndexRangeQuery qry, LinkedHashMap<String, IndexKeyDefinition> idxDef, IndexRowComparator rowCmp) {
            this.qry = qry;
            this.rowCmp = rowCmp;
            this.descOrderCache = new boolean[qry.criteria.length];
            for (int i = 0; i < qry.criteria.length; ++i) {
                RangeIndexQueryCriterion c = qry.criteria[i];
                this.descOrderCache[i] = idxDef.get(c.field()).order().sortOrder() == SortOrder.DESC;
            }
        }

        @Override
        public boolean apply(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
            return !this.rowIsOutOfRange((InlineIndexTree)tree, io, pageAddr, idx, this.qry.lower, this.qry.upper);
        }

        private boolean rowIsOutOfRange(InlineIndexTree tree, BPlusIO<IndexRow> io, long pageAddr, int idx, IndexRow low, IndexRow high) throws IgniteCheckedException {
            int criteriaKeysCnt = this.qry.criteria.length;
            int off = io.offset(idx);
            int fieldOff = 0;
            InlineIndexRow currRow = new InlineIndexRow(tree, io, pageAddr, idx);
            List<InlineIndexKeyType> keyTypes = tree.rowHandler().inlineIndexKeyTypes();
            for (int keyIdx = 0; keyIdx < criteriaKeysCnt; ++keyIdx) {
                int cmp;
                RangeIndexQueryCriterion c = this.qry.criteria[keyIdx];
                InlineIndexKeyType keyType = keyIdx < keyTypes.size() ? keyTypes.get(keyIdx) : null;
                boolean descOrder = this.descOrderCache[keyIdx];
                int maxSize = tree.inlineSize() - fieldOff;
                if (low != null && low.key(keyIdx) != null && ((cmp = currRow.compare(this.rowCmp, low, keyIdx, off + fieldOff, maxSize, keyType)) == 0 ? !c.lowerIncl() : cmp < 0 ^ descOrder)) {
                    return true;
                }
                if (high != null && high.key(keyIdx) != null && ((cmp = currRow.compare(this.rowCmp, high, keyIdx, off + fieldOff, maxSize, keyType)) == 0 ? !c.upperIncl() : cmp > 0 ^ descOrder)) {
                    return true;
                }
                if (keyType == null) continue;
                fieldOff += keyType.inlineSize(pageAddr, off + fieldOff);
            }
            return false;
        }
    }

    private static class SegmentedIndexCursor
    implements GridCursor<IndexRow> {
        private final PriorityQueue<GridCursor<IndexRow>> cursors;
        private final Comparator<GridCursor<IndexRow>> cursorComp;
        private IndexRow head;

        SegmentedIndexCursor(GridCursor<IndexRow>[] cursors, final SortedIndexDefinition idxDef) throws IgniteCheckedException {
            this.cursorComp = new Comparator<GridCursor<IndexRow>>(){

                @Override
                public int compare(GridCursor<IndexRow> o1, GridCursor<IndexRow> o2) {
                    try {
                        int keysLen = o1.get().keys().length;
                        Iterator<IndexKeyDefinition> it = idxDef.indexKeyDefinitions().values().iterator();
                        for (int i = 0; i < keysLen; ++i) {
                            int cmp = idxDef.rowComparator().compareRow(o1.get(), o2.get(), i);
                            IndexKeyDefinition def = it.next();
                            if (cmp == 0) continue;
                            boolean desc = def.order().sortOrder() == SortOrder.DESC;
                            return desc ? -cmp : cmp;
                        }
                        return 0;
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException("Failed to sort remote index rows", e);
                    }
                }
            };
            this.cursors = new PriorityQueue<GridCursor<IndexRow>>(cursors.length, this.cursorComp);
            for (GridCursor<IndexRow> c : cursors) {
                if (!c.next()) continue;
                this.cursors.add(c);
            }
        }

        @Override
        public boolean next() throws IgniteCheckedException {
            if (this.cursors.isEmpty()) {
                return false;
            }
            GridCursor<IndexRow> c = this.cursors.poll();
            this.head = c.get();
            if (c.next()) {
                this.cursors.add(c);
            }
            return true;
        }

        @Override
        public IndexRow get() throws IgniteCheckedException {
            return this.head;
        }
    }
}

