/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlCreateTableOptionEnum;
import org.jetbrains.annotations.NotNull;

public class IgniteSqlCreateTableOption
extends SqlCall {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("TableOption", SqlKind.OTHER);
    private final SqlLiteral key;
    private final SqlNode value;

    public IgniteSqlCreateTableOption(SqlLiteral key, SqlNode value, SqlParserPos pos) {
        super(pos);
        this.key = key;
        this.value = value;
    }

    @NotNull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @NotNull
    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.key, (Object)this.value);
    }

    public SqlNode clone(SqlParserPos pos) {
        return new IgniteSqlCreateTableOption(this.key, this.value, pos);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.key.unparse(writer, leftPrec, rightPrec);
        writer.keyword("=");
        this.value.unparse(writer, leftPrec, rightPrec);
    }

    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        throw new UnsupportedOperationException();
    }

    public <R> R accept(SqlVisitor<R> visitor) {
        throw new UnsupportedOperationException();
    }

    public boolean equalsDeep(SqlNode node, Litmus litmus) {
        if (!(node instanceof IgniteSqlCreateTableOption)) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        IgniteSqlCreateTableOption that = (IgniteSqlCreateTableOption)node;
        if (this.key != that.key) {
            return litmus.fail("{} != {}", new Object[]{this, node});
        }
        return this.value.equalsDeep(that.value, litmus);
    }

    public IgniteSqlCreateTableOptionEnum key() {
        return (IgniteSqlCreateTableOptionEnum)((Object)this.key.getValueAs(IgniteSqlCreateTableOptionEnum.class));
    }

    public SqlNode value() {
        return this.value;
    }
}

