/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlCreateTableOption;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlCreateTableOptionEnum;
import org.apache.ignite.internal.processors.query.calcite.util.IgniteResource;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlCreateTable
extends SqlCreate {
    private final SqlIdentifier name;
    private final @Nullable SqlNodeList columnList;
    private final @Nullable SqlNode qry;
    private final @Nullable SqlNodeList createOptionList;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE", SqlKind.CREATE_TABLE);

    public IgniteSqlCreateTable(SqlParserPos pos, boolean ifNotExists, SqlIdentifier name, @Nullable SqlNodeList columnList, @Nullable SqlNode qry, @Nullable SqlNodeList createOptionList) {
        super(OPERATOR, pos, false, ifNotExists);
        this.name = Objects.requireNonNull(name, "name");
        this.columnList = columnList;
        this.qry = qry;
        this.createOptionList = createOptionList;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.columnList, (Object)this.qry, (Object)this.createOptionList);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("TABLE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode c : this.columnList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
        if (this.createOptionList != null) {
            writer.keyword("WITH");
            this.createOptionList.unparse(writer, 0, 0);
        }
        if (this.qry != null) {
            writer.keyword("AS");
            writer.newlineAndIndent();
            this.qry.unparse(writer, 0, 0);
        }
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public SqlNodeList columnList() {
        return this.columnList;
    }

    public SqlNode query() {
        return this.qry;
    }

    public SqlNodeList createOptionList() {
        return this.createOptionList;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public static SqlNodeList parseOptionList(String opts, SqlParserPos pos) {
        String[] pairs;
        SqlNodeList list = new SqlNodeList(pos);
        for (String pair : pairs = opts.split(",")) {
            String[] keyVal = pair.split("=");
            if (keyVal.length != 2) {
                throw SqlUtil.newContextException((SqlParserPos)pos, IgniteResource.INSTANCE.cannotParsePair(pair));
            }
            String key = keyVal[0].trim();
            String val = keyVal[1].trim();
            IgniteSqlCreateTableOptionEnum optionKey = IgniteSqlCreateTableOptionEnum.valueOf(key.toUpperCase());
            if (optionKey == null) {
                throw SqlUtil.newContextException((SqlParserPos)pos, IgniteResource.INSTANCE.illegalOption(key));
            }
            list.add((SqlNode)new IgniteSqlCreateTableOption(SqlLiteral.createSymbol((Enum)optionKey, (SqlParserPos)pos), (SqlNode)new SqlIdentifier(val, pos), pos));
        }
        return list;
    }
}

