/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.Frameworks;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.IgniteScalarFunction;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheIndexImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptorImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.ColumnDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteCacheTable;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteSchema;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.schema.SchemaHolder;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewTableDescriptorImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewTableImpl;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.processors.query.schema.SchemaChangeListener;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaHolderImpl
extends AbstractService
implements SchemaHolder,
SchemaChangeListener {
    private final Map<String, IgniteSchema> igniteSchemas = new HashMap<String, IgniteSchema>();
    private final GridKernalContext ctx;
    private GridInternalSubscriptionProcessor subscriptionProcessor;
    private volatile SchemaPlus calciteSchema;

    public SchemaHolderImpl(GridKernalContext ctx) {
        super(ctx);
        this.ctx = ctx;
        this.subscriptionProcessor(ctx.internalSubscriptionProcessor());
        this.init();
    }

    public void subscriptionProcessor(GridInternalSubscriptionProcessor subscriptionProcessor) {
        this.subscriptionProcessor = subscriptionProcessor;
    }

    @Override
    public void init() {
        this.subscriptionProcessor.registerSchemaChangeListener((SchemaChangeListener)this);
    }

    @Override
    public void onStart(GridKernalContext ctx) {
    }

    public synchronized void onSchemaCreated(String schemaName) {
        this.igniteSchemas.putIfAbsent(schemaName, new IgniteSchema(schemaName));
        this.rebuild();
    }

    public synchronized void onSchemaDropped(String schemaName) {
        this.igniteSchemas.remove(schemaName);
        this.rebuild();
    }

    public synchronized void onSqlTypeCreated(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo) {
        IgniteSchema schema = this.igniteSchemas.computeIfAbsent(schemaName, IgniteSchema::new);
        String tblName = typeDesc.tableName();
        CacheTableDescriptorImpl desc = new CacheTableDescriptorImpl(cacheInfo, typeDesc, SchemaHolderImpl.affinityIdentity(cacheInfo.config()));
        schema.addTable(tblName, new CacheTableImpl(this.ctx, desc));
        this.rebuild();
    }

    public void onSqlTypeUpdated(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo) {
        this.onSqlTypeCreated(schemaName, typeDesc, cacheInfo);
    }

    private static Object affinityIdentity(CacheConfiguration<?, ?> ccfg) {
        if (ccfg.getCacheMode() == CacheMode.PARTITIONED) {
            return new AffinityIdentity(ccfg.getAffinity(), ccfg.getBackups(), (IgnitePredicate<ClusterNode>)ccfg.getNodeFilter());
        }
        return null;
    }

    public synchronized void onSqlTypeDropped(String schemaName, GridQueryTypeDescriptor typeDesc) {
        IgniteSchema schema = this.igniteSchemas.computeIfAbsent(schemaName, IgniteSchema::new);
        schema.removeTable(typeDesc.tableName());
        this.rebuild();
    }

    public synchronized void onIndexCreated(String schemaName, String tblName, String idxName, GridQueryIndexDescriptor idxDesc, @Nullable Index gridIdx) {
        IgniteSchema schema = this.igniteSchemas.get(schemaName);
        assert (schema != null);
        IgniteCacheTable tbl = (IgniteCacheTable)schema.getTable(tblName);
        assert (tbl != null);
        RelCollation idxCollation = SchemaHolderImpl.deriveSecondaryIndexCollation(idxDesc, tbl);
        CacheIndexImpl idx = new CacheIndexImpl(idxCollation, idxName, gridIdx, tbl);
        tbl.addIndex(idx);
    }

    @NotNull
    private static RelCollation deriveSecondaryIndexCollation(GridQueryIndexDescriptor idxDesc, IgniteCacheTable tbl) {
        CacheTableDescriptor tblDesc = tbl.descriptor();
        ArrayList<RelFieldCollation> collations = new ArrayList<RelFieldCollation>(idxDesc.fields().size());
        for (String idxField : idxDesc.fields()) {
            ColumnDescriptor fieldDesc = tblDesc.columnDescriptor(idxField);
            assert (fieldDesc != null);
            boolean descending = idxDesc.descending(idxField);
            int fieldIdx = fieldDesc.fieldIndex();
            collations.add(TraitUtils.createFieldCollation(fieldIdx, !descending));
        }
        return RelCollations.of(collations);
    }

    public synchronized void onIndexDropped(String schemaName, String tblName, String idxName) {
        IgniteSchema schema = this.igniteSchemas.get(schemaName);
        assert (schema != null);
        IgniteTable tbl = (IgniteTable)schema.getTable(tblName);
        assert (tbl != null);
        tbl.removeIndex(idxName);
        this.rebuild();
    }

    public void onIndexRebuildStarted(String schemaName, String tblName) {
        IgniteSchema schema = this.igniteSchemas.get(schemaName);
        assert (schema != null);
        IgniteTable tbl = (IgniteTable)schema.getTable(tblName);
        assert (tbl != null);
        tbl.markIndexRebuildInProgress(true);
    }

    public void onIndexRebuildFinished(String schemaName, String tblName) {
        IgniteSchema schema = this.igniteSchemas.get(schemaName);
        assert (schema != null);
        IgniteTable tbl = (IgniteTable)schema.getTable(tblName);
        assert (tbl != null);
        tbl.markIndexRebuildInProgress(false);
    }

    public void onFunctionCreated(String schemaName, String name, Method method) {
        IgniteSchema schema = this.igniteSchemas.computeIfAbsent(schemaName, IgniteSchema::new);
        schema.addFunction(name.toUpperCase(), (Function)IgniteScalarFunction.create(method));
        this.rebuild();
    }

    public void onSystemViewCreated(String schemaName, SystemView<?> sysView) {
        IgniteSchema schema = this.igniteSchemas.computeIfAbsent(schemaName, IgniteSchema::new);
        SystemViewTableDescriptorImpl desc = new SystemViewTableDescriptorImpl(sysView);
        schema.addTable(desc.name(), new SystemViewTableImpl(desc));
        this.rebuild();
    }

    @Override
    public SchemaPlus schema(@Nullable String schema) {
        return schema != null ? this.calciteSchema.getSubSchema(schema) : this.calciteSchema;
    }

    private void rebuild() {
        SchemaPlus newCalciteSchema = Frameworks.createRootSchema((boolean)false);
        newCalciteSchema.add("UUID", typeFactory -> ((IgniteTypeFactory)((Object)typeFactory)).createCustomType((Type)((Object)UUID.class)));
        newCalciteSchema.add("OTHER", typeFactory -> ((IgniteTypeFactory)((Object)typeFactory)).createCustomType((Type)((Object)Object.class)));
        newCalciteSchema.add("PUBLIC", (Schema)new IgniteSchema("PUBLIC"));
        this.igniteSchemas.forEach((arg_0, arg_1) -> ((SchemaPlus)newCalciteSchema).add(arg_0, arg_1));
        this.calciteSchema = newCalciteSchema;
    }

    private static class AffinityIdentity {
        private final Class<?> affFuncCls;
        private final int backups;
        private final int partsCnt;
        private final Class<?> filterCls;
        private final int hash;

        public AffinityIdentity(AffinityFunction aff, int backups, IgnitePredicate<ClusterNode> nodeFilter) {
            this.affFuncCls = aff.getClass();
            this.backups = backups;
            this.partsCnt = aff.partitions();
            this.filterCls = nodeFilter == null ? CacheConfiguration.IgniteAllNodesPredicate.class : nodeFilter.getClass();
            int hash = backups;
            hash = 31 * hash + this.affFuncCls.hashCode();
            hash = 31 * hash + this.filterCls.hashCode();
            this.hash = hash = 31 * hash + this.partsCnt;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AffinityIdentity identity = (AffinityIdentity)o;
            return this.backups == identity.backups && this.affFuncCls == identity.affFuncCls && this.filterCls == identity.filterCls && this.partsCnt == identity.partsCnt;
        }

        public String toString() {
            return S.toString(AffinityIdentity.class, (Object)this);
        }
    }
}

