/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.schema;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RexImpTable;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseDataContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.MappingQueryContext;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheColumnDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.ColumnDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.ModifyTuple;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheTableDescriptorImpl
extends NullInitializerExpressionFactory
implements CacheTableDescriptor {
    private static final CacheColumnDescriptor[] DUMMY = new CacheColumnDescriptor[0];
    private final GridCacheContextInfo<?, ?> cacheInfo;
    private final GridQueryTypeDescriptor typeDesc;
    private final Object affinityIdentity;
    private final CacheColumnDescriptor[] descriptors;
    private final Map<String, CacheColumnDescriptor> descriptorsMap;
    private final int keyField;
    private final int valField;
    private final ImmutableIntList affFields;
    private final ImmutableBitSet insertFields;

    public CacheTableDescriptorImpl(GridCacheContextInfo<?, ?> cacheInfo, GridQueryTypeDescriptor typeDesc, Object affinityIdentity) {
        this.cacheInfo = cacheInfo;
        this.typeDesc = typeDesc;
        this.affinityIdentity = affinityIdentity;
        Set fields = this.typeDesc.fields().keySet();
        ArrayList<CacheColumnDescriptor> descriptors = new ArrayList<CacheColumnDescriptor>(fields.size() + 2);
        BitSet virtualFields = new BitSet();
        if (typeDesc.implicitPk()) {
            descriptors.add(new KeyValDescriptor("_KEY", typeDesc.keyClass(), true, 0){

                @Override
                public Object defaultValue() {
                    return IgniteUuid.randomUuid();
                }
            });
            virtualFields.set(0);
        } else {
            descriptors.add(new KeyValDescriptor("_KEY", typeDesc.keyClass(), true, 0));
        }
        descriptors.add(new KeyValDescriptor("_VAL", typeDesc.valueClass(), false, 1));
        int fldIdx = 2;
        int keyField = 0;
        int valField = 1;
        for (Object field : fields) {
            if (Objects.equals(field, typeDesc.keyFieldAlias())) {
                keyField = descriptors.size();
                virtualFields.set(0);
                descriptors.add(new KeyValDescriptor(typeDesc.keyFieldAlias(), typeDesc.keyClass(), true, fldIdx++));
                continue;
            }
            if (Objects.equals(field, typeDesc.valueFieldAlias())) {
                valField = descriptors.size();
                virtualFields.set(1);
                descriptors.add(new KeyValDescriptor(typeDesc.valueFieldAlias(), typeDesc.valueClass(), false, fldIdx++));
                continue;
            }
            GridQueryProperty prop = typeDesc.property((String)field);
            virtualFields.set(prop.key() ? 0 : 1);
            descriptors.add(new FieldDescriptor(prop, fldIdx++));
        }
        HashMap descriptorsMap = U.newHashMap((int)descriptors.size());
        for (CacheColumnDescriptor descriptor : descriptors) {
            descriptorsMap.put(descriptor.name(), descriptor);
        }
        ArrayList<Integer> affFields = new ArrayList<Integer>();
        if (!F.isEmpty((String)typeDesc.affinityKey())) {
            affFields.add(((CacheColumnDescriptor)descriptorsMap.get(typeDesc.affinityKey())).fieldIndex());
        } else if (!F.isEmpty((String)typeDesc.keyFieldAlias())) {
            affFields.add(((CacheColumnDescriptor)descriptorsMap.get(typeDesc.keyFieldAlias())).fieldIndex());
        } else if (!F.isEmpty((Collection)typeDesc.primaryKeyFields())) {
            affFields.addAll(descriptors.stream().filter(desc -> typeDesc.primaryKeyFields().contains(desc.name())).map(ColumnDescriptor::fieldIndex).collect(Collectors.toList()));
        } else {
            affFields.addAll(descriptors.stream().filter(desc -> typeDesc.fields().containsKey(desc.name()) && typeDesc.property(desc.name()).key()).map(ColumnDescriptor::fieldIndex).collect(Collectors.toList()));
        }
        if (affFields.stream().map(descriptors::get).map(ColumnDescriptor::storageType).anyMatch(TypeUtils::isConvertableType)) {
            affFields.clear();
        }
        this.keyField = keyField;
        this.valField = valField;
        this.affFields = ImmutableIntList.copyOf(affFields);
        this.descriptors = descriptors.toArray(DUMMY);
        this.descriptorsMap = descriptorsMap;
        virtualFields.flip(0, descriptors.size());
        this.insertFields = ImmutableBitSet.fromBitSet((BitSet)virtualFields);
    }

    @Override
    public RelDataType insertRowType(IgniteTypeFactory factory) {
        return this.rowType(factory, this.insertFields);
    }

    @Override
    public GridCacheContext cacheContext() {
        return this.cacheInfo.cacheContext();
    }

    @Override
    public GridCacheContextInfo cacheInfo() {
        return this.cacheInfo;
    }

    @Override
    public IgniteDistribution distribution() {
        if (this.affinityIdentity == null) {
            return IgniteDistributions.broadcast();
        }
        if (this.affFields.isEmpty()) {
            return IgniteDistributions.random();
        }
        return IgniteDistributions.affinity(this.affFields, this.cacheInfo.cacheId(), this.affinityIdentity);
    }

    @Override
    public boolean match(CacheDataRow row) {
        return this.typeDesc.matchType(row.value());
    }

    @Override
    public <Row> Row toRow(ExecutionContext<Row> ectx, CacheDataRow row, RowHandler.RowFactory<Row> factory, @Nullable ImmutableBitSet requiredColumns) throws IgniteCheckedException {
        RowHandler<Row> handler = factory.handler();
        assert (handler == ectx.rowHandler());
        Row res = factory.create();
        assert (handler.columnCount(res) == (requiredColumns == null ? this.descriptors.length : requiredColumns.cardinality()));
        if (requiredColumns == null) {
            for (int i = 0; i < this.descriptors.length; ++i) {
                CacheColumnDescriptor desc = this.descriptors[i];
                handler.set(i, res, TypeUtils.toInternal(ectx, desc.value(ectx, this.cacheContext(), row), desc.storageType()));
            }
        } else {
            int i = 0;
            int j = requiredColumns.nextSetBit(0);
            while (j != -1) {
                CacheColumnDescriptor desc = this.descriptors[j];
                handler.set(i, res, TypeUtils.toInternal(ectx, desc.value(ectx, this.cacheContext(), row), desc.storageType()));
                j = requiredColumns.nextSetBit(j + 1);
                ++i;
            }
        }
        return res;
    }

    @Override
    public boolean isUpdateAllowed(RelOptTable tbl, int colIdx) {
        CacheColumnDescriptor desc = this.descriptors[colIdx];
        return !desc.key() && (desc.field() || QueryUtils.isSqlType(desc.storageType()));
    }

    public ColumnStrategy generationStrategy(RelOptTable tbl, int colIdx) {
        if (this.descriptors[colIdx].hasDefaultValue()) {
            return ColumnStrategy.DEFAULT;
        }
        return super.generationStrategy(tbl, colIdx);
    }

    public RexNode newColumnDefaultValue(RelOptTable tbl, int colIdx, InitializerContext ctx) {
        CacheColumnDescriptor desc = this.descriptors[colIdx];
        if (!desc.hasDefaultValue()) {
            return super.newColumnDefaultValue(tbl, colIdx, ctx);
        }
        RexBuilder rexBuilder = ctx.getRexBuilder();
        IgniteTypeFactory typeFactory = (IgniteTypeFactory)rexBuilder.getTypeFactory();
        BaseDataContext dataCtx = new BaseDataContext(typeFactory);
        return TypeUtils.toRexLiteral(desc.defaultValue(), desc.logicalType(typeFactory), dataCtx, rexBuilder);
    }

    @Override
    public <Row> ModifyTuple toTuple(ExecutionContext<Row> ectx, Row row, TableModify.Operation op, Object arg) throws IgniteCheckedException {
        switch (op) {
            case INSERT: {
                return this.insertTuple(row, ectx);
            }
            case DELETE: {
                return this.deleteTuple(row, ectx);
            }
            case UPDATE: {
                return this.updateTuple(row, (List)arg, 0, ectx);
            }
            case MERGE: {
                return this.mergeTuple(row, (List)arg, ectx);
            }
        }
        throw new AssertionError();
    }

    private <Row> ModifyTuple insertTuple(Row row, ExecutionContext<Row> ectx) throws IgniteCheckedException {
        Object key = this.insertKey(row, ectx);
        Object val = this.insertVal(row, ectx);
        if (this.cacheContext().binaryMarshaller()) {
            if (key instanceof BinaryObjectBuilder) {
                key = ((BinaryObjectBuilder)key).build();
            }
            if (val instanceof BinaryObjectBuilder) {
                val = ((BinaryObjectBuilder)val).build();
            }
        }
        this.typeDesc.validateKeyAndValue(key, val);
        return new ModifyTuple(key, val, TableModify.Operation.INSERT);
    }

    private <Row> Object insertKey(Row row, ExecutionContext<Row> ectx) throws IgniteCheckedException {
        RowHandler<Row> handler = ectx.rowHandler();
        Object key = handler.get(this.keyField, row);
        if (key != null) {
            key = this.replaceDefault(key, this.descriptors[0]);
            return TypeUtils.fromInternal(ectx, key, this.descriptors[0].storageType());
        }
        for (int i = 2; i < this.descriptors.length; ++i) {
            Object fieldVal;
            CacheColumnDescriptor desc = this.descriptors[i];
            if (!desc.field() || !desc.key() || (fieldVal = this.replaceDefault(handler.get(i, row), desc)) == null) continue;
            if (key == null) {
                key = this.newVal(this.typeDesc.keyTypeName(), this.typeDesc.keyClass());
            }
            desc.set(key, TypeUtils.fromInternal(ectx, fieldVal, desc.storageType()));
        }
        if (key == null) {
            key = this.descriptors[0].defaultValue();
        }
        return key;
    }

    private <Row> Object insertVal(Row row, ExecutionContext<Row> ectx) throws IgniteCheckedException {
        RowHandler<Row> handler = ectx.rowHandler();
        Object val = handler.get(this.valField, row);
        if (val == null) {
            val = this.newVal(this.typeDesc.valueTypeName(), this.typeDesc.valueClass());
            for (int i = 2; i < this.descriptors.length; ++i) {
                CacheColumnDescriptor desc = this.descriptors[i];
                Object fieldVal = this.replaceDefault(handler.get(i, row), desc);
                if (!desc.field() || desc.key() || fieldVal == null) continue;
                desc.set(val, TypeUtils.fromInternal(ectx, fieldVal, desc.storageType()));
            }
        } else {
            val = this.replaceDefault(val, this.descriptors[1]);
            val = TypeUtils.fromInternal(ectx, val, this.descriptors[1].storageType());
        }
        return val;
    }

    private Object replaceDefault(Object val, ColumnDescriptor desc) {
        return val == RexImpTable.DEFAULT_VALUE_PLACEHOLDER ? desc.defaultValue() : val;
    }

    private Object newVal(String typeName, Class<?> typeCls) throws IgniteCheckedException {
        GridCacheContext cctx = this.cacheContext();
        if (cctx.binaryMarshaller()) {
            BinaryObjectBuilder builder = cctx.grid().binary().builder(typeName);
            cctx.prepareAffinityField(builder);
            return builder;
        }
        Class cls = U.classForName((String)typeName, typeCls);
        try {
            Constructor ctor = cls.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw this.instantiationException(typeName, e);
        }
        catch (NoSuchMethodException | SecurityException e) {
            try {
                return GridUnsafe.allocateInstance((Class)cls);
            }
            catch (InstantiationException e0) {
                e0.addSuppressed(e);
                throw this.instantiationException(typeName, e0);
            }
        }
    }

    private IgniteCheckedException instantiationException(String typeName, ReflectiveOperationException e) {
        return S.includeSensitive() ? new IgniteCheckedException("Failed to instantiate key [type=" + typeName + ']', (Throwable)e) : new IgniteCheckedException("Failed to instantiate key", (Throwable)e);
    }

    private <Row> ModifyTuple updateTuple(Row row, List<String> updateColList, int offset, ExecutionContext<Row> ectx) throws IgniteCheckedException {
        RowHandler<Row> handler = ectx.rowHandler();
        Object key = Objects.requireNonNull(handler.get(offset + 0, row));
        Object val = this.clone(Objects.requireNonNull(handler.get(offset + 1, row)));
        offset += this.descriptorsMap.size();
        for (int i = 0; i < updateColList.size(); ++i) {
            CacheColumnDescriptor desc = Objects.requireNonNull(this.descriptorsMap.get(updateColList.get(i)));
            assert (!desc.key());
            Object fieldVal = handler.get(i + offset, row);
            if (desc.field()) {
                desc.set(val, TypeUtils.fromInternal(ectx, fieldVal, desc.storageType()));
                continue;
            }
            val = TypeUtils.fromInternal(ectx, fieldVal, desc.storageType());
        }
        if (this.cacheContext().binaryMarshaller() && val instanceof BinaryObjectBuilder) {
            val = ((BinaryObjectBuilder)val).build();
        }
        this.typeDesc.validateKeyAndValue(key, val);
        return new ModifyTuple(key, val, TableModify.Operation.UPDATE);
    }

    private <Row> ModifyTuple mergeTuple(Row row, List<String> updateColList, ExecutionContext<Row> ectx) throws IgniteCheckedException {
        RowHandler<Row> hnd = ectx.rowHandler();
        int rowColumnsCnt = hnd.columnCount(row);
        if (rowColumnsCnt == this.descriptors.length) {
            return this.insertTuple(row, ectx);
        }
        if (rowColumnsCnt == this.descriptors.length + updateColList.size()) {
            return this.updateTuple(row, updateColList, 0, ectx);
        }
        assert (rowColumnsCnt == this.descriptors.length * 2 + updateColList.size()) : "Unexpected columns count: " + rowColumnsCnt;
        int updateOffset = this.descriptors.length;
        if (hnd.get(updateOffset + 0, row) != null) {
            return this.updateTuple(row, updateColList, updateOffset, ectx);
        }
        return this.insertTuple(row, ectx);
    }

    private Object clone(Object val) throws IgniteCheckedException {
        if (val == null || QueryUtils.isSqlType(val.getClass())) {
            return val;
        }
        GridCacheContext cctx = this.cacheContext();
        if (!cctx.binaryMarshaller()) {
            return cctx.marshaller().unmarshal(cctx.marshaller().marshal(val), U.resolveClassLoader((IgniteConfiguration)cctx.gridConfig()));
        }
        BinaryObjectBuilder builder = cctx.grid().binary().builder((BinaryObject)cctx.grid().binary().toBinary(val));
        cctx.prepareAffinityField(builder);
        return builder;
    }

    private <Row> ModifyTuple deleteTuple(Row row, ExecutionContext<Row> ectx) {
        Object key = TypeUtils.fromInternal(ectx, ectx.rowHandler().get(0, row), this.descriptors[0].storageType());
        return new ModifyTuple(Objects.requireNonNull(key), null, TableModify.Operation.DELETE);
    }

    @Override
    public RelDataType rowType(IgniteTypeFactory factory, ImmutableBitSet usedColumns) {
        RelDataTypeFactory.Builder b = new RelDataTypeFactory.Builder((RelDataTypeFactory)factory);
        if (usedColumns == null) {
            for (int i = 0; i < this.descriptors.length; ++i) {
                b.add(this.descriptors[i].name(), this.descriptors[i].logicalType(factory));
            }
        } else {
            int i = usedColumns.nextSetBit(0);
            while (i != -1) {
                b.add(this.descriptors[i].name(), this.descriptors[i].logicalType(factory));
                i = usedColumns.nextSetBit(i + 1);
            }
        }
        return b.build();
    }

    @Override
    public ColumnDescriptor columnDescriptor(String fieldName) {
        return fieldName == null ? null : (ColumnDescriptor)this.descriptorsMap.get(fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColocationGroup colocationGroup(MappingQueryContext ctx) {
        GridCacheContext cctx = this.cacheContext();
        if (!cctx.gate().enterIfNotStopped()) {
            throw U.convertException((IgniteCheckedException)new CacheStoppedException(cctx.name()));
        }
        try {
            ColocationGroup colocationGroup = cctx.isReplicated() ? this.replicatedGroup(ctx.topologyVersion()) : this.partitionedGroup(ctx.topologyVersion());
            return colocationGroup;
        }
        finally {
            cctx.gate().leave();
        }
    }

    private ColocationGroup partitionedGroup(@NotNull AffinityTopologyVersion topVer) {
        List<List<UUID>> assignments0;
        GridCacheContext cctx = this.cacheContext();
        List assignments = cctx.affinity().assignments(topVer);
        if (cctx.config().getWriteSynchronizationMode() != CacheWriteSynchronizationMode.PRIMARY_SYNC) {
            assignments0 = Commons.transform(assignments, nodes -> Commons.transform(nodes, ClusterNode::id));
        } else {
            assignments0 = new ArrayList<List>(assignments.size());
            for (List partNodes : assignments) {
                assignments0.add(F.isEmpty((Collection)partNodes) ? Collections.emptyList() : Collections.singletonList(((ClusterNode)F.first((List)partNodes)).id()));
            }
        }
        return ColocationGroup.forAssignments(assignments0);
    }

    private ColocationGroup replicatedGroup(@NotNull AffinityTopologyVersion topVer) {
        List<UUID> nodes0;
        GridCacheContext cctx = this.cacheContext();
        GridDhtPartitionTopology top = cctx.topology();
        List nodes = cctx.discovery().discoCache(topVer).cacheGroupAffinityNodes(cctx.groupId());
        if (!top.rebalanceFinished(topVer)) {
            nodes0 = new ArrayList<UUID>(nodes.size());
            int parts = top.partitions();
            for (ClusterNode node : nodes) {
                if (!this.isOwner(node.id(), top, parts)) continue;
                nodes0.add(node.id());
            }
        } else {
            nodes0 = Commons.transform(nodes, ClusterNode::id);
        }
        return ColocationGroup.forNodes(nodes0);
    }

    private boolean isOwner(UUID nodeId, GridDhtPartitionTopology top, int parts) {
        for (int p = 0; p < parts; ++p) {
            if (top.partitionState(nodeId, p) == GridDhtPartitionState.OWNING) continue;
            return false;
        }
        return true;
    }

    @Override
    public GridQueryTypeDescriptor typeDescription() {
        return this.typeDesc;
    }

    private static class FieldDescriptor
    implements CacheColumnDescriptor {
        private final GridQueryProperty desc;
        private final Object dfltVal;
        private final int fieldIdx;
        private final Class<?> storageType;
        private volatile RelDataType logicalType;

        private FieldDescriptor(GridQueryProperty desc, int fieldIdx) {
            this.desc = desc;
            this.fieldIdx = fieldIdx;
            this.dfltVal = desc.defaultValue();
            this.storageType = desc.type();
        }

        @Override
        public boolean field() {
            return true;
        }

        @Override
        public boolean key() {
            return this.desc.key();
        }

        @Override
        public boolean hasDefaultValue() {
            return this.dfltVal != null;
        }

        @Override
        public Object defaultValue() {
            return this.dfltVal;
        }

        @Override
        public String name() {
            return this.desc.name();
        }

        @Override
        public int fieldIndex() {
            return this.fieldIdx;
        }

        @Override
        public RelDataType logicalType(IgniteTypeFactory f) {
            if (this.logicalType == null) {
                this.logicalType = TypeUtils.sqlType(f, this.storageType, this.desc.precision() == -1 ? -1 : this.desc.precision(), this.desc.scale() == -1 ? Integer.MIN_VALUE : this.desc.scale());
            }
            return this.logicalType;
        }

        @Override
        public Class<?> storageType() {
            return this.storageType;
        }

        @Override
        public Object value(ExecutionContext<?> ectx, GridCacheContext<?, ?> cctx, CacheDataRow src) throws IgniteCheckedException {
            return cctx.unwrapBinaryIfNeeded(this.desc.value((Object)src.key(), (Object)src.value()), ectx.keepBinary(), null);
        }

        @Override
        public void set(Object dst, Object val) throws IgniteCheckedException {
            Object key0 = this.key() ? dst : null;
            Object val0 = this.key() ? null : dst;
            this.desc.setValue(key0, val0, val);
        }
    }

    private static class KeyValDescriptor
    implements CacheColumnDescriptor {
        private final String name;
        private final boolean isKey;
        private final int fieldIdx;
        private final Class<?> storageType;
        private volatile RelDataType logicalType;

        private KeyValDescriptor(String name, Class<?> type, boolean isKey, int fieldIdx) {
            this.name = name;
            this.isKey = isKey;
            this.fieldIdx = fieldIdx;
            this.storageType = type;
        }

        @Override
        public boolean field() {
            return false;
        }

        @Override
        public boolean key() {
            return this.isKey;
        }

        @Override
        public boolean hasDefaultValue() {
            return false;
        }

        @Override
        public Object defaultValue() {
            throw new AssertionError();
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int fieldIndex() {
            return this.fieldIdx;
        }

        @Override
        public RelDataType logicalType(IgniteTypeFactory f) {
            if (this.logicalType == null) {
                this.logicalType = TypeUtils.sqlType(f, this.storageType, -1, Integer.MIN_VALUE);
            }
            return this.logicalType;
        }

        @Override
        public Class<?> storageType() {
            return this.storageType;
        }

        @Override
        public Object value(ExecutionContext<?> ectx, GridCacheContext<?, ?> cctx, CacheDataRow src) {
            return cctx.unwrapBinaryIfNeeded(this.isKey ? src.key() : src.value(), ectx.keepBinary(), null);
        }

        @Override
        public void set(Object dst, Object val) {
            throw new AssertionError();
        }
    }
}

