/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.processors.query.calcite.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.processors.query.calcite.rule.logical.ImmutableProjectScanMergeRule;
import org.apache.ignite.internal.processors.query.calcite.rule.logical.RuleFactoryConfig;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;

@Value.Enclosing
public abstract class ProjectScanMergeRule<T extends ProjectableFilterableTableScan>
extends RelRule<Config> {
    public static final RelOptRule INDEX_SCAN = Config.INDEX_SCAN.toRule();
    public static final RelOptRule TABLE_SCAN = Config.TABLE_SCAN.toRule();
    public static final RelOptRule TABLE_SCAN_SKIP_CORRELATED = Config.TABLE_SCAN_SKIP_CORRELATED.toRule();

    @Nullable
    protected abstract T createNode(RelOptCluster var1, T var2, RelTraitSet var3, List<RexNode> var4, RexNode var5, ImmutableBitSet var6);

    private ProjectScanMergeRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        ProjectableFilterableTableScan res;
        LogicalProject relProject = (LogicalProject)call.rel(0);
        ProjectableFilterableTableScan scan = (ProjectableFilterableTableScan)call.rel(1);
        RelOptCluster cluster = scan.getCluster();
        List projects = relProject.getProjects();
        RexNode cond = scan.condition();
        ImmutableBitSet requiredColumns = scan.requiredColumns();
        final List<RexNode> scanProjects = scan.projects();
        RelTraitSet traits = cluster.traitSet();
        IgniteTable tbl = (IgniteTable)scan.getTable().unwrap(IgniteTable.class);
        IgniteTypeFactory typeFactory = Commons.typeFactory(cluster);
        if (requiredColumns == null) {
            assert (scanProjects == null);
            final ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
            new RexShuttle(){

                public RexNode visitInputRef(RexInputRef ref) {
                    builder.set(ref.getIndex());
                    return ref;
                }
            }.apply(projects);
            new RexShuttle(){

                public RexNode visitLocalRef(RexLocalRef inputRef) {
                    builder.set(inputRef.getIndex());
                    return inputRef;
                }
            }.apply(cond);
            requiredColumns = builder.build();
            final Mappings.TargetMapping targetMapping = Commons.mapping(requiredColumns, tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount());
            projects = new RexShuttle(){

                public RexNode visitInputRef(RexInputRef ref) {
                    return new RexLocalRef(targetMapping.getTarget(ref.getIndex()), ref.getType());
                }
            }.apply(projects);
            cond = new RexShuttle(){

                public RexNode visitLocalRef(RexLocalRef ref) {
                    return new RexLocalRef(targetMapping.getTarget(ref.getIndex()), ref.getType());
                }
            }.apply(cond);
        } else {
            projects = RexUtils.replaceInputRefs(projects);
        }
        if (scanProjects != null) {
            projects = new RexShuttle(){

                public RexNode visitLocalRef(RexLocalRef ref) {
                    return (RexNode)scanProjects.get(ref.getIndex());
                }
            }.apply(projects);
        }
        if (RexUtils.isIdentity(projects, tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns), true)) {
            projects = null;
        }
        if ((res = this.createNode(cluster, scan, traits, projects, cond, requiredColumns)) == null) {
            return;
        }
        call.transformTo((RelNode)res);
        if (!RexUtils.hasCorrelation(relProject.getProjects())) {
            cluster.getPlanner().prune((RelNode)relProject);
        }
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RuleFactoryConfig<Config> {
        public static final Config DEFAULT = ImmutableProjectScanMergeRule.Config.builder().withRuleFactory((Config x$0) -> new ProjectTableScanMergeRule((Config)x$0)).build();
        public static final Config TABLE_SCAN = DEFAULT.withScanRuleConfig(IgniteLogicalTableScan.class, "ProjectTableScanMergeRule", false);
        public static final Config TABLE_SCAN_SKIP_CORRELATED = DEFAULT.withScanRuleConfig(IgniteLogicalTableScan.class, "ProjectTableScanMergeSkipCorrelatedRule", true);
        public static final Config INDEX_SCAN = DEFAULT.withRuleFactory(x$0 -> new ProjectIndexScanMergeRule((Config)x$0)).withScanRuleConfig(IgniteLogicalIndexScan.class, "ProjectIndexScanMergeRule", false);

        default public Config withScanRuleConfig(Class<? extends ProjectableFilterableTableScan> scanCls, String desc, boolean skipCorrelated) {
            return (Config)this.withDescription(desc).withOperandSupplier(b -> b.operand(LogicalProject.class).predicate(p -> !skipCorrelated || !RexUtils.hasCorrelation(p.getProjects())).oneInput(b1 -> b1.operand(scanCls).noInputs())).as(Config.class);
        }
    }

    private static class ProjectIndexScanMergeRule
    extends ProjectScanMergeRule<IgniteLogicalIndexScan> {
        private ProjectIndexScanMergeRule(Config config) {
            super(config);
        }

        @Override
        @Nullable
        protected IgniteLogicalIndexScan createNode(RelOptCluster cluster, IgniteLogicalIndexScan scan, RelTraitSet traits, List<RexNode> projections, RexNode cond, ImmutableBitSet requiredColumns) {
            if (((IgniteTable)scan.getTable().unwrap(IgniteTable.class)).isIndexRebuildInProgress()) {
                cluster.getPlanner().prune((RelNode)scan);
                return null;
            }
            return IgniteLogicalIndexScan.create(cluster, traits, scan.getTable(), scan.indexName(), projections, cond, requiredColumns);
        }
    }

    private static class ProjectTableScanMergeRule
    extends ProjectScanMergeRule<IgniteLogicalTableScan> {
        private ProjectTableScanMergeRule(Config config) {
            super(config);
        }

        @Override
        protected IgniteLogicalTableScan createNode(RelOptCluster cluster, IgniteLogicalTableScan scan, RelTraitSet traits, List<RexNode> projections, RexNode cond, ImmutableBitSet requiredColumns) {
            return IgniteLogicalTableScan.create(cluster, traits, scan.getTable(), projections, cond, requiredColumns);
        }
    }
}

