/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteFilter;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableSpool;
import org.apache.ignite.internal.processors.query.calcite.rule.ImmutableFilterSpoolMergeToSortedIndexSpoolRule;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.util.IndexConditions;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.immutables.value.Value;

@Value.Enclosing
public class FilterSpoolMergeToSortedIndexSpoolRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    private FilterSpoolMergeToSortedIndexSpoolRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        RelCollation searchCollation;
        RelCollation traitCollation;
        RelNode input;
        RelCollation inCollation;
        IndexConditions idxCond;
        IgniteFilter filter = (IgniteFilter)call.rel(0);
        IgniteTableSpool spool = (IgniteTableSpool)call.rel(1);
        RelOptCluster cluster = spool.getCluster();
        RelTraitSet trait = spool.getTraitSet();
        CorrelationTrait filterCorr = TraitUtils.correlation((RelNode)filter);
        if (filterCorr.correlated()) {
            trait = trait.replace((RelTrait)filterCorr);
        }
        if (F.isEmpty((idxCond = RexUtils.buildSortedIndexConditions(cluster, inCollation = TraitUtils.collation(input = spool.getInput()), filter.getCondition(), spool.getRowType(), null)).lowerCondition()) && F.isEmpty(idxCond.upperCondition())) {
            return;
        }
        if (inCollation == null || inCollation.isDefault()) {
            List<RexNode> lowerBound = idxCond.lowerBound();
            List<RexNode> upperBound = idxCond.upperBound();
            assert (lowerBound == null || upperBound == null || lowerBound.size() == upperBound.size());
            int cardinality = lowerBound != null ? lowerBound.size() : upperBound.size();
            ArrayList<Integer> equalsFields = new ArrayList<Integer>(cardinality);
            ArrayList otherFields = new ArrayList(cardinality);
            for (int i = 0; i < cardinality; ++i) {
                RexNode upperNode;
                RexNode lowerNode = lowerBound != null ? lowerBound.get(i) : null;
                RexNode rexNode = upperNode = upperBound != null ? upperBound.get(i) : null;
                if (!RexUtils.isNotNull(lowerNode) && !RexUtils.isNotNull(upperNode)) continue;
                (F.eq((Object)lowerNode, (Object)upperNode) ? equalsFields : otherFields).add(i);
            }
            searchCollation = traitCollation = TraitUtils.createCollation(F.concat((boolean)true, equalsFields, otherFields));
        } else {
            traitCollation = inCollation;
            Set<Integer> searchKeys = idxCond.keys();
            List collationFields = inCollation.getFieldCollations().subList(0, searchKeys.size());
            assert (searchKeys.containsAll(collationFields.stream().map(RelFieldCollation::getFieldIndex).collect(Collectors.toSet()))) : "Search condition should be a prefix of collation [searchKeys=" + searchKeys + ", collation=" + inCollation + ']';
            searchCollation = RelCollations.of(collationFields);
        }
        IgniteSortedIndexSpool res = new IgniteSortedIndexSpool(cluster, trait.replace((RelTrait)traitCollation), FilterSpoolMergeToSortedIndexSpoolRule.convert((RelNode)input, (RelTraitSet)input.getTraitSet().replace((RelTrait)traitCollation)), searchCollation, filter.getCondition(), idxCond);
        call.transformTo((RelNode)res);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterSpoolMergeToSortedIndexSpoolRule.Config.of().withDescription("FilterSpoolMergeToSortedIndexSpoolRule").withOperandFor(IgniteFilter.class, IgniteTableSpool.class);

        default public Config withOperandFor(Class<? extends Filter> filterClass, Class<? extends Spool> spoolClass) {
            return (Config)this.withOperandSupplier(o0 -> o0.operand(filterClass).oneInput(o1 -> o1.operand(spoolClass).anyInputs())).as(Config.class);
        }

        default public FilterSpoolMergeToSortedIndexSpoolRule toRule() {
            return new FilterSpoolMergeToSortedIndexSpoolRule(this);
        }
    }
}

