/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.processors.query.calcite.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;

public class IgniteSort
extends Sort
implements IgniteRel {
    public IgniteSort(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation) {
        super(cluster, traits, child, collation);
    }

    public IgniteSort(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        assert (offset == null && fetch == null);
        return new IgniteSort(this.getCluster(), traitSet, newInput, newCollation);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        if (this.isEnforcer() || required.getConvention() != IgniteConvention.INSTANCE) {
            return null;
        }
        RelCollation collation = TraitUtils.collation(required);
        return Pair.of((Object)required.replace((RelTrait)collation), (Object)ImmutableList.of((Object)required.replace((RelTrait)RelCollations.EMPTY)));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        assert (childId == 0);
        if (this.isEnforcer() || childTraits.getConvention() != IgniteConvention.INSTANCE) {
            return null;
        }
        return Pair.of((Object)childTraits.replace((RelTrait)this.collation()), (Object)ImmutableList.of((Object)childTraits));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rows = mq.getRowCount(this.getInput());
        double cpuCost = rows * 1.0 + Util.nLogN((double)rows) * 3.0;
        double memory = rows * (double)this.getRowType().getFieldCount() * 4.0;
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        RelOptCost cost = costFactory.makeCost(rows, cpuCost, 0.0, memory, 0.0);
        if (TraitUtils.distribution(this.traitSet).satisfies((RelTrait)IgniteDistributions.single())) {
            cost.plus(costFactory.makeTinyCost());
        }
        return cost;
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteSort(cluster, this.getTraitSet(), (RelNode)IgniteSort.sole(inputs), this.collation);
    }
}

