/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare.ddl;

import java.util.ArrayList;
import java.util.UUID;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.calcite.prepare.PlanningContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.NativeCommandWrapper;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlAlterTable;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlAlterUser;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlCreateIndex;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlCreateUser;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlDropIndex;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlDropUser;
import org.apache.ignite.internal.processors.query.calcite.sql.IgniteSqlKill;
import org.apache.ignite.internal.processors.query.calcite.sql.kill.IgniteSqlKillComputeTask;
import org.apache.ignite.internal.processors.query.calcite.sql.kill.IgniteSqlKillContinuousQuery;
import org.apache.ignite.internal.processors.query.calcite.sql.kill.IgniteSqlKillQuery;
import org.apache.ignite.internal.processors.query.calcite.sql.kill.IgniteSqlKillScanQuery;
import org.apache.ignite.internal.processors.query.calcite.sql.kill.IgniteSqlKillService;
import org.apache.ignite.internal.processors.query.calcite.sql.kill.IgniteSqlKillTransaction;
import org.apache.ignite.internal.processors.query.calcite.util.PlanUtils;
import org.apache.ignite.internal.sql.command.SqlAlterTableCommand;
import org.apache.ignite.internal.sql.command.SqlAlterUserCommand;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCreateIndexCommand;
import org.apache.ignite.internal.sql.command.SqlCreateUserCommand;
import org.apache.ignite.internal.sql.command.SqlDropIndexCommand;
import org.apache.ignite.internal.sql.command.SqlDropUserCommand;
import org.apache.ignite.internal.sql.command.SqlIndexColumn;
import org.apache.ignite.internal.sql.command.SqlKillComputeTaskCommand;
import org.apache.ignite.internal.sql.command.SqlKillContinuousQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillScanQueryCommand;
import org.apache.ignite.internal.sql.command.SqlKillServiceCommand;
import org.apache.ignite.internal.sql.command.SqlKillTransactionCommand;
import org.apache.ignite.lang.IgniteUuid;

public class SqlToNativeCommandConverter {
    public static boolean isSupported(SqlNode sqlCmd) {
        return sqlCmd instanceof IgniteSqlCreateIndex || sqlCmd instanceof IgniteSqlDropIndex || sqlCmd instanceof IgniteSqlAlterTable || sqlCmd instanceof IgniteSqlCreateUser || sqlCmd instanceof IgniteSqlAlterUser || sqlCmd instanceof IgniteSqlDropUser || sqlCmd instanceof IgniteSqlKill;
    }

    public static NativeCommandWrapper convert(SqlDdl sqlCmd, PlanningContext pctx) {
        return new NativeCommandWrapper(SqlToNativeCommandConverter.convertSqlCmd(sqlCmd, pctx));
    }

    private static SqlCommand convertSqlCmd(SqlDdl cmd, PlanningContext pctx) {
        if (cmd instanceof IgniteSqlCreateIndex) {
            return SqlToNativeCommandConverter.convertCreateIndex((IgniteSqlCreateIndex)cmd, pctx);
        }
        if (cmd instanceof IgniteSqlDropIndex) {
            return SqlToNativeCommandConverter.convertDropIndex((IgniteSqlDropIndex)cmd, pctx);
        }
        if (cmd instanceof IgniteSqlAlterTable) {
            return SqlToNativeCommandConverter.convertAlterTable((IgniteSqlAlterTable)cmd, pctx);
        }
        if (cmd instanceof IgniteSqlCreateUser) {
            return SqlToNativeCommandConverter.convertCreateUser((IgniteSqlCreateUser)cmd, pctx);
        }
        if (cmd instanceof IgniteSqlAlterUser) {
            return SqlToNativeCommandConverter.convertAlterUser((IgniteSqlAlterUser)cmd, pctx);
        }
        if (cmd instanceof IgniteSqlDropUser) {
            return SqlToNativeCommandConverter.convertDropUser((IgniteSqlDropUser)cmd, pctx);
        }
        if (cmd instanceof IgniteSqlKill) {
            return SqlToNativeCommandConverter.convertKill((IgniteSqlKill)cmd, pctx);
        }
        throw new IgniteSQLException("Unsupported native operation [cmdName=" + (cmd == null ? null : cmd.getClass().getSimpleName()) + "; querySql=\"" + pctx.query() + "\"]", 1002);
    }

    private static SqlCreateIndexCommand convertCreateIndex(IgniteSqlCreateIndex sqlCmd, PlanningContext ctx) {
        String schemaName = PlanUtils.deriveSchemaName(sqlCmd.tableName(), ctx);
        String tblName = PlanUtils.deriveObjectName(sqlCmd.tableName(), ctx, "table name");
        String idxName = sqlCmd.indexName().getSimple();
        ArrayList<SqlIndexColumn> cols = new ArrayList<SqlIndexColumn>(sqlCmd.columnList().size());
        for (SqlNode col : sqlCmd.columnList().getList()) {
            boolean desc = false;
            if (col.getKind() == SqlKind.DESCENDING) {
                col = (SqlNode)((SqlCall)col).getOperandList().get(0);
                desc = true;
            }
            cols.add(new SqlIndexColumn(((SqlIdentifier)col).getSimple(), desc));
        }
        int parallel = sqlCmd.parallel() == null ? 0 : sqlCmd.parallel().intValue(true);
        int inlineSize = sqlCmd.inlineSize() == null ? -1 : sqlCmd.inlineSize().intValue(true);
        return new SqlCreateIndexCommand(schemaName, tblName, idxName, sqlCmd.ifNotExists(), cols, false, parallel, inlineSize);
    }

    private static SqlDropIndexCommand convertDropIndex(IgniteSqlDropIndex sqlCmd, PlanningContext ctx) {
        String schemaName = PlanUtils.deriveSchemaName(sqlCmd.name(), ctx);
        String idxName = PlanUtils.deriveObjectName(sqlCmd.name(), ctx, "index name");
        return new SqlDropIndexCommand(schemaName, idxName, sqlCmd.ifExists());
    }

    private static SqlAlterTableCommand convertAlterTable(IgniteSqlAlterTable sqlCmd, PlanningContext ctx) {
        String schemaName = PlanUtils.deriveSchemaName(sqlCmd.name(), ctx);
        String tblName = PlanUtils.deriveObjectName(sqlCmd.name(), ctx, "table name");
        return new SqlAlterTableCommand(schemaName, tblName, sqlCmd.ifExists(), sqlCmd.logging());
    }

    private static SqlCreateUserCommand convertCreateUser(IgniteSqlCreateUser sqlCmd, PlanningContext ctx) {
        return new SqlCreateUserCommand(sqlCmd.user().getSimple(), sqlCmd.password());
    }

    private static SqlAlterUserCommand convertAlterUser(IgniteSqlAlterUser sqlCmd, PlanningContext ctx) {
        return new SqlAlterUserCommand(sqlCmd.user().getSimple(), sqlCmd.password());
    }

    private static SqlDropUserCommand convertDropUser(IgniteSqlDropUser sqlCmd, PlanningContext ctx) {
        return new SqlDropUserCommand(sqlCmd.user().getSimple());
    }

    private static SqlCommand convertKill(IgniteSqlKill cmd, PlanningContext pctx) {
        if (cmd instanceof IgniteSqlKillScanQuery) {
            IgniteSqlKillScanQuery cmd0 = (IgniteSqlKillScanQuery)cmd;
            return new SqlKillScanQueryCommand(UUID.fromString((String)cmd0.nodeId().getValueAs(String.class)), (String)cmd0.cacheName().getValueAs(String.class), cmd0.queryId().longValue(true));
        }
        if (cmd instanceof IgniteSqlKillContinuousQuery) {
            IgniteSqlKillContinuousQuery cmd0 = (IgniteSqlKillContinuousQuery)cmd;
            return new SqlKillContinuousQueryCommand(UUID.fromString((String)cmd0.nodeId().getValueAs(String.class)), UUID.fromString((String)cmd0.routineId().getValueAs(String.class)));
        }
        if (cmd instanceof IgniteSqlKillService) {
            IgniteSqlKillService cmd0 = (IgniteSqlKillService)cmd;
            return new SqlKillServiceCommand((String)cmd0.serviceName().getValueAs(String.class));
        }
        if (cmd instanceof IgniteSqlKillTransaction) {
            IgniteSqlKillTransaction cmd0 = (IgniteSqlKillTransaction)cmd;
            return new SqlKillTransactionCommand((String)cmd0.xid().getValueAs(String.class));
        }
        if (cmd instanceof IgniteSqlKillComputeTask) {
            IgniteSqlKillComputeTask cmd0 = (IgniteSqlKillComputeTask)cmd;
            IgniteUuid sessId = IgniteUuid.fromString((String)((String)cmd0.sessionId().getValueAs(String.class)));
            return new SqlKillComputeTaskCommand(sessId);
        }
        if (cmd instanceof IgniteSqlKillQuery) {
            IgniteSqlKillQuery cmd0 = (IgniteSqlKillQuery)cmd;
            return new SqlKillQueryCommand(cmd0.nodeId(), cmd0.queryId(), cmd0.isAsync());
        }
        throw new IgniteSQLException("Unsupported native operation [cmdName=" + (cmd == null ? null : ((Object)((Object)cmd)).getClass().getSimpleName()) + "; querySql=\"" + pctx.query() + "\"]", 1002);
    }
}

