/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.calcite.prepare.CacheKey;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryPlanCache;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.processors.query.schema.SchemaChangeListener;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.spi.systemview.view.SystemView;

public class QueryPlanCacheImpl
extends AbstractService
implements QueryPlanCache,
SchemaChangeListener {
    private static final int CACHE_SIZE = 1024;
    private GridInternalSubscriptionProcessor subscriptionProcessor;
    private volatile Map<CacheKey, QueryPlan> cache = new GridBoundedConcurrentLinkedHashMap(1024);

    public QueryPlanCacheImpl(GridKernalContext ctx) {
        super(ctx);
        this.subscriptionProcessor(ctx.internalSubscriptionProcessor());
        this.init();
    }

    public void subscriptionProcessor(GridInternalSubscriptionProcessor subscriptionProcessor) {
        this.subscriptionProcessor = subscriptionProcessor;
    }

    @Override
    public void init() {
        this.subscriptionProcessor.registerSchemaChangeListener((SchemaChangeListener)this);
    }

    @Override
    public void onStart(GridKernalContext ctx) {
    }

    @Override
    public QueryPlan queryPlan(CacheKey key, Supplier<QueryPlan> planSupplier) {
        Map<CacheKey, QueryPlan> cache = this.cache;
        QueryPlan plan = cache.computeIfAbsent(key, k -> (QueryPlan)planSupplier.get());
        return plan.copy();
    }

    @Override
    public QueryPlan queryPlan(CacheKey key) {
        Map<CacheKey, QueryPlan> cache = this.cache;
        QueryPlan plan = cache.get(key);
        return plan != null ? plan.copy() : null;
    }

    @Override
    public void clear() {
        this.cache = new GridBoundedConcurrentLinkedHashMap(1024);
    }

    public void onSchemaDropped(String schemaName) {
        this.clear();
    }

    public void onSqlTypeDropped(String schemaName, GridQueryTypeDescriptor typeDescriptor) {
        this.clear();
    }

    public void onIndexCreated(String schemaName, String tblName, String idxName, GridQueryIndexDescriptor idxDesc, Index idx) {
        this.clear();
    }

    public void onIndexDropped(String schemaName, String tblName, String idxName) {
        this.clear();
    }

    public void onIndexRebuildStarted(String schemaName, String tblName) {
        this.clear();
    }

    public void onIndexRebuildFinished(String schemaName, String tblName) {
        this.clear();
    }

    public void onSchemaCreated(String schemaName) {
    }

    public void onSqlTypeCreated(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo) {
    }

    public void onSqlTypeUpdated(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo) {
        this.clear();
    }

    public void onFunctionCreated(String schemaName, String name, Method method) {
    }

    public void onSystemViewCreated(String schemaName, SystemView<?> sysView) {
    }
}

