/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.processors.query.calcite.externalize.RelJsonWriter;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationMappingException;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentMapping;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentMappingException;
import org.apache.ignite.internal.processors.query.calcite.metadata.IgniteMdFragmentMapping;
import org.apache.ignite.internal.processors.query.calcite.metadata.MappingService;
import org.apache.ignite.internal.processors.query.calcite.metadata.NodeMappingException;
import org.apache.ignite.internal.processors.query.calcite.prepare.Cloner;
import org.apache.ignite.internal.processors.query.calcite.prepare.MappingQueryContext;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteReceiver;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSender;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Fragment {
    private final long id;
    private final IgniteRel root;
    @GridToStringExclude
    private final String rootSer;
    private final FragmentMapping mapping;
    private final ImmutableList<IgniteReceiver> remotes;

    public Fragment(long id, IgniteRel root, List<IgniteReceiver> remotes) {
        this(id, root, remotes, null, null);
    }

    Fragment(long id, IgniteRel root, List<IgniteReceiver> remotes, @Nullable String rootSer, @Nullable FragmentMapping mapping) {
        this.id = id;
        this.root = root;
        this.remotes = ImmutableList.copyOf(remotes);
        this.rootSer = rootSer != null ? rootSer : RelJsonWriter.toJson((RelNode)root);
        this.mapping = mapping;
    }

    public long fragmentId() {
        return this.id;
    }

    public IgniteRel root() {
        return this.root;
    }

    public String serialized() {
        return this.rootSer;
    }

    public FragmentMapping mapping() {
        return this.mapping;
    }

    public List<IgniteReceiver> remotes() {
        return this.remotes;
    }

    public boolean rootFragment() {
        return !(this.root instanceof IgniteSender);
    }

    public Fragment attach(RelOptCluster cluster) {
        return this.root.getCluster() == cluster ? this : new Cloner(cluster).go(this);
    }

    Fragment map(MappingService mappingSrvc, MappingQueryContext ctx, RelMetadataQuery mq) throws FragmentMappingException {
        if (this.mapping != null) {
            return this;
        }
        return new Fragment(this.id, this.root, (List<IgniteReceiver>)this.remotes, this.rootSer, this.mapping(ctx, mq, this.nodesSource(mappingSrvc, ctx)));
    }

    private FragmentMapping mapping(MappingQueryContext ctx, RelMetadataQuery mq, Supplier<List<UUID>> nodesSource) {
        try {
            FragmentMapping mapping = IgniteMdFragmentMapping._fragmentMapping((RelNode)this.root, mq, ctx);
            if (this.rootFragment()) {
                mapping = FragmentMapping.create(ctx.localNodeId()).colocate(mapping);
            }
            if (this.single() && mapping.nodeIds().size() > 1) {
                mapping = FragmentMapping.create(mapping.nodeIds().get(ThreadLocalRandom.current().nextInt(mapping.nodeIds().size()))).colocate(mapping);
            }
            return mapping.finalize(nodesSource);
        }
        catch (NodeMappingException e) {
            throw new FragmentMappingException("Failed to calculate physical distribution", this, e.node(), e);
        }
        catch (ColocationMappingException e) {
            throw new FragmentMappingException("Failed to calculate physical distribution", this, (RelNode)this.root, e);
        }
    }

    @NotNull
    private Supplier<List<UUID>> nodesSource(MappingService mappingSrvc, MappingQueryContext ctx) {
        return () -> mappingSrvc.executionNodes(ctx.topologyVersion(), this.single(), null);
    }

    private boolean single() {
        return this.root instanceof IgniteSender && ((IgniteSender)this.root).sourceDistribution().satisfies((RelTrait)IgniteDistributions.single());
    }

    public String toString() {
        return S.toString(Fragment.class, (Object)this, (String)"root", (Object)RelOptUtil.toString((RelNode)this.root));
    }
}

