/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.metadata.cost;

import java.util.Objects;
import org.apache.calcite.plan.RelOptCost;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IgniteCost
implements RelOptCost {
    public static final double ROW_PASS_THROUGH_COST = 1.0;
    public static final double AVERAGE_FIELD_SIZE = 4.0;
    public static final double ROW_COMPARISON_COST = 3.0;
    public static final double AGG_CALL_MEM_COST = 5.0;
    public static final double HASH_LOOKUP_COST = 10.0;
    public static final double BROADCAST_DISTRIBUTION_PENALTY = 5.0;
    static final IgniteCost ZERO = new IgniteCost(0.0, 0.0, 0.0, 0.0, 0.0);
    static final IgniteCost TINY = new IgniteCost(1.0, 1.0, 1.0, 1.0, 1.0);
    static final IgniteCost HUGE = new IgniteCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
    static final IgniteCost INFINITY = new IgniteCost(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private final double rowCount;
    private final double cpu;
    private final double memory;
    private final double io;
    private final double network;

    IgniteCost(double rowCount, double cpu, double memory, double io, double network) {
        this.rowCount = rowCount;
        this.cpu = cpu;
        this.memory = memory;
        this.io = io;
        this.network = network;
    }

    public double getRows() {
        return this.rowCount;
    }

    public double getCpu() {
        return this.cpu;
    }

    public double getIo() {
        return this.io;
    }

    public double getMemory() {
        return this.memory;
    }

    public double getNetwork() {
        return this.network;
    }

    public boolean isInfinite() {
        return this == INFINITY || this.rowCount == Double.POSITIVE_INFINITY || this.cpu == Double.POSITIVE_INFINITY || this.memory == Double.POSITIVE_INFINITY || this.io == Double.POSITIVE_INFINITY || this.network == Double.POSITIVE_INFINITY;
    }

    public int hashCode() {
        return Objects.hash(this.rowCount, this.cpu, this.io, this.memory, this.network);
    }

    public boolean equals(RelOptCost cost) {
        return this == cost || cost instanceof IgniteCost && this.rowCount == ((IgniteCost)cost).rowCount && this.cpu == ((IgniteCost)cost).cpu && this.memory == ((IgniteCost)cost).memory && this.io == ((IgniteCost)cost).io && this.network == ((IgniteCost)cost).network;
    }

    public boolean isEqWithEpsilon(RelOptCost cost) {
        return this == cost || cost instanceof IgniteCost && Math.abs(this.rowCount - ((IgniteCost)cost).rowCount) < 1.0E-5 && Math.abs(this.cpu - ((IgniteCost)cost).cpu) < 1.0E-5 && Math.abs(this.memory - ((IgniteCost)cost).memory) < 1.0E-5 && Math.abs(this.io - ((IgniteCost)cost).io) < 1.0E-5 && Math.abs(this.network - ((IgniteCost)cost).network) < 1.0E-5;
    }

    public boolean isLe(RelOptCost cost) {
        IgniteCost other = (IgniteCost)cost;
        return this == cost || this.cpu + this.memory + this.io + this.network <= other.cpu + other.memory + other.io + other.network;
    }

    public boolean isLt(RelOptCost cost) {
        IgniteCost other = (IgniteCost)cost;
        return this != cost && this.cpu + this.memory + this.io + this.network < other.cpu + other.memory + other.io + other.network;
    }

    public RelOptCost plus(RelOptCost cost) {
        IgniteCost other = (IgniteCost)cost;
        return new IgniteCost(this.rowCount + other.rowCount, this.cpu + other.cpu, this.memory + other.memory, this.io + other.io, this.network + other.network);
    }

    public RelOptCost minus(RelOptCost cost) {
        IgniteCost other = (IgniteCost)cost;
        return new IgniteCost(this.rowCount - other.rowCount, this.cpu - other.cpu, this.memory - other.memory, this.io - other.io, this.network - other.network);
    }

    public RelOptCost multiplyBy(double factor) {
        return new IgniteCost(this.rowCount * factor, this.cpu * factor, this.memory * factor, this.io * factor, this.network * factor);
    }

    public double divideBy(RelOptCost cost) {
        throw new UnsupportedOperationException(IgniteCost.class.getSimpleName() + "#divideBy");
    }

    public String toString() {
        return S.toString(IgniteCost.class, (Object)this);
    }
}

