/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.externalize;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVariable;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsertKeyword;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.trait.DistributionFunction;
import org.apache.ignite.internal.processors.query.calcite.trait.DistributionTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteCustomType;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

class RelJson {
    private static final LoadingCache<String, RelFactory> FACTORIES_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(RelJson::relFactory));
    private static final ImmutableMap<String, Enum<?>> ENUM_BY_NAME;
    private static final List<String> PACKAGES;
    private final BaseQueryContext qctx;

    private static RelFactory relFactory(String typeName) {
        Constructor<?> constructor;
        Class<?> clazz = null;
        if (!typeName.contains(".")) {
            String package_;
            Iterator<String> iterator = PACKAGES.iterator();
            while (iterator.hasNext() && (clazz = RelJson.classForName((package_ = iterator.next()) + typeName, true)) == null) {
            }
        }
        if (clazz == null) {
            clazz = RelJson.classForName(typeName, false);
        }
        assert (RelNode.class.isAssignableFrom(clazz));
        try {
            constructor = clazz.getConstructor(RelInput.class);
        }
        catch (NoSuchMethodException e) {
            throw new IgniteException("class does not have required constructor, " + clazz + "(RelInput)");
        }
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression input_ = Expressions.parameter(RelInput.class);
        builder.add((Expression)Expressions.new_(constructor, (Expression[])new Expression[]{input_}));
        MethodDeclaration declaration = Expressions.methodDecl((int)1, RelNode.class, (String)"apply", (Iterable)F.asList((Object)input_), (BlockStatement)builder.toBlock());
        return Commons.compile(RelFactory.class, Expressions.toString((List)F.asList((Object)declaration), (String)"\n", (boolean)true));
    }

    private static void register(ImmutableMap.Builder<String, Enum<?>> builder, Class<? extends Enum> aClass) {
        String preffix = aClass.getSimpleName() + "#";
        for (Enum enumConstant : aClass.getEnumConstants()) {
            builder.put((Object)(preffix + enumConstant.name()), (Object)enumConstant);
        }
    }

    private static Class<?> classForName(String typeName, boolean skipNotFound) {
        try {
            return U.forName((String)typeName, (ClassLoader)U.gridClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (!skipNotFound) {
                throw new IgniteException("unknown type " + typeName);
            }
            return null;
        }
    }

    RelJson(BaseQueryContext qctx) {
        this.qctx = qctx;
    }

    Function<RelInput, RelNode> factory(String type) {
        return (Function)FACTORIES_CACHE.getUnchecked((Object)type);
    }

    String classToTypeName(Class<? extends RelNode> class_) {
        if (IgniteRel.class.isAssignableFrom(class_)) {
            return class_.getSimpleName();
        }
        String canonicalName = class_.getName();
        for (String package_ : PACKAGES) {
            String remaining;
            if (!canonicalName.startsWith(package_) || (remaining = canonicalName.substring(package_.length())).indexOf(46) >= 0 || remaining.indexOf(36) >= 0) continue;
            return remaining;
        }
        return canonicalName;
    }

    Object toJson(Object value) {
        if (value == null || value instanceof Number || value instanceof String || value instanceof Boolean) {
            return value;
        }
        if (value instanceof Enum) {
            return this.toJson((Enum)value);
        }
        if (value instanceof RexNode) {
            return this.toJson((RexNode)value);
        }
        if (value instanceof RexWindow) {
            return this.toJson((RexWindow)value);
        }
        if (value instanceof RexFieldCollation) {
            return this.toJson((RexFieldCollation)value);
        }
        if (value instanceof RexWindowBound) {
            return this.toJson((RexWindowBound)value);
        }
        if (value instanceof CorrelationId) {
            return this.toJson((CorrelationId)value);
        }
        if (value instanceof List) {
            List list = this.list();
            for (Object o : (List)value) {
                list.add(this.toJson(o));
            }
            return list;
        }
        if (value instanceof ImmutableBitSet) {
            List list = this.list();
            for (Integer integer : (ImmutableBitSet)value) {
                list.add(this.toJson(integer));
            }
            return list;
        }
        if (value instanceof Set) {
            Set set = this.set();
            for (Object o : (Set)value) {
                set.add(this.toJson(o));
            }
            return set;
        }
        if (value instanceof DistributionTrait) {
            return this.toJson((DistributionTrait)value);
        }
        if (value instanceof AggregateCall) {
            return this.toJson((AggregateCall)value);
        }
        if (value instanceof RelCollationImpl) {
            return this.toJson((RelCollationImpl)value);
        }
        if (value instanceof RelDataType) {
            return this.toJson((RelDataType)value);
        }
        if (value instanceof RelDataTypeField) {
            return this.toJson((RelDataTypeField)value);
        }
        if (value instanceof ByteString) {
            return this.toJson((ByteString)value);
        }
        throw new UnsupportedOperationException("type not serializable: " + value + " (type " + value.getClass().getCanonicalName() + ")");
    }

    RelCollation toCollation(List<Map<String, Object>> jsonFieldCollations) {
        if (jsonFieldCollations == null) {
            return RelCollations.EMPTY;
        }
        List fieldCollations = jsonFieldCollations.stream().map(this::toFieldCollation).collect(Collectors.toList());
        return RelCollations.of(fieldCollations);
    }

    IgniteDistribution toDistribution(Object distribution) {
        Map map;
        Number cacheId;
        if (distribution instanceof String) {
            switch ((String)distribution) {
                case "single": {
                    return IgniteDistributions.single();
                }
                case "any": {
                    return IgniteDistributions.any();
                }
                case "broadcast": {
                    return IgniteDistributions.broadcast();
                }
                case "random": {
                    return IgniteDistributions.random();
                }
            }
        }
        if ((cacheId = (Number)(map = (Map)distribution).get("cacheId")) != null) {
            return IgniteDistributions.hash((List)map.get("keys"), DistributionFunction.affinity(cacheId.intValue(), map.get("identity")));
        }
        return IgniteDistributions.hash((List)map.get("keys"), DistributionFunction.hash());
    }

    RelDataType toType(RelDataTypeFactory typeFactory, Object o) {
        if (o instanceof List) {
            List jsonList = (List)o;
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (Map jsonMap : jsonList) {
                builder.add((String)jsonMap.get("name"), this.toType(typeFactory, jsonMap));
            }
            return builder.build();
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            String clazz = (String)map.get("class");
            if (clazz != null) {
                RelDataType type = typeFactory.createJavaType(RelJson.classForName(clazz, false));
                if (Boolean.TRUE == map.get("nullable")) {
                    type = typeFactory.createTypeWithNullability(type, true);
                }
                return type;
            }
            Object fields = map.get("fields");
            if (fields != null) {
                return this.toType(typeFactory, fields);
            }
            SqlTypeName sqlTypeName = (SqlTypeName)this.toEnum(map.get("type"));
            Integer precision = (Integer)map.get("precision");
            Integer scale = (Integer)map.get("scale");
            RelDataType type = null;
            if (SqlTypeName.INTERVAL_TYPES.contains(sqlTypeName)) {
                TimeUnit startUnit = sqlTypeName.getStartUnit();
                TimeUnit endUnit = sqlTypeName.getEndUnit();
                type = typeFactory.createSqlIntervalType(new SqlIntervalQualifier(startUnit, endUnit, SqlParserPos.ZERO));
            } else if (sqlTypeName == SqlTypeName.ARRAY) {
                type = typeFactory.createArrayType(this.toType(typeFactory, map.get("elementType")), -1L);
            } else if (sqlTypeName == SqlTypeName.MAP) {
                type = typeFactory.createMapType(this.toType(typeFactory, map.get("keyType")), this.toType(typeFactory, map.get("valueType")));
            } else if (sqlTypeName == SqlTypeName.ANY) {
                String customType = (String)map.get("customType");
                if (customType != null) {
                    type = ((IgniteTypeFactory)typeFactory).createCustomType(RelJson.classForName(customType, false));
                }
            } else if (precision == null) {
                type = typeFactory.createSqlType(sqlTypeName);
            } else if (scale == null) {
                type = typeFactory.createSqlType(sqlTypeName, precision.intValue());
            }
            if (type == null) {
                type = typeFactory.createSqlType(sqlTypeName, precision.intValue(), scale.intValue());
            }
            if (Boolean.TRUE == map.get("nullable")) {
                type = typeFactory.createTypeWithNullability(type, true);
            }
            return type;
        }
        SqlTypeName sqlTypeName = (SqlTypeName)this.toEnum(o);
        return typeFactory.createSqlType(sqlTypeName);
    }

    RexNode toRex(RelInput relInput, Object o) {
        RelOptCluster cluster = relInput.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            Map opMap = (Map)map.get("op");
            IgniteTypeFactory typeFactory = Commons.typeFactory(cluster);
            if (opMap != null) {
                if (map.containsKey("class")) {
                    opMap.put("class", map.get("class"));
                }
                List operands = (List)map.get("operands");
                List<RexNode> rexOperands = this.toRexList(relInput, operands);
                Object jsonType = map.get("type");
                Map window = (Map)map.get("window");
                if (window != null) {
                    boolean physical;
                    RexWindowBound upperBound;
                    RexWindowBound lowerBound;
                    SqlAggFunction operator = (SqlAggFunction)this.toOp(opMap);
                    RelDataType type = this.toType((RelDataTypeFactory)typeFactory, jsonType);
                    List<Object> partitionKeys = new ArrayList();
                    if (window.containsKey("partition")) {
                        partitionKeys = this.toRexList(relInput, (List)window.get("partition"));
                    }
                    List<Object> orderKeys = new ArrayList();
                    if (window.containsKey("order")) {
                        orderKeys = this.toRexFieldCollationList(relInput, (List)window.get("order"));
                    }
                    if (window.get("rows-lower") != null) {
                        lowerBound = this.toRexWindowBound(relInput, (Map)window.get("rows-lower"));
                        upperBound = this.toRexWindowBound(relInput, (Map)window.get("rows-upper"));
                        physical = true;
                    } else if (window.get("range-lower") != null) {
                        lowerBound = this.toRexWindowBound(relInput, (Map)window.get("range-lower"));
                        upperBound = this.toRexWindowBound(relInput, (Map)window.get("range-upper"));
                        physical = false;
                    } else {
                        lowerBound = null;
                        upperBound = null;
                        physical = false;
                    }
                    boolean distinct = (Boolean)map.get("distinct");
                    return rexBuilder.makeOver(type, operator, rexOperands, partitionKeys, ImmutableList.copyOf(orderKeys), lowerBound, upperBound, physical, true, false, distinct, false);
                }
                SqlOperator operator = this.toOp(opMap);
                RelDataType type = jsonType != null ? this.toType((RelDataTypeFactory)typeFactory, jsonType) : rexBuilder.deriveReturnType(operator, rexOperands);
                return rexBuilder.makeCall(type, operator, rexOperands);
            }
            Integer input = (Integer)map.get("input");
            if (input != null) {
                if (map.containsKey("type")) {
                    RelDataType type = this.toType((RelDataTypeFactory)typeFactory, map.get("type"));
                    return map.get("dynamic") == Boolean.TRUE ? rexBuilder.makeDynamicParam(type, input.intValue()) : rexBuilder.makeLocalRef(type, input.intValue());
                }
                List inputNodes = relInput.getInputs();
                int i = input;
                for (RelNode inputNode : inputNodes) {
                    RelDataType rowType = inputNode.getRowType();
                    if (i < rowType.getFieldCount()) {
                        RelDataTypeField field = (RelDataTypeField)rowType.getFieldList().get(i);
                        return rexBuilder.makeInputRef(field.getType(), input.intValue());
                    }
                    i -= rowType.getFieldCount();
                }
                throw new RuntimeException("input field " + input + " is out of range");
            }
            String field = (String)map.get("field");
            if (field != null) {
                Object jsonExpr = map.get("expr");
                RexNode expr = this.toRex(relInput, jsonExpr);
                return rexBuilder.makeFieldAccess(expr, field, true);
            }
            String correl = (String)map.get("correl");
            if (correl != null) {
                RelDataType type = this.toType((RelDataTypeFactory)typeFactory, map.get("type"));
                return rexBuilder.makeCorrel(type, new CorrelationId(correl));
            }
            if (map.containsKey("literal")) {
                Object literal = map.get("literal");
                RelDataType type = this.toType((RelDataTypeFactory)typeFactory, map.get("type"));
                if (literal == null) {
                    return rexBuilder.makeNullLiteral(type);
                }
                if (type.getSqlTypeName() == SqlTypeName.SYMBOL) {
                    literal = this.toEnum(literal);
                } else if (type.getSqlTypeName().getFamily() == SqlTypeFamily.BINARY) {
                    literal = this.toByteString(literal);
                }
                return rexBuilder.makeLiteral(literal, type, false);
            }
            throw new UnsupportedOperationException("cannot convert to rex " + o);
        }
        if (o instanceof Boolean) {
            return rexBuilder.makeLiteral(((Boolean)o).booleanValue());
        }
        if (o instanceof String) {
            return rexBuilder.makeLiteral((String)o);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            if (number instanceof Double || number instanceof Float) {
                return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(number.doubleValue()));
            }
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(number.longValue()));
        }
        throw new UnsupportedOperationException("cannot convert to rex " + o);
    }

    SqlOperator toOp(Map<String, Object> map) {
        String name = map.get("name").toString();
        SqlKind sqlKind = (SqlKind)this.toEnum(map.get("kind"));
        SqlSyntax sqlSyntax = (SqlSyntax)this.toEnum(map.get("syntax"));
        ArrayList operators = new ArrayList();
        this.qctx.opTable().lookupOperatorOverloads(new SqlIdentifier(name, new SqlParserPos(0, 0)), null, sqlSyntax, operators, SqlNameMatchers.liberal());
        for (SqlOperator operator : operators) {
            if (operator.kind != sqlKind) continue;
            return operator;
        }
        String class_ = (String)map.get("class");
        if (class_ != null) {
            return (SqlOperator)AvaticaUtils.instantiatePlugin(SqlOperator.class, (String)class_);
        }
        return null;
    }

    <T> List<T> list() {
        return new ArrayList();
    }

    <T> Set<T> set() {
        return new LinkedHashSet();
    }

    <T> Map<String, T> map() {
        return new LinkedHashMap();
    }

    <T extends Enum<T>> T toEnum(Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            String class_ = (String)map.get("class");
            String name = map.get("name").toString();
            return (T)Util.enumVal(RelJson.classForName(class_, false), (String)name);
        }
        assert (o instanceof String && ENUM_BY_NAME.containsKey(o));
        String name = (String)o;
        return (T)((Enum)ENUM_BY_NAME.get((Object)name));
    }

    private ByteString toByteString(Object o) {
        assert (o instanceof String);
        return ByteString.of((String)((String)o), (int)16);
    }

    private RelFieldCollation toFieldCollation(Map<String, Object> map) {
        Integer field = (Integer)map.get("field");
        RelFieldCollation.Direction direction = (RelFieldCollation.Direction)this.toEnum(map.get("direction"));
        RelFieldCollation.NullDirection nullDirection = (RelFieldCollation.NullDirection)this.toEnum(map.get("nulls"));
        return new RelFieldCollation(field.intValue(), direction, nullDirection);
    }

    private List<RexFieldCollation> toRexFieldCollationList(RelInput relInput, List<Map<String, Object>> order) {
        if (order == null) {
            return null;
        }
        ArrayList<RexFieldCollation> list = new ArrayList<RexFieldCollation>();
        for (Map<String, Object> o : order) {
            RexNode expr = this.toRex(relInput, o.get("expr"));
            HashSet<SqlKind> directions = new HashSet<SqlKind>();
            if (this.toEnum(o.get("direction")) == RelFieldCollation.Direction.DESCENDING) {
                directions.add(SqlKind.DESCENDING);
            }
            if (this.toEnum(o.get("null-direction")) == RelFieldCollation.NullDirection.FIRST) {
                directions.add(SqlKind.NULLS_FIRST);
            } else {
                directions.add(SqlKind.NULLS_LAST);
            }
            list.add(new RexFieldCollation(expr, directions));
        }
        return list;
    }

    private RexWindowBound toRexWindowBound(RelInput input, Map<String, Object> map) {
        String type;
        if (map == null) {
            return null;
        }
        switch (type = (String)map.get("type")) {
            case "CURRENT_ROW": {
                return RexWindowBounds.create((SqlNode)SqlWindow.createCurrentRow((SqlParserPos)SqlParserPos.ZERO), null);
            }
            case "UNBOUNDED_PRECEDING": {
                return RexWindowBounds.create((SqlNode)SqlWindow.createUnboundedPreceding((SqlParserPos)SqlParserPos.ZERO), null);
            }
            case "UNBOUNDED_FOLLOWING": {
                return RexWindowBounds.create((SqlNode)SqlWindow.createUnboundedFollowing((SqlParserPos)SqlParserPos.ZERO), null);
            }
            case "PRECEDING": {
                RexNode precedingOffset = this.toRex(input, map.get("offset"));
                return RexWindowBounds.create(null, (RexNode)input.getCluster().getRexBuilder().makeCall((SqlOperator)SqlWindow.PRECEDING_OPERATOR, new RexNode[]{precedingOffset}));
            }
            case "FOLLOWING": {
                RexNode followingOffset = this.toRex(input, map.get("offset"));
                return RexWindowBounds.create(null, (RexNode)input.getCluster().getRexBuilder().makeCall((SqlOperator)SqlWindow.FOLLOWING_OPERATOR, new RexNode[]{followingOffset}));
            }
        }
        throw new UnsupportedOperationException("cannot convert type to rex window bound " + type);
    }

    private List<RexNode> toRexList(RelInput relInput, List<?> operands) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (Object operand : operands) {
            list.add(this.toRex(relInput, operand));
        }
        return list;
    }

    private Object toJson(Enum<?> enum0) {
        String key = enum0.getDeclaringClass().getSimpleName() + "#" + enum0.name();
        if (ENUM_BY_NAME.get((Object)key) == enum0) {
            return key;
        }
        Map map = this.map();
        map.put("class", enum0.getDeclaringClass().getName());
        map.put("name", enum0.name());
        return map;
    }

    private Object toJson(AggregateCall node) {
        Map map = this.map();
        map.put("agg", this.toJson((SqlOperator)node.getAggregation()));
        map.put("type", this.toJson(node.getType()));
        map.put("distinct", node.isDistinct());
        map.put("operands", node.getArgList());
        map.put("filter", node.filterArg);
        map.put("name", node.getName());
        return map;
    }

    private Object toJson(RelDataType node) {
        if (node instanceof RelDataTypeFactoryImpl.JavaType) {
            Map map = this.map();
            map.put("class", ((RelDataTypeFactoryImpl.JavaType)node).getJavaClass().getName());
            if (node.isNullable()) {
                map.put("nullable", true);
            }
            return map;
        }
        if (node.isStruct()) {
            List list = this.list();
            for (RelDataTypeField field : node.getFieldList()) {
                list.add(this.toJson(field));
            }
            return list;
        }
        if (node.getSqlTypeName() == SqlTypeName.ARRAY) {
            Map map = this.map();
            map.put("type", this.toJson((Enum<?>)node.getSqlTypeName()));
            map.put("elementType", this.toJson(node.getComponentType()));
            return map;
        }
        if (node.getSqlTypeName() == SqlTypeName.MAP) {
            Map map = this.map();
            map.put("type", this.toJson((Enum<?>)node.getSqlTypeName()));
            map.put("keyType", this.toJson(node.getKeyType()));
            map.put("valueType", this.toJson(node.getValueType()));
            return map;
        }
        Map map = this.map();
        map.put("type", this.toJson((Enum<?>)node.getSqlTypeName()));
        if (node.getSqlTypeName() == SqlTypeName.ANY && node instanceof IgniteCustomType) {
            map.put("customType", ((IgniteCustomType)node).storageType().getTypeName());
        }
        if (node.isNullable()) {
            map.put("nullable", true);
        }
        if (node.getSqlTypeName().allowsPrec()) {
            map.put("precision", node.getPrecision());
        }
        if (node.getSqlTypeName().allowsScale()) {
            map.put("scale", node.getScale());
        }
        return map;
    }

    private Object toJson(RelDataTypeField node) {
        Map map;
        if (node.getType().isStruct()) {
            map = this.map();
            map.put("fields", this.toJson(node.getType()));
        } else {
            map = (Map)this.toJson(node.getType());
        }
        map.put("name", node.getName());
        return map;
    }

    private Object toJson(CorrelationId node) {
        return node.getId();
    }

    private Object toJson(RexNode node) {
        node = RexUtil.expandSearch((RexBuilder)Commons.emptyCluster().getRexBuilder(), null, (RexNode)node);
        switch (node.getKind()) {
            case FIELD_ACCESS: {
                Map map = this.map();
                RexFieldAccess fieldAccess = (RexFieldAccess)node;
                map.put("field", fieldAccess.getField().getName());
                map.put("expr", this.toJson(fieldAccess.getReferenceExpr()));
                return map;
            }
            case LITERAL: {
                RexLiteral literal = (RexLiteral)node;
                Object value = literal.getValue3();
                Map map = this.map();
                map.put("literal", this.toJson(value));
                map.put("type", this.toJson(node.getType()));
                return map;
            }
            case INPUT_REF: {
                Map map = this.map();
                map.put("input", ((RexSlot)node).getIndex());
                map.put("name", ((RexVariable)node).getName());
                return map;
            }
            case DYNAMIC_PARAM: {
                Map map = this.map();
                map.put("input", ((RexDynamicParam)node).getIndex());
                map.put("name", ((RexVariable)node).getName());
                map.put("type", this.toJson(node.getType()));
                map.put("dynamic", true);
                return map;
            }
            case LOCAL_REF: {
                Map map = this.map();
                map.put("input", ((RexSlot)node).getIndex());
                map.put("name", ((RexVariable)node).getName());
                map.put("type", this.toJson(node.getType()));
                return map;
            }
            case CORREL_VARIABLE: {
                Map map = this.map();
                map.put("correl", ((RexVariable)node).getName());
                map.put("type", this.toJson(node.getType()));
                return map;
            }
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            Map map = this.map();
            map.put("op", this.toJson(call.getOperator()));
            List list = this.list();
            for (RexNode operand : call.getOperands()) {
                list.add(this.toJson(operand));
            }
            map.put("operands", list);
            map.put("type", this.toJson(node.getType()));
            if (call.getOperator() instanceof SqlFunction && ((SqlFunction)call.getOperator()).getFunctionType().isUserDefined()) {
                SqlOperator op = call.getOperator();
                map.put("class", op.getClass().getName());
                map.put("deterministic", op.isDeterministic());
                map.put("dynamic", op.isDynamicFunction());
            }
            if (call instanceof RexOver) {
                RexOver over = (RexOver)call;
                map.put("distinct", over.isDistinct());
                map.put("window", this.toJson(over.getWindow()));
            }
            return map;
        }
        throw new UnsupportedOperationException("unknown rex " + node);
    }

    private Object toJson(RexWindow window) {
        Map map = this.map();
        if (!window.partitionKeys.isEmpty()) {
            map.put("partition", this.toJson(window.partitionKeys));
        }
        if (!window.orderKeys.isEmpty()) {
            map.put("order", this.toJson(window.orderKeys));
        }
        if (window.getLowerBound() != null) {
            if (window.getUpperBound() == null) {
                if (window.isRows()) {
                    map.put("rows-lower", this.toJson(window.getLowerBound()));
                } else {
                    map.put("range-lower", this.toJson(window.getLowerBound()));
                }
            } else if (window.isRows()) {
                map.put("rows-lower", this.toJson(window.getLowerBound()));
                map.put("rows-upper", this.toJson(window.getUpperBound()));
            } else {
                map.put("range-lower", this.toJson(window.getLowerBound()));
                map.put("range-upper", this.toJson(window.getUpperBound()));
            }
        }
        return map;
    }

    private Object toJson(DistributionTrait distribution) {
        RelDistribution.Type type = distribution.getType();
        switch (type) {
            case ANY: 
            case BROADCAST_DISTRIBUTED: 
            case RANDOM_DISTRIBUTED: 
            case SINGLETON: {
                return type.shortName;
            }
            case HASH_DISTRIBUTED: {
                Map map = this.map();
                List keys = this.list();
                for (Integer key : distribution.getKeys()) {
                    keys.add(this.toJson(key));
                }
                map.put("keys", keys);
                DistributionFunction function = distribution.function();
                if (function.affinity()) {
                    map.put("cacheId", function.cacheId());
                    map.put("identity", function.identity().toString());
                }
                return map;
            }
        }
        throw new AssertionError((Object)"Unexpected distribution type.");
    }

    private Object toJson(RelCollationImpl node) {
        List list = this.list();
        for (RelFieldCollation fieldCollation : node.getFieldCollations()) {
            Map map = this.map();
            map.put("field", fieldCollation.getFieldIndex());
            map.put("direction", this.toJson((Enum<?>)fieldCollation.getDirection()));
            map.put("nulls", this.toJson((Enum<?>)fieldCollation.nullDirection));
            list.add(map);
        }
        return list;
    }

    private Object toJson(RexFieldCollation collation) {
        Map map = this.map();
        map.put("expr", this.toJson((RexNode)collation.left));
        map.put("direction", this.toJson((Enum<?>)collation.getDirection()));
        map.put("null-direction", this.toJson((Enum<?>)collation.getNullDirection()));
        return map;
    }

    private Object toJson(RexWindowBound windowBound) {
        Map map = this.map();
        if (windowBound.isCurrentRow()) {
            map.put("type", "CURRENT_ROW");
        } else if (windowBound.isUnbounded()) {
            map.put("type", windowBound.isPreceding() ? "UNBOUNDED_PRECEDING" : "UNBOUNDED_FOLLOWING");
        } else {
            map.put("type", windowBound.isPreceding() ? "PRECEDING" : "FOLLOWING");
            map.put("offset", this.toJson(windowBound.getOffset()));
        }
        return map;
    }

    private Object toJson(SqlOperator operator) {
        Map map = this.map();
        map.put("name", operator.getName());
        map.put("kind", this.toJson((Enum<?>)operator.kind));
        map.put("syntax", this.toJson((Enum<?>)operator.getSyntax()));
        return map;
    }

    private Object toJson(ByteString val) {
        return val.toString();
    }

    static {
        ImmutableMap.Builder enumByName = ImmutableMap.builder();
        RelJson.register(enumByName, JoinConditionType.class);
        RelJson.register(enumByName, JoinType.class);
        RelJson.register(enumByName, RelFieldCollation.Direction.class);
        RelJson.register(enumByName, RelFieldCollation.NullDirection.class);
        RelJson.register(enumByName, SqlTypeName.class);
        RelJson.register(enumByName, SqlKind.class);
        RelJson.register(enumByName, SqlSyntax.class);
        RelJson.register(enumByName, SqlExplain.Depth.class);
        RelJson.register(enumByName, SqlExplainFormat.class);
        RelJson.register(enumByName, SqlExplainLevel.class);
        RelJson.register(enumByName, SqlInsertKeyword.class);
        RelJson.register(enumByName, SqlJsonConstructorNullClause.class);
        RelJson.register(enumByName, SqlJsonQueryWrapperBehavior.class);
        RelJson.register(enumByName, SqlJsonValueEmptyOrErrorBehavior.class);
        RelJson.register(enumByName, SqlMatchRecognize.AfterOption.class);
        RelJson.register(enumByName, SqlSelectKeyword.class);
        RelJson.register(enumByName, SqlTrimFunction.Flag.class);
        RelJson.register(enumByName, TimeUnitRange.class);
        RelJson.register(enumByName, Spool.Type.class);
        ENUM_BY_NAME = enumByName.build();
        PACKAGES = ImmutableList.of((Object)"org.apache.ignite.internal.processors.query.calcite.rel.", (Object)"org.apache.ignite.internal.processors.query.calcite.rel.agg.", (Object)"org.apache.ignite.internal.processors.query.calcite.rel.set.", (Object)"org.apache.calcite.rel.", (Object)"org.apache.calcite.rel.core.", (Object)"org.apache.calcite.rel.logical.", (Object)"org.apache.calcite.adapter.jdbc.", (Object)"org.apache.calcite.adapter.jdbc.JdbcRules$");
    }

    @FunctionalInterface
    public static interface RelFactory
    extends Function<RelInput, RelNode> {
        @Override
        public RelNode apply(RelInput var1);
    }
}

