/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Node;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.NotNull;

public abstract class MergeJoinNode<Row>
extends AbstractNode<Row> {
    protected static final int NOT_WAITING = -1;
    protected final Comparator<Row> comp;
    protected final RowHandler<Row> handler;
    protected int requested;
    protected int waitingLeft;
    protected int waitingRight;
    protected final Deque<Row> rightInBuf = new ArrayDeque<Row>(IN_BUFFER_SIZE);
    protected final Deque<Row> leftInBuf = new ArrayDeque<Row>(IN_BUFFER_SIZE);
    protected boolean inLoop;

    private MergeJoinNode(ExecutionContext<Row> ctx, RelDataType rowType, Comparator<Row> comp) {
        super(ctx, rowType);
        this.comp = comp;
        this.handler = ctx.rowHandler();
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!F.isEmpty(this.sources()) && this.sources().size() == 2);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.context().execute(this::doJoin, this::onError);
        }
    }

    private void doJoin() throws Exception {
        this.checkState();
        this.join();
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waitingLeft = 0;
        this.waitingRight = 0;
        this.rightInBuf.clear();
        this.leftInBuf.clear();
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        if (idx == 0) {
            return new Downstream<Row>(){

                @Override
                public void push(Row row) throws Exception {
                    MergeJoinNode.this.pushLeft(row);
                }

                @Override
                public void end() throws Exception {
                    MergeJoinNode.this.endLeft();
                }

                @Override
                public void onError(Throwable e) {
                    MergeJoinNode.this.onError(e);
                }
            };
        }
        if (idx == 1) {
            return new Downstream<Row>(){

                @Override
                public void push(Row row) throws Exception {
                    MergeJoinNode.this.pushRight(row);
                }

                @Override
                public void end() throws Exception {
                    MergeJoinNode.this.endRight();
                }

                @Override
                public void onError(Throwable e) {
                    MergeJoinNode.this.onError(e);
                }
            };
        }
        throw new IndexOutOfBoundsException();
    }

    private void pushLeft(Row row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingLeft > 0);
        this.checkState();
        --this.waitingLeft;
        this.leftInBuf.add(row);
        this.join();
    }

    private void pushRight(Row row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        this.checkState();
        --this.waitingRight;
        this.rightInBuf.add(row);
        this.join();
    }

    private void endLeft() throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingLeft > 0);
        this.checkState();
        this.waitingLeft = -1;
        this.join();
    }

    private void endRight() throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        this.checkState();
        this.waitingRight = -1;
        this.join();
    }

    protected Node<Row> leftSource() {
        return this.sources().get(0);
    }

    protected Node<Row> rightSource() {
        return this.sources().get(1);
    }

    protected abstract void join() throws Exception;

    @NotNull
    public static <Row> MergeJoinNode<Row> create(ExecutionContext<Row> ctx, RelDataType outputRowType, RelDataType leftRowType, RelDataType rightRowType, JoinRelType joinType, Comparator<Row> comp) {
        switch (joinType) {
            case INNER: {
                return new InnerJoin<Row>(ctx, outputRowType, comp);
            }
            case LEFT: {
                RowHandler.RowFactory<Row> rightRowFactory = ctx.rowHandler().factory(ctx.getTypeFactory(), rightRowType);
                return new LeftJoin<Row>(ctx, outputRowType, comp, rightRowFactory);
            }
            case RIGHT: {
                RowHandler.RowFactory<Row> leftRowFactory = ctx.rowHandler().factory(ctx.getTypeFactory(), leftRowType);
                return new RightJoin<Row>(ctx, outputRowType, comp, leftRowFactory);
            }
            case FULL: {
                RowHandler.RowFactory<Row> leftRowFactory = ctx.rowHandler().factory(ctx.getTypeFactory(), leftRowType);
                RowHandler.RowFactory<Row> rightRowFactory = ctx.rowHandler().factory(ctx.getTypeFactory(), rightRowType);
                return new FullOuterJoin<Row>(ctx, outputRowType, comp, leftRowFactory, rightRowFactory);
            }
            case SEMI: {
                return new SemiJoin<Row>(ctx, outputRowType, comp);
            }
            case ANTI: {
                return new AntiJoin<Row>(ctx, outputRowType, comp);
            }
        }
        throw new IllegalStateException("Join type \"" + joinType + "\" is not supported yet");
    }

    private static class AntiJoin<Row>
    extends MergeJoinNode<Row> {
        private Row left;
        private Row right;

        public AntiJoin(ExecutionContext<Row> ctx, RelDataType rowType, Comparator<Row> comp) {
            super(ctx, rowType, comp);
        }

        @Override
        protected void rewindInternal() {
            this.left = null;
            this.right = null;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            this.inLoop = true;
            try {
                while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty() || this.right == null && this.rightInBuf.isEmpty() && this.waitingRight != -1)) {
                    this.checkState();
                    if (this.left == null) {
                        this.left = this.leftInBuf.remove();
                    }
                    if (this.right == null && !this.rightInBuf.isEmpty()) {
                        this.right = this.rightInBuf.remove();
                    }
                    if (this.right != null) {
                        int cmp = this.comp.compare(this.left, this.right);
                        if (cmp == 0) {
                            this.left = null;
                            continue;
                        }
                        if (cmp > 0) {
                            this.right = null;
                            continue;
                        }
                    }
                    --this.requested;
                    this.downstream().push(this.left);
                    this.left = null;
                }
            }
            finally {
                this.inLoop = false;
            }
            if (this.waitingRight == 0) {
                this.waitingRight = IN_BUFFER_SIZE;
                this.rightSource().request(this.waitingRight);
            }
            if (this.waitingLeft == 0) {
                this.waitingLeft = IN_BUFFER_SIZE;
                this.leftSource().request(this.waitingLeft);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.left == null && this.leftInBuf.isEmpty()) {
                this.requested = 0;
                this.downstream().end();
            }
        }
    }

    private static class SemiJoin<Row>
    extends MergeJoinNode<Row> {
        private Row left;
        private Row right;

        public SemiJoin(ExecutionContext<Row> ctx, RelDataType rowType, Comparator<Row> comp) {
            super(ctx, rowType, comp);
        }

        @Override
        protected void rewindInternal() {
            this.left = null;
            this.right = null;
            super.rewindInternal();
        }

        @Override
        protected void join() throws Exception {
            this.inLoop = true;
            try {
                while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty() || this.right == null && this.rightInBuf.isEmpty())) {
                    int cmp;
                    this.checkState();
                    if (this.left == null) {
                        this.left = this.leftInBuf.remove();
                    }
                    if (this.right == null) {
                        this.right = this.rightInBuf.remove();
                    }
                    if ((cmp = this.comp.compare(this.left, this.right)) < 0) {
                        this.left = null;
                        continue;
                    }
                    if (cmp > 0) {
                        this.right = null;
                        continue;
                    }
                    --this.requested;
                    this.downstream().push(this.left);
                    this.left = null;
                }
            }
            finally {
                this.inLoop = false;
            }
            if (this.waitingRight == 0) {
                this.waitingRight = IN_BUFFER_SIZE;
                this.rightSource().request(this.waitingRight);
            }
            if (this.waitingLeft == 0) {
                this.waitingLeft = IN_BUFFER_SIZE;
                this.leftSource().request(this.waitingLeft);
            }
            if (this.requested > 0 && (this.waitingLeft == -1 && this.left == null && this.leftInBuf.isEmpty() || this.waitingRight == -1 && this.right == null && this.rightInBuf.isEmpty())) {
                this.requested = 0;
                this.downstream().end();
            }
        }
    }

    private static class FullOuterJoin<Row>
    extends MergeJoinNode<Row> {
        private final RowHandler.RowFactory<Row> leftRowFactory;
        private final RowHandler.RowFactory<Row> rightRowFactory;
        private Row left;
        private Row right;
        private List<Row> rightMaterialization;
        private int rightIdx;
        private boolean drainMaterialization;
        private boolean leftMatched;
        private boolean rightMatched;

        public FullOuterJoin(ExecutionContext<Row> ctx, RelDataType rowType, Comparator<Row> comp, RowHandler.RowFactory<Row> leftRowFactory, RowHandler.RowFactory<Row> rightRowFactory) {
            super(ctx, rowType, comp);
            this.leftRowFactory = leftRowFactory;
            this.rightRowFactory = rightRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.left = null;
            this.right = null;
            this.rightIdx = 0;
            this.rightMaterialization = null;
            this.drainMaterialization = false;
            super.rewindInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            this.inLoop = true;
            try {
                while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty() && this.waitingLeft != -1 || this.right == null && this.rightInBuf.isEmpty() && this.rightMaterialization == null && this.waitingRight != -1)) {
                    Row row;
                    this.checkState();
                    if (this.left == null && !this.leftInBuf.isEmpty()) {
                        this.left = this.leftInBuf.remove();
                        this.leftMatched = false;
                    }
                    if (this.right == null) {
                        if (this.rightInBuf.isEmpty() && this.waitingRight != -1) {
                            break;
                        }
                        if (!this.rightInBuf.isEmpty()) {
                            this.right = this.rightInBuf.remove();
                            this.rightMatched = false;
                        }
                    }
                    if (this.right == null && this.rightMaterialization != null && !this.drainMaterialization) {
                        this.drainMaterialization = true;
                        this.left = null;
                        continue;
                    }
                    if (!this.drainMaterialization) {
                        if (this.left == null || this.right == null) {
                            if (this.left == null && this.right != null) {
                                if (!this.rightMatched) {
                                    row = this.handler.concat(this.leftRowFactory.create(), this.right);
                                    --this.requested;
                                    this.downstream().push(row);
                                }
                                this.right = null;
                                continue;
                            }
                            if (this.left != null && this.right == null) {
                                if (!this.leftMatched) {
                                    row = this.handler.concat(this.left, this.rightRowFactory.create());
                                    --this.requested;
                                    this.downstream().push(row);
                                }
                                this.left = null;
                                continue;
                            }
                            break;
                        }
                        int cmp = this.comp.compare(this.left, this.right);
                        if (cmp < 0) {
                            if (!this.leftMatched) {
                                row = this.handler.concat(this.left, this.rightRowFactory.create());
                                --this.requested;
                                this.downstream().push(row);
                            }
                            this.left = null;
                            this.rightIdx = 0;
                            if (this.rightMaterialization == null) continue;
                            this.drainMaterialization = true;
                            continue;
                        }
                        if (cmp > 0) {
                            if (!this.rightMatched) {
                                row = this.handler.concat(this.leftRowFactory.create(), this.right);
                                --this.requested;
                                this.downstream().push(row);
                            }
                            this.right = null;
                            this.rightIdx = 0;
                            this.rightMaterialization = null;
                            continue;
                        }
                        if (!(this.rightMaterialization != null || this.rightInBuf.isEmpty() && this.waitingRight == -1)) {
                            if (this.rightInBuf.isEmpty()) {
                                break;
                            }
                            if (this.comp.compare(this.left, this.rightInBuf.peek()) == 0) {
                                this.rightMaterialization = new ArrayList<Row>();
                            }
                        }
                        this.leftMatched = true;
                        this.rightMatched = true;
                        row = this.handler.concat(this.left, this.right);
                        if (this.rightMaterialization != null) {
                            this.rightMaterialization.add(this.right);
                            this.right = null;
                        } else {
                            this.left = null;
                        }
                    } else {
                        Row right;
                        int cmp;
                        if (this.left == null) {
                            if (this.waitingLeft == -1) {
                                this.rightMaterialization = null;
                            }
                            break;
                        }
                        if (this.rightIdx >= this.rightMaterialization.size()) {
                            this.rightIdx = 0;
                            this.left = null;
                            continue;
                        }
                        if ((cmp = this.comp.compare(this.left, right = this.rightMaterialization.get(this.rightIdx++))) > 0) {
                            this.rightIdx = 0;
                            this.rightMaterialization = null;
                            this.drainMaterialization = false;
                            continue;
                        }
                        this.leftMatched = true;
                        row = this.handler.concat(this.left, right);
                    }
                    --this.requested;
                    this.downstream().push(row);
                }
            }
            finally {
                this.inLoop = false;
            }
            if (this.waitingRight == 0) {
                this.waitingRight = IN_BUFFER_SIZE;
                this.rightSource().request(this.waitingRight);
            }
            if (this.waitingLeft == 0) {
                this.waitingLeft = IN_BUFFER_SIZE;
                this.leftSource().request(this.waitingLeft);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.left == null && this.leftInBuf.isEmpty() && this.waitingRight == -1 && this.right == null && this.rightInBuf.isEmpty() && this.rightMaterialization == null) {
                this.requested = 0;
                this.downstream().end();
            }
        }
    }

    private static class RightJoin<Row>
    extends MergeJoinNode<Row> {
        private final RowHandler.RowFactory<Row> leftRowFactory;
        private Row left;
        private Row right;
        private List<Row> rightMaterialization;
        private int rightIdx;
        private boolean drainMaterialization;
        private boolean matched;

        public RightJoin(ExecutionContext<Row> ctx, RelDataType rowType, Comparator<Row> comp, RowHandler.RowFactory<Row> leftRowFactory) {
            super(ctx, rowType, comp);
            this.leftRowFactory = leftRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.left = null;
            this.right = null;
            this.rightIdx = 0;
            this.rightMaterialization = null;
            this.drainMaterialization = false;
            super.rewindInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            this.inLoop = true;
            try {
                while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty() && this.waitingLeft != -1 || this.right == null && this.rightInBuf.isEmpty() && this.rightMaterialization == null)) {
                    Row row;
                    this.checkState();
                    if (this.left == null && !this.leftInBuf.isEmpty()) {
                        this.left = this.leftInBuf.remove();
                    }
                    if (this.right == null) {
                        if (this.rightInBuf.isEmpty() && this.waitingRight != -1) {
                            break;
                        }
                        if (!this.rightInBuf.isEmpty()) {
                            this.right = this.rightInBuf.remove();
                            this.matched = false;
                        }
                    }
                    if (this.right == null && this.rightMaterialization != null && !this.drainMaterialization) {
                        this.drainMaterialization = true;
                        this.left = null;
                        continue;
                    }
                    if (!this.drainMaterialization) {
                        if (this.left == null) {
                            if (!this.matched) {
                                row = this.handler.concat(this.leftRowFactory.create(), this.right);
                                --this.requested;
                                this.downstream().push(row);
                            }
                            this.right = null;
                            continue;
                        }
                        int cmp = this.comp.compare(this.left, this.right);
                        if (cmp < 0) {
                            this.left = null;
                            this.rightIdx = 0;
                            if (this.rightMaterialization == null) continue;
                            this.drainMaterialization = true;
                            continue;
                        }
                        if (cmp > 0) {
                            if (!this.matched) {
                                row = this.handler.concat(this.leftRowFactory.create(), this.right);
                                --this.requested;
                                this.downstream().push(row);
                            }
                            this.right = null;
                            this.rightIdx = 0;
                            this.rightMaterialization = null;
                            continue;
                        }
                        if (!(this.rightMaterialization != null || this.rightInBuf.isEmpty() && this.waitingRight == -1)) {
                            if (this.rightInBuf.isEmpty()) {
                                break;
                            }
                            if (this.comp.compare(this.left, this.rightInBuf.peek()) == 0) {
                                this.rightMaterialization = new ArrayList<Row>();
                            }
                        }
                        this.matched = true;
                        row = this.handler.concat(this.left, this.right);
                        if (this.rightMaterialization != null) {
                            this.rightMaterialization.add(this.right);
                            this.right = null;
                        } else {
                            this.left = null;
                        }
                    } else {
                        Row right;
                        int cmp;
                        if (this.left == null) {
                            if (this.waitingLeft == -1) {
                                this.rightMaterialization = null;
                            }
                            break;
                        }
                        if (this.rightIdx >= this.rightMaterialization.size()) {
                            this.rightIdx = 0;
                            this.left = null;
                            continue;
                        }
                        if ((cmp = this.comp.compare(this.left, right = this.rightMaterialization.get(this.rightIdx++))) > 0) {
                            this.rightIdx = 0;
                            this.rightMaterialization = null;
                            this.drainMaterialization = false;
                            continue;
                        }
                        row = this.handler.concat(this.left, right);
                    }
                    --this.requested;
                    this.downstream().push(row);
                }
            }
            finally {
                this.inLoop = false;
            }
            if (this.waitingRight == 0) {
                this.waitingRight = IN_BUFFER_SIZE;
                this.rightSource().request(this.waitingRight);
            }
            if (this.waitingLeft == 0) {
                this.waitingLeft = IN_BUFFER_SIZE;
                this.leftSource().request(this.waitingLeft);
            }
            if (this.requested > 0 && this.waitingRight == -1 && this.right == null && this.rightInBuf.isEmpty() && this.rightMaterialization == null) {
                this.requested = 0;
                this.downstream().end();
            }
        }
    }

    private static class LeftJoin<Row>
    extends MergeJoinNode<Row> {
        private final RowHandler.RowFactory<Row> rightRowFactory;
        private Row left;
        private Row right;
        private List<Row> rightMaterialization;
        private int rightIdx;
        private boolean drainMaterialization;
        private boolean matched;

        public LeftJoin(ExecutionContext<Row> ctx, RelDataType rowType, Comparator<Row> comp, RowHandler.RowFactory<Row> rightRowFactory) {
            super(ctx, rowType, comp);
            this.rightRowFactory = rightRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.left = null;
            this.right = null;
            this.rightIdx = 0;
            this.rightMaterialization = null;
            this.drainMaterialization = false;
            super.rewindInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            this.inLoop = true;
            try {
                while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty() || this.right == null && this.rightInBuf.isEmpty() && this.rightMaterialization == null && this.waitingRight != -1)) {
                    Row row;
                    this.checkState();
                    if (this.left == null) {
                        this.left = this.leftInBuf.remove();
                        this.matched = false;
                    }
                    if (this.right == null) {
                        if (this.rightInBuf.isEmpty() && this.waitingRight != -1) {
                            break;
                        }
                        if (!this.rightInBuf.isEmpty()) {
                            this.right = this.rightInBuf.remove();
                        }
                    }
                    if (this.right == null && this.rightMaterialization != null && !this.drainMaterialization) {
                        this.drainMaterialization = true;
                        this.left = null;
                        continue;
                    }
                    if (!this.drainMaterialization) {
                        if (this.right == null) {
                            row = this.handler.concat(this.left, this.rightRowFactory.create());
                            --this.requested;
                            this.downstream().push(row);
                            this.left = null;
                            continue;
                        }
                        int cmp = this.comp.compare(this.left, this.right);
                        if (cmp < 0) {
                            if (!this.matched) {
                                row = this.handler.concat(this.left, this.rightRowFactory.create());
                                --this.requested;
                                this.downstream().push(row);
                            }
                            this.left = null;
                            this.rightIdx = 0;
                            if (this.rightMaterialization == null) continue;
                            this.drainMaterialization = true;
                            continue;
                        }
                        if (cmp > 0) {
                            this.right = null;
                            this.rightIdx = 0;
                            this.rightMaterialization = null;
                            continue;
                        }
                        this.matched = true;
                        if (!(this.rightMaterialization != null || this.rightInBuf.isEmpty() && this.waitingRight == -1)) {
                            if (this.rightInBuf.isEmpty()) {
                                break;
                            }
                            if (this.comp.compare(this.left, this.rightInBuf.peek()) == 0) {
                                this.rightMaterialization = new ArrayList<Row>();
                            }
                        }
                        row = this.handler.concat(this.left, this.right);
                        if (this.rightMaterialization != null) {
                            this.rightMaterialization.add(this.right);
                            this.right = null;
                        } else {
                            this.left = null;
                        }
                    } else {
                        Row right;
                        int cmp;
                        if (this.rightIdx >= this.rightMaterialization.size()) {
                            this.rightIdx = 0;
                            this.left = null;
                            continue;
                        }
                        if ((cmp = this.comp.compare(this.left, right = this.rightMaterialization.get(this.rightIdx++))) > 0) {
                            this.rightIdx = 0;
                            this.rightMaterialization = null;
                            this.drainMaterialization = false;
                            continue;
                        }
                        row = this.handler.concat(this.left, right);
                    }
                    --this.requested;
                    this.downstream().push(row);
                }
            }
            finally {
                this.inLoop = false;
            }
            if (this.waitingRight == 0) {
                this.waitingRight = IN_BUFFER_SIZE;
                this.rightSource().request(this.waitingRight);
            }
            if (this.waitingLeft == 0) {
                this.waitingLeft = IN_BUFFER_SIZE;
                this.leftSource().request(this.waitingLeft);
            }
            if (this.requested > 0 && this.waitingLeft == -1 && this.left == null && this.leftInBuf.isEmpty()) {
                this.requested = 0;
                this.downstream().end();
            }
        }
    }

    private static class InnerJoin<Row>
    extends MergeJoinNode<Row> {
        private Row left;
        private Row right;
        private List<Row> rightMaterialization;
        private int rightIdx;
        private boolean drainMaterialization;

        public InnerJoin(ExecutionContext<Row> ctx, RelDataType rowType, Comparator<Row> comp) {
            super(ctx, rowType, comp);
        }

        @Override
        protected void rewindInternal() {
            this.left = null;
            this.right = null;
            this.rightIdx = 0;
            this.rightMaterialization = null;
            this.drainMaterialization = false;
            super.rewindInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            this.inLoop = true;
            try {
                while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty() || this.right == null && this.rightInBuf.isEmpty() && this.rightMaterialization == null)) {
                    Row row;
                    this.checkState();
                    if (this.left == null) {
                        this.left = this.leftInBuf.remove();
                    }
                    if (this.right == null) {
                        if (this.rightInBuf.isEmpty() && this.waitingRight != -1) {
                            break;
                        }
                        if (!this.rightInBuf.isEmpty()) {
                            this.right = this.rightInBuf.remove();
                        }
                    }
                    if (this.right == null && this.rightMaterialization != null && !this.drainMaterialization) {
                        this.drainMaterialization = true;
                        this.left = null;
                        continue;
                    }
                    if (!this.drainMaterialization) {
                        int cmp = this.comp.compare(this.left, this.right);
                        if (cmp < 0) {
                            this.left = null;
                            this.rightIdx = 0;
                            if (this.rightMaterialization == null) continue;
                            this.drainMaterialization = true;
                            continue;
                        }
                        if (cmp > 0) {
                            this.right = null;
                            this.rightIdx = 0;
                            this.rightMaterialization = null;
                            continue;
                        }
                        if (!(this.rightMaterialization != null || this.rightInBuf.isEmpty() && this.waitingRight == -1)) {
                            if (this.rightInBuf.isEmpty()) {
                                break;
                            }
                            if (this.comp.compare(this.left, this.rightInBuf.peek()) == 0) {
                                this.rightMaterialization = new ArrayList<Row>();
                            }
                        }
                        row = this.handler.concat(this.left, this.right);
                        if (this.rightMaterialization != null) {
                            this.rightMaterialization.add(this.right);
                            this.right = null;
                        } else {
                            this.left = null;
                        }
                    } else {
                        Row right;
                        int cmp;
                        if (this.rightIdx >= this.rightMaterialization.size()) {
                            this.rightIdx = 0;
                            this.left = null;
                            continue;
                        }
                        if ((cmp = this.comp.compare(this.left, right = this.rightMaterialization.get(this.rightIdx++))) > 0) {
                            this.rightIdx = 0;
                            this.rightMaterialization = null;
                            this.drainMaterialization = false;
                            continue;
                        }
                        row = this.handler.concat(this.left, right);
                    }
                    --this.requested;
                    this.downstream().push(row);
                }
            }
            finally {
                this.inLoop = false;
            }
            if (this.waitingRight == 0) {
                this.waitingRight = IN_BUFFER_SIZE;
                this.rightSource().request(this.waitingRight);
            }
            if (this.waitingLeft == 0) {
                this.waitingLeft = IN_BUFFER_SIZE;
                this.leftSource().request(this.waitingLeft);
            }
            if (this.requested > 0 && (this.waitingLeft == -1 && this.left == null && this.leftInBuf.isEmpty() || this.waitingRight == -1 && this.right == null && this.rightInBuf.isEmpty() && this.rightMaterialization == null)) {
                this.requested = 0;
                this.downstream().end();
            }
        }
    }
}

