/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.exp;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.OptimizeShuttle;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlJsonEmptyOrError;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlTableFunction;
import org.apache.calcite.sql.SqlTypeConstructorFunction;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.CallImplementor;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.ConverterUtils;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.ImplementableFunction;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.NotNullImplementor;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.ReflectiveCallNotNullImplementor;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RexToLixTranslator;
import org.apache.ignite.internal.processors.query.calcite.sql.fun.IgniteOwnSqlOperatorTable;
import org.apache.ignite.internal.processors.query.calcite.util.IgniteMethod;

public class RexImpTable {
    public static final RexImpTable INSTANCE = new RexImpTable();
    public static final ConstantExpression NULL_EXPR = Expressions.constant(null);
    public static final ConstantExpression FALSE_EXPR = Expressions.constant((Object)false);
    public static final ConstantExpression TRUE_EXPR = Expressions.constant((Object)true);
    public static final MemberExpression BOXED_FALSE_EXPR = Expressions.field(null, Boolean.class, (String)"FALSE");
    public static final MemberExpression BOXED_TRUE_EXPR = Expressions.field(null, Boolean.class, (String)"TRUE");
    private final Map<SqlOperator, RexCallImplementor> map = new HashMap<SqlOperator, RexCallImplementor>();
    public static final Object DEFAULT_VALUE_PLACEHOLDER = new Object();

    RexImpTable() {
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ROW, BuiltInMethod.ARRAY.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.UPPER, BuiltInMethod.UPPER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOWER, BuiltInMethod.LOWER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.INITCAP, BuiltInMethod.INITCAP.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.TO_BASE64, BuiltInMethod.TO_BASE64.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.FROM_BASE64, BuiltInMethod.FROM_BASE64.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.MD5, BuiltInMethod.MD5.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.SHA1, BuiltInMethod.SHA1.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SUBSTRING, BuiltInMethod.SUBSTRING.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.LEFT, BuiltInMethod.LEFT.method, NullPolicy.ANY);
        this.defineMethod((SqlOperator)SqlLibraryOperators.RIGHT, BuiltInMethod.RIGHT.method, NullPolicy.ANY);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.REPLACE, BuiltInMethod.REPLACE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.TRANSLATE3, BuiltInMethod.TRANSLATE3.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.CHR, "chr", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, BuiltInMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.OCTET_LENGTH, BuiltInMethod.OCTET_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CONCAT, BuiltInMethod.STRING_CONCAT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.CONCAT_FUNCTION, BuiltInMethod.MULTI_STRING_CONCAT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.OVERLAY, BuiltInMethod.OVERLAY.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POSITION, BuiltInMethod.POSITION.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ASCII, BuiltInMethod.ASCII.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.REPEAT, BuiltInMethod.REPEAT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.SPACE, BuiltInMethod.SPACE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.STRCMP, BuiltInMethod.STRCMP.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.SOUNDEX, BuiltInMethod.SOUNDEX.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.DIFFERENCE, BuiltInMethod.DIFFERENCE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.REVERSE, BuiltInMethod.REVERSE.method, NullPolicy.STRICT);
        this.map.put((SqlOperator)SqlStdOperatorTable.TRIM, new TrimImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.AND, new LogicalAndImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.OR, new LogicalOrImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.NOT, new LogicalNotImplementor());
        this.defineBinary((SqlOperator)SqlStdOperatorTable.LESS_THAN, ExpressionType.LessThan, NullPolicy.STRICT, "lt");
        this.defineBinary((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, ExpressionType.LessThanOrEqual, NullPolicy.STRICT, "le");
        this.defineBinary((SqlOperator)SqlStdOperatorTable.GREATER_THAN, ExpressionType.GreaterThan, NullPolicy.STRICT, "gt");
        this.defineBinary((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ExpressionType.GreaterThanOrEqual, NullPolicy.STRICT, "ge");
        this.defineBinary((SqlOperator)SqlStdOperatorTable.EQUALS, ExpressionType.Equal, NullPolicy.STRICT, "eq");
        this.defineBinary((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, ExpressionType.NotEqual, NullPolicy.STRICT, "ne");
        this.defineBinary((SqlOperator)SqlStdOperatorTable.PLUS, ExpressionType.Add, NullPolicy.STRICT, "plus");
        this.defineBinary((SqlOperator)SqlStdOperatorTable.MINUS, ExpressionType.Subtract, NullPolicy.STRICT, "minus");
        this.defineBinary((SqlOperator)SqlStdOperatorTable.MULTIPLY, ExpressionType.Multiply, NullPolicy.STRICT, "multiply");
        this.defineBinary((SqlOperator)SqlStdOperatorTable.DIVIDE, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineBinary((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineUnary((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, ExpressionType.Negate, NullPolicy.STRICT, BuiltInMethod.BIG_DECIMAL_NEGATE.getMethodName());
        this.defineUnary((SqlOperator)SqlStdOperatorTable.UNARY_PLUS, ExpressionType.UnaryPlus, NullPolicy.STRICT, null);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MOD, "mod", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.EXP, "exp", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POWER, "power", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LN, "ln", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOG10, "log10", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ABS, "abs", NullPolicy.STRICT);
        this.map.put((SqlOperator)SqlStdOperatorTable.RAND, new RandImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.RAND_INTEGER, new RandIntegerImplementor());
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ACOS, "acos", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ASIN, "asin", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ATAN, "atan", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ATAN2, "atan2", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CBRT, "cbrt", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.COS, "cos", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.COSH, "cosh", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.COT, "cot", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.DEGREES, "degrees", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.RADIANS, "radians", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ROUND, "sround", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SIGN, "sign", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SIN, "sin", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.SINH, "sinh", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.TAN, "tan", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.TANH, "tanh", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.TRUNCATE, "struncate", NullPolicy.STRICT);
        this.map.put((SqlOperator)SqlStdOperatorTable.PI, new PiImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, new DatetimeArithmeticImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.MINUS_DATE, new DatetimeArithmeticImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.EXTRACT, new ExtractImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.FLOOR, new FloorImplementor(BuiltInMethod.FLOOR.method.getName(), BuiltInMethod.UNIX_TIMESTAMP_FLOOR.method, BuiltInMethod.UNIX_DATE_FLOOR.method));
        this.map.put((SqlOperator)SqlStdOperatorTable.CEIL, new FloorImplementor(BuiltInMethod.CEIL.method.getName(), BuiltInMethod.UNIX_TIMESTAMP_CEIL.method, BuiltInMethod.UNIX_DATE_CEIL.method));
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LAST_DAY, "lastDay", NullPolicy.STRICT);
        this.map.put((SqlOperator)SqlLibraryOperators.DAYNAME, new PeriodNameImplementor("dayName", BuiltInMethod.DAYNAME_WITH_TIMESTAMP, BuiltInMethod.DAYNAME_WITH_DATE));
        this.map.put((SqlOperator)SqlLibraryOperators.MONTHNAME, new PeriodNameImplementor("monthName", BuiltInMethod.MONTHNAME_WITH_TIMESTAMP, BuiltInMethod.MONTHNAME_WITH_DATE));
        this.defineMethod((SqlOperator)SqlLibraryOperators.TIMESTAMP_SECONDS, "timestampSeconds", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.TIMESTAMP_MILLIS, "timestampMillis", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.TIMESTAMP_MICROS, "timestampMicros", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_SECONDS, "unixSeconds", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_MILLIS, "unixMillis", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_MICROS, "unixMicros", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.DATE_FROM_UNIX_DATE, "dateFromUnixDate", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlLibraryOperators.UNIX_DATE, "unixDate", NullPolicy.STRICT);
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_NULL, new IsNullImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new IsNotNullImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_TRUE, new IsTrueImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, new IsNotTrueImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_FALSE, new IsFalseImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_NOT_FALSE, new IsNotFalseImplementor());
        MethodImplementor likeImplementor = new MethodImplementor(BuiltInMethod.LIKE.method, NullPolicy.STRICT, false);
        this.map.put((SqlOperator)SqlStdOperatorTable.LIKE, likeImplementor);
        this.map.put((SqlOperator)SqlStdOperatorTable.NOT_LIKE, likeImplementor);
        MethodImplementor similarImplementor = new MethodImplementor(BuiltInMethod.SIMILAR.method, NullPolicy.STRICT, false);
        this.map.put((SqlOperator)SqlStdOperatorTable.SIMILAR_TO, similarImplementor);
        this.map.put((SqlOperator)SqlStdOperatorTable.NOT_SIMILAR_TO, NotImplementor.of(similarImplementor));
        PosixRegexMethodImplementor posixRegexImplementorCaseSensitive = new PosixRegexMethodImplementor(true);
        PosixRegexMethodImplementor posixRegexImplementorCaseInsensitive = new PosixRegexMethodImplementor(false);
        this.map.put((SqlOperator)SqlStdOperatorTable.POSIX_REGEX_CASE_INSENSITIVE, posixRegexImplementorCaseInsensitive);
        this.map.put((SqlOperator)SqlStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE, posixRegexImplementorCaseSensitive);
        this.map.put((SqlOperator)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_INSENSITIVE, NotImplementor.of(posixRegexImplementorCaseInsensitive));
        this.map.put((SqlOperator)SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_SENSITIVE, NotImplementor.of(posixRegexImplementorCaseSensitive));
        this.map.put((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE, new RegexpReplaceImplementor());
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CARDINALITY, BuiltInMethod.COLLECTION_SIZE.method, NullPolicy.STRICT);
        MethodImplementor isEmptyImplementor = new MethodImplementor(BuiltInMethod.IS_EMPTY.method, NullPolicy.NONE, false);
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_EMPTY, isEmptyImplementor);
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_NOT_EMPTY, NotImplementor.of(isEmptyImplementor));
        this.map.put((SqlOperator)SqlStdOperatorTable.COALESCE, new CoalesceImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.CAST, new CastImplementor());
        this.map.put((SqlOperator)SqlLibraryOperators.DATE, new CastImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.REINTERPRET, new ReinterpretImplementor());
        ValueConstructorImplementor value = new ValueConstructorImplementor();
        this.map.put((SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, value);
        this.map.put((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, value);
        this.map.put(SqlStdOperatorTable.ITEM, new ItemImplementor());
        this.map.put((SqlOperator)SqlStdOperatorTable.DEFAULT, new DefaultImplementor());
        this.defineMethod((SqlOperator)SqlLibraryOperators.COMPRESS, BuiltInMethod.COMPRESS.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.EXTRACT_VALUE, BuiltInMethod.EXTRACT_VALUE.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.XML_TRANSFORM, BuiltInMethod.XML_TRANSFORM.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.EXTRACT_XML, BuiltInMethod.EXTRACT_XML.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.EXISTS_NODE, BuiltInMethod.EXISTS_NODE.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_VALUE_EXPRESSION, BuiltInMethod.JSON_VALUE_EXPRESSION.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_EXISTS, BuiltInMethod.JSON_EXISTS.method, NullPolicy.ARG0);
        this.map.put((SqlOperator)SqlStdOperatorTable.JSON_VALUE, new JsonValueImplementor(BuiltInMethod.JSON_VALUE.method));
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_QUERY, BuiltInMethod.JSON_QUERY.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_TYPE, BuiltInMethod.JSON_TYPE.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_DEPTH, BuiltInMethod.JSON_DEPTH.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_KEYS, BuiltInMethod.JSON_KEYS.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_PRETTY, BuiltInMethod.JSON_PRETTY.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_LENGTH, BuiltInMethod.JSON_LENGTH.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_REMOVE, BuiltInMethod.JSON_REMOVE.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlLibraryOperators.JSON_STORAGE_SIZE, BuiltInMethod.JSON_STORAGE_SIZE.method, NullPolicy.ARG0);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_OBJECT, BuiltInMethod.JSON_OBJECT.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.JSON_ARRAY, BuiltInMethod.JSON_ARRAY.method, NullPolicy.NONE);
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_JSON_VALUE, new MethodImplementor(BuiltInMethod.IS_JSON_VALUE.method, NullPolicy.NONE, false));
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_JSON_OBJECT, new MethodImplementor(BuiltInMethod.IS_JSON_OBJECT.method, NullPolicy.NONE, false));
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_JSON_ARRAY, new MethodImplementor(BuiltInMethod.IS_JSON_ARRAY.method, NullPolicy.NONE, false));
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_JSON_SCALAR, new MethodImplementor(BuiltInMethod.IS_JSON_SCALAR.method, NullPolicy.NONE, false));
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_NOT_JSON_VALUE, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_VALUE.method, NullPolicy.NONE, false)));
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_NOT_JSON_OBJECT, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_OBJECT.method, NullPolicy.NONE, false)));
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_NOT_JSON_ARRAY, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_ARRAY.method, NullPolicy.NONE, false)));
        this.map.put((SqlOperator)SqlStdOperatorTable.IS_NOT_JSON_SCALAR, NotImplementor.of(new MethodImplementor(BuiltInMethod.IS_JSON_SCALAR.method, NullPolicy.NONE, false)));
        SystemFunctionImplementor systemFunctionImplementor = new SystemFunctionImplementor();
        this.map.put((SqlOperator)IgniteOwnSqlOperatorTable.SYSTEM_RANGE, systemFunctionImplementor);
        this.map.put((SqlOperator)SqlStdOperatorTable.CURRENT_TIME, systemFunctionImplementor);
        this.map.put((SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP, systemFunctionImplementor);
        this.map.put((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, systemFunctionImplementor);
        this.map.put((SqlOperator)SqlStdOperatorTable.LOCALTIME, systemFunctionImplementor);
        this.map.put((SqlOperator)SqlStdOperatorTable.LOCALTIMESTAMP, systemFunctionImplementor);
        this.map.put((SqlOperator)IgniteOwnSqlOperatorTable.TYPEOF, systemFunctionImplementor);
        this.map.put((SqlOperator)IgniteOwnSqlOperatorTable.QUERY_ENGINE, systemFunctionImplementor);
    }

    private <T> Supplier<T> constructorSupplier(Class<T> klass) {
        Constructor constructor;
        try {
            constructor = klass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(klass + " should implement zero arguments constructor");
        }
        return () -> {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Error while creating aggregate implementor " + constructor, e);
            }
        };
    }

    private void defineMethod(SqlOperator operator, String functionName, NullPolicy nullPolicy) {
        this.map.put(operator, new MethodNameImplementor(functionName, nullPolicy, false));
    }

    private void defineMethod(SqlOperator operator, Method method, NullPolicy nullPolicy) {
        this.map.put(operator, new MethodImplementor(method, nullPolicy, false));
    }

    private void defineUnary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy, String backupMethodName) {
        this.map.put(operator, new UnaryImplementor(expressionType, nullPolicy, backupMethodName));
    }

    private void defineBinary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy, String backupMethodName) {
        this.map.put(operator, new BinaryImplementor(nullPolicy, true, expressionType, backupMethodName));
    }

    private static RexCallImplementor wrapAsRexCallImplementor(final CallImplementor implementor) {
        return new AbstractRexCallImplementor(NullPolicy.NONE, false){

            @Override
            String getVariableName() {
                return "udf";
            }

            @Override
            Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
                return implementor.implement(translator, call, NullAs.NULL);
            }
        };
    }

    public RexCallImplementor get(SqlOperator operator) {
        if (operator instanceof SqlUserDefinedFunction) {
            Function udf = ((SqlUserDefinedFunction)operator).getFunction();
            if (!(udf instanceof ImplementableFunction)) {
                throw new IllegalStateException("User defined function " + operator + " must implement ImplementableFunction");
            }
            CallImplementor implementor = ((ImplementableFunction)udf).getImplementor();
            return RexImpTable.wrapAsRexCallImplementor(implementor);
        }
        if (operator instanceof SqlTypeConstructorFunction) {
            return this.map.get(SqlStdOperatorTable.ROW);
        }
        return this.map.get(operator);
    }

    static Expression optimize(Expression expression) {
        return expression.accept((Shuttle)new OptimizeShuttle());
    }

    static Expression optimize2(Expression operand, Expression expression) {
        if (Primitive.is((Type)operand.getType())) {
            return RexImpTable.optimize(expression);
        }
        return RexImpTable.optimize(Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)NULL_EXPR), (Expression)NULL_EXPR, (Expression)expression));
    }

    private static RelDataType toSql(RelDataTypeFactory typeFactory, RelDataType type) {
        SqlTypeName typeName;
        if (type instanceof RelDataTypeFactoryImpl.JavaType && (typeName = type.getSqlTypeName()) != null && typeName != SqlTypeName.OTHER) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(typeName), type.isNullable());
        }
        return type;
    }

    private static <E> boolean allSame(List<E> list) {
        Object prev = null;
        for (E e : list) {
            if (prev != null && !prev.equals(e)) {
                return false;
            }
            prev = e;
        }
        return true;
    }

    static Expression getDefaultValue(Type type) {
        if (Primitive.is((Type)type)) {
            Primitive p = Primitive.of((Type)type);
            return Expressions.constant((Object)p.defaultValue, (Type)type);
        }
        return Expressions.constant(null, (Type)type);
    }

    public static Expression multiplyDivide(Expression e, BigDecimal multiplier, BigDecimal divider) {
        if (multiplier.equals(BigDecimal.ONE)) {
            if (divider.equals(BigDecimal.ONE)) {
                return e;
            }
            return Expressions.divide((Expression)e, (Expression)Expressions.constant((Object)divider.intValueExact()));
        }
        BigDecimal x = multiplier.divide(divider, RoundingMode.UNNECESSARY);
        switch (x.compareTo(BigDecimal.ONE)) {
            case 0: {
                return e;
            }
            case 1: {
                return Expressions.multiply((Expression)e, (Expression)Expressions.constant((Object)x.intValueExact()));
            }
            case -1: {
                return RexImpTable.multiplyDivide(e, BigDecimal.ONE, x);
            }
        }
        throw new AssertionError();
    }

    private static Expression mod(Expression operand, long factor, boolean floorMod) {
        if (factor == 1L) {
            return operand;
        }
        return floorMod ? Expressions.call((Method)BuiltInMethod.FLOOR_MOD.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)factor)}) : Expressions.modulo((Expression)operand, (Expression)Expressions.constant((Object)factor));
    }

    private static long getFactor(TimeUnit unit) {
        switch (unit) {
            case DAY: {
                return 1L;
            }
            case HOUR: {
                return TimeUnit.DAY.multiplier.longValue();
            }
            case MINUTE: {
                return TimeUnit.HOUR.multiplier.longValue();
            }
            case SECOND: {
                return TimeUnit.MINUTE.multiplier.longValue();
            }
            case MILLISECOND: {
                return TimeUnit.SECOND.multiplier.longValue();
            }
            case MONTH: {
                return TimeUnit.YEAR.multiplier.longValue();
            }
            case QUARTER: {
                return TimeUnit.YEAR.multiplier.longValue();
            }
            case MILLENNIUM: 
            case CENTURY: 
            case YEAR: 
            case DECADE: {
                return 1L;
            }
        }
        throw Util.unexpected((Enum)unit);
    }

    private static CallImplementor createTableFunctionImplementor(Method method) {
        return RexImpTable.createImplementor(new ReflectiveCallNotNullImplementor(method){

            @Override
            public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
                Expression expr = super.implement(translator, call, translatedOperands);
                Class<?> returnType = this.method.getReturnType();
                if (QueryableTable.class.isAssignableFrom(returnType)) {
                    MethodCallExpression queryable = Expressions.call((Expression)Expressions.convert_((Expression)expr, QueryableTable.class), (Method)BuiltInMethod.QUERYABLE_TABLE_AS_QUERYABLE.method, (Expression[])new Expression[]{Expressions.call((Expression)translator.getRoot(), (Method)BuiltInMethod.DATA_CONTEXT_GET_QUERY_PROVIDER.method, (Expression[])new Expression[0]), Expressions.constant(null, SchemaPlus.class), Expressions.constant((Object)call.getOperator().getName(), String.class)});
                    expr = Expressions.call((Expression)queryable, (Method)BuiltInMethod.QUERYABLE_AS_ENUMERABLE.method, (Expression[])new Expression[0]);
                } else {
                    expr = Expressions.call((Expression)expr, (Method)BuiltInMethod.SCANNABLE_TABLE_SCAN.method, (Expression[])new Expression[]{translator.getRoot()});
                }
                return expr;
            }
        }, NullPolicy.NONE, false);
    }

    public static CallImplementor createImplementor(NotNullImplementor implementor, NullPolicy nullPolicy, boolean harmonize) {
        return (translator, call, nullAs) -> {
            RexCallImplementor rexCallImplementor = RexImpTable.createRexCallImplementor(implementor, nullPolicy, harmonize);
            List<RexToLixTranslator.Result> arguments = translator.getCallOperandResult(call);
            assert (arguments != null);
            RexToLixTranslator.Result result = rexCallImplementor.implement(translator, call, arguments);
            return nullAs.handle((Expression)result.valueVariable);
        };
    }

    private static RexCallImplementor createRexCallImplementor(final NotNullImplementor implementor, NullPolicy nullPolicy, boolean harmonize) {
        return new AbstractRexCallImplementor(nullPolicy, harmonize){

            @Override
            String getVariableName() {
                return "not_null_udf";
            }

            @Override
            Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
                return implementor.implement(translator, call, argValueList);
            }
        };
    }

    private static class DefaultImplementor
    extends AbstractRexCallImplementor {
        DefaultImplementor() {
            super(NullPolicy.NONE, false);
        }

        @Override
        String getVariableName() {
            return "default";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.field(null, RexImpTable.class, (String)"DEFAULT_VALUE_PLACEHOLDER");
        }
    }

    private static class RegexpReplaceImplementor
    extends AbstractRexCallImplementor {
        private final AbstractRexCallImplementor[] implementors;

        RegexpReplaceImplementor() {
            super(NullPolicy.STRICT, false);
            this.implementors = new AbstractRexCallImplementor[]{new ReflectiveImplementor(BuiltInMethod.REGEXP_REPLACE3.method, this.nullPolicy), new ReflectiveImplementor(BuiltInMethod.REGEXP_REPLACE4.method, this.nullPolicy), new ReflectiveImplementor(BuiltInMethod.REGEXP_REPLACE5.method, this.nullPolicy), new ReflectiveImplementor(BuiltInMethod.REGEXP_REPLACE6.method, this.nullPolicy)};
        }

        @Override
        String getVariableName() {
            return "regexp_replace";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return this.implementors[call.getOperands().size() - 3].implementSafe(translator, call, argValueList);
        }
    }

    private static class IsTrueImplementor
    extends AbstractRexCallImplementor {
        IsTrueImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_true";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)false, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.equal((Expression)argValueList.get(0), (Expression)TRUE_EXPR);
        }
    }

    private static class IsNullImplementor
    extends AbstractRexCallImplementor {
        IsNullImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_null";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)true, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.equal((Expression)argValueList.get(0), (Expression)NULL_EXPR);
        }
    }

    private static class IsNotTrueImplementor
    extends AbstractRexCallImplementor {
        IsNotTrueImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_not_true";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)true, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.notEqual((Expression)argValueList.get(0), (Expression)TRUE_EXPR);
        }
    }

    private static class IsNotNullImplementor
    extends AbstractRexCallImplementor {
        IsNotNullImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_not_null";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)false, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.notEqual((Expression)argValueList.get(0), (Expression)NULL_EXPR);
        }
    }

    private static class IsNotFalseImplementor
    extends AbstractRexCallImplementor {
        IsNotFalseImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_not_false";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)true, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.notEqual((Expression)argValueList.get(0), (Expression)FALSE_EXPR);
        }
    }

    private static class IsFalseImplementor
    extends AbstractRexCallImplementor {
        IsFalseImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "is_false";
        }

        @Override
        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return Expressions.constant((Object)false, (Type)type);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.equal((Expression)argValueList.get(0), (Expression)FALSE_EXPR);
        }
    }

    private static class PiImplementor
    extends AbstractRexCallImplementor {
        PiImplementor() {
            super(NullPolicy.NONE, false);
        }

        @Override
        String getVariableName() {
            return "pi";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.constant((Object)Math.PI);
        }
    }

    private static class RandIntegerImplementor
    extends AbstractRexCallImplementor {
        private final AbstractRexCallImplementor[] implementors;

        RandIntegerImplementor() {
            super(NullPolicy.STRICT, false);
            this.implementors = new AbstractRexCallImplementor[]{null, new ReflectiveImplementor(BuiltInMethod.RAND_INTEGER.method, this.nullPolicy), new ReflectiveImplementor(BuiltInMethod.RAND_INTEGER_SEED.method, this.nullPolicy)};
        }

        @Override
        String getVariableName() {
            return "rand_integer";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return this.implementors[call.getOperands().size()].implementSafe(translator, call, argValueList);
        }
    }

    private static class RandImplementor
    extends AbstractRexCallImplementor {
        private final AbstractRexCallImplementor[] implementors;

        RandImplementor() {
            super(NullPolicy.STRICT, false);
            this.implementors = new AbstractRexCallImplementor[]{new ReflectiveImplementor(BuiltInMethod.RAND.method, this.nullPolicy), new ReflectiveImplementor(BuiltInMethod.RAND_SEED.method, this.nullPolicy)};
        }

        @Override
        String getVariableName() {
            return "rand";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return this.implementors[call.getOperands().size()].implementSafe(translator, call, argValueList);
        }
    }

    private static class ReflectiveImplementor
    extends AbstractRexCallImplementor {
        protected final Method method;

        ReflectiveImplementor(Method method, NullPolicy nullPolicy) {
            super(nullPolicy, false);
            this.method = method;
        }

        @Override
        String getVariableName() {
            return "reflective_" + this.method.getName();
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            List<Expression> argValueList0 = ConverterUtils.fromInternal(this.method.getParameterTypes(), argValueList);
            if ((this.method.getModifiers() & 8) != 0) {
                return Expressions.call((Method)this.method, argValueList0);
            }
            NewExpression target = Expressions.new_(this.method.getDeclaringClass());
            return Expressions.call((Expression)target, (Method)this.method, argValueList0);
        }
    }

    private static class LogicalNotImplementor
    extends AbstractRexCallImplementor {
        LogicalNotImplementor() {
            super(NullPolicy.NONE, true);
        }

        @Override
        String getVariableName() {
            return "logical_not";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return Expressions.call((Method)BuiltInMethod.NOT.method, argValueList);
        }
    }

    private static class LogicalOrImplementor
    extends AbstractRexCallImplementor {
        LogicalOrImplementor() {
            super(NullPolicy.NONE, true);
        }

        @Override
        String getVariableName() {
            return "logical_or";
        }

        @Override
        public RexToLixTranslator.Result implement(RexToLixTranslator translator, RexCall call, List<RexToLixTranslator.Result> arguments) {
            ArrayList<ParameterExpression> argIsNullList = new ArrayList<ParameterExpression>();
            for (RexToLixTranslator.Result result2 : arguments) {
                argIsNullList.add(result2.isNullVariable);
            }
            List nullAsFalse = arguments.stream().map(result -> Expressions.condition((Expression)result.isNullVariable, (Expression)FALSE_EXPR, (Expression)result.valueVariable)).collect(Collectors.toList());
            Expression hasTrue = Expressions.foldOr(nullAsFalse);
            Expression hasNull = Expressions.foldOr(argIsNullList);
            Expression callExpression = Expressions.condition((Expression)hasTrue, (Expression)BOXED_TRUE_EXPR, (Expression)Expressions.condition((Expression)hasNull, (Expression)NULL_EXPR, (Expression)BOXED_FALSE_EXPR));
            NullAs nullAs = translator.isNullable((RexNode)call) ? NullAs.NULL : NullAs.NOT_POSSIBLE;
            Expression valueExpression = nullAs.handle(callExpression);
            ParameterExpression valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)translator.getBlockBuilder().newName(this.getVariableName() + "_value"));
            Expression isNullExpression = translator.checkNull(valueExpression);
            ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)translator.getBlockBuilder().newName(this.getVariableName() + "_isNull"));
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
            return new RexToLixTranslator.Result(isNullVariable, valueVariable);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return null;
        }
    }

    private static class LogicalAndImplementor
    extends AbstractRexCallImplementor {
        LogicalAndImplementor() {
            super(NullPolicy.NONE, true);
        }

        @Override
        String getVariableName() {
            return "logical_and";
        }

        @Override
        public RexToLixTranslator.Result implement(RexToLixTranslator translator, RexCall call, List<RexToLixTranslator.Result> arguments) {
            ArrayList<ParameterExpression> argIsNullList = new ArrayList<ParameterExpression>();
            for (RexToLixTranslator.Result result2 : arguments) {
                argIsNullList.add(result2.isNullVariable);
            }
            List nullAsTrue = arguments.stream().map(result -> Expressions.condition((Expression)result.isNullVariable, (Expression)TRUE_EXPR, (Expression)result.valueVariable)).collect(Collectors.toList());
            UnaryExpression hasFalse = Expressions.not((Expression)Expressions.foldAnd(nullAsTrue));
            Expression hasNull = Expressions.foldOr(argIsNullList);
            Expression callExpression = Expressions.condition((Expression)hasFalse, (Expression)BOXED_FALSE_EXPR, (Expression)Expressions.condition((Expression)hasNull, (Expression)NULL_EXPR, (Expression)BOXED_TRUE_EXPR));
            NullAs nullAs = translator.isNullable((RexNode)call) ? NullAs.NULL : NullAs.NOT_POSSIBLE;
            Expression valueExpression = nullAs.handle(callExpression);
            ParameterExpression valueVariable = Expressions.parameter((Type)valueExpression.getType(), (String)translator.getBlockBuilder().newName(this.getVariableName() + "_value"));
            Expression isNullExpression = translator.checkNull((Expression)valueVariable);
            ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)translator.getBlockBuilder().newName(this.getVariableName() + "_isNull"));
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)valueVariable, (Expression)valueExpression));
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
            return new RexToLixTranslator.Result(isNullVariable, valueVariable);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return null;
        }
    }

    private static abstract class AbstractRexCallImplementor
    implements RexCallImplementor {
        final NullPolicy nullPolicy;
        private final boolean harmonize;

        AbstractRexCallImplementor(NullPolicy nullPolicy, boolean harmonize) {
            this.nullPolicy = nullPolicy;
            this.harmonize = harmonize;
        }

        @Override
        public RexToLixTranslator.Result implement(RexToLixTranslator translator, RexCall call, List<RexToLixTranslator.Result> arguments) {
            ArrayList<Expression> argIsNullList = new ArrayList<Expression>();
            ArrayList<Expression> argValueList = new ArrayList<Expression>();
            for (RexToLixTranslator.Result result : arguments) {
                argIsNullList.add((Expression)result.isNullVariable);
                argValueList.add((Expression)result.valueVariable);
            }
            Expression condition = this.getCondition(argIsNullList);
            ParameterExpression valueVariable = this.genValueStatement(translator, call, argValueList, condition);
            ParameterExpression isNullVariable = this.genIsNullStatement(translator, valueVariable);
            return new RexToLixTranslator.Result(isNullVariable, valueVariable);
        }

        abstract String getVariableName();

        Expression getCondition(List<Expression> argIsNullList) {
            if (argIsNullList.isEmpty() || this.nullPolicy == null || this.nullPolicy == NullPolicy.NONE) {
                return FALSE_EXPR;
            }
            if (this.nullPolicy == NullPolicy.ARG0) {
                return argIsNullList.get(0);
            }
            return Expressions.foldOr(argIsNullList);
        }

        private ParameterExpression genValueStatement(RexToLixTranslator translator, RexCall call, List<Expression> argValueList, Expression condition) {
            List<Expression> optimizedArgValueList = argValueList;
            if (this.harmonize) {
                optimizedArgValueList = this.harmonize(optimizedArgValueList, translator, call);
            }
            optimizedArgValueList = this.unboxIfNecessary(optimizedArgValueList);
            Expression callValue = this.implementSafe(translator, call, optimizedArgValueList);
            SqlOperator op = call.getOperator();
            Type returnType = translator.typeFactory.getJavaClass(call.getType());
            boolean noConvert = returnType == null || returnType == callValue.getType() || op instanceof SqlTableFunction || op instanceof SqlUserDefinedTableMacro || op instanceof SqlUserDefinedTableFunction;
            Expression convertedCallValue = noConvert ? callValue : ConverterUtils.convert(callValue, returnType);
            Expression valueExpression = Expressions.condition((Expression)condition, (Expression)this.getIfTrue(convertedCallValue.getType(), argValueList), (Expression)convertedCallValue);
            ParameterExpression value = Expressions.parameter((Type)convertedCallValue.getType(), (String)translator.getBlockBuilder().newName(this.getVariableName() + "_value"));
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)value, (Expression)valueExpression));
            return value;
        }

        Expression getIfTrue(Type type, List<Expression> argValueList) {
            return RexImpTable.getDefaultValue(type);
        }

        private ParameterExpression genIsNullStatement(RexToLixTranslator translator, ParameterExpression value) {
            ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, (String)translator.getBlockBuilder().newName(this.getVariableName() + "_isNull"));
            Expression isNullExpression = translator.checkNull((Expression)value);
            translator.getBlockBuilder().add((Statement)Expressions.declare((int)16, (ParameterExpression)isNullVariable, (Expression)isNullExpression));
            return isNullVariable;
        }

        private List<Expression> harmonize(List<Expression> argValueList, RexToLixTranslator translator, RexCall call) {
            int nullCount = 0;
            ArrayList<RelDataType> types = new ArrayList<RelDataType>();
            RelDataTypeFactory typeFactory = translator.builder.getTypeFactory();
            for (RexNode operand : call.getOperands()) {
                RelDataType type = operand.getType();
                type = RexImpTable.toSql(typeFactory, type);
                if (translator.isNullable(operand)) {
                    ++nullCount;
                } else {
                    type = typeFactory.createTypeWithNullability(type, false);
                }
                types.add(type);
            }
            if (RexImpTable.allSame(types)) {
                return argValueList;
            }
            RelDataType type = typeFactory.leastRestrictive(types);
            if (type == null) {
                return argValueList;
            }
            assert (nullCount > 0 == type.isNullable());
            Type javaClass = translator.typeFactory.getJavaClass(type);
            ArrayList<Expression> harmonizedArgValues = new ArrayList<Expression>();
            for (Expression argValue : argValueList) {
                harmonizedArgValues.add(EnumUtils.convert((Expression)argValue, (Type)javaClass));
            }
            return harmonizedArgValues;
        }

        private List<Expression> unboxIfNecessary(List<Expression> argValueList) {
            List<Object> unboxValueList = argValueList;
            if (this.nullPolicy == NullPolicy.STRICT || this.nullPolicy == NullPolicy.ANY || this.nullPolicy == NullPolicy.SEMI_STRICT) {
                unboxValueList = argValueList.stream().map(this::unboxExpression).collect(Collectors.toList());
            }
            if (this.nullPolicy == NullPolicy.ARG0 && !argValueList.isEmpty()) {
                Expression unboxArg0 = this.unboxExpression((Expression)unboxValueList.get(0));
                unboxValueList.set(0, unboxArg0);
            }
            return unboxValueList;
        }

        private Expression unboxExpression(Expression argValue) {
            Primitive fromBox = Primitive.ofBox((Type)argValue.getType());
            if (fromBox == null || fromBox == Primitive.VOID) {
                return argValue;
            }
            if (argValue instanceof MethodCallExpression) {
                MethodCallExpression mce = (MethodCallExpression)argValue;
                if (mce.method.getName().equals("valueOf") && mce.expressions.size() == 1) {
                    Expression originArg = (Expression)mce.expressions.get(0);
                    if (Primitive.of((Type)originArg.type) == fromBox) {
                        return originArg;
                    }
                }
            }
            return NullAs.NOT_POSSIBLE.handle(argValue);
        }

        abstract Expression implementSafe(RexToLixTranslator var1, RexCall var2, List<Expression> var3);
    }

    public static interface RexCallImplementor {
        public RexToLixTranslator.Result implement(RexToLixTranslator var1, RexCall var2, List<RexToLixTranslator.Result> var3);
    }

    private static class DatetimeArithmeticImplementor
    extends AbstractRexCallImplementor {
        DatetimeArithmeticImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "dateTime_arithmetic";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            RexNode operand0 = (RexNode)call.getOperands().get(0);
            Expression trop0 = argValueList.get(0);
            SqlTypeName typeName1 = ((RexNode)call.getOperands().get(1)).getType().getSqlTypeName();
            Expression trop1 = argValueList.get(1);
            SqlTypeName typeName = call.getType().getSqlTypeName();
            block0 : switch (operand0.getType().getSqlTypeName()) {
                case DATE: {
                    switch (typeName) {
                        case TIMESTAMP: {
                            trop0 = Expressions.convert_((Expression)Expressions.multiply((Expression)trop0, (Expression)Expressions.constant((Object)86400000L)), Long.TYPE);
                            break block0;
                        }
                    }
                    switch (typeName1) {
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            trop1 = Expressions.convert_((Expression)Expressions.divide((Expression)trop1, (Expression)Expressions.constant((Object)86400000L)), Integer.TYPE);
                        }
                    }
                    break;
                }
                case TIME: {
                    trop1 = Expressions.convert_((Expression)trop1, Integer.TYPE);
                }
            }
            switch (typeName1) {
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    switch (call.getKind()) {
                        case MINUS: {
                            trop1 = Expressions.negate((Expression)trop1);
                        }
                    }
                    switch (typeName) {
                        case TIME: {
                            return Expressions.convert_((Expression)trop0, Long.TYPE);
                        }
                    }
                    BuiltInMethod method = operand0.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP ? BuiltInMethod.ADD_MONTHS : BuiltInMethod.ADD_MONTHS_INT;
                    return Expressions.call((Method)method.method, (Expression[])new Expression[]{trop0, trop1});
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    switch (call.getKind()) {
                        case MINUS: {
                            return this.normalize(typeName, (Expression)Expressions.subtract((Expression)trop0, (Expression)trop1));
                        }
                    }
                    return this.normalize(typeName, (Expression)Expressions.add((Expression)trop0, (Expression)trop1));
                }
            }
            switch (call.getKind()) {
                case MINUS: {
                    switch (typeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: {
                            return Expressions.call((Method)BuiltInMethod.SUBTRACT_MONTHS.method, (Expression[])new Expression[]{trop0, trop1});
                        }
                    }
                    TimeUnit fromUnit = typeName1 == SqlTypeName.DATE ? TimeUnit.DAY : TimeUnit.MILLISECOND;
                    TimeUnit toUnit = TimeUnit.MILLISECOND;
                    return RexImpTable.multiplyDivide((Expression)Expressions.convert_((Expression)Expressions.subtract((Expression)trop0, (Expression)trop1), Long.TYPE), fromUnit.multiplier, toUnit.multiplier);
                }
            }
            throw new AssertionError(call);
        }

        private Expression normalize(SqlTypeName typeName, Expression e) {
            switch (typeName) {
                case TIME: {
                    return Expressions.call((Method)BuiltInMethod.FLOOR_MOD.method, (Expression[])new Expression[]{e, Expressions.constant((Object)86400000L)});
                }
            }
            return e;
        }
    }

    private static class NotImplementor
    extends AbstractRexCallImplementor {
        private AbstractRexCallImplementor implementor;

        private NotImplementor(NullPolicy nullPolicy, AbstractRexCallImplementor implementor) {
            super(nullPolicy, false);
            this.implementor = implementor;
        }

        static AbstractRexCallImplementor of(AbstractRexCallImplementor implementor) {
            return new NotImplementor(implementor.nullPolicy, implementor);
        }

        @Override
        String getVariableName() {
            return "not";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression expression = this.implementor.implementSafe(translator, call, argValueList);
            return Expressions.not((Expression)expression);
        }
    }

    private static class SystemFunctionImplementor
    extends AbstractRexCallImplementor {
        SystemFunctionImplementor() {
            super(NullPolicy.NONE, false);
        }

        @Override
        String getVariableName() {
            return "system_func";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            SqlOperator op = call.getOperator();
            Expression root = translator.getRoot();
            if (op == SqlStdOperatorTable.CURRENT_TIMESTAMP) {
                return Expressions.call((Method)BuiltInMethod.CURRENT_TIMESTAMP.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.CURRENT_TIME) {
                return Expressions.call((Method)BuiltInMethod.CURRENT_TIME.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.CURRENT_DATE) {
                return Expressions.call((Method)BuiltInMethod.CURRENT_DATE.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.LOCALTIMESTAMP) {
                return Expressions.call((Method)BuiltInMethod.LOCAL_TIMESTAMP.method, (Expression[])new Expression[]{root});
            }
            if (op == SqlStdOperatorTable.LOCALTIME) {
                return Expressions.call((Method)BuiltInMethod.LOCAL_TIME.method, (Expression[])new Expression[]{root});
            }
            if (op == IgniteOwnSqlOperatorTable.SYSTEM_RANGE) {
                if (call.getOperands().size() == 2) {
                    return RexImpTable.createTableFunctionImplementor(IgniteMethod.SYSTEM_RANGE2.method()).implement(translator, call, NullAs.NULL);
                }
                if (call.getOperands().size() == 3) {
                    return RexImpTable.createTableFunctionImplementor(IgniteMethod.SYSTEM_RANGE3.method()).implement(translator, call, NullAs.NULL);
                }
            } else {
                if (op == IgniteOwnSqlOperatorTable.TYPEOF) {
                    assert (call.getOperands().size() == 1) : call.getOperands();
                    return Expressions.constant((Object)((RexNode)call.getOperands().get(0)).getType().toString());
                }
                if (op == IgniteOwnSqlOperatorTable.QUERY_ENGINE) {
                    return Expressions.constant((Object)"calcite");
                }
            }
            throw new AssertionError((Object)("unknown function " + op));
        }
    }

    private static class ItemImplementor
    extends AbstractRexCallImplementor {
        ItemImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "item";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            MethodImplementor implementor = this.getImplementor(((RexNode)call.getOperands().get(0)).getType().getSqlTypeName());
            return implementor.implementSafe(translator, call, argValueList);
        }

        private MethodImplementor getImplementor(SqlTypeName sqlTypeName) {
            switch (sqlTypeName) {
                case ARRAY: {
                    return new MethodImplementor(BuiltInMethod.ARRAY_ITEM.method, this.nullPolicy, false);
                }
                case MAP: {
                    return new MethodImplementor(BuiltInMethod.MAP_ITEM.method, this.nullPolicy, false);
                }
            }
            return new MethodImplementor(BuiltInMethod.ANY_ITEM.method, this.nullPolicy, false);
        }
    }

    private static class ValueConstructorImplementor
    extends AbstractRexCallImplementor {
        ValueConstructorImplementor() {
            super(NullPolicy.NONE, false);
        }

        @Override
        String getVariableName() {
            return "value_constructor";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            SqlKind kind = call.getOperator().getKind();
            BlockBuilder blockBuilder = translator.getBlockBuilder();
            switch (kind) {
                case MAP_VALUE_CONSTRUCTOR: {
                    Expression map = blockBuilder.append("map", (Expression)Expressions.new_(LinkedHashMap.class), false);
                    for (int i = 0; i < argValueList.size(); ++i) {
                        Expression key = argValueList.get(i++);
                        Expression value = argValueList.get(i);
                        blockBuilder.add(Expressions.statement((Expression)Expressions.call((Expression)map, (Method)BuiltInMethod.MAP_PUT.method, (Expression[])new Expression[]{Expressions.box((Expression)key), Expressions.box((Expression)value)})));
                    }
                    return map;
                }
                case ARRAY_VALUE_CONSTRUCTOR: {
                    Expression lyst = blockBuilder.append("list", (Expression)Expressions.new_(ArrayList.class), false);
                    for (Expression value : argValueList) {
                        blockBuilder.add(Expressions.statement((Expression)Expressions.call((Expression)lyst, (Method)BuiltInMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{Expressions.box((Expression)value)})));
                    }
                    return lyst;
                }
            }
            throw new AssertionError((Object)("unexpected: " + kind));
        }
    }

    private static class ReinterpretImplementor
    extends AbstractRexCallImplementor {
        ReinterpretImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "reInterpret";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            assert (call.getOperands().size() == 1);
            return argValueList.get(0);
        }
    }

    private static class CastImplementor
    extends AbstractRexCallImplementor {
        CastImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "cast";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            assert (call.getOperands().size() == 1);
            RelDataType sourceType = ((RexNode)call.getOperands().get(0)).getType();
            RexNode arg = (RexNode)call.getOperands().get(0);
            if (call.getType().equals(sourceType)) {
                return argValueList.get(0);
            }
            if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)translator.typeFactory, (RelDataType)call.getType(), (RelDataType)arg.getType()) && translator.deref(arg) instanceof RexLiteral) {
                return RexToLixTranslator.translateLiteral((RexLiteral)translator.deref(arg), call.getType(), translator.typeFactory, NullAs.NULL);
            }
            RelDataType targetType = this.nullifyType(translator.typeFactory, call.getType(), false);
            return translator.translateCast(sourceType, targetType, argValueList.get(0));
        }

        private RelDataType nullifyType(JavaTypeFactory typeFactory, RelDataType type, boolean nullable) {
            Primitive primitive;
            if (type instanceof RelDataTypeFactoryImpl.JavaType && (primitive = Primitive.ofBox((Type)((RelDataTypeFactoryImpl.JavaType)type).getJavaClass())) != null) {
                return typeFactory.createJavaType(primitive.primitiveClass);
            }
            return typeFactory.createTypeWithNullability(type, nullable);
        }
    }

    private static class CoalesceImplementor
    extends AbstractRexCallImplementor {
        CoalesceImplementor() {
            super(NullPolicy.NONE, false);
        }

        @Override
        String getVariableName() {
            return "coalesce";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return this.implementRecurse(translator, argValueList);
        }

        private Expression implementRecurse(RexToLixTranslator translator, List<Expression> argValueList) {
            if (argValueList.size() == 1) {
                return argValueList.get(0);
            }
            return Expressions.condition((Expression)translator.checkNotNull(argValueList.get(0)), (Expression)argValueList.get(0), (Expression)this.implementRecurse(translator, Util.skip(argValueList)));
        }
    }

    private static class ExtractImplementor
    extends AbstractRexCallImplementor {
        ExtractImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "extract";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            TimeUnitRange timeUnitRange = (TimeUnitRange)translator.getLiteralValue(argValueList.get(0));
            TimeUnit unit = timeUnitRange.startUnit;
            Expression operand = argValueList.get(1);
            SqlTypeName sqlTypeName = ((RexNode)call.operands.get(1)).getType().getSqlTypeName();
            boolean isIntervalType = SqlTypeUtil.isInterval((RelDataType)((RexNode)call.operands.get(1)).getType());
            block0 : switch (unit) {
                case MILLENNIUM: 
                case CENTURY: 
                case YEAR: 
                case QUARTER: 
                case MONTH: 
                case DAY: 
                case DOW: 
                case DECADE: 
                case DOY: 
                case ISODOW: 
                case ISOYEAR: 
                case WEEK: {
                    switch (sqlTypeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            break block0;
                        }
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand = Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{translator.getRoot()})});
                        }
                        case TIMESTAMP: {
                            operand = Expressions.call((Method)BuiltInMethod.FLOOR_DIV.method, (Expression[])new Expression[]{operand, Expressions.constant((Object)TimeUnit.DAY.multiplier.longValue())});
                        }
                        case DATE: {
                            return Expressions.call((Method)BuiltInMethod.UNIX_DATE_EXTRACT.method, (Expression[])new Expression[]{argValueList.get(0), operand});
                        }
                    }
                    throw new AssertionError((Object)("unexpected " + sqlTypeName));
                }
                case MILLISECOND: 
                case MICROSECOND: 
                case NANOSECOND: {
                    if (sqlTypeName == SqlTypeName.DATE) {
                        return Expressions.constant((Object)0L);
                    }
                    operand = RexImpTable.mod(operand, TimeUnit.MINUTE.multiplier.longValue(), !isIntervalType);
                    return Expressions.multiply((Expression)operand, (Expression)Expressions.constant((Object)((long)(1.0 / unit.multiplier.doubleValue()))));
                }
                case EPOCH: {
                    switch (sqlTypeName) {
                        case DATE: {
                            operand = Expressions.multiply((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.DAY.multiplier.longValue()));
                        }
                        case TIMESTAMP: {
                            return Expressions.divide((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.SECOND.multiplier.longValue()));
                        }
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand = Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{translator.getRoot()})});
                            return Expressions.divide((Expression)operand, (Expression)Expressions.constant((Object)TimeUnit.SECOND.multiplier.longValue()));
                        }
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            throw new AssertionError((Object)("unexpected " + sqlTypeName));
                        }
                    }
                    break;
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    switch (sqlTypeName) {
                        case DATE: {
                            return Expressions.multiply((Expression)operand, (Expression)Expressions.constant((Object)0L));
                        }
                    }
                }
            }
            operand = RexImpTable.mod(operand, RexImpTable.getFactor(unit), unit == TimeUnit.QUARTER || !isIntervalType);
            if (unit == TimeUnit.QUARTER) {
                operand = Expressions.subtract((Expression)operand, (Expression)Expressions.constant((Object)1L));
            }
            operand = Expressions.divide((Expression)operand, (Expression)Expressions.constant((Object)unit.multiplier.longValue()));
            if (unit == TimeUnit.QUARTER) {
                operand = Expressions.add((Expression)operand, (Expression)Expressions.constant((Object)1L));
            }
            return operand;
        }
    }

    private static class UnaryImplementor
    extends AbstractRexCallImplementor {
        private final ExpressionType expressionType;
        private final String backupMethodName;

        UnaryImplementor(ExpressionType expressionType, NullPolicy nullPolicy, String backupMethodName) {
            super(nullPolicy, false);
            this.expressionType = expressionType;
            this.backupMethodName = backupMethodName;
        }

        @Override
        String getVariableName() {
            return "unary_call";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression argValue = argValueList.get(0);
            Object e = this.expressionType == ExpressionType.Negate && argValue.type == BigDecimal.class && null != this.backupMethodName ? Expressions.call((Expression)argValue, (String)this.backupMethodName, (Expression[])new Expression[0]) : Expressions.makeUnary((ExpressionType)this.expressionType, (Expression)argValue);
            if (e.type.equals(argValue.type)) {
                return e;
            }
            return Expressions.convert_((Expression)e, (Type)argValue.type);
        }
    }

    private static class BinaryImplementor
    extends AbstractRexCallImplementor {
        private static final List<Primitive> COMP_OP_TYPES = ImmutableList.of((Object)Primitive.BYTE, (Object)Primitive.CHAR, (Object)Primitive.SHORT, (Object)Primitive.INT, (Object)Primitive.LONG, (Object)Primitive.FLOAT, (Object)Primitive.DOUBLE);
        private static final List<SqlBinaryOperator> COMPARISON_OPERATORS = ImmutableList.of((Object)SqlStdOperatorTable.LESS_THAN, (Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.GREATER_THAN, (Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        private static final List<SqlBinaryOperator> EQUALS_OPERATORS = ImmutableList.of((Object)SqlStdOperatorTable.EQUALS, (Object)SqlStdOperatorTable.NOT_EQUALS);
        public static final String METHOD_POSTFIX_FOR_ANY_TYPE = "Any";
        private final ExpressionType expressionType;
        private final String backupMethodName;

        BinaryImplementor(NullPolicy nullPolicy, boolean harmonize, ExpressionType expressionType, String backupMethodName) {
            super(nullPolicy, harmonize);
            this.expressionType = expressionType;
            this.backupMethodName = backupMethodName;
        }

        @Override
        String getVariableName() {
            return "binary_call";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            if (this.backupMethodName != null) {
                Primitive primitive;
                if (this.anyAnyOperands(call)) {
                    return this.callBackupMethodAnyType(translator, call, argValueList);
                }
                Type type0 = argValueList.get(0).getType();
                Type type1 = argValueList.get(1).getType();
                SqlBinaryOperator op = (SqlBinaryOperator)call.getOperator();
                RelDataType relDataType0 = ((RexNode)call.getOperands().get(0)).getType();
                Expression fieldComparator = EnumUtils.generateCollatorExpression((SqlCollation)relDataType0.getCollation());
                if (fieldComparator != null) {
                    argValueList.add(fieldComparator);
                }
                if ((primitive = Primitive.ofBoxOr((Type)type0)) == null || type1 == BigDecimal.class || COMPARISON_OPERATORS.contains(op) && !COMP_OP_TYPES.contains(primitive)) {
                    return Expressions.call(SqlFunctions.class, (String)this.backupMethodName, argValueList);
                }
                Primitive boxPrimitive0 = Primitive.ofBox((Type)type0);
                Primitive boxPrimitive1 = Primitive.ofBox((Type)type1);
                if (EQUALS_OPERATORS.contains(op) && boxPrimitive0 != null && boxPrimitive1 != null) {
                    return Expressions.call(SqlFunctions.class, (String)this.backupMethodName, argValueList);
                }
            }
            return Expressions.makeBinary((ExpressionType)this.expressionType, (Expression)argValueList.get(0), (Expression)argValueList.get(1));
        }

        private boolean anyAnyOperands(RexCall call) {
            for (RexNode operand : call.operands) {
                if (operand.getType().getSqlTypeName() != SqlTypeName.ANY) continue;
                return true;
            }
            return false;
        }

        private Expression callBackupMethodAnyType(RexToLixTranslator translator, RexCall call, List<Expression> expressions) {
            String backupMethodNameForAnyType = this.backupMethodName + METHOD_POSTFIX_FOR_ANY_TYPE;
            Expression expression0 = this.maybeBox(expressions.get(0));
            Expression expression1 = this.maybeBox(expressions.get(1));
            return Expressions.call(SqlFunctions.class, (String)backupMethodNameForAnyType, (Expression[])new Expression[]{expression0, expression1});
        }

        private Expression maybeBox(Expression expression) {
            Primitive primitive = Primitive.of((Type)expression.getType());
            if (primitive != null) {
                expression = Expressions.box((Expression)expression, (Primitive)primitive);
            }
            return expression;
        }
    }

    private static class MethodNameImplementor
    extends AbstractRexCallImplementor {
        protected final String methodName;

        MethodNameImplementor(String methodName, NullPolicy nullPolicy, boolean harmonize) {
            super(nullPolicy, harmonize);
            this.methodName = methodName;
        }

        @Override
        String getVariableName() {
            return "method_name_call";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            return EnumUtils.call(null, SqlFunctions.class, (String)this.methodName, argValueList);
        }
    }

    private static class JsonValueImplementor
    extends MethodImplementor {
        JsonValueImplementor(Method method) {
            super(method, NullPolicy.ARG0, false);
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            ArrayList<Object> newOperands = new ArrayList<Object>();
            newOperands.add(argValueList.get(0));
            newOperands.add(argValueList.get(1));
            List leftExprs = Util.skip(argValueList, (int)2);
            ConstantExpression emptyBehavior = Expressions.constant((Object)SqlJsonValueEmptyOrErrorBehavior.NULL);
            ConstantExpression defaultValueOnEmpty = Expressions.constant(null);
            ConstantExpression errorBehavior = Expressions.constant((Object)SqlJsonValueEmptyOrErrorBehavior.NULL);
            ConstantExpression defaultValueOnError = Expressions.constant(null);
            if (!leftExprs.isEmpty()) {
                for (int i = 0; i < leftExprs.size(); ++i) {
                    Expression expr = (Expression)leftExprs.get(i);
                    Object exprVal = translator.getLiteralValue(expr);
                    if (exprVal == null) continue;
                    int defaultSymbolIdx = i - 2;
                    if (exprVal == SqlJsonEmptyOrError.EMPTY) {
                        if (defaultSymbolIdx >= 0 && translator.getLiteralValue((Expression)leftExprs.get(defaultSymbolIdx)) == SqlJsonValueEmptyOrErrorBehavior.DEFAULT) {
                            defaultValueOnEmpty = (Expression)leftExprs.get(i - 1);
                            emptyBehavior = (Expression)leftExprs.get(defaultSymbolIdx);
                            continue;
                        }
                        emptyBehavior = (Expression)leftExprs.get(i - 1);
                        continue;
                    }
                    if (exprVal != SqlJsonEmptyOrError.ERROR) continue;
                    if (defaultSymbolIdx >= 0 && translator.getLiteralValue((Expression)leftExprs.get(defaultSymbolIdx)) == SqlJsonValueEmptyOrErrorBehavior.DEFAULT) {
                        defaultValueOnError = (Expression)leftExprs.get(i - 1);
                        errorBehavior = (Expression)leftExprs.get(defaultSymbolIdx);
                        continue;
                    }
                    errorBehavior = (Expression)leftExprs.get(i - 1);
                }
            }
            newOperands.add(emptyBehavior);
            newOperands.add(defaultValueOnEmpty);
            newOperands.add(errorBehavior);
            newOperands.add(defaultValueOnError);
            Class<?> clazz = this.method.getDeclaringClass();
            MethodCallExpression expression = EnumUtils.call(null, clazz, (String)this.method.getName(), newOperands);
            Type returnType = translator.typeFactory.getJavaClass(call.getType());
            return EnumUtils.convert((Expression)expression, (Type)returnType);
        }
    }

    private static class PosixRegexMethodImplementor
    extends MethodImplementor {
        protected final boolean caseSensitive;

        PosixRegexMethodImplementor(boolean caseSensitive) {
            super(BuiltInMethod.POSIX_REGEX.method, NullPolicy.STRICT, false);
            this.caseSensitive = caseSensitive;
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            assert (argValueList.size() == 2);
            ArrayList<Expression> newOperands = new ArrayList<Expression>(argValueList);
            newOperands.add((Expression)Expressions.constant((Object)this.caseSensitive));
            return super.implementSafe(translator, call, newOperands);
        }
    }

    private static class MethodImplementor
    extends AbstractRexCallImplementor {
        protected final Method method;

        MethodImplementor(Method method, NullPolicy nullPolicy, boolean harmonize) {
            super(nullPolicy, harmonize);
            this.method = method;
        }

        @Override
        String getVariableName() {
            return "method_call";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Class<?> clazz = this.method.getDeclaringClass();
            MethodCallExpression expression = Modifier.isStatic(this.method.getModifiers()) ? EnumUtils.call(null, clazz, (String)this.method.getName(), argValueList) : EnumUtils.call((Expression)argValueList.get(0), clazz, (String)this.method.getName(), (List)Util.skip(argValueList, (int)1));
            return expression;
        }
    }

    private static class FloorImplementor
    extends MethodNameImplementor {
        final Method timestampMethod;
        final Method dateMethod;

        FloorImplementor(String methodName, Method timestampMethod, Method dateMethod) {
            super(methodName, NullPolicy.STRICT, false);
            this.timestampMethod = timestampMethod;
            this.dateMethod = dateMethod;
        }

        @Override
        String getVariableName() {
            return "floor";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            switch (call.getOperands().size()) {
                case 1: {
                    switch (call.getType().getSqlTypeName()) {
                        case BIGINT: 
                        case INTEGER: 
                        case SMALLINT: 
                        case TINYINT: {
                            return argValueList.get(0);
                        }
                    }
                    return super.implementSafe(translator, call, argValueList);
                }
                case 2: {
                    boolean preFloor;
                    Method floorMethod;
                    Class<Number> type;
                    Expression operand = argValueList.get(0);
                    switch (call.getType().getSqlTypeName()) {
                        case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                            operand = Expressions.call((Method)BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand, Expressions.call((Method)BuiltInMethod.TIME_ZONE.method, (Expression[])new Expression[]{translator.getRoot()})});
                        }
                        case TIMESTAMP: {
                            type = Long.TYPE;
                            floorMethod = this.timestampMethod;
                            preFloor = true;
                            break;
                        }
                        default: {
                            type = Integer.TYPE;
                            floorMethod = this.dateMethod;
                            preFloor = false;
                        }
                    }
                    TimeUnitRange timeUnitRange = (TimeUnitRange)translator.getLiteralValue(argValueList.get(1));
                    switch (timeUnitRange) {
                        case YEAR: 
                        case QUARTER: 
                        case MONTH: 
                        case WEEK: 
                        case DAY: {
                            Expression operand1 = preFloor ? this.call(operand, type, TimeUnit.DAY) : operand;
                            return Expressions.call((Method)floorMethod, (Expression[])new Expression[]{translator.getLiteral(argValueList.get(1)), operand1});
                        }
                    }
                    return this.call(operand, type, timeUnitRange.startUnit);
                }
            }
            throw new AssertionError();
        }

        private Expression call(Expression operand, Type type, TimeUnit timeUnit) {
            return Expressions.call(SqlFunctions.class, (String)this.methodName, (Expression[])new Expression[]{ConverterUtils.convert(operand, type), ConverterUtils.convert((Expression)Expressions.constant((Object)timeUnit.multiplier), type)});
        }
    }

    private static class PeriodNameImplementor
    extends MethodNameImplementor {
        private final BuiltInMethod timestampMethod;
        private final BuiltInMethod dateMethod;

        PeriodNameImplementor(String methodName, BuiltInMethod timestampMethod, BuiltInMethod dateMethod) {
            super(methodName, NullPolicy.STRICT, false);
            this.timestampMethod = timestampMethod;
            this.dateMethod = dateMethod;
        }

        @Override
        String getVariableName() {
            return "periodName";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            Expression operand = argValueList.get(0);
            RelDataType type = ((RexNode)call.operands.get(0)).getType();
            switch (type.getSqlTypeName()) {
                case TIMESTAMP: {
                    return this.getExpression(translator, operand, this.timestampMethod);
                }
                case DATE: {
                    return this.getExpression(translator, operand, this.dateMethod);
                }
            }
            throw new AssertionError((Object)("unknown type " + type));
        }

        protected Expression getExpression(RexToLixTranslator translator, Expression operand, BuiltInMethod builtInMethod) {
            MethodCallExpression locale = Expressions.call((Method)BuiltInMethod.LOCALE.method, (Expression[])new Expression[]{translator.getRoot()});
            return Expressions.call(builtInMethod.method.getDeclaringClass(), (String)builtInMethod.method.getName(), (Expression[])new Expression[]{operand, locale});
        }
    }

    private static class TrimImplementor
    extends AbstractRexCallImplementor {
        TrimImplementor() {
            super(NullPolicy.STRICT, false);
        }

        @Override
        String getVariableName() {
            return "trim";
        }

        @Override
        Expression implementSafe(RexToLixTranslator translator, RexCall call, List<Expression> argValueList) {
            boolean strict = !translator.conformance.allowExtendedTrim();
            Object value = translator.getLiteralValue(argValueList.get(0));
            SqlTrimFunction.Flag flag = (SqlTrimFunction.Flag)value;
            return Expressions.call((Method)BuiltInMethod.TRIM.method, (Expression[])new Expression[]{Expressions.constant((Object)(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.LEADING ? 1 : 0)), Expressions.constant((Object)(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.TRAILING ? 1 : 0)), argValueList.get(1), argValueList.get(2), Expressions.constant((Object)strict)});
        }
    }

    public static enum NullAs {
        NULL,
        FALSE,
        TRUE,
        NOT_POSSIBLE,
        IS_NULL,
        IS_NOT_NULL;


        public static NullAs of(boolean nullable) {
            return nullable ? NULL : NOT_POSSIBLE;
        }

        public Expression handle(Expression x) {
            switch (Primitive.flavor((Type)x.getType())) {
                case PRIMITIVE: {
                    switch (this) {
                        case NULL: 
                        case NOT_POSSIBLE: 
                        case FALSE: 
                        case TRUE: {
                            return x;
                        }
                        case IS_NULL: {
                            return FALSE_EXPR;
                        }
                        case IS_NOT_NULL: {
                            return TRUE_EXPR;
                        }
                    }
                    throw new AssertionError();
                }
                case BOX: {
                    switch (this) {
                        case NOT_POSSIBLE: {
                            return ConverterUtils.convert(x, Primitive.ofBox((Type)x.getType()).primitiveClass);
                        }
                    }
                }
            }
            switch (this) {
                case NULL: 
                case NOT_POSSIBLE: {
                    return x;
                }
                case FALSE: {
                    return Expressions.call((Method)BuiltInMethod.IS_TRUE.method, (Expression[])new Expression[]{x});
                }
                case TRUE: {
                    return Expressions.call((Method)BuiltInMethod.IS_NOT_FALSE.method, (Expression[])new Expression[]{x});
                }
                case IS_NULL: {
                    return Expressions.equal((Expression)x, (Expression)NULL_EXPR);
                }
                case IS_NOT_NULL: {
                    return Expressions.notEqual((Expression)x, (Expression)NULL_EXPR);
                }
            }
            throw new AssertionError();
        }
    }
}

