/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RuntimeIndex;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.util.lang.GridFilteredIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimeHashIndex<Row>
implements RuntimeIndex<Row> {
    private static final GroupKey NULL_KEY = new GroupKey(X.EMPTY_OBJECT_ARRAY);
    protected final ExecutionContext<Row> ectx;
    private final ImmutableBitSet keys;
    private HashMap<GroupKey, List<Row>> rows;

    public RuntimeHashIndex(ExecutionContext<Row> ectx, ImmutableBitSet keys) {
        this.ectx = ectx;
        assert (!F.isEmpty((Iterable)keys));
        this.keys = keys;
        this.rows = new HashMap();
    }

    @Override
    public void push(Row r) {
        GroupKey key = this.key(r);
        if (key == NULL_KEY) {
            return;
        }
        List eqRows = this.rows.computeIfAbsent(key, k -> new ArrayList());
        eqRows.add(r);
    }

    @Override
    public void close() {
        this.rows.clear();
    }

    public Iterable<Row> scan(Supplier<Row> searchRow, @Nullable Predicate<Row> filter) {
        return new IndexScan(searchRow, filter);
    }

    private GroupKey key(Row r) {
        GroupKey.Builder b = GroupKey.builder(this.keys.cardinality());
        for (Integer field : this.keys) {
            Object fieldVal = this.ectx.rowHandler().get(field, r);
            if (fieldVal == null) {
                return NULL_KEY;
            }
            b.add(fieldVal);
        }
        return b.build();
    }

    private class IndexScan
    implements Iterable<Row>,
    AutoCloseable {
        private final Supplier<Row> searchRow;
        private final Predicate<Row> filter;

        IndexScan(@Nullable Supplier<Row> searchRow, Predicate<Row> filter) {
            this.searchRow = searchRow;
            this.filter = filter;
        }

        @Override
        public void close() {
        }

        @Override
        @NotNull
        public Iterator<Row> iterator() {
            GroupKey key = RuntimeHashIndex.this.key(this.searchRow.get());
            if (key == NULL_KEY) {
                return Collections.emptyIterator();
            }
            List eqRows = (List)RuntimeHashIndex.this.rows.get(key);
            if (eqRows == null) {
                return Collections.emptyIterator();
            }
            return this.filter == null ? eqRows.iterator() : new GridFilteredIterator<Row>(eqRows.iterator()){

                protected boolean accept(Row row) {
                    return IndexScan.this.filter.test(row);
                }
            };
        }
    }
}

