/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.processors.query.stat.BusyExecutor;
import org.apache.ignite.internal.processors.query.stat.CancellableTask;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.GatherStatisticCancelException;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsRepository;
import org.apache.ignite.internal.processors.query.stat.LocalStatisticsGatheringContext;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.processors.query.stat.task.GatherPartitionStatistics;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;

public class StatisticsProcessor {
    private final IgniteLogger log;
    private final IgniteStatisticsRepository statRepo;
    private final BusyExecutor gatheringBusyExecutor;
    private final ConcurrentMap<StatisticsKey, LocalStatisticsGatheringContext> gatheringInProgress = new ConcurrentHashMap<StatisticsKey, LocalStatisticsGatheringContext>();

    public StatisticsProcessor(IgniteStatisticsRepository repo, IgniteThreadPoolExecutor gatherPool, Supplier<Boolean> stopping, Function<Class<?>, IgniteLogger> logSupplier) {
        this.statRepo = repo;
        this.gatheringBusyExecutor = new BusyExecutor("gathering", gatherPool, stopping, logSupplier);
        this.log = logSupplier.apply(StatisticsProcessor.class);
    }

    public void updateLocalStatistics(LocalStatisticsGatheringContext ctx) {
        block9: {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Start statistics processing: forceRecollect=%b, cfg=%s, partToProcess = %s, topVer=%s", ctx.forceRecollect(), ctx.configuration(), ctx.allParts(), ctx.topologyVersion()));
            }
            if (this.registerNewTask(ctx)) {
                try {
                    if (ctx.forceRecollect()) {
                        this.statRepo.saveObsolescenceInfo(ctx.configuration().key());
                    }
                    if (ctx.table() == null || ctx.configuration() == null || ctx.configuration().columns().isEmpty()) {
                        this.statRepo.clearLocalPartitionsStatistics(ctx.configuration().key(), null);
                        ctx.future().complete(null);
                        return;
                    }
                    if (ctx.remainingParts().isEmpty()) {
                        ctx.future().complete(null);
                        break block9;
                    }
                    this.submitTasks(ctx);
                }
                catch (Throwable t) {
                    ctx.future().completeExceptionally(t);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Gathered by key " + ctx.configuration().key() + " were skipped due to previous one.");
            }
        }
    }

    private boolean registerNewTask(LocalStatisticsGatheringContext ctx) {
        boolean[] res = new boolean[1];
        this.gatheringInProgress.compute(ctx.configuration().key(), (k, v) -> {
            if (v == null) {
                res[0] = true;
                ctx.future().whenComplete((r, t) -> {
                    if (t != null) {
                        if (t instanceof CancellationException || t instanceof NodeStoppingException) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Got " + t.getClass() + " exception during statistics collection by key " + ctx.configuration().key() + ".");
                            }
                        } else {
                            this.log.warning("Unexpected error during statistics collection by key " + ctx.configuration().key() + " . " + t.getMessage(), t);
                        }
                    }
                    this.gatheringInProgress.remove(ctx.configuration().key(), ctx);
                });
                return ctx;
            }
            if (v.topologyVersion() == null || ctx.topologyVersion() != null && v.topologyVersion().compareTo(ctx.topologyVersion()) < 0 || v.configuration().compareTo(ctx.configuration()) < 0) {
                v.cancel();
                v.future().whenComplete((r, t) -> {
                    this.gatheringInProgress.remove(ctx.configuration().key(), v);
                    boolean rescheduled = this.gatheringBusyExecutor.busyRun(() -> this.updateLocalStatistics(ctx));
                    if (!rescheduled && this.log.isDebugEnabled()) {
                        this.log.debug("Unable to reschedule statistics task by key " + ctx.configuration().key() + " due to inactive state.");
                    }
                });
                res[0] = false;
                return v;
            }
            res[0] = false;
            return v;
        });
        return res[0];
    }

    private void submitTasks(LocalStatisticsGatheringContext ctx) {
        for (int part : ctx.remainingParts()) {
            final GatherPartitionStatistics task = new GatherPartitionStatistics(this.statRepo, ctx, part, this.log);
            this.gatheringBusyExecutor.submit(new CancellableTask(){

                @Override
                public void run() {
                    StatisticsProcessor.this.processPartitionTask(task);
                }

                @Override
                public void cancel() {
                    task.context().cancel();
                }
            }).thenAccept(success -> {
                if (!success.booleanValue()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(String.format("Gathering failed for key %s.%d ", ctx.configuration().key(), task.partition()));
                    }
                    ctx.partitionNotAvailable(task.partition());
                }
            });
        }
    }

    private void aggregateStatistics(LocalStatisticsGatheringContext ctx) {
        if (ctx.cancelled()) {
            return;
        }
        StatisticsKey key = ctx.configuration().key();
        Collection<ObjectPartitionStatisticsImpl> allParts = this.statRepo.getLocalPartitionsStatistics(key);
        if (ctx.forceRecollect()) {
            this.statRepo.aggregatedLocalStatistics(allParts, ctx.configuration(), ctx.topologyVersion());
        } else {
            HashSet<Integer> partsToRemove = new HashSet<Integer>();
            ArrayList<ObjectPartitionStatisticsImpl> partsToAggregate = new ArrayList<ObjectPartitionStatisticsImpl>();
            for (ObjectPartitionStatisticsImpl partStat : allParts) {
                if (ctx.allParts() == null || !ctx.allParts().contains(partStat.partId())) {
                    partsToRemove.add(partStat.partId());
                    continue;
                }
                partsToAggregate.add(partStat);
            }
            if (!partsToRemove.isEmpty()) {
                this.statRepo.clearLocalPartitionsStatistics(ctx.configuration().key(), partsToRemove);
            }
            if (!partsToAggregate.isEmpty()) {
                this.statRepo.aggregatedLocalStatistics(partsToAggregate, ctx.configuration(), ctx.topologyVersion());
            }
        }
    }

    private void processPartitionTask(GatherPartitionStatistics task) {
        LocalStatisticsGatheringContext ctx = task.context();
        try {
            task.call();
            if (ctx.partitionDone(task.partition())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Local partitions statistics successfully gathered by key " + ctx.configuration().key());
                }
                this.aggregateStatistics(ctx);
                ctx.future().complete(null);
            }
        }
        catch (Throwable t) {
            ctx.partitionNotAvailable(task.partition());
            if (t instanceof GatherStatisticCancelException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Collect statistics task was cancelled [key=" + ctx.configuration().key() + ", part=" + task.partition() + ']');
                }
            }
            if (t.getCause() instanceof NodeStoppingException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Node stopping during statistics collection on [key=" + ctx.configuration().key() + ", part=" + task.partition() + ']');
                }
            }
            this.log.warning("Unexpected error on statistic gathering", t);
        }
    }

    private boolean partStatSuitToConfiguration(ObjectStatisticsImpl stat, StatisticsObjectConfiguration cfg) {
        if (stat == null) {
            return false;
        }
        if (stat.columnsStatistics().size() != cfg.columns().size()) {
            return false;
        }
        for (StatisticsColumnConfiguration colCfg : cfg.columns().values()) {
            ColumnStatistics colStat = stat.columnStatistics(colCfg.name());
            if (colStat != null && colCfg.version() <= colStat.version()) continue;
            return false;
        }
        return true;
    }

    public void start() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Statistics gathering started.");
        }
        this.gatheringBusyExecutor.activate();
    }

    public void stop() {
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format("Statistics gathering stopping %d task...", this.gatheringInProgress.size()));
        }
        this.gatheringBusyExecutor.deactivate();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Statistics gathering stopped.");
        }
    }
}

