/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ColumnStatisticsCollector;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsAddressedRequest;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.StatisticsType;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsKeyMessage;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsRequest;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.table.Column;
import org.jetbrains.annotations.Nullable;

public class IgniteStatisticsHelper {
    private final IgniteLogger log;
    private final SchemaManager schemaMgr;

    public IgniteStatisticsHelper(UUID locNodeId, SchemaManager schemaMgr, Function<Class<?>, IgniteLogger> logSupplier) {
        this.schemaMgr = schemaMgr;
        this.log = logSupplier.apply(IgniteStatisticsHelper.class);
    }

    public CacheGroupContext groupContext(StatisticsKey key) throws IgniteCheckedException {
        GridH2Table tbl = this.schemaMgr.dataTable(key.schema(), key.obj());
        if (tbl == null) {
            throw new IgniteCheckedException(String.format("Can't find object %s.%s", key.schema(), key.obj()));
        }
        return tbl.cacheContext().group();
    }

    public List<StatisticsAddressedRequest> generateGatheringRequests(StatisticsTarget target, StatisticsObjectConfiguration cfg) throws IgniteCheckedException {
        List<String> cols = target.columns() == null ? null : Arrays.asList(target.columns());
        StatisticsKeyMessage keyMsg = new StatisticsKeyMessage(target.schema(), target.obj(), cols);
        Map<String, Long> versions = cfg.columns().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((StatisticsColumnConfiguration)e.getValue()).version()));
        CacheGroupContext grpCtx = this.groupContext(target.key());
        AffinityTopologyVersion topVer = grpCtx.affinity().lastVersion();
        StatisticsRequest req = new StatisticsRequest(UUID.randomUUID(), keyMsg, StatisticsType.LOCAL, topVer, versions);
        List assignments = grpCtx.affinity().assignments(topVer);
        HashSet<UUID> nodes = new HashSet<UUID>();
        for (List partNodes : assignments) {
            if (F.isEmpty((Collection)partNodes)) continue;
            nodes.add(((ClusterNode)partNodes.get(0)).id());
        }
        ArrayList<StatisticsAddressedRequest> res = new ArrayList<StatisticsAddressedRequest>(nodes.size());
        for (UUID nodeId : nodes) {
            res.add(new StatisticsAddressedRequest(req, nodeId));
        }
        return res;
    }

    public ObjectStatisticsImpl aggregateLocalStatistics(StatisticsObjectConfiguration cfg, Collection<? extends ObjectStatisticsImpl> stats) {
        StatisticsKeyMessage keyMsg = new StatisticsKeyMessage(cfg.key().schema(), cfg.key().obj(), new ArrayList<String>(cfg.columns().keySet()));
        GridH2Table tbl = this.schemaMgr.dataTable(keyMsg.schema(), keyMsg.obj());
        if (tbl == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Removing statistics for object %s.%s cause table doesn't exists.", keyMsg.schema(), keyMsg.obj()));
            }
            return null;
        }
        return IgniteStatisticsHelper.aggregateLocalStatistics(tbl, cfg, stats, this.log);
    }

    public static ObjectStatisticsImpl aggregateLocalStatistics(GridH2Table tbl, StatisticsObjectConfiguration cfg, Collection<? extends ObjectStatisticsImpl> stats, IgniteLogger log) {
        assert (!stats.isEmpty());
        Column[] selectedCols = IgniteStatisticsHelper.filterColumns(tbl.getColumns(), cfg.columns().keySet());
        HashMap colPartStats = new HashMap(selectedCols.length);
        long rowCnt = 0L;
        for (Column col : selectedCols) {
            colPartStats.put(col, new ArrayList());
        }
        for (ObjectStatisticsImpl objectStatisticsImpl : stats) {
            for (Column col : selectedCols) {
                ColumnStatistics colPartStat = objectStatisticsImpl.columnStatistics(col.getName());
                if (colPartStat == null) continue;
                ((List)colPartStats.get(col)).add(colPartStat);
            }
            rowCnt += objectStatisticsImpl.rowCount();
        }
        HashMap<String, ColumnStatistics> colStats = new HashMap<String, ColumnStatistics>(selectedCols.length);
        for (Column col : selectedCols) {
            StatisticsColumnConfiguration colCfg = (StatisticsColumnConfiguration)cfg.columns().get(col.getName());
            ColumnStatistics stat = ColumnStatisticsCollector.aggregate((arg_0, arg_1) -> ((GridH2Table)tbl).compareTypeSafe(arg_0, arg_1), (List)colPartStats.get(col), colCfg.overrides());
            if (log.isDebugEnabled()) {
                log.debug("Aggregate column statistic done [col=" + col.getName() + ", stat=" + stat + ']');
            }
            colStats.put(col.getName(), stat);
        }
        rowCnt = IgniteStatisticsHelper.calculateRowCount(cfg, rowCnt);
        return new ObjectStatisticsImpl(rowCnt, colStats);
    }

    public static long calculateRowCount(StatisticsObjectConfiguration cfg, long actualRowCount) {
        long overridedRowCnt = -1L;
        for (StatisticsColumnConfiguration ccfg : cfg.columns().values()) {
            if (ccfg.overrides() == null || ccfg.overrides().total() == null) continue;
            Long colRowCnt = ccfg.overrides().total();
            overridedRowCnt = Math.max(overridedRowCnt, colRowCnt);
        }
        return overridedRowCnt == -1L ? actualRowCount : overridedRowCnt;
    }

    public static StatisticsObjectConfiguration[] buildDefaultConfigurations(StatisticsTarget ... targets) {
        StatisticsObjectConfiguration[] res = (StatisticsObjectConfiguration[])Arrays.stream(targets).map(t -> {
            List colCfgs = t.columns() == null ? Collections.emptyList() : Arrays.stream(t.columns()).map(name -> new StatisticsColumnConfiguration(name, null)).collect(Collectors.toList());
            return new StatisticsObjectConfiguration(t.key(), colCfgs, 15);
        }).toArray(StatisticsObjectConfiguration[]::new);
        return res;
    }

    public static Column[] filterColumns(Column[] cols, @Nullable Collection<String> colNames) {
        if (F.isEmpty(colNames)) {
            return (Column[])Arrays.stream(cols).filter(c -> c.getColumnId() >= 2).toArray(Column[]::new);
        }
        HashSet<String> colNamesSet = new HashSet<String>(colNames);
        return (Column[])Arrays.stream(cols).filter(c -> colNamesSet.contains(c.getName())).toArray(Column[]::new);
    }
}

